@extends('layouts.app')

@section('title')
Generate Voucher
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Vouchers</li>
</ol>
@stop

@section('css')
<style type="text/css">
	.only-print{
		display:none;
	}
    
    @media print {
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        padding-top: 0px !important
    }
    .printableArea {
        color: black;
    }
    strong{
        color: black;
    }
        .white-box {
            border: none !important;
        }
        
        .table>thead>tr>th, .user-table .table tbody>tr:last-child td {
    border-bottom: 1px solid #2e3233;
    line-height: 2.2;
    background: #eee;
    border-right: 1px solid;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    .table>tbody>tr>td{
        padding: 5px 3px 0 4px;
        vertical-align: top;
    }
    h3{
        font-size: 21px !important;
    }
    .panel .panel-body{
        padding:0;
    }
    .fix-header .page-wrapper {
    margin-top: 0px !important;
    }
    h4 strong{
        text-transform: uppercase;
    }
    h3{
        margin-bottom: -10px;
    }
    .mt-20{
        margin-top: 40px;
    }
	.bor{
		border: 1px solid !important;
	}
	.no-bor{
		border: none!important;
	}
	.th-bor th{
		border: 1px solid !important;
	}
	.th-bor td{
		border: 1px solid !important;
	}
	.only-print{
		display:none;
	}
	.mt-50{
		margin-top: 50px;
	}
    }
</style>
@endsection

@section('content')


            <div class="container-fluid">

                 <!--.row-->
                <div class="row printableArea">
                    <div class="col-md-12" >
                        <div class="white-box">
                        
                        <div class="panel panel-info" >
                            <div class="panel-heading no-print" style="text-align: center;">
                            @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                            
                            Cash Receipt Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                            Bank Receipt Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                            Cash Payment Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                            Bank Payment Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                           Journal Voucher
                            @endif

                           

                            @if($next)
                            <span class="pull-right"><a href="{{route('voucher-detail',['id'=>$entry->entry_no + 1])}}"> <i class="fa fa-arrow-right " style="font-size:26px;"></i></a></span>

                            @endif

                            &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;

                             @if($previous)

                            <span class="pull-right"><a href="{{route('voucher-detail',['id'=>$entry->entry_no - 1])}}"> <i class="fa fa-arrow-left fa-2x" style="font-size:26px;"></i></a></span>

                            @endif

                            </div>


                            @if($entry->is_post)
                            <div class="ribbon ribbon-bookmark  ribbon-primary no-print" style="background-color:green">Posted</div>
                            @elseif($entry->is_check)
                            <div class="ribbon ribbon-bookmark  ribbon-primary no-print">Checked</div>
                            @else
                            <div class="ribbon ribbon-bookmark  ribbon-danger no-print">Prepared</div>
                            @endif
                            
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <h3><strong><span style="font-size:14px;">{{env('APP_NAME')}}</span></h3></strong>
                                    <div class="row text-center">
                                       <h3><strong>  @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                            
                            Cash Receipt Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                            Bank Receipt Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                            Cash Payment Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                            Bank Payment Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                           Journal Voucher
                            @endif</strong></h3>
                                       <!--<h4><strong><u> </u></strong></h4> -->
                                    </div>
                                    <div class="row"><br>
                                        <div class="col-md-4 col-xs-4">
                                            @if($entry->cheaque_no)
                                            <span>
                                                @if($entry->voucher_type == \App\GeneralJournalEntry::BRV || $entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                                
                                                Cheque Number: &nbsp;
                                                @else
                                                Cheque# / Ins.#: 
                                                @endif
                      
                            
                                                
                                                @if($entry->cheaque_no)
                            {{$entry->cheaque_no}}

                            @endif</span>
                            @endif<br>
                                        <span>
                                            @foreach($entries as $entry)

                                            @if($entry->controlAccount)
                                            <span>Party : {{$entry->controlAccount ? $entry->controlAccount->name : ''}}</span><br>
                                            @endif

                                            @endforeach

                                        </span>
                                            
                                        </div>
                                        <div class="col-md-4 col-xs-4">
                                            @if($entry->bank_name)
                                            <span>Bank Name: 
                                                @if($entry->bank_name){{$entry->bank_name}}
                                            @endif</span>
                                            @endif
                                        </div>
                                        <div class="col-md-4 col-xs-4">
                                            <table class="table">
                                                <tbody>
                                                    <tr>
                                                    <td>Voucher No.:</td>
                                                    <td> @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                                    <span>CRV-{{$entry->voucher_no}}</span>
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                                    <span> BRV-{{$entry->voucher_no}}</span>
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                                    <span>CPV-{{$entry->voucher_no}}</span>
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                                    <span>BPV-{{$entry->voucher_no}}</span>
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                                    <span>JV-{{$entry->voucher_no}}</span>
                                                    @endif</td>
                                                    </tr>
                                                    <tr>
                                                        <td>Date</td>
                                                        <td>{{date('d-m-Y',strtotime($entry->date))}}</td>
                                                    </tr>
                                                    <tr>
                                                        <td>Status</td>
                                                        <td>
                                                        @if($entry->is_post)
                                                        <span>Posted</span>
                                                        @elseif($entry->is_check)
                                                        <span>Checked</span>
                                                        @else
                                                        <span>Prepared</span>
                                                        @endif
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="row" style="position: relative;bottom: 2rem;">
                                        <div class=col-md-12 >
                                            <div class="col-md-2 col-xs-2"><b>Narration :</b></div>
                                                <div class="col-md-8 col-xs-8">
                                                    <span> 
                                                        <u>{{$entry->voucher?$entry->voucher->narration:''}}</u>
                                                    </span><br><br>
                                                </div>
                                            <table class="table">
                                                <thead>
                                                    <tr style="border: 1px solid;">
                                                        <th >Sr No.</th>
                                                        <th>Code</th>
                                                        <th>Name</th>
                                                        <th class="text-center">Debit</th>
                                                        <th class="text-center">Credit</th>
                                                        
                                                    </tr>

                                                </thead>
                                                <tbody>

                                                    <?php $sum = 0;$sr = 1;?>


                                                    @foreach($entries as $entry)

                                                    <tr>
                                                        <td class="text-center">{{$sr++}}</td>
                                                        @if(!empty($entry->account))
                                                        <td class="pt-3-half account text-left">&nbsp;&nbsp;
                                                            <a target="_blank" href="{{route('chart-of-account.detail',['id'=>$entry->account->id])}}"> {{$entry->account ? $entry->account->number : ''}}</a></td>
                                                          
                                                            @else
                                                            <td class="pt-3-half account text-left">&nbsp;&nbsp;
                                                                <a target="_blank" href="#"> {{$entry->account ? $entry->account->number : ''}}</a></td>
                                                              
                                                          @endif
                                                            <td>
                                                            @if($entry->amount >0) 

                                                               <b> {{$entry->account ? $entry->account->name : ''}} </b><br>
                                                                {{ $entry->memo}}
                                                               @else

                                                               <span style="margin-left: 30px"><b>{{$entry->account ? $entry->account->name : ''}}</b></span><br>
                                                               {{ $entry->memo}}
                                                              @endif  
                                                      
                                                            <br>
                                                            @if($entry->transaction_type == \App\GeneralJournalEntry::booking)

                                                            @if($entry->customer)
                                                            <span style="font-size: 10px;">
                                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                            
                                                           <b> Owner : </b>{{$entry->customer->name}}
                                                        </span>

                                                            @endif

                                                            @endif
                                                        </td>

                                                        
                                                        <td class="pt-3-half debit text-right">{{$entry->amount > 0 ? number_format($entry->amount) : ''}}
                                                            <?php $sum +=$entry->amount > 0 ? $entry->amount : 0;?> </td>
                                                        <td class="pt-3-half credit text-right" >{{$entry->amount < 0 ? number_format(abs($entry->amount)) : ''}}</td>
                                                        
                                                    

                                                    </tr>

                                                   

                                                    @endforeach

                                                    <tr>
                                                        <td colspan="3" class="text-right"><b>Total: &nbsp;&nbsp;</b></td>
                                                        <td class="text-right">
                                                            <div style="border-bottom-style: double;border-top: 1px solid;">
                                                            <b>{{number_format($sum)}}</b></div></td>
                                                        <td class="text-right"><div style="border-bottom-style: double;border-top: 1px solid;"><b>{{number_format($sum)}}</b></div></td>
                                                    </tr>

                                                    
                                            </tbody>
                                        </table>
                                        
                                    </div>

                                    @if($entry->transaction_type == \App\GeneralJournalEntry::receipt && $entry->receipt)

                                    <div class="col-md-12"><b>Receipt : </b>&nbsp;&nbsp;&nbsp; <u>Amount Received Against Receipt No <a href="{{route('receipt.detail',['id'=>$entry->receipt->id])}}" target="_blank"><b>{{$entry->receipt->receipt_no}}</b></a></u></div>

                                    @endif
                                    
                                    
                                    @if($entry->transaction_type == \App\GeneralJournalEntry::customer_tax_receipt && $entry->receipt)

                                    <div class="col-md-12"><b>Receipt : </b>&nbsp;&nbsp;&nbsp; <u>Amount Received Against Tax Receipt No <b>{{$entry->receipt->receipt_no}}</b></u></div>

                                    @endif
                                 

                                    @if($entry->transaction_type == \App\GeneralJournalEntry::bill && $entry->bill)

                                    <div class="col-md-12"><b>Bill : </b>&nbsp;&nbsp;&nbsp; <u>{{$entry->bill->notes}} Bill No <a href="{{route('expense.detail',['id'=>$entry->bill->id])}}" target="_blank"><b>BILL-00{{$entry->bill->id}}</b></a></u></div>

                                    @endif

                                    @if($entry->transaction_type == \App\GeneralJournalEntry::massPayment && $entry->bills)

                                    <div class="col-md-12"><b>Detail : </b><br>
                                        <div class="col-md-6"> <table class="table table-bordered">
                                            <tr>
                                            <th>Sr #</th>
                                            <th>Bill #</th>
                                            <th>Date</th>
                                            <th>Notes</th>
                                            <th>Amount</th>
                                        </tr>
                                        <?php $count = 0 ; $sr = 1;?>
                                        @foreach($entry->bills as $bill)
                                        <tr>
                                            
                                            <td>{{$sr++}}</td>
                                            <td>BILL-00{{$bill->id}}</td>
                                            <td>{{date('d-m-Y',strtotime($bill->billed_at))}}</td>
                                            <td>{{$bill->notes}}</td>
                                            <td>{{number_format($bill->amount)}} <?php $count +=$bill->amount ?></td>
                                        </tr>
                                        @endforeach

                                        <tr>
                                            <td colspan="4"><b>Total</b></td>
                                            <td><b>{{number_format($count)}}</b></td>
                                        </tr>
                                        </table> </div>
                                    </div>

                                    @endif

                                    @if($entry->transaction_type == \App\GeneralJournalEntry::payment && $entry->bill)

                                    <div class="col-md-12"><b>Bill : </b>&nbsp;&nbsp;&nbsp; <u>Payment Paid Againt  Bill No <a href="{{route('expense.detail',['id'=>$entry->bill->id])}}" target="_blank"><b>BILL-00{{$entry->bill->id}}</b></a></u></div>

                                    @endif

                                    @if($entry->transaction_type == \App\GeneralJournalEntry::bill)
                                    <div class="col-md-3 pull-right"><b>Balance : </b>&nbsp;&nbsp;&nbsp; <u>{{number_format(abs($balance))}}</u></div>
                                    @endif

                                    @if($entry->transaction_type == \App\GeneralJournalEntry::payment || $entry->transaction_type == \App\GeneralJournalEntry::massPayment)
                                    <div class="col-md-3 pull-right"><b>Previous Balance : </b>&nbsp;&nbsp;&nbsp; <u>{{number_format($previousBalance)}}</u></div><div class="clearfix"></div>
                                    <div class="col-md-3 pull-right"><b>Paid Amount : </b>&nbsp;&nbsp;&nbsp; <u>{{number_format(abs($entry->amount))}}</u></div><div class="clearfix"></div>
                                    <div class="col-md-3 pull-right"><b>Remaining Amount : </b>&nbsp;&nbsp;&nbsp; <u>{{number_format($balance)}}</u></div>
                                    @endif

                                   

                                </div>

                                <div class="clearfix"></div>

                                <div class="row">
                                   
                                    <div class="col-md-12">

                                                            <div class="col-md-4 col-xs-4 text-center">
                                   <span><b>{{$entry->preparedBy ? $entry->preparedBy->name : '&nbsp;'}}</b></span> 
                                    <div style="text-align: center;border-top: 2px solid">
                                    <span style="text-align:center; font-weight: bold; font-size: 14px">Prepared By</span></div>
                                    </div>

                                <div class="col-md-4 col-xs-4 text-center">
                                    <span><b>{{$entry->checkedBy ? $entry->checkedBy->name : '&nbsp;'}}</b></span>
                                    <div style="text-align: center; border-top: 2px solid;">
                                    <span style="text-align:center; font-weight: bold;font-size: 14px">Checked By</span></div></div>

                                

                                <div class="col-md-4 col-xs-4 text-center">
                                    <span><b>{{$entry->postedBy ? $entry->postedBy->name : '&nbsp;'}}</b></span>
                                    <div style="text-align: center; border-top: 2px solid;">
                                    <span style="text-align:center; font-weight: bold;font-size: 14px">Posted By</span></div></div>
                            </div>
                            
                                    <div class="col-md-12">

                                                            <div class="col-md-4 col-xs-4 text-center">
                                   &nbsp;
                                    </div>

                                <div class="col-md-4 col-xs-4 text-center">
                                    &nbsp;
                                    </div>

                                

                                <div class="col-md-4 col-xs-4 text-center mt-20">
                                    <span><b>&nbsp;</b></span>
                                    <div style="text-align: center; border-top: 2px solid;">
                                    <span style="text-align:center; font-weight: bold;font-size: 14px">Approved By</span></div></div>
                            </div>
                            
                            
                              @if($entry->voucher_type != \App\GeneralJournalEntry::JV )
                                        
                                        <div class="col-md-12" style="margin-top: 12rem;">
                                        
                                        <div class="col-md-4 col-xs-4 text-center">
                                        <span><b>&nbsp;</b></span> 
                                        <div style="text-align: center;border-top: 2px solid">
                                        <span style="text-align:center; font-weight: bold; font-size: 14px">Name</span></div>
                                        </div>
                                        
                                        <div class="col-md-4 col-xs-4 text-center">
                                        <span><b>&nbsp;</b></span>
                                        <div style="text-align: center; border-top: 2px solid;">
                                        <span style="text-align:center; font-weight: bold;font-size: 14px">CNIC</span></div></div>
                                        
                                        
                                        
                                        <div class="col-md-4 col-xs-4 text-center">
                                        <span><b>&nbsp;</b></span>
                                        <div style="text-align: center; border-top: 2px solid;">
                                        <span style="text-align:center; font-weight: bold;font-size: 14px">Recipient Signature</span></div></div>
                                        </div>
                                        
                                        
                                        @endif

                                    
                                    

                                   
                                </div>
                        </div>
                    </div>
                </div>
            </div>

            @if($entry->voucher_type == \App\GeneralJournalEntry::BPV  || $entry->voucher_type == \App\GeneralJournalEntry::CPV)
			<div class="table-responsive only-print">
			<div class="text-center">
			<h3 style="color:black"><strong>ACKNOWLEDGEMENT RECEIPT</strong></h3><br>
			</div>
			<span>Received through Cheque / P.O. / Bank Transfer / Cash as per detail below:</span>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr class="th-bor">
                                            <th class="text-center">Sr. No.</th>
                                            <th class="text-center">Instruemnet Type</th>
                                            <th class="text-center">Instruemnet Date</th>
                                            <th class="text-center">Instruemnet No.</th>
                                            <th class="text-center">Invoice No.</th>
                                            <th class="text-center">Invoice Total</th>
                                            <th class="text-center">Withholding Income Tax</th>
                                            <th class="text-center">Withholding Sales Tax</th>
                                            <th class="text-center">Net Payment Rs.</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="th-bor">
                                            <td>&nbsp;</td>
											 <td>&nbsp;</td>
											  <td>&nbsp;</td>
											   <td>&nbsp;</td>
											    <td>&nbsp;</td>
												 <td>&nbsp;</td>
												  <td>&nbsp;</td>
												   <td>&nbsp;</td>
												   <td>&nbsp;</td>
                                        </tr>
										<tr class="th-bor">
                                            <td>&nbsp;</td>
											 <td>&nbsp;</td>
											  <td>&nbsp;</td>
											   <td>&nbsp;</td>
											    <td>&nbsp;</td>
												 <td>&nbsp;</td>
												  <td>&nbsp;</td>
												   <td>&nbsp;</td>
												   <td>&nbsp;</td>
                                        </tr>
										<tr class="th-bor">
                                            <td>&nbsp;</td>
											 <td>&nbsp;</td>
											  <td>&nbsp;</td>
											   <td>&nbsp;</td>
											    <td>&nbsp;</td>
												 <td>&nbsp;</td>
												  <td>&nbsp;</td>
												   <td>&nbsp;</td>
												   <td>&nbsp;</td>
                                        </tr>
										<tr class="th-bor">
                                            <td>&nbsp;</td>
											 <td>&nbsp;</td>
											  <td>&nbsp;</td>
											   <td>&nbsp;</td>
											    <td>&nbsp;</td>
												 <td>&nbsp;</td>
												  <td>&nbsp;</td>
												   <td>&nbsp;</td>
												   <td>&nbsp;</td>
                                        </tr>
										<tr class="th-bor">
                                            <td>&nbsp;</td>
											 <td>&nbsp;</td>
											  <td>&nbsp;</td>
											   <td>&nbsp;</td>
											    <td>&nbsp;</td>
												 <td>&nbsp;</td>
												  <td>&nbsp;</td>
												   <td>&nbsp;</td>
												   <td>&nbsp;</td>
                                        </tr>
                                  <tr class="th-bor">
								 <td colspan="5" class="text-right">Total</td>
								  <td></td>
								   <td></td>
								    <td></td>
								    <td></td>
								  </tr>
                                    </tbody>
                                </table>
								<div class="col-md-6 col-xs-6">
								&nbsp;
								</div>
								<div class="col-md-6 col-xs-6">
								<table class="table table-bordered">
								<tbody>
                                        <tr>
                                            <td class="no-bor">Recipient`s Name</td>
											 <td class="bor" width="250px">&nbsp;</td>
                                        </tr>
										<tr>
                                            <td class="no-bor">CNIC No.</td>
											 <td class="bor">&nbsp;</td>
                                        </tr>
										<tr>
                                            <td class="no-bor">Mobile No.</td>
											 <td class="bor">&nbsp;</td>
                                        </tr>
										<tr >
                                            <td class="no-bor" rowspan="2" height="50px" style="vertical-align:middle">Signature</td>
											 <td class="bor" rowspan="2">&nbsp;</td>
                                        </tr>
								</tbody>
								</table>
								</div>
                            </div>

                            @endif
            </div>
        </div>

            @permission('print-voucher')
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
        <button  class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        @endpermission

        @if(!$entry->is_check)
        @permission('voucher-check')
        <a href="{{route('voucher-check',['id'=>$entry->entry_no])}}" class="btn btn-primary">Check</a>
        @endpermission
        @elseif(!$entry->is_post)
        @permission('voucher-post')
        <a href="{{route('voucher-post',['id'=>$entry->entry_no])}}" class="btn btn-primary">Post</a>
        @endpermission
        @endif

       
        <!-- @permission('edit-voucher')
            <a href="{{route('voucher-edit',['id'=>$entry->entry_no])}}" class="btn btn-warning">Edit</a>
            @endpermission -->
        

        @permission('reversal-voucher')
        @if($entry->is_post)
 
            <a href="{{route('create-reversal-voucher',['entry_no'=>$entry->entry_no])}}" class="btn btn-warning">Make Reversal Entry</a>
        @endif
        @endpermission


    </div>

    
        
                <!--./row-->

                

                
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':50,
            'ordering' : false,
            });

    });

</script>

@stop