@extends('layouts.app')

@section('title')
Employee List 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard no-print"></i> Home</a></li>

        <li class="active no-print">Employee Vouchers</li>
      </ol>
@stop
@section('css')
<style type="text/css">

     @media print {
    thead{
        color: black !important;
    }
    .bg1{
        background: black;
    }
    table.dataTable {
   
    border: 1px solid black !important;
}
.table-bordered, .table-bordered>tbody>tr>td, .table-bordered>tbody>tr>th, .table-bordered>tfoot>tr>td, .table-bordered>tfoot>tr>th, .table-bordered>thead>tr>td, .table-bordered>thead>tr>th {
    border: 1px solid black !important;
    color: black !important;


}
td{
    color: black !important;
}

}


table.dataTable thead .sorting_asc:after {
    content: "";
    
}
table.dataTable thead .sorting::after, table.dataTable thead .sorting_asc::after, table.dataTable thead .sorting_desc::after {
    float: none;
    padding-left: 10px;
}
table.dataTable thead .sorting:after {
    content: "";
    float: right;
    font-family: fontawesome;
    color: rgba(50, 50, 50, .5);
}

a.dt-button, button.dt-button, div.dt-button {
    background: rgb(153 142 142 / 15%);
    color: #2b2b2b;
    border-color: #fff;
    border: 1px solid rgb(0 0 0 / 24%);
    border-radius: 2px;
    cursor: pointer;
    font-size: .88em;
    line-height: 1.6em;
    padding: 0.5em 1em;
    overflow: hidden;
} 

.dataTables_wrapper .dataTables_paginate .paginate_button.current, .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: gray;
    color: #fff;
    width: 50px;
    height: 35px;
    white-space: nowrap;
    border-color: #d4af37;

}

.badge {
    text-transform: uppercase;
    font-weight: 500 !important;
    padding: 7px 7px !important;
    font-size: 13px !important;
    margin-top: 4px !important;

  }
</style>
@stop

@section('content')


      <div class="container-fluid">

      <!-- /row -->
      <div class="row">
      <div class="col-sm-12">

      <div class="white-box">
      <h3 class="box-title no-print">Employees</h3>
      @if(Session::has('success'))
      <div id="successMessage" class="alert alert-success" role="alert"> {{ Session::get('success') }} 
      </div> 
      @endif
                            <!-- Nav tabs -->
      <ul class="nav customtab nav-tabs" role="tablist">

          <li role="presentation" class="active no-print"><a href="#home" onclick="changetitle('Employees List')" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs no-print">List</span></a></li>

          <li role="presentation" class="no-print"><a href="#home1" onclick="changetitle('Pending Payroll Sheet')" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs no-print">Pending Payroll Sheet 
          @if($total_pending_payroll > 0)
          <span class="label label-rounded pull-right" style="line-height: 1.8;
           min-width: 0px;
          font-size: 14px;
          padding: 0px 8px;
          background-color: rgb(300 2 2); 
          margin-top: 2px;
          margin-right: -11px;
          ">{{$total_pending_payroll}}</span>
          @endif
           </span> 
          </span>
          </a>
          </li>

          <li role="presentation" class="no-print"><a href="#home2" onclick="changetitle('Annexure')" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Annexure </span> </a></li>

          <li role="presentation" class="no-print"><a href="#home3" onclick="changetitle('Benevolent Fund')" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Benevolent Fund </span></a></li>

          <li role="presentation" class="no-print"><a href="#home4" onclick="changetitle('Loan & Advance')" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Loan & Advance </span>@if($total_pending_loan_advance > 0)
          <span class="label label-rounded pull-right" style="line-height: 1.8;
           min-width: 0px;
          font-size: 14px;
          padding: 0px 8px;
          background-color: rgb(300 2 2); 
          margin-top: 2px;
          margin-right: -11px;
          ">{{$total_pending_loan_advance}}</span>
          @endif
           </span> 
          </span></a></li>

          <li role="presentation" class="no-print"><a href="#profile2" onclick="changetitle('Vouchers')" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs no-print" onclick="changetitle('Employees Vouchers')">Vouchers</span></a></li>

    </ul>
              <!-- Tab panes -->
              <div class="tab-content">

              <div role="tabpanel" class="tab-pane fade active in" id="home">
              <div class="table-responsive">

              <a href="{{route('control-account.addView',['id'=>\App\ControlAccount::EMPLOYEE])}}" target="_blank"  class="btn btn-default pull-right"> Add New </a>

              <br>
              <br>
              <div class="clearfix"></div>
              <table id="myTable8" class="table table-striped">
              <thead>
              <tr>
              <th>#</th>

              <th>Name</th>
              <th>Description</th>
              <th>balance</th>


              <th style="width: 185px!important;">Action</th>
              </tr>
              </thead>
              <tbody>
              <?php $count =1;?>


              @foreach($list as $l)
              <tr >
              <td>{{$count++}}</td>
              <td>
              {{$l->name}}


              </td> 

              <td>{{$l->description}}</td>
              <td>
              @if($balance[$l->id] < 0 )
              ({{number_format(abs($balance[$l->id]))}})
              @elseif($balance[$l->id] > 0 )
              {{number_format($balance[$l->id])}}
              @else
              -
              @endif
              </td>


              <td class="text-nowrap">

              <a href="{{route('control-account.detail',['id'=>$l->id])}}" target="_blank"  class="btn btn-default"> View </a>


              <a href="{{route('control-account.editView',['id'=>$l->id])}}" target="_blank"  class="btn btn-default"> Edit</a>

              </td>

              </tr>

              @endforeach

              </tbody>
              </table>

              </div>
              <div class="clearfix"></div>
              </div>

                                 
                      <div role="tabpanel" class="tab-pane fade" id="home2">
                      <h2 style="text-align: center; color: black;"><strong>ANNEXURE "A"</strong></h2>
                      <h4 style="background: gray; text-align: center; color: white; margin-top: -1rem; border-radius: 5px;" class="bg1">ANNEXURE "A"</h4>

                      <div class="table-responsive" style="margin-top: -2rem;">

                      <table id="myTable1" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                      <thead>
                      <tr role="row">
                      <th tabindex="0" class="no-print" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 10px; font-size: x-large;"><input type="checkbox" style="zoom: 2;" value="" id="select_all"></th>
                      <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 100px;"> S.No</th>
                      <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Payee</th>
                      <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Designation</th>
                      <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 150px;">Meezan Bank Account No</th>
                      <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Meezan Bank Branch</th>
                      <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Total Rs</th>
                      </tr>
                      </thead>
                      <tbody>
                      @php
                      $total_net_salary = 0 ;
                      @endphp
                      @foreach($HrmEmployees as $HrmEmployee)
                      @php

                      $total = \App\HrmEmployeeMonthlyEarningDeduction::getData($HrmEmployee->id , $month , $year );

                      @endphp

                      @if($total[0] > 0 && $total[1] > 0 && $HrmEmployee->company_detail->salary_method == 'bank')
                      

                      @php
                      $net_salary = ($total[0]-$total[1]-$total[3]-$total[4] - $total[5]);
                      $total_net_salary += $net_salary;
                      @endphp

                      
                      <tr>
                      <td class="no-print"><input type="checkbox" style="zoom: 1.4;" class="checkbox chlid_checkbox" name="chlid_checkbox"  value="{{$net_salary}}"></td>    
                      <td>{{$HrmEmployee->company_detail->employee_code}}</td>
                      <td>{{$HrmEmployee->name}}</td>
                      <td>{{$HrmEmployee->company_detail->designation->name}}</td>
                      <td>{{$HrmEmployee->account_detail ? $HrmEmployee->account_detail->account_no:''}}</td>
                      <td>{{$HrmEmployee->account_detail ? $HrmEmployee->account_detail->branch_location:''}}</td>



                      <td>{{number_format($net_salary)}}</td>

                      </tr>
                      @endif

                      @endforeach
                      <tr>
                      <td class="no-print"></td>   
                      <td colspan="3"><strong></strong></td>

                      <td colspan="2"><strong>Sub-Total.</strong></td>
                      <td><strong>{{number_format($total_net_salary )}}</strong></td>
                      </tr>

                      </tbody>
                      </table>
                      <a class="btn btn-info btn-sm no-print"  onclick="return AddAccountNo(this)" style="float: right;" href="">Transfer Letter </a>
                      <a>
                      <button id="print" class="btn btn-success no-print" type="button" style="float: left; color: white;"> <span style="color: white; float: right;"><i class="fa fa-print"></i> Print</span> </button>
                      </a>
                      </div>
                      <div class="clearfix"></div>
                      </div>

      <div role="tabpanel" class="tab-pane fade" id="home3">
      <h2 style="text-align: center; color: black;"><strong>Employees Benevolent Fund</strong></h2>
      <h4 style="background: gray; text-align: center; color: white; margin-top: -1rem; border-radius: 5px;" class="bg1">Benevolent Fund</h4>

      <div class="table-responsive" style="margin-top: -2rem;">

      <table id="myTable1" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
      <thead>
      <tr role="row">
      <th tabindex="0" class="no-print" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 10px; font-size: x-large;"><input type="checkbox" style="zoom: 2;" value="" id="select_alls"></th>
      <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 100px;"> S.No</th>
      <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Name</th>
      <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Benevolent Fund</th>
      <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Status</th>
      <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Action</th>
      </tr>
      </thead>
      <tbody>
      @php
      $count = 1;
      $total_bf = 0;

      @endphp
      @foreach($HrmEmployees as $HrmEmployee)
      @php

      $total = \App\HrmEmployeeBenevolentFound::getData($HrmEmployee->id , $month , $year );

      @endphp
      @php 
      $total_bf += $total[1];
      @endphp
      @if($total[1] > 0 )
      <tr>
      <td class="no-print">
      @if($total[2] != 0)
      <input type="checkbox" style="zoom: 1.4;" class="checkbox1 chlid_checkbox" name="chlid_checkbox"  value="{{$total[1] * 2}}">
      @endif
      </td> 
      <td>{{$count++}}</td>  
      <td>{{$HrmEmployee->name}}</td>
      <td>{{number_format($total[1] * 2)}}</td>
      <td>

      @if($total[2] == 1 )

      <li id="notreceived" class="badge badge-success">
      <a href="{{ route('bf.status.update',['status'=>0,'id'=>$HrmEmployee->id,])}}" style="color: #f7fafc;">Not Received</a>
      </li>

      @elseif($total[2] == 0) 

      <li id="notreceived" class="badge badge" class="badge badge" style="background: #24d727 !important; color: black !important">
      <a href="{{ route('bf.status.update',['status'=>1,'id'=>$HrmEmployee->id,])}}" style="color: #f7fafc;">Received</a>
      </li>

      @endif 

  </td>

      <td>  
      <a href="#"  onclick="$('#voucher-form').submit()"  class="btn btn-primary"> Make Voucher</a>

                    <form id="voucher-form" method="post" action="{{route('create-voucher')}}">
                    {{csrf_field()}}

                    <input type="hidden" name="type" value="">
                    <input type="hidden" name="id" value="">
                    <input type="hidden" name="control" value=""> 
                    </form>
  
      </td>
      </tr>
      @endif
      @endforeach


      </tbody>
      </table>
      <a class="btn btn-info btn-sm no-print"  onclick="return AddAccountNo(this)" style="float: right;" href="">Transfer Letter </a>
      <a>
      <button id="print2" class="btn btn-success no-print" type="button" style="float: left; color: white;"> <span style="color: white; float: right;"><i class="fa fa-print"></i> Print</span> </button>
      </a>
      </div>
      <div class="clearfix"></div>
      </div>

                    <div role="tabpanel" class="tab-pane fade" id="home1">
                    <div class="table-responsive">

                    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                    <thead>
                    <tr role="row">

                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Month/Year</th>
                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Total Earning </th>
                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Tax </th>
                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Benavalent Fund  </th>
                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Total Deduction </th>
                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Advance </th>
                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Loan </th>
                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Net Salary </th>

                    <th class="sorting" style="width: 185px!important; background-color: white !important">Action</th>
                    </tr>
                    </thead>
                    <tbody>


                    @foreach($totalArray as $t)

                    <tr>
                    <td>{{date('F Y', strtotime('01-'.$t['month'].'-'.$t['year']))   }}</td>
                    <td>{{number_format( $t['total_monthly_earning'])}}</td>
                    <td>{{number_format( $t['total_monthly_tax'])}}</td>
                    <td>{{number_format( $t['employee_benevolent_found'])}}</td>
                    <td>{{number_format( $t['total_monthly_deduction'])}}</td>
                    <td>{{number_format( $t['HrmEmployeeAdvance'])}}</td>
                    <td>{{number_format( $t['HrmEmployeeLoan'])}}</td>
                    <td>{{number_format( $t['total_net_salary'] )}}</td>
                    <td class="text-nowrap"> 

                    <a href="{{route('employee.salary.report' , ['month' => $t['month'] , 'year' => $t['year']])}}" target="_blank" class="btn btn-default"> View </a> 

                    <a href="#"  onclick="$('#voucher-form').submit()"  class="btn btn-primary"> Make Voucher</a>

                    <form id="voucher-form" method="post" action="{{route('create-voucher')}}">
                    {{csrf_field()}}

                    <input type="hidden" name="type" value="">
                    <input type="hidden" name="id" value="">
                    <input type="hidden" name="control" value=""> 
                    </form>

                    </td>
                    </tr>

                    @endforeach
                    </tbody>
                    </table>
                    </div>
                    <div class="clearfix"></div>
                    </div>


                    <div role="tabpanel" class="tab-pane fade" id="home4">
                    <div class="table-responsive">

                    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                    <thead>
                    <tr role="row">

                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name</th>
                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Month / Year</th>
                
                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Type </th>
                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Amount </th>

                    <th class="sorting" style="width: 185px!important; background-color: white !important">Action</th>
                    </tr>
                    </thead>
                    <tbody>

                    @foreach($employees as $employee)
                    
                    @foreach($employee->loan as $eloan)
                    
                    @if($eloan->type == 'Loan' && $eloan->is_approved == 1)
                    <tr>
                    <td>{{$employee->name}}{{$eloan->is_approved}} </td>
                    <td>{{date('F-Y', strtotime($eloan->date))}}</td>
                    <td>{{$eloan->type}}</td> 
                    <td>{{number_format($eloan->loan_amount)}}</td>

                    <td class="text-nowrap"> 

                    <a href="{{route('detail.loan.advance',['employ_id'=>$employee->id ,'id'=>$eloan->id])}}" target="_blank" class="btn btn-default"> View </a> 

                    </td>
                    </tr>
                    
                    
                    @elseif($eloan->type == 'Advance' && $eloan->is_approved == 1)

                  <tr>
                    <td>{{$employee->name}}{{$eloan->is_approved}}</td>
                    <td>{{date('F-Y', strtotime($eloan->date))}}</td>
                    <td>{{$eloan->type}}</td> 
                    <td>{{number_format($eloan->loan_amount)}}</td>

                       <td class="text-nowrap"> 

                    <a href="{{route('detail.loan.advance',['employ_id'=>$employee->id ,$eloan->id])}}" target="_blank" class="btn btn-default"> View </a> 

                    </td>
                    </tr>
                    {{-- @endif --}}

                    @endif    
                    
                     
                   @endforeach
                   @endforeach

             
                    </tbody>
                    </table>
                    </div>
                    <div class="clearfix"></div>
                    </div>         


  <div role="tabpanel" class="tab-pane fade" id="profile2">
  <div class="table-responsive">

  @permission('create-voucher')
  <a onclick="$('#voucher-form').submit()" href="#"><button  class="btn btn-default btn-outline pull-right"  type="button"> <span><i class="fa fa-money "></i> Make Voucher</span> </button></a>
  @endpermission

  <form id="voucher-form" method="post" action="{{route('create-voucher')}}">
  {{csrf_field()}}
  <input type="hidden" name="type" value="">
  <input type="hidden" name="id" value="">
  <input type="hidden" name="control" value="{{\App\ControlAccount::EMPLOYEE}}">

  </form>

  <table id="myTable3" class="table table-striped table-bordered">
  <thead>
  <tr>
  <th>Type</th>
  <th>Checked</th>
  <th>Posted</th>
  <th>Date</th>
  <th>Entry No.</th>
  <th>ADJ</th>
  <th>Account</th>
  <th>Memo</th>
  <!-- <th>Class</th> -->
  <th>Debit/Credit (+/-)</th>
  <th>Action</th>

  </tr>
  </thead>
  <tbody>
  @foreach($allEntries as $entry)
  <tr ondblclick="showEntry('{{$entry->entry_no}}')">

  @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
  <td>CRV-{{$entry->voucher_no}}</td>
  @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
  <td>BRV-{{$entry->voucher_no}}</td>
  @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
  <td>CPV-{{$entry->voucher_no}}</td>
  @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
  <td>BPV-{{$entry->voucher_no}}</td>
  @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
  <td>JV-{{$entry->voucher_no}}</td>
  @else
  <td></td>
  @endif

  <td>@if($entry->is_check)
  <i class="fa fa-check" style="color:green"></i>
  @else
  <i class="fa fa-close" style="color: red;"></i>

  @endif

  <td>@if($entry->is_post)
  <i class="fa fa-check" style="color:green"></i>
  @else
  <i class="fa fa-close" style="color: red;"></i>

  @endif
  </td>

  <td>{{date('d/m/Y', strtotime($entry->date))}}</td>
  <td>{{$entry->entry_no}}</td>
  <td>
  @if($entry->adjusting_entry)
  <i class="fa fa-check"></i>
  @endif
  </td>
  <td>{{$entry->account ? $entry->account->name : ''}}</td>
  <td>{{$entry->memo}}</td>
  <!-- <td>{{$entry->class ? $entry->class->name : ''}}</td> -->
  <td>{{number_format($totalAmount[$entry->entry_no])}}</td>
  <td >
  <!-- <span onclick="showEntry('{{$entry->entry_no}}')" style="cursor: pointer;" class="btn btn-sm btn-primary"> Show</span> -->

  <a href="{{route('voucher-detail',['id'=>$entry->entry_no])}}" class="btn btn-default">View</a>

  @if(!$entry->is_approved)

  <br><br>
  <span onclick="approveEntryModal('{{$entry->entry_no}}')" style="cursor: pointer;" class="btn btn-default btn-sm"> Approve</span>


  @endif

  </td>
  </tr>
  @endforeach

  </tbody>
  </table>

  </div>
  <div class="clearfix"></div>
  </div>


  </div>
  </div>


  </div>
  </div>

              <form id="voucher-form" method="post" action="{{route('create-voucher')}}">
              {{csrf_field()}}
              <input type="hidden" name="type" value="{{\App\GeneralJournalEntry::massPayment}}">
              <input type="hidden" name="id" id="id" value="">
              </form>

              <!-- /.row -->
              </div>

<!-- /.container-fluid -->
<div class="modal fade" id="add-account-no" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog" role="document">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title" id="exampleModalLabel"><strong>Account Information</strong></h5>
<button type="button" class="close" data-dismiss="modal" aria-label="Close">
<span aria-hidden="true">&times;</span>
</button>
</div>
<div class="modal-body">
<form method="get" action="{{route('hrm.transper.letter')}}">
<div class="form-group">
<label for="check-no" class="col-form-label"><strong>Cheque No<span style="color: red;">*</span></strong></label>
<input type="number" class="form-control" id="check-no" name="check_no" placeholder="Enter Cheque No" required>
</div>
<input type="hidden" value="{{round($total_net_salary)}}"  name="total_amount" id="total_amount">

<input type="hidden" value="{{round($total_bf)}}"  name="total_bf" id="total_bf">
<div class="form-group">
<label for="recipient-name" class="col-form-label"><strong> Account No<span style="color: red;">*</span></strong></label>
<select id="name" class="form-control" name="account_no" required> 

<option value="" selected>Select Account No </option> 
@foreach($company_account_no as $account_no)
<option value="{{ $account_no->account_number}}">{{ $account_no->account_number }}</option> 
@endforeach 

</select>
</div>
<div class="modal-footer">
<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
<button type="submit" class="btn btn-primary">Save</button>
</div>
</form>
</div>

</div>
</div>
</div>

@stop

@section('js')

  <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


  <script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>

  <script>

    $(function () {
    $("#print").on("click", function () {
    window.print();
    });
    });

    $(function () {
    $("#print2").on("click", function () {
    window.print();
    });
    });
    function changetitle(argument) 
    {
    $('title').html(argument);
    }

    $(function() {
    $('#myTable').DataTable({
    'pageLength':25,
    'dom': 'Bfrtip',
    "ordering": false,
    'buttons': [
    'csv', 'excel', 'pdf', 'print'
    ]

    });


    //   $('#myTable1').DataTable({
    //      'pageLength':25,
    //     'dom': 'Bfrtip',
    //     "ordering": false,
    // 'buttons': [
    //      'csv', 'excel', 'pdf', 'print'
    // ]

    // });
    $('#myTable3').DataTable({
      'pageLength':25,
      'dom': 'Bfrtip',
      "ordering": false,
      'buttons': [
      'csv', 'excel', 'pdf', 'print'
      ]

    });

    $('#myTable8').DataTable({
      'pageLength': 25,
      'dom': 'Bfrtip',
      "ordering": false,
      'paging': true,
      'searching': true,
      'info': true,
      'buttons': [
      'csv', 'excel', 'pdf', 'print'
      ]

    });

    });



    function checkSelectedCheckbox()
    {


    var check_ids = [];

    $.each($("input[name='check_list']:checked"), function(){
    check_ids.push($(this).val());
    });


    if(check_ids.length==0)
    {
    document.getElementById('status').style.display = 'block';
    document.getElementById('status').style.color = 'red';
    document.getElementById('status').innerHTML = '<strong><h3>please select any bill!</h3></strong>';
    $('#status').delay(3000).fadeOut();
    }
    else {
    paymentVoucher(check_ids); }



    }

    function paymentVoucher(check_ids) {

    $('#id').val(check_ids);

    $('#voucher-form').submit();

    }


    function AddAccountNo(self ) 
    {

      var total = 0;
      var bf = 0;

    $.each($(self).closest('.tab-pane').find("input[name='chlid_checkbox']:checked"), function(){
      total += Number($(this).val());
      bf += Number($(this).val());
    });

    $('#total_amount').val(total)
    $('#total_bf').val(bf)

    $('#add-account-no').modal('show');

    return false;
    }


    </script>

    <script type="text/javascript">
    $(document).ready(function(){

     $('#select_all').on('click',function(){

     if(this.checked){

      $('.checkbox').each(function(){
      this.checked = true;
    });

    }
    else
    {
      $('.checkbox').each(function(){
      this.checked = false;
    });
    }
    });

    $('.checkbox').on('click',function(){

     if($('.checkbox:checked').length == $('.checkbox').length){
     $('#select_all').prop('checked',true);
    }
    else 
    {
     $('#select_all').prop('checked',false);
    }
    });
    });
    </script>

  <script type="text/javascript">
    $(document).ready(function(){

     $('#select_alls').on('click',function()
     {
      if(this.checked)
    {
     $('.checkbox1').each(function(){
     this.checked = true;
    });
    }
    else
    {
    $('.checkbox1').each(function(){
    this.checked = false;
    });
    }
    });

    $('.checkbox').on('click',function()
    {
    if($('.checkbox:checked').length == $('.checkbox').length)
    {
    $('#select_alls').prop('checked',true);
    }
    else
    {
    $('#select_alls').prop('checked',false);
    }
    });
    });
    </script>

    @stop