<div class="row" style="margin-top:25px;">

    <div class="col-md-12">
        <div class="panel panel-info">
            <div class="panel-heading">Customize Entries</div>
            <div class="panel-wrapper collapse in" aria-expanded="true">
                <div class="panel-body">
                    <form>
                        <div class="form-body">
                            <div class="row">

                                <div class="col-md-4">


                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">By Account</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <div class="input-group-addon">

                                                </div>
                                                <select class="form-control chosen-select" id="c_account">
                                                    <option value="0">None</option>
                                                    @foreach ($accounts as $ac)
                                                        <option value="{{ $ac->id }}">{{ $ac->number }} -
                                                            {{ $ac->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                               

                                <div class="col-md-4">



                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">Date range</label>
                                        <div class="col-sm-9">
                                            <div class="input-group" id="date-div">
                                                <div class="input-group-addon">
                                                    <i class="fa fa-calendar"></i>
                                                </div>
                                                <input type="text" class="form-control pull-right"
                                                    id="daterange-btn" name='date_range'>

                                            </div>
                                            @if ($errors->has('date_range'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('date_range') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                        <!-- /.input group -->
                                    </div>
                                </div>

                                <div class="form-actions pull-right" style="margin-right: 30PX;">
                                    <button type="button" class="btn btn-success update-record"> <i
                                            class="fa fa-check"></i> Update</button>
                                </div>
                            </div>

                        </div>



                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!--./row-->


<div class="pull-right">


    <form class="form-inline" method="get" onsubmit="return getSearcableResult(this)"
        style="position: relative;top: 7rem;right: 2.2rem;z-index: 999;">
        <div class="form-group mb-2">
            <input type="search" name="search_voucher" id="search_voucher" class="form-control"
                placeholder="Search by type & amount">
        </div>

        <button type="submit" class="btn btn-success mb-2">Search</button>
    </form>


</div>

<!-- /row -->
<div class="row" id="update-table">

    <div class="col-sm-12">
        <div class="white-box">

            <h3 class="box-title">List of General Journal Entries</h3>

            <div class="table-responsive">

                <table id="myTable" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>Type</th>
                            <th>Checked</th>
                            <th>Posted</th>
                            <th>Date</th>
                            <th>Entry No.</th>
                            <th>Cheque No.</th>
                            <th>Receipt No.</th>
                            <th>Account</th>
                            <!-- <th>Narration</th> -->
                            <!-- <th>Class</th> -->
                            <th>Debit/Credit (+/-)</th>
                            <th>Action</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($allEntries as $entry)
                            <tr ondblclick="showEntry('{{ $entry->entry_no }}')">

                                @if ($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                    <td>CRV-{{ $entry->voucher_no }}</td>
                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                    <td>BRV-{{ $entry->voucher_no }}</td>
                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                    <td>CPV-{{ $entry->voucher_no }}</td>
                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                    <td>BPV-{{ $entry->voucher_no }}</td>
                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                    <td>JV-{{ $entry->voucher_no }}</td>
                                @else
                                    <td></td>
                                @endif

                                <td>
                                    @if ($entry->is_check)
                                        <i class="fa fa-check" style="color:green"></i>
                                    @else
                                        <i class="fa fa-close" style="color: red;"></i>
                                    @endif

                                <td>
                                    @if ($entry->is_post)
                                        <i class="fa fa-check" style="color:green"></i>
                                    @else
                                        <i class="fa fa-close" style="color: red;"></i>
                                    @endif
                                </td>

                                <td>{{ date('d/m/Y', strtotime($entry->date)) }}</td>
                                <td class="text-right">{{ $entry->entry_no }}</td>
                                <td>
                                    {{ $entry->cheaque_no ? $entry->cheaque_no : '' }}
                                </td>

                                <td>
                                    @if ($entry->dealer_package_voucher == 1)
                                        @if ($entry->dealerReceipt)
                                            <a
                                                href="{{ route('openfile.package.detailReceipt', [$entry->dealerReceipt->id]) }}">
                                                {{ $entry->dealerReceipt->receipt_no }}
                                            </a>
                                        @endif
                                    @elseif($entry->customer_refund_unit == 1)
                                        @if ($entry->customerUnitRefundReceipt)
                                            <a
                                                href="{{ route('receipt.refund-openfile.detail', [$entry->customerUnitRefundReceipt->id]) }}">
                                                {{ $entry->customerUnitRefundReceipt->receipt_no }}
                                            </a>
                                        @endif
                                    @elseif($entry->dealer_refund_openfile == 1)
                                        @if ($entry->dealerOpenFileRefundReceipt)
                                            <a
                                                href="{{ route('receipt.refund.detail', [$entry->dealerOpenFileRefundReceipt->id]) }}">
                                                {{ $entry->dealerOpenFileRefundReceipt->receipt_no }}
                                            </a>
                                        @endif
                                    @elseif($entry->cancel_close_unit == 1)
                                        @if ($entry->CustomerCancelUnitReceipt)
                                            <a
                                                href="{{ route('receipt.cancel-closeunit.detail', [$entry->CustomerCancelUnitReceipt->id]) }}">
                                                {{ $entry->CustomerCancelUnitReceipt->receipt_no }}
                                            </a>
                                        @endif
                                        @elseif($entry->cancel_open_unit == 1)
                                        @if ($entry->DealerOpenFileCancelReceipt)
                                            <a
                                                href="{{ route('receipt.cancel-openunit.detail', [$entry->DealerOpenFileCancelReceipt->id]) }}">
                                                {{ $entry->DealerOpenFileCancelReceipt->receipt_no }}
                                            </a>
                                        @endif
                                    @else
                                        @if ($entry->receipt)
                                            <a href="{{ route('receipt.detail', [$entry->receipt->id]) }}">
                                                {{ $entry->receipt->receipt_no }}
                                            </a>
                                        @endif
                                    @endif
                                </td>

                                <td>{{ $entry->account ? $entry->account->name : '' }}</td>
                                <!-- <td>{{ $entry->voucher ? $entry->voucher->narration : '' }}</td> -->
                                <!-- <td>{{ $entry->class ? $entry->class->name : '' }}</td> -->
                                <td class="text-right">{{ number_format($totalAmount[$entry->entry_no]) }}</td>
                                <td>
                                    <!-- <span onclick="showEntry('{{ $entry->entry_no }}')" style="cursor: pointer;" class="btn btn-sm btn-primary"> Show</span> -->

                                    @permission('view-voucher')
                                        <a href="{{ route('voucher-detail', ['id' => $entry->entry_no]) }}"
                                            class="btn btn-sm btn-default">View</a>
                                    @endpermission

                                    @permission('delete-voucher')
                                        <a href="{{ route('voucher-delete', ['id' => $entry->entry_no]) }}"
                                            class="btn btn-sm btn-danger" data-toggle="confirmation"
                                            data-placement="left" data-title="Are you sure to delete?">Delete</a>
                                    @endpermission



                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
                {{ $allEntries->links() }}
            </div>
        </div>
    </div>
</div>