@extends('layouts.app')

@section('title')
Pay Slip
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Pay Slip</li>
</ol>
@stop

@section('css')
<style type="text/css">
	.only-print{
		display:none;
	}
    
    @media print {
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        padding-top: 0px !important
    }
    .printableArea {
        color: black;
    }
    strong{
        color: black;
    }
        .white-box {
            border: none !important;
        }
        
        .table>thead>tr>th, .user-table .table tbody>tr:last-child td {
    border-bottom: 1px solid #2e3233;
    line-height: 2.2;
    background: #eee;
    border-right: 1px solid;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    .table>tbody>tr>td{
        padding: 5px 3px 0 4px;
        vertical-align: top;
    }
    h3{
        font-size: 21px !important;
    }
    .panel .panel-body{
        padding:0;
    }
    .fix-header .page-wrapper {
    margin-top: 0px !important;
    }
    h4 strong{
        text-transform: uppercase;
    }
    h3{
        margin-bottom: -10px;
    }
    .mt-20{
        margin-top: 40px;
    }
	.bor{
		border: 1px solid !important;
	}
	.no-bor{
		border: none!important;
	}
	.th-bor th{
		border: 1px solid !important;
	}
	.th-bor td{
		border: 1px solid !important;
	}
	.only-print{
		display:block;
	}
	.mt-50{
		margin-top: 50px;
	}
    }
</style>
@endsection

@section('content')


            <div class="container-fluid">

                 <!--.row-->
                <div class="row printableArea">
                    <div class="col-md-12" >
                        <div class="white-box">
                        
                        <div class="panel panel-info" >
                            <div class="panel-heading no-print" style="text-align: center;">
                            @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                            
                            Cash Receipt Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                            Bank Receipt Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                            Cash Payment Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                            Bank Payment Voucher
                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                           Journal Voucher
                            @endif

                           

                            @if($next)
                            <span class="pull-right"><a href="{{route('voucher-detail',['id'=>$entry->entry_no + 1])}}"> <i class="fa fa-arrow-right " style="font-size:26px;"></i></a></span>

                            @endif

                            &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;

                             @if($previous)

                            <span class="pull-right"><a href="{{route('voucher-detail',['id'=>$entry->entry_no - 1])}}"> <i class="fa fa-arrow-left fa-2x" style="font-size:26px;"></i></a></span>

                            @endif

                            </div>


                            @if($entry->is_post)
                            <div class="ribbon ribbon-bookmark  ribbon-primary no-print" style="background-color:green">Posted</div>
                            @elseif($entry->is_check)
                            <div class="ribbon ribbon-bookmark  ribbon-primary no-print">Checked</div>
                            @else
                            <div class="ribbon ribbon-bookmark  ribbon-danger no-print">Prepared</div>
                            @endif
                            
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <div class="row text-center">
                                       <h3><strong>{{env('APP_NAME')}}</strong></h3>
                                       <h4><strong><u>PAYSLIP</u></strong></h4> 
                                    </div>
                                    <div class="row"><br>
                                        <div class="col-md-4 col-xs-4">
                                           
                                            <span>Name: <b>Nadeem Akhter</b></span><br>
											<span>Designation: <b>Software Developer</b></span>
                                            
                                        </div>
                                        <div class="col-md-4 col-xs-4">
                                            <span>Employee ID: <b>15</b><br>
											<span>Period: <b>AUG-SEP-21</b>
                                        </div>
                                        <div class="col-md-4 col-xs-4">
                                            <span>Payement Type: <b>Monthly</b><br>
											<span>Payment Date: <b>1-SEP-2021</b>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class=col-md-12 >
                                            <table class="table">
                                                <thead>
                                                    <tr style="border: 1px solid;">
                                                        <th >EARNINGS</th>
                                                        <th>DAYS</th>
                                                        <th>GROSS SALARY</th>
                                                        <th class="text-center">ADVANCE</th>
                                                        <th class="text-center">NET SALARY</th>
                                                        
                                                    </tr>

                                                </thead>
                                                <tbody>
												<tr>
												<td>Basic Pay</td>
												<td>23</td>
												<td class="text-right">25000</td>
												<td class="text-right">5000</td>
												<td class="text-right">235000</td>
												</tr>
												<tr>
												<td>Commission and Bonus</td>
												<td>23</td>
												<td class="text-right">25000</td>
												<td class="text-right">5000</td>
												<td class="text-right">235000</td>
												</tr>
												<tr>
												<td>Outstanding salary</td>
												<td>23</td>
												<td class="text-right">25000</td>
												<td class="text-right">5000</td>
												<td class="text-right">235000</td>
												</tr>
												<tr>
												<td class="text-center bor" colspan="5">DEDUCTIONS</td>
												</tr>
												<tr>
												<td>Late coming fine</td>
												<td>5</td>
												<td>&nbsp;</td>
												<td>&nbsp;</td>
												<td class="text-right">1500</td>
												</tr>
												<tr>
												<td class="text-right" colspan="4"><b>NET PAY</b></td>
												<td class="bor text-right"><b>450500</b></td>
												</tr>
												</tbody>
                                        </table>
                                        
                                    </div>
                                   

                                </div>

                                <div class="clearfix"></div>

                                <div class="row">
                            <br><br><br>
                                    <div class="col-md-12">

                                                            <div class="col-md-4 col-xs-4 text-center">
                                   &nbsp;
                                    </div>

                                <div class="col-md-4 col-xs-4 text-center">
                                    &nbsp;
                                    </div>

                                

                                <div class="col-md-4 col-xs-4 text-center mt-50">
                                    <span><b>&nbsp;</b></span>
                                    <div style="text-align: center; border-top: 2px solid;">
                                    <span style="text-align:center; font-weight: bold;font-size: 14px">Approved By</span></div></div>
                            </div>

                                    
                                    

                                   
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>

            @permission('print-voucher')
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
        <button  class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        @endpermission



    </div>

    
        
                <!--./row-->

                

                
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':50,
            'ordering' : false,
            });

    });

</script>

@stop