@extends('layouts.app')
@section('title')
Payment Receipt 
@stop

@section('css')
<style type="text/css">
    @page  
{ 
    size: auto;   /* auto is the initial value */ 
    margin: 0mm 0mm 0mm 0mm;  
} 
.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}
.container-fluid {
    padding: 3px 30px 0;
}
</style>
@stop

@section('content')

<div class="container-fluid">

     <!-- /row -->
     <br>
                <div class="row ">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Receipt Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Receipt #</td>
                                                    <td>{{$receipt->receipt_no}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Date</td>
                                                    <td>{{date('d-m-Y',strtotime($receipt->receipt_date))}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Customer</td>
                                                    <td>{{$receipt->customer->name}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Unit No.</td>
                                                    <td> {{$receipt->property->inventory ? $receipt->property->inventory->unit_number : ''}} </td>
                                                </tr>

                                                <tr>
                                                    <td>Payment Head</td>
                                                    <td>@if($receipt->payment_head == \App\Receipt::down_payment)
														Down Payment
                                @elseif($receipt->payment_head == \App\Receipt::installment)
                                Installment
                                @elseif($receipt->payment_head == \App\Receipt::others)
                                Others
                                @endif</td>
                                                </tr>

                                               <tr>
                                                    <td>Payment Mode</td>
                                                    @if($receipt->payment_method == \App\Receipt::cash)
                                                    <td>Cash</td>
                                                    @elseif($receipt->payment_method == \App\Receipt::bank)
                                                    <td>Bank transfer
                                                        <br>
                                                        <b>Depositor bank:</b> 

                                                    {{$receipt->DepositorBank ? $receipt->DepositorBank->name : ''}}

                                                    <br>
                                                    <b>Company bank:</b> 

                                                    {{$receipt->companyAccount ? $receipt->companyAccount->name : ''}}


                                                </td>
                                                    @elseif($receipt->payment_method == \App\Receipt::cheque)
                                                    <td>Cheque</td>
                                                    @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                                    <td>Adjustment</td>
                                                    @endif
                                                </tr>
                                                
                                                @if($receipt->payment_method == \App\Receipt::cheque || $receipt->payment_method == \App\Receipt::bank)
                                                 <tr>
                                                    <td>Instrument No </td>
                                                    <td>{{$receipt->cheque_number}}</td>
                                                </tr>
                                                @endif

                                                <tr>
                                                    <td>Gross Amount</td>
                                                    <td>{{number_format($receipt->amount)}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Tax Amount</td>
                                                    <td>
                                                        @if($receipt->tax_paid_by == \App\Receipt::company)

                                                        {{number_format($receipt->tax_amount)}}
                                                    @else
                                                    {{number_format(0)}}

                                                @endif</td>
                                                </tr>

                                                 <tr>
                                                    <td>Net Amount</td>
                                                    @if($receipt->tax_paid_by == \App\Receipt::company)
                                                    <td>{{number_format($receipt->amount + $receipt->tax_amount)}}</td>

                                                    @else

                                                    <td>{{number_format($receipt->amount)}}</td>

                                                    @endif
                                                </tr>

                                                <tr>
                                                    <td>Tax Pay By</td>
                                                    <td>@if($receipt->tax_paid_by == \App\Receipt::customer)
                                                        Customer
                                                        @else
                                                        Company
                                                    @endif</td>
                                                </tr>

                                                <tr>
                                                    <td>Tax Payment Received</td>
                                                    <td>@if($receipt->tax_payment_received)
                                                        YES
                                                        @else
                                                        NO
                                                    @endif
                                                </td>
                                                </tr>

                                                <tr>
                                                    <td>Notes</td>
                                                    <td>{{$receipt->notes}}</td>
                                                </tr>
                                                

                                                @if($receipt->payment_method == \App\Receipt::adjustment)
                                                <tr>
                                                    <td>Adjustment Detail</td>
                                                    <td>{{$receipt->adjustment_detail}}</td>
                                                </tr>

                                                @if($receipt->dealer_adjustment_unit_id)
                                                <tr>
                                                    <td>Rebate Detail</td>
                                                    <td>Adjust againt {{$receipt->rebate->property->inventory->unit_number}}</td>
                                                </tr>
                                                @endif

                                                @endif
                                               
                                            

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>

    
            

   
    <div style="display: inline-block; ">



    <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
        <button  class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>

        @permission('create-voucher')

        <a onclick="$('#voucher-form').submit()" href="#"><button  class="btn btn-default btn-outline"  type="button"> <span><i class="fa fa-money"></i> Make Receipt Voucher</span> </button></a>

        @endpermission

        

        <form id="voucher-form" method="post" action="{{route('create-voucher')}}">
            {{csrf_field()}}
        <input type="hidden" name="type" value="{{\App\GeneralJournalEntry::receipt}}">
        <input type="hidden" name="id" value="{{$receipt->id}}">
        <input type="hidden" name="control" value="{{\App\ControlAccount::CUSTOMER}}">

        </form>

    </div>
    
</div>
</div>
<!-- /.container-fluid -->



@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>
$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>
@stop