@extends('layouts.app')

@section('title')
Generate Voucher
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

    <li class="active">Vouchers</li>
</ol>
@stop

@section('css')

<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />


@endsection

@section('content')


<div class="container-fluid">

    <!--.row-->
    <div class="row">

        <div class="col-md-12" style="padding:0px;">
            <div class="panel panel-info">
                <div class="panel-heading">Make Voucher</div>
                <div class="panel-wrapper collapse in" aria-expanded="true">
                    <div class="panel-body" style="    margin-bottom: 36px;">


                        <hr>
                        <form id="form-div">

                            {{csrf_field()}}


                            <b>Voucher Type</b> 
                            <input type="radio" name="voucher_type" value="{{\App\GeneralJournalEntry::BPV}}" @if(\App\GeneralJournalEntry::BPV== $voucher_type) checked @endif> BPV &nbsp;&nbsp;&nbsp;
                            <input type="radio" name="voucher_type" value="{{\App\GeneralJournalEntry::CPV}}" @if(\App\GeneralJournalEntry::CPV== $voucher_type) checked @endif > CPV &nbsp;&nbsp;&nbsp; 
                            <input  type="radio" name="voucher_type" value="{{\App\GeneralJournalEntry::BRV}}" @if(\App\GeneralJournalEntry::BRV== $voucher_type) checked @endif> BRV &nbsp;&nbsp;&nbsp; 
                            <input type="radio" name="voucher_type" value="{{\App\GeneralJournalEntry::CRV}}" @if(\App\GeneralJournalEntry::CRV== $voucher_type) checked @endif> CRV &nbsp;&nbsp;&nbsp; 
                            <input type="radio" name="voucher_type" value="{{\App\GeneralJournalEntry::JV}}" @if(\App\GeneralJournalEntry::JV== $voucher_type) checked @endif> JV &nbsp;&nbsp;&nbsp;

                            <br><br>
                            <input type="hidden" id="entry_no" name="entry_no" value="{{$account_info[0]->entry_no}}">
                            <input type="hidden" id="transaction_id" name="transaction_id" value="{{$transaction_id}}">

                            <input type="hidden" id="transaction_type" name="transaction_type" value="{{$transaction_type}}">

                            <div class="row">
                                <div class="col-md-4">
                                    Bank Name &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="text" name="bank_name" id="bank_name" value="{{ $account_info[0]->bank_name}}">

                                </div>

                                <div class="col-md-4">
                                   Ins. # &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="text" id="cheaque_no" name="cheaque_no" value="{{ $account_info[0]->cheaque_no}}">

                                </div>

                            </div>

                            <br><br>

                            <div class="row">
                                <div class="col-md-3">
                                    DATE &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="date" id="date" name="date" value="<?php echo $account_info[0]->date; ?>">

                                </div>
                                <div class="col-md-3">
                                    <input type="checkbox" style="background-color: #f7fafc;" name="adjusting_entry" id="adjusting_entry" value="{{ $account_info[0]->adjusting_entry}}"> &nbsp;&nbsp;ADJUSTING ENTRY
                                </div>

                                <br>

                                <br> <br>

                                <div class=col-md-12 style="overflow-y:auto;height: 220px;">
                                    <table class="table table-bordered table-responsive-md table-striped text-center">
                                        <thead>
                                            <tr>

                                                <th class="text-center">ACCOUNT</th>
                                                <th class="text-center">DEBIT</th>
                                                <th class="text-center">CREDIT</th>

                                                <th class="text-center">NAME</th>
                                                <th class="text-center" style="display: none;">CLASS</th>

                                            </tr>

                                        </thead>
                                        <tbody id="tbody_data" >
                                            <?php $used_account_count = count($account_info);
                                                $credit=0;
                                                $debit=0;
                                               
                                            ?>
                                            <?php for ($i = 0; $i < $count; $i++) { ?>
                                                <tr height="2px" id="account_tr_{{$i}}"  data-id="{{$i}}"  >

                                                    <td class="pt-3-half account" style="width: 40%" contenteditable="true">
                                                        <select class="form-control chosen-select us_acnt" style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;" name="account[]">
                                                            <option value="0">None</option>
                                                            @foreach($accounts as $a)

                                                            @if($leafAccount[$a->id])

                                                            @if($a->sub_account_id)
                                                            <option style="font-size: 11px;" value="{{$a->id}}" @if($i < $used_account_count)
                                                                @if($a->id==$account_info[$i]->account_id) selected 
                                                                @endif
                                                            @endif>&nbsp;&nbsp;&nbsp;{{$a->number}} - {{$a->name}}</option>
                                                            @else
                                                            <option style="font-size: 11px;" value="{{$a->id}}" 
                                                            >{{$a->number}} - {{$a->name}}</option>
                                                            @endif

                                                            @else

                                                            @if($a->sub_account_id)
                                                            <option style="font-size: 11px;" value="{{$a->id}}" disabled="">&nbsp;&nbsp;&nbsp;{{$a->number}} - {{$a->name}}</option>
                                                            @else
                                                            <option style="font-size: 11px;" value="{{$a->id}}" disabled="">{{$a->number}} - {{$a->name}}</option>
                                                            @endif



                                                            @endif
                                                            @endforeach
                                                        </select>
                                                    </td>
    <td class="pt-3-half debit"  onfocusout="return setZeroBydefault(this)"  onkeyup="addDebit(this)" contenteditable="true">
    @if($i < $used_account_count)
        @if($account_info[$i]->amount>0) 
          {{ $account_info[$i]->amount }} 
          <?php  $debit = $debit + $account_info[$i]->amount; ?>
        @else
            0
        @endif
        @else
         0

    @endif
    </td>

    <td class="pt-3-half credit"  onfocusout="return setZeroBydefault(this)"  onkeyup="addCredit(this)" contenteditable="true">
    @if($i < $used_account_count)
        @if($account_info[$i]->amount<0) 
          {{ ($account_info[$i]->amount) * -1 }}
          <?php  $credit = $credit + (($account_info[$i]->amount) * -1); ?>
        @else
            0
        @endif
        @else
         0
    @endif
    </td>


                                                    <td class="pt-3-half name" contenteditable="true">
                                                        <select class="form-control chosen-select" style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;" name="name1[]">
                                                            <option value="0">None</option>
                                                            @foreach($names as $n)
                                                            <option style="font-size: 11px;" value="{{$n->id}}" @if($i < $used_account_count)
                                                                @if($n->id==$account_info[$i]->name) selected 
                                                                @endif
                                                            @endif>{{$n->name}}</option>
                                                            @endforeach

                                                        </select>
                                                    </td>

                                                    <td class="pt-3-half name" contenteditable="true" style="display: none;">
                                                        <select class="form-control chosen-select" style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;" name="class_id[]">


                                                            <option style="font-size: 11px;" value="{{env('PROJECT_ID')}}">{{env('APP_NAME')}} </option>


                                                        </select>
                                                    </td>
                                                    
                                                    
                                                <td class="pt-3-half name" >
                                                <button type="button" class="btn btn-sm btn-success btn-sm addRowBtn" data-id="{{$i}}" onclick="addNewRow(this)"><i class="fa fa-plus" ></i></button>
                                                 <button type="button" class="btn btn-sm btn-danger btn-sm" onclick="removeParentDiv(this)"><i class="fa fa-times" ></i></button>
                                                </td>

                        
                                                </tr>
                                                <tr  height="2px" id="narration_tr_{{$i}}"  class="tr_{{$i}}">
                                                        <td colspan="4" style="text-align: center;width: 90%; padding-left:50px;padding-right:30px"><input class="form-control" type="text" name="line_narration[]" id="line_narration[]" placeholder="Line Narration" value="@if($i < $used_account_count) {{ $account_info[$i]->memo }} @endif"></td>
                                                    </tr>
                                            <?php } ?>




                                    <tr height="2px" id="account_tr_{{$count+1}}" data-id="{{$count+1}}" style="display:none;">
                                    
                                    <td class="pt-3-half account"  style="width: 40%" contenteditable="true">
                                    
                                    
                                    <select class="form-control chosen-select us_acnt"  style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;" name="account[]">
                                    <option value="0">None</option>
                                    @foreach($accounts as $a)
                                    
                                    @if($leafAccount[$a->id])
                                    
                                    @if($a->sub_account_id)
                                    <option style="font-size: 11px;" value="{{$a->id}}">&nbsp;&nbsp;&nbsp;{{$a->number}} - {{$a->name}}</option>
                                    @else
                                    <option style="font-size: 11px;" value="{{$a->id}}">{{$a->number}} - {{$a->name}}</option>
                                    @endif
                                    
                                    @else
                                    
                                    @if($a->sub_account_id)
                                    <option style="font-size: 11px;" value="{{$a->id}}" disabled="">&nbsp;&nbsp;&nbsp;{{$a->number}} - {{$a->name}}</option>
                                    @else
                                    <option style="font-size: 11px;" value="{{$a->id}}" disabled="">{{$a->number}} - {{$a->name}}</option>
                                    @endif
                                    
                                    
                                    
                                    @endif
                                    @endforeach
                                    </select>
                                    </td>
                                    <td class="pt-3-half debit" onfocusout="return setZeroBydefault(this)" onkeyup="addDebit(this)"  contenteditable="true"></td>
                                    <td class="pt-3-half credit" onfocusout="return setZeroBydefault(this)"  onkeyup="addCredit(this)" contenteditable="true"></td>
                                    
                                    
                                    <td class="pt-3-half name" contenteditable="true">
                                    <select class="form-control chosen-select name1"  style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;" >
                                    <option value="0">None</option>
                                    @foreach($names as $n)
                                    <option style="font-size: 11px;" value="{{$n->id}}">{{$n->name}}</option>
                                    @endforeach
                                    
                                    </select>
                                    </td>
                                    
                                    <td class="pt-3-half name" >
                                    <button type="button" class="btn btn-sm btn-success btn-sm addRowBtn" data-id="{{$i}}" onclick="addNewRow(this)"><i class="fa fa-plus" ></i></button>
                                     <button type="button" class="btn btn-sm btn-danger btn-sm" onclick="removeParentDiv(this)"><i class="fa fa-times" ></i></button>
                                    </td>
                                    
                                    </tr>
                                    
                                   
                                    
                                     <tr id="narration_tr_{{$count+1}}" style="display:none;">
                                    <td colspan="4" style="text-align: center;width: 90%; padding-left:50px;padding-right:30px"><input class="form-control h30 line_narration" type="text"  id="line_narration[]" placeholder="Line Narration"></td>
                                    </tr>



                                        </tbody>
                                    </table>
                                </div>
                                <table class="table">
                                    <tr>
                                        <th style="text-align: right;width: 37%;">Totals</th>
                                        <th style="text-align: center; width: 10%; font-size: 16px;font-weight: 600;" id="debit-total">{{ $debit}}</th>
                                        <th style="text-align: center;width: 10%; font-size: 16px; font-weight: 600;" id="credit-total">{{ $credit}}</th>
                                        <th></th>
                                        <th></th>
                                    </tr>
                                </table>

                                <div class="col-md-4">
                                    Narration : &nbsp;&nbsp;<textarea class="form-control" name="memo" id="memo">{{  $account_info[0]->voucher?$account_info[0]->voucher->narration:'' }}</textarea>
                                </div>



                                <div class="form-actions">
                                    <button style="float: right;margin-right: 20px;" type="button" class="btn btn-success search-customer" id="search" @if($debit!=$credit) disabled="" @endif> <i class="fa fa-check"></i> Save </button>

                                    <!--<button style="float: right;margin-right: 20px;" type="button" class="btn btn-info" onclick="return addNewRow(this)"> <i class="fa fa-plus" ></i> Add </button>-->


                                </div>
                        </form>


                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--./row-->




</div>
<!-- /.container-fluid -->

@stop

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script>

function removeParentDiv(self)
{
  var id = $(self).closest('tr').data("id");
  
    $('#account_tr_'+id).remove()
    $('#narration_tr_'+id).remove()
}

window.setInterval(function(){
    
    $('.debit').each(function(){
            if(this.innerHTML == "") {
                this.innerHTML = 0;
            }
        });
        
        
        $('.credit').each(function(){
            if(this.innerHTML == "") {
                this.innerHTML = 0;
            }
        });
        
        
        $('.line_narration').each(function(){
            if (!$(this).attr("name"))
            {
                $(this).attr('name', 'line_narration[]')
            }
        });
        
        
        $('.name1').each(function(){
            if (!$(this).attr("name"))
            {
                $(this).attr('name', 'name1[]')
            }
        });
       
        
        $('#account_tr_{{$i+1}}').find('.name1').removeAttr('name', 'name1[]');
       $('#narration_tr_{{$i+1}}').find('.line_narration').removeAttr('name', 'line_narration[]');
    
    
}, 1000);

$('.us_acnt').on('change', function() {
     
          if(($(this).closest('tr').find('.debit').html() > 0 || $(this).closest('tr').find('.credit').html() > 0) && $(this).val() == 0 )
        {
            $( "#search" ).prop( "disabled",true );
        } 
        else if(($(this).closest('tr').find('.debit').html() > 0 || $(this).closest('tr').find('.credit').html() > 0) && $(this).val() > 0 )
        {
             $( "#search" ).prop( "disabled",false );
        }
        
        
          if(  ($('#debit-total').html() > 0 && $('#credit-total').html() > 0) &&  ($('#credit-total').html() != $('#debit-total').html()) )
    {
        $( "#search" ).prop( "disabled",true);
    }
  
    
    });
    
//   function addNewRow(self) 
// {
//     $(".chosen-select").chosen("destroy");

//     var narration_row = $('#narration_tr_{{$i+1}}').html();
//     var account_row = $('#account_tr_{{$i+1}}').html();
//     var rand_id = Math.floor(Math.random() * 100);
    
//     $('#tbody_data').append('<tr  id="account_tr_'+rand_id+'"  data-id="'+rand_id+'" >'+account_row+'</tr> <tr id="narration_tr_'+rand_id+'">'+narration_row+'</tr>' );
//     $("#account_tr_"+rand_id).find('.debit').text(0)
//     $("#account_tr_"+rand_id).find('.credit').text(0)
//     $("#account_tr_"+rand_id).find('.name1').attr('name', 'name1[]');
//     $("#narration_tr_"+rand_id).find('.line_narration').attr('name', 'line_narration[]');
    
//      $("#narration_tr_"+rand_id).show();
//     $("#account_tr_"+rand_id).show();
    
//     $(".chosen-select").chosen();
    
//      return false;
// }

   function addNewRow(self ) 
{
    $(".chosen-select").chosen("destroy");

    var narration_row = $('#narration_tr_{{$i+1}}').html();
    var account_row = $('#account_tr_{{$i+1}}').html();
    var rand_id = Math.floor(Math.random() * 100);
    var tr_id = $(self).data("id");
    
    $('.tr_'+tr_id).after('<tr  id="account_tr_'+rand_id+'"  data-id="'+rand_id+'" >'+account_row+'</tr> <tr id="narration_tr_'+rand_id+'"   class="tr_'+rand_id+'">'+narration_row+'</tr>' );
    $("#account_tr_"+rand_id).find('.debit').text(0)
    $("#account_tr_"+rand_id).find('.credit').text(0)
    $("#account_tr_"+rand_id).find('.name1').attr('name', 'name1[]');
    $("#account_tr_"+rand_id).find('.addRowBtn').data('id',rand_id);
    $("#narration_tr_"+rand_id).find('.line_narration').attr('name', 'line_narration[]');
    
    $("#narration_tr_"+rand_id).show();
    $("#account_tr_"+rand_id).show();
    
    $(".chosen-select").chosen();
    
     return false;
}



    $(function() {
        $('#myTable').DataTable({
            'pageLength': 50,
            'ordering': false,
        });

    });

    const year = new Date().getFullYear();


  function setZeroBydefault(self) 
    {
        if ($(self).text().length == 0) 
        {
            $(self).text('0');
        }
    }



    $('.update-record').on('click', function() {

        $('.preloader').fadeIn();

        date_range = $('#daterange-btn').val();
        account = $('#c_account').val();
        name = $('#c_name').val();


        var data = {
            'date_range': date_range,
            'account': account,
            'name': name
        };
        $.get('/general-journal-entries/update-entries', data, function(data) {
            document.getElementById('update-table').innerHTML = data;

            $('#myTable').DataTable({
                'paging': false,
                'searching': false,
                'info': true
            });
            toastr.success("Report updated.");
        });

        $('.preloader').fadeOut();
    });

    function addDebit() {
        sum = 0;
         $response = 1;
        $('.debit').each(function() {
            if (this.innerHTML) {
                sum += parseInt(this.innerHTML);
            }
        });
        document.getElementById('debit-total').innerHTML = sum;
         if($(self).closest('tr').find('.us_acnt').val() == 0)
        {
            $response = 0;
        }
        
        
        if($response == 1)
        {
            checkTotal();
        }
        else
        {
            $( "#search" ).prop( "disabled",true );
        }
    }

    function addCredit() {
        sum = 0;
         $response = 1;
        $('.credit').each(function() {
            if (this.innerHTML) {
                sum += parseInt(this.innerHTML);
            }
        });
        document.getElementById('credit-total').innerHTML = sum;
         if($(self).closest('tr').find('.us_acnt').val() == 0)
        {
            $response = 0;
        }
        
        
        if($response == 1)
        {
            checkTotal();
        }
        else
        {
            $( "#search" ).prop( "disabled",true );
        }
    }

    function checkTotal() {

        debit = parseInt(document.getElementById('debit-total').innerHTML);
        credit = parseInt(document.getElementById('credit-total').innerHTML);
        if (debit == credit) {
            $("#search").prop("disabled", false);

            document.getElementById('debit-total').style.color = 'black';
            document.getElementById('credit-total').style.color = 'black';
            $("#update").prop("disabled", false);
        } else {
            $("#search").prop("disabled", true);

            document.getElementById('debit-total').style.color = 'red';
            document.getElementById('credit-total').style.color = 'red';
            $("#update").prop("disabled", false);
        }

    }

    $('#search').click(function() {

        document.getElementById("search").disabled = true;

        date = $('#date').val();
        entry_no = $('#entry_no').val();
        adjusting_entry = 0;
        if ($('#adjusting_entry').prop("checked") == true) {
            adjusting_entry = 1;
        }
        account = [];
        $('select[name="account[]"]').each(function() {
            if ($(this).val() != 0)
                account.push($(this).val());
        });
        name1 = [];
        $('select[name="name1[]"]').each(function() {
            name1.push($(this).val());
        });

        class_id = [];
        $('select[name="class_id[]"]').each(function() {
            class_id.push($(this).val());
        });

        debit = [];
        $('.debit').each(function() {
            if (this.innerHTML) {
                debit.push(parseInt(this.innerHTML));
            }
        });

        credit = [];
        $('.credit').each(function() {
            if (this.innerHTML) {
                credit.push(parseInt(this.innerHTML));
            }
        });

        memo = $('#memo').val();

        var line_narration = $("input[name='line_narration[]']")
              .map(function(){return $(this).val();}).get();

        voucher_type = $("input[type='radio'][name='voucher_type']:checked").val();

        if (!voucher_type) {
            alert('voucher type required.');

            return false;
        }

        transaction_id = $('#transaction_id').val();
        transaction_type = $('#transaction_type').val();

        bank_name = $('#bank_name').val();
        cheaque_no = $('#cheaque_no').val();


        data = {
            'date': date,
            'entry_no': entry_no,
            'adjusting_entry': adjusting_entry,
            'account': account,
            'debit': debit,
            'credit': credit,
            'memo': memo,
            'name': name1,
            'class_id': class_id,
            'voucher_type': voucher_type,
            'transaction_id': transaction_id,
            'transaction_type': transaction_type,
            'bank_name': bank_name,
            'cheaque_no': cheaque_no,
            'line_narration':line_narration
        };
      
        $.get('/general-journal-entries/update-voucher', data, function(data) {
            
             if (data == 'date_error') 
            {
                    toastr.error("Invalid date!");
                  document.getElementById("search").disabled = false;
            }
            else
            {

            toastr.success("Entry updated successfully.");

            window.location.href = '/general-journal-entries/voucher-detail/' + data.entry_no;   
            }
            
        });
    });
</script>

@stop