@extends('layouts.app')

@section('title')
Vendor Certificate
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Vendor Certificate</li>
</ol>
@stop

@section('css')

<style type="text/css">

.white-box .box-title {
    color: black !important;
}



@media print {
    
    .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        padding-top: 0px !important
    }
    
    .printableArea {
        color: black;
    }
    
    strong{
        color: black;
    }
    
    .white-box {
        border: none !important;
    }
    
    .table>thead>tr>th, .user-table .table tbody>tr:last-child td {
        border-bottom: 1px solid #2e3233;
        line-height: 2.2;
        background: #eee;
        border-right: 1px solid;
    }
    
    .table>tbody>tr>td, .table>tbody>tr>th {
        font-size: 12px;
    }
    
    .table>tbody>tr>td {
        padding: 5px 3px 0 4px;
        vertical-align: top;
    }
    
    h3 {
        font-size: 21px !important;
    }
    
    .panel .panel-body {
        padding:0;
    }
    
    .fix-header .page-wrapper {
        margin-top: 0px !important;
    }
    
    h4 strong {
        text-transform: uppercase;
    }
    
    h3 {
        margin-bottom: -10px;
    }
    
    .mt-20 {
        margin-top: 40px;
    }
	
	.bor {
		border: 1px solid !important;
	}
	
	.no-bor {
		border: none!important;
	}
	
	.th-bor th {
		border: 1px solid !important;
	}
	
	.th-bor td {
		border: 1px solid !important;
	}
	
	.only-print {
		display:none;
	}
	
	.mt-50 {
		margin-top: 50px;
	}
	
}

</style>

@stop

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="white-box">
				<!--------------Start Ffrom Here---------------------------------------->
				<br>
				<div class="row">
					<div class="col-sm-12 col-xs-12">
						<h3 class="box-title text-center " style="text-transform: uppercase;">
                            <span class="font-size" style="font-weight:bolder;">Certificate of Collection OR Deduction of Tax</span>
                        </h3>
						<h3 class="box-title text-center " style="">
                            <span><u>(See Rule 42)</u></span>
                        </h3> 
                    </div>
				</div>
				<div class="row">
					<div class="col-sm-4 col-xs-4">
						<p><strong>S.No {{rand(000000,999999)}}</strong></p>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p><strong>Original/Duplicate</strong></p>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>Date of issue &nbsp; <strong>{{date('d/m/Y')}}</strong></p>
					</div>
				</div>
				<br>
				<div class="row">
					<div class="col-sm-2 col-xs-2">
						<p>Certified that a sum of</p>
					</div>
					<div class="col-sm-10 col-xs-10">
						<p>Rs: <span style="display:inline-block; width:160px; border-bottom:1px solid black">&nbsp;&nbsp;&nbsp;{{number_format($vendor_certificate->total_tax_amount , 2)}}</span><strong>-</strong>/- <span style="font-size: 12px;">(Amount of tax collected/deducted in figure)</span></p>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-1 col-xs-1"> </div>
					<div class="col-sm-11 col-xs-11">
						<p style="display:flex;">Rupees: <span style="flex:1; border-bottom:1px solid black;">&nbsp;&nbsp;&nbsp;{{$total_tax}}</span></p>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-12 col-xs-12">
						<p>On account of Income Tax has</p>
						<p style="display:flex;">Been collected / deducted from - <span style="flex:1; border-bottom:1px solid black;">&nbsp;&nbsp;&nbsp;{{$vendor_certificate->control_account->name}}</span></p>
						<p style="display:flex;">(Name of Address of person <span style="flex:1;">&nbsp;</span></p>
						<p style="display:flex;">From whom tax collected/deducted) - <span style="flex:1; border-bottom:1px solid black;">&nbsp;&nbsp;&nbsp;{{$vendor_certificate->control_account->address}}</span></p>
					</div>
				</div>
				<br>
				<div class="row">
					<div class="col-sm-12 col-xs-12">
						<p><span class="col-sm-2 col-xs-2"></span>In case of individual, his/her name in full and in case of an association of person/company, name and style of the association of persons/company </p>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-8 col-xs-8"></div>
					<div class="col-sm-4 col-xs-4">
						<p>(If any) an</p>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-6 col-xs-7">
						<p style="display:flex;">Having National Tax Number <span style="flex:1; border-bottom:1px solid black;">&nbsp;&nbsp;&nbsp;{{$vendor_certificate->control_account->national_tax_number}}</span></p>
					</div>
				</div>
				<br>
				<div class="row">
					<div class="col-sm-2 col-xs-2">
						<p style="display:flex;">Holder of CNIC No </p>
						<p style="display:flex;">On </p>
					</div>
					<div class="col-sm-4 col-xs-5">
						<p style="display:flex;"><span style="flex:1; border-bottom:1px solid black;">&nbsp;&nbsp;&nbsp;{{$vendor_certificate->control_account->cnic}}</span></p>
						<p style="display:flex;"><span style="flex:1; border-bottom:1px solid black;">&nbsp;</span></p>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-2 col-xs-2">
						<p style="display:flex;">Or during the period </p>
					</div>
					<div class="col-sm-10 col-xs-10">
						<p class="col-sm-4 col-xs-5" style="border-bottom:1px solid black; display:flex;">from <span class="col-sm-5 col-xs-5" style="text-align:center;">{{$vendor_certificate->date_from}}</span><strong>To</strong> <span class="col-sm-5 col-xs-5" style="text-align:center;">{{$vendor_certificate->date_from}}</span></p>
						<p class="mt-5"> (period of collection/deduction)</p>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-2 col-xs-2">
						<p style="display:flex;">Under section </p>
					</div>
					<div class="col-sm-10 col-xs-10">
						<p class="col-sm-2 col-xs-3" style="border-bottom:1px solid black; display:flex;">U/S </p>
						<p> Specify section of income tax ordinance, 2001</p>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-2 col-xs-2">
						<p style="display:flex;">On account of </p>
					</div>
					<div class="col-sm-10 col-xs-10">
						<p class="col-sm-4 col-xs-5" style="border-bottom:1px solid black; display:flex;">{{$vendor_certificate->specific_nature}}</p>
						<p class="mt-5"> <u>(specify nature)</u></p>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-12 col-xs-12">
						<p style="display:flex;">Vide </p>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-2 col-xs-2">
						<p style="display:flex;">On the vale/ amount of </p>
					</div>
					<div class="col-sm-10 col-xs-10">
						<p class="col-sm-2 col-xs-2" style="border-bottom:1px solid black; display:flex;"><strong>RS.</strong> &nbsp;&nbsp;&nbsp;{{number_format($vendor_certificate->total_amount , 2)}} </p>
						<p class="mt-5"> <u>(Gross amount on which tax collected/ deducted in figure)</u></p>
					</div>
				</div>
				<br>
				<div class="row">
					<div class="col-sm-12 col-xs-12">
						<p style="display:flex;">Rupees <span style="flex:1; border-bottom:1px solid black;">&nbsp;&nbsp;&nbsp;{{$total_amount}}</span></p>
					</div>
				</div>
				<br>
				<div class="row">
					<div class="col-sm-12 col-xs-12">
						<p style="display:flex;">This is further certify that the tax collected/deducted has been deposited in federal Government Account as per the following details:</p>
					</div>
				</div>
				<br>
				<div class="row">
					<div class="col-sm-3 col-xs-3">
						<center>
							<p>Date of deposit</p>
							<p>============================</p>
							<p style="display:flex;">&nbsp; <span style="flex:1; border-bottom:1px solid black;"></span></p>
							<p style="display:flex;">&nbsp; <span style="flex:1; border-bottom:1px solid black;"></span></p>
						</center>
					</div>
					<div class="col-sm-3 col-xs-3">
						<center>
							<p>SBP/NBP/Treasury</p>
							<p>============================</p>
							<p style="display:flex;">&nbsp; <span style="flex:1; border-bottom:1px solid black;"></span></p>
							<p style="display:flex;">&nbsp; <span style="flex:1; border-bottom:1px solid black;"></span></p>
						</center>
					</div>
					<div class="col-sm-3 col-xs-3">
						<center>
							<p>Branch city Amount</p>
							<p>============================</p>
							<p style="display:flex;">&nbsp; <span style="flex:1; border-bottom:1px solid black;"></span></p>
							<p style="display:flex;">&nbsp; <span style="flex:1; border-bottom:1px solid black;"></span></p>
						</center>
					</div>
					<div class="col-sm-3 col-xs-3">
						<center>
							<p>Challan/Treasury No</p>
							<p>============================</p>
							<p style="display:flex;">&nbsp; <span style="flex:1; border-bottom:1px solid black;"></span></p>
							<p style="display:flex;">&nbsp; <span style="flex:1; border-bottom:1px solid black;"></span></p>
						</center>
					</div>
				</div>
				<br>
				<div class="row">
					<div class="col-sm-12 col-xs-12">
						<p style="display:flex;">Company/ Office etc. collecting/deducting the tax:</p>
					</div>
				</div>
				<br>
				<div class="row">
					<div class="col-sm-6 col-xs-6">
						<p class="col-sm-2 col-xs-3">NAME: </p>
						<p style="border-bottom:1px solid black; display:flex;"> &nbsp;</p>
						<p class="col-sm-2 col-xs-3">Address: </p>
						<p style="border-bottom:1px solid black; display:flex;"> &nbsp;</p>
						<p class="col-sm-2 col-xs-3">&nbsp;</p>
						<p style="border-bottom:1px solid black; display:flex;"> &nbsp;</p>
						<br>
						<p class="col-sm-2 col-xs-3">NTN(if any): </p>
						<p style="border-bottom:1px solid black; display:flex;"> &nbsp;</p>
						<br>
						<p class="col-sm-2 col-xs-3">Date: </p>
						<p style="border-bottom:1px solid black; display:flex;"> &nbsp;</p>
					</div>
					<div class="col-sm-6 col-xs-6">
						<p class="col-sm-2 col-xs-3">Signature:- </p>
						<p style="border-bottom:1px solid black; display:flex;"> &nbsp;</p>
						<br>
						<p class="col-sm-2 col-xs-3">Name:- </p>
						<p style="border-bottom:1px solid black; display:flex;"> &nbsp;</p>
						<br>
						<p class="col-sm-2 col-xs-3">Designation:- </p>
						<p style="border-bottom:1px solid black; display:flex;"> &nbsp;</p>
						<br>
						<p class="col-sm-2 col-xs-3">Seal:- </p>
						<p style="border-bottom:1px solid black; display:flex;"> &nbsp;</p>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
		    <button class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> 
		        <span><i class="fa fa-print"></i> Print</span> 
		    </button>
		</div>
	</div>
</div>
                 
                            
@stop
