@extends('layouts.app')

@section('title')
Vendors Vouchers 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Vendor Vouchers</li>
      </ol>
@stop


@section('content')


            <div class="container-fluid">


                <!-- /row -->
                <div class="row" >
                    <div class="col-sm-12">

                        <div class="white-box">
                            <h3 class="box-title">Vendor</h3>
                            
                            <!-- Nav tabs -->
                            <ul class="nav customtab nav-tabs" role="tablist">

                                <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">List</span></a></li>
                                
                                 <li role="presentation" class=""><a href="#vendor_certificate" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Vendor Certificate</span></a></li>
                                
                                <li role="presentation" class=""><a href="#profile1" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Bills</span></a></li>

                                 <li role="presentation" class=""><a href="#home1" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Pending Procurement Bills </span></a></li> 

                                 <li role="presentation" class=""><a href="#home2" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Pending Procurement Advance Bills </span></a></li> 

                                <li role="presentation" class=""><a href="#profile2" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Vouchers</span></a></li>

                               
                                
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content">

                                <div role="tabpanel" class="tab-pane fade active in" id="home">
                                    <div class="table-responsive">

                                        <a href="{{route('control-account.addView',['id'=>\App\ControlAccount::VENDOR])}}" target="_blank"  class="btn btn-default pull-right"> Add New </a>
                                        &nbsp;&nbsp;<a href="#" style="margin-right: 1rem;" class="btn btn-info pull-right" onclick="return showCertificateModal(this)"> Add Certificate </a>
                                        
                                        <br>
                                        <br>
                                        <div class="clearfix"></div>
                                <table id="myTable8" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                           
                                            <th>Name</th>
                                            <th>Description</th>
                                            <th>balance</th>
                                            
                                           
                                            <th style="width: 185px!important;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1; $vendorArray = array();?>
                                        

                                        @foreach($list as $l)
                                        
                                        @php
                                        $vendorArray[] = array('vendor_id' => $l->id , 'vendor_name' => $l->name);
                                        @endphp
                                        <tr >
                                            <td>{{$count++}}</td>
                                           <td>
                                                {{$l->name}}
                                        
                                           
                                        </td> 
                                          
                                            <td>{{$l->description}}</td>
                                              <td>
                                                  @if($balance[$l->id] < 0 )
                                              ({{number_format(abs($balance[$l->id]))}})
                                              @elseif($balance[$l->id] > 0 )
                                              {{number_format($balance[$l->id])}}
                                              @else
                                              -
                                              @endif
                                            </td>
                                            

                                            <td class="text-nowrap">
                                                
                                                <a href="{{route('control-account.detail',['id'=>$l->id])}}" target="_blank"  class="btn btn-default"> View </a>
                                                

                                                <a href="{{route('control-account.editView',['id'=>$l->id])}}" target="_blank"  class="btn btn-default"> Edit</a>

                                                
           
                                            </td>

                                        </tr>

                                        @endforeach

                                    </tbody>
                                </table>
                                
                            </div>
                                    <div class="clearfix"></div>
                                </div>
                                
                                
                                
                                
                                <div role="tabpanel" class="tab-pane fade active in" id="vendor_certificate">
                                    <div class="table-responsive">

            
                                        <div class="clearfix"></div>
                                <table id="myTable8" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Vendor</th>
                                            <th>Date From</th>
                                            <th>Date To</th>
                                            <th>Tax Amount</th>
                                            <th>Total Amount</th>
                                            <th style="width: 185px!important;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1; ?>
                                        

                                        @foreach($vendorCertificates as $vendor_certificate)
                                        
                                    
                                        <tr >
                                            <td>{{$count++}}</td>
                                            <td>{{ !empty($vendor_certificate->control_account)? $vendor_certificate->control_account->name:''}}</td> 
                                            <td>{{$vendor_certificate->date_from}}</td> 
                                            <td>{{$vendor_certificate->date_to}}</td>
                                            <td>{{number_format($vendor_certificate->total_tax_amount,2)}}</td>
                                            <td>{{number_format($vendor_certificate->total_amount , 2)}}</td>
                                            <td class="text-nowrap">
    
                                                <a href="{{route('get-certificate-detail',['id'=>$vendor_certificate->id])}}" target="_blank"  class="btn btn-default"> View </a>
           
                                            </td>

                                        </tr>

                                        @endforeach

                                    </tbody>
                                </table>
                                
                            </div>
                                    <div class="clearfix"></div>
                                </div>


                                <div role="tabpanel" class="tab-pane fade " id="home1">
                                    <div class="table-responsive">
                                <table id="myTable" style="margin-top: 5rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                <thead>
                                <tr role="row">

                                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Po#</th>


                                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>

                                
                                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Bill Amount</th>


                                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 200px;text-align: center;">Date</th>


                                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Action</th>

                                </tr>

                                </thead>
                                <tbody>
                                @foreach($total_receipts as $pr )
                                @foreach($pr->receipts as $list )
                                @if($list->receipt_type == 1)

                                @php
                                $vendor = \App\PurchaseRequestVendor::find($list->vendor_id);
                                @endphp
                                <tr role="row" class="odd">

                                <td>
                                    @permission('list-purchase-order')
                                    <a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($vendor->id).'&purchase_request='.Crypt::encryptString($list->purchase_request_id).'')}}"  target="_blank" >PO-{{ucfirst($list->purchase_order_id)}}</a> 
                                    @else

                                    PO-{{ucfirst($list->purchase_order_id)}}
                                    @endpermission
                                </td>

                                <td>
                                    @permission('view-vendor')
                                    <a href="{{ route('vendor.view' ,[$vendor->id]) }}">{{ucfirst($vendor->name)}}</a>
                                    @else
                                    {{ucfirst($vendor->name)}}
                                    @endpermission </td>
                                
                                <td>{{number_format($list->remaining_amount)}}</td>


                                <td style="line-height: 30px;font-size: 15px;text-align: center;">
                                    <b>Created At :</b><br> {{date('d-F-Y' , strtotime($list->receipt_date))}}
                                   
                                </td>

                                <td>

                                    
                                
                                <a href="{{url('purchase-order-receipts/detail?vendor='.Crypt::encryptString($vendor->id).'&purchase_order='.Crypt::encryptString($list->purchase_order_id).'&receipt_id='.Crypt::encryptString($list->id).'&purchase_request='.Crypt::encryptString($list->purchase_request_id).'')}}" class="btn btn-success btn-sm" target="_blank">View</a> 

                                    @permission('create-voucher')
                                <a onclick="$('#voucher-form').submit()" href="#"><button  class="btn btn-default btn-outline"  type="button"> <span><i class="fa fa-money"></i> Make Voucher</span> </button></a>
                                @endpermission

        

                                <form id="voucher-form" method="post" action="{{route('create-voucher')}}">
                                {{csrf_field()}}
                                <input type="hidden" name="type" value="{{\App\GeneralJournalEntry::procurment_receipt}}">
                                <input type="hidden" name="id" value="{{$list->id}}">
                                <input type="hidden" name="control" value="{{\App\ControlAccount::VENDOR}}">

                                </form>
                                
                            </td>

                            </tr>

                            @endif

                            @endforeach   
                            @endforeach  
                            </tbody>
                            </table>

                            </div>
                            <div class="clearfix"></div>
                            </div>



                            <div role="tabpanel" class="tab-pane fade " id="home2">
                            <div class="table-responsive">
                            <table id="myTable" style="margin-top: 5rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                            <thead>
                            <tr role="row">

                            <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Po#</th>


                            <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>


                            <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Bill Amount</th>


                            <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 200px;text-align: center;">Date</th>


                            <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Action</th>

                            </tr>

                            </thead>
                            <tbody>
                            @foreach($total_receipts as $pr )
                            @foreach($pr->receipts as $list )
                            @if($list->receipt_type == 2)

                            @php
                            $vendor = \App\PurchaseRequestVendor::find($list->vendor_id);
                            @endphp
                            <tr role="row" class="odd">

                            <td>
                            @permission('list-purchase-order')
                            <a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($vendor->id).'&purchase_request='.Crypt::encryptString($list->purchase_request_id).'')}}"  target="_blank" >PO-{{ucfirst($list->purchase_order_id)}}</a> 
                            @else

                            PO-{{ucfirst($list->purchase_order_id)}}
                            @endpermission
                            </td>

                            <td>
                            @permission('view-vendor')
                            <a href="{{ route('vendor.view' ,[$vendor->id]) }}">{{ucfirst($vendor->name)}}</a>
                            @else
                            {{ucfirst($vendor->name)}}
                            @endpermission </td>

                            <td>{{number_format($list->remaining_amount)}}</td>


                            <td style="line-height: 30px;font-size: 15px;text-align: center;">
                            <b>Created At :</b><br> {{date('d-F-Y' , strtotime($list->receipt_date))}}

                            </td>

                            <td>


                            @permission('create-voucher')
                            <a onclick="$('#voucher-form').submit()" href="#"><button  class="btn btn-default btn-outline"  type="button"> <span><i class="fa fa-money"></i> Make Voucher</span> </button></a>
                            @endpermission



<form id="voucher-form" method="post" action="{{route('create-voucher')}}">
    {{csrf_field()}}
<input type="hidden" name="type" value="{{\App\GeneralJournalEntry::procurment_receipt}}">
<input type="hidden" name="id" value="{{$list->id}}">
<input type="hidden" name="control" value="{{\App\ControlAccount::VENDOR}}">

                            </form>

                            </td>

                            </tr>

                            @endif

                            @endforeach   
                            @endforeach  
                            </tbody>
                            </table>

                            </div>
                            <div class="clearfix"></div>
                            </div>


                                <div role="tabpanel" class="tab-pane fade " id="profile1">
                                    <div class="pull-right">
                                    @permission('create-voucher')
                                <a href="{{route('add-bill-form')}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Add New
                                </a>

                                <a href="#" class="btn  btn-default" onclick="checkSelectedCheckbox()">
                                    <i class="fa fa-plus-square"></i>&nbsp; Make Payment Voucher
                                </a>
                                @endpermission
                            </div>
                            <div id="status" style="text-align: center;color:green;display: none"></div>
                            <div class="clearfix"></div><br>
                                   <div class="table-responsive">
                                <table id="myTable1" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th></th>
                                            <th>Number</th>
                                            <th>Type</th>
                                            <th>Account Head</th>

                                            <th>Vendor</th>
                                            <th>Amount</th>




                                            <th>Bill Date</th>
                                            <th>Due Date</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allExpenses as $expense)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td><input type="checkbox" name="check_list" value="{{$expense->id}}"></td>
                                            <td>BILL-000{{$expense->id}}</td>
                                            <td> {{$expense->expense_type == \App\Expense::CONSTRUCTION ? 'Construction' : 'Service'}} </td>
                                            <td><b>@if($expense->category){{$expense->category->number}} - {{$expense->category->name}}</b>@endif</td>
                                             <td>@if($expense->vendor){{$expense->vendor->name}}@endif</td>

                                              <td>{{number_format($expense->amount)}}</td>
                                               <td>{{date('d-m-Y', strtotime($expense->billed_at)) }}</td>
                                               <td>{{date('d-m-Y', strtotime($expense->due_at)) }}</td>
                                               @if($expense->status == 1)
                                            <td><span class="label label-success">PAID</span></td>
                                            @elseif($expense->status == 2)
                                            <td><span class="label label-primary">PARTIALY</span></td>
                                            @else
                                            <td><span class="label label-danger">UNPAID</span></td>
                                            @endif
                                            <td class="text-nowrap">
                                                @permission('view-expense')
                                                <a href="{{route('pending-bills.detail',['id'=>$expense->id])}}" class="btn btn-default">View</a>

                                                @endpermission

                                                

                                                
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                                
                            </div>
                                    <div class="clearfix"></div>
                                </div>

                                <div role="tabpanel" class="tab-pane fade" id="profile2">
                                   <div class="table-responsive">
                                <table id="myTable3" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Type</th>
                                            <th>Checked</th>
                                            <th>Posted</th>
                                            <th>Date</th>
                                            <th>Entry No.</th>
                                            <th>ADJ</th>
                                            <th>Account</th>
                                            <th>Memo</th>
                                            <!-- <th>Class</th> -->
                                            <th>Debit/Credit (+/-)</th>
                                            <th>Action</th>
                    
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($allEntries as $entry)
                                        <tr ondblclick="showEntry('{{$entry->entry_no}}')">

                                            @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                            <td>CRV-{{$entry->voucher_no}}</td>
                                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                            <td>BRV-{{$entry->voucher_no}}</td>
                                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                            <td>CPV-{{$entry->voucher_no}}</td>
                                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                            <td>BPV-{{$entry->voucher_no}}</td>
                                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                            <td>JV-{{$entry->voucher_no}}</td>
                                            @else
                                            <td></td>
                                            @endif

                                            <td>@if($entry->is_check)
                                                <i class="fa fa-check" style="color:green"></i>
                                            @else
                                            <i class="fa fa-close" style="color: red;"></i>

                                        @endif

                                        <td>@if($entry->is_post)
                                                <i class="fa fa-check" style="color:green"></i>
                                            @else
                                            <i class="fa fa-close" style="color: red;"></i>

                                        @endif
                                        </td>
                                    
                                            <td>{{date('d/m/Y', strtotime($entry->date))}}</td>
                                            <td>{{$entry->entry_no}}</td>
                                            <td>
                                                @if($entry->adjusting_entry)
                                                <i class="fa fa-check"></i>
                                                @endif
                                            </td>
                                            <td>{{$entry->account ? $entry->account->name : ''}}</td>
                                            <td>{{$entry->memo}}</td>
                                            <!-- <td>{{$entry->class ? $entry->class->name : ''}}</td> -->
                                            <td>{{number_format($totalAmount[$entry->entry_no])}}</td>
                                            <td >
                                                <!-- <span onclick="showEntry('{{$entry->entry_no}}')" style="cursor: pointer;" class="btn btn-sm btn-primary"> Show</span> -->

                                                <a href="{{route('voucher-detail',['id'=>$entry->entry_no])}}" class="btn btn-default">View</a>

                                            @if(!$entry->is_approved)

                                            <br><br>
                                            <span onclick="approveEntryModal('{{$entry->entry_no}}')" style="cursor: pointer;" class="btn btn-default btn-sm"> Approve</span>


                                            @endif

                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                                
                            </div>
                                    <div class="clearfix"></div>
                                </div>


                                
                                
                                
                            </div>
                        </div>


                    </div>
                </div>

                <form id="voucher-form" method="post" action="{{route('create-voucher')}}">
            {{csrf_field()}}
        <input type="hidden" name="type" value="{{\App\GeneralJournalEntry::massPayment}}">
        <input type="hidden" name="id" id="id" value="">

        </form>

                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->
            
            
            
            <!-- Modal -->
            <div class="modal fade" id="certificateModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Add Certificate</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
            </div>
            <form method="post" action="{{route('certificate-detail.add')}}" onsubmit="return validateData(this)">
                {{ csrf_field() }}
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4">
                        <label>Vendor <span class="text-danger">*</span></label>
                      <select class="form-control chosen-select" name="vendor_id" id="vendor_id" onchange="return getCertificate(this)">
                          <option value="0">None</option>
                          @foreach($vendorArray as $vendor_list)
                          <option value="{{$vendor_list['vendor_id']}}">
                              {{$vendor_list['vendor_name']}}
                          </option>
                          @endforeach
                      </select>
                    </div>
                    
                    
                    <div class="col-md-4">
                        <label>Cnic</label>
                      <input type="text" readonly class="form-control" name="cnic" id="cnic">
                    </div>
                    
                    
                     <div class="col-md-4">
                        <label>National Tax Number</label>
                      <input type="text" readonly class="form-control" name="national_tax_number" id="national_tax_number">
                    </div>
                    
                    
                    
                    <div class="col-md-4" style="margin-top: 2rem;">
                        <label>From <span class="text-danger">*</span></label>
                      <input type="date"  class="form-control" value="{{date('Y-m-d')}}" name="date_from" id="date_from" >
                    </div>
                    
                    
                     <div class="col-md-4" style="margin-top: 2rem;">
                        <label>To <span class="text-danger">*</span></label>
                        <input type="date"  class="form-control" value="{{date('Y-m-d')}}" name="date_to"  id="date_to">
                    </div>
                    
                    
                    <div class="col-md-4" style="margin-top: 2rem;">
                        <label>On acount of value</label>
                        <input type="text"  class="form-control" name="specific_nature" id="specific_nature" >
                    </div>
                    
                    
                    <div class="col-md-4" style="margin-top: 2rem;">
                        <label>Total Tax Amount <span class="text-danger">*</span></label>
                      <input type="number"  class="form-control" name="total_tax_amount" id="total_tax_amount" >
                    </div>
                    
                    
                     <div class="col-md-4" style="margin-top: 2rem;">
                        <label>Total Amount <span class="text-danger">*</span></label>
                        <input type="number"  class="form-control" name="total_amount" id="total_amount" >
                    </div>
                    
                    
                    
                </div>
            </div>
            <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save</button>
            
             </form>
            </div>
            </div>
            </div>
            </div>



@stop

@section('js')
<script>

function validateData(self)
{
    if($(self).find('#date_from').val() == "" || $(self).find('#date_to').val() == ""  || $(self).find('#total_tax_amount').val() == "" || $(self).find('#total_amount').val() == "" || $(self).find('#vendor_id').val() == 0)
    {
        alert('Please Select All Fields With *');
        return false;
    }
    else
    {
        return true;
    }
}

function getCertificate(self)
{
     $.ajax({
        url:"{{ route('get-certificate-details') }}",
        method:'GET',
        dataType:'json',
        data: {vender_id:$(self).val()},
        success:function(data)
        {
            if(data.response == 'yes')
            {
                $('#cnic').val(data.output.cnic)
                $('#national_tax_number').val(data.output.national_tax_number)
            }
            else
            {
                $('#cnic').val('')
                $('#national_tax_number').val('')
            }
        }
        })
        
        return false;
}

function showCertificateModal(self)
{
    $('#certificateModal').modal('show')
    
    return false;
}

    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'info':true,
            'ordering':false
        });

        $('#myTable1').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'info':true,
            'ordering':false
        });
        $('#myTable3').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'info':true,
            'ordering':false
        });

        $('#myTable8').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'info':true,
            'ordering':false
        });
    });


    function checkSelectedCheckbox()
    {
        

        var check_ids = [];
        
        $.each($("input[name='check_list']:checked"), function(){
                check_ids.push($(this).val());
            });

       
        if(check_ids.length==0)
        {
            document.getElementById('status').style.display = 'block';
            document.getElementById('status').style.color = 'red';
            document.getElementById('status').innerHTML = '<strong><h3>please select any bill!</h3></strong>';
            $('#status').delay(3000).fadeOut();
        }
        else {
          paymentVoucher(check_ids); }
           


    }

    function paymentVoucher(check_ids) {

        $('#id').val(check_ids);

        $('#voucher-form').submit();
        
    }

        
    </script>
    
@stop