@role('admin')
    <div class="row colorbox-group-widget" style="margin-top: 50px;">
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-primary">
                                <div class="media-body">
                                    <a style="color: white" href="{{route('report.received-amount-all')}}" target="_blank">
                                    <h3 class="info-count">{{number_format($stats['received-amount'])}} <span class="pull-right"><i class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                    <p class="info-text font-12">Received Amount</p>
                                    <p class="info-ot font-15">{{$stats['month']}}<span class="label label-rounded">{{number_format($stats['current-received-amount'])}}</span></p>
                                </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-success">
                                <div class="media-body">
                                    <a style="color: white" href="{{route('inventory.open')}}" target="_blank">
                                    <h3 class="info-count">{{number_format($stats['open_inventory_cost'])}} <span class="pull-right"><i class="mdi mdi-comment-text-outline"></i></span></h3>
                                    <p class="info-text font-12">Open Inventory</p>
                                    <p class="info-ot font-15">Count :<span class="label label-rounded">{{number_format($stats['open_inventory_count'])}}</span></p>
                                </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-danger">
                                <div class="media-body">
                                      <a style="color: white" href="{{route('report.sold-inventory-all')}}" target="_blank">
                                    <h3 class="info-count">{{number_format($stats['sold_inventory_paid'])}} <span class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                                    <p class="info-text font-12">Sold Inventory</p>
                                    <p class="info-ot font-15">Count :<span class="label label-rounded">{{number_format($stats['sold_inventory_count'])}}</span></p>
                                </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-warning">
                                <div class="media-body">
                                    <a style="color: white" href="{{route('report.profit-loss-statement-all')}}" target="_blank">
                                    <h3 class="info-count">{{number_format($stats['earning'])}} <span class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                                    <p class="info-text font-12">Net Income</p>
                                    <p class="info-ot font-15">{{$stats['month']}}<span class="label label-rounded"></span></p>
                                </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>




<br>
@endrole

 <!--.row-->
 @permission('list-membership')
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Search Statements</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">
                                                
                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Unit No.</label>
                                                        
                                                        <select id="unit" class="form-control chosen-select">
                                                        <option  value="0">None</option>
                                                        @foreach($unitNumbers as $p)
                                                        <option value="{{$p->id}}">{{$p->unit_number}}</option>
                                                        @endforeach
                                                        </select> </div>
                                                </div>
                                                <!--/span-->
                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Customer</label>
                                                        
                                                        <select id="customer" class="form-control chosen-select">
                                                        <option  value="0">None</option>
                                                        @foreach($customers as $c)
                                                        <option value="{{$c->id}}">{{$c->name}}</option>
                                                        @endforeach
                                                        </select> </div>
                                                </div>
                                                <!--/span-->

                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Dealer</label>
                                                        
                                                        <select id="dealer" class="form-control chosen-select">
                                                        <option  value="0">None</option>
                                                        @foreach($dealers as $d)
                                                        <option value="{{$d->id}}">{{$d->name}}-{{$d->code}}</option>
                                                        @endforeach
                                                        </select> </div>
                                                </div>
                                                <!--/span-->

                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By status</label>
                                                        <select id="status" class="form-control chosen-select">
                                                        <option  value="0">None</option>
                                                            
                                                        <option  value="{{\App\CustomerProperty::approved}}">Approved</option>
                                                        <option  value="{{\App\CustomerProperty::pending}}">Pending</option>
                                                        <option value="{{\App\CustomerProperty::cancel}}">Cancelled</option>
                                                        
                                                        </select> </div>
                                                </div>
                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-actions" style="margin-top: 26px">
                                            <button type="button" class="btn btn-success search-customer"> <i class="fa fa-check" ></i> Search</button>
                                            
                                        </div>
                                                </div>
                                            </div>
                                            
                                            
                                        </div>
                                        
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->

                <div class="row" id="update-table">
                    
                </div>
                <!-- /.row -->

        @endpermission

@permission('due-payments')



      <div class="row">

                    <div class="col-sm-12">
                        <div class="white-box">

                            <h3 class="box-title">Current Month Due Amounts <a href="{{route('properties.due')}}" style="float: right;font-size: 12px"><u>View All</u></a></h3>


                            <div class="table-responsive">
                                <table id="myTable1" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr No.</th>
                                            <th>Unit No.</th>
                                            <th>Member Name</th>
                                            <th>Dealer</th>
                                            <th>Net Amount</th>
                                            <th class="text-center">Received Amount</th>
                                            <th class="text-center">Due Amount</th>
                                            <th>Due Date</th>
                                            <th>Number</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @permission('view-membership')
                                        <?php $view_membership = true;?>
                                        @else
                                        <?php $view_membership = false;?>
                                        @endpermission

                                        @foreach($due['properties'] as $statement)

                                      @if($due['dueAmt'][$statement->id] > 0)
                                          @if($due['color'][$statement->id] == 'red')
                                              <tr style="color:red;">
                                          @elseif($due['color'][$statement->id] == 'orange')
                                              <tr style="color:orange;">
                                          @else
                                              <tr style="color:black;">
                                                  @endif
                                            <td>{{$count++}}</td>
                                            
                                            <td>
                                            {{$statement->inventory ? $statement->inventory->unit_number : ''}}</td>

                                            
                                            

                                            <td>{{$statement->customer ? $statement->customer->name: ''}}</td>
                                            <td >
                                                @if($statement->dealer)
                                            {{$statement->dealer->name}}
                                        @endif</td>

                                            <td class="text-right">{{number_format($statement->net_pay)}} PKR</td>


                                            <td class="text-right">{{number_format($due['receivedAmt'][$statement->id])}} PKR</td>

                                             <td class="text-right">{{number_format($due['dueAmt'][$statement->id])}} PKR</td>
                                            <td>{{$due['dueDate'][$statement->id] ? date('d-m-Y', strtotime($due['dueDate'][$statement->id]->due_date)) : '' }}
                                             <br>@foreach($due['dueMonth'][$statement->id] as $s) @if($loop->last){{date('M', strtotime($s->due_date))}} @else{{date('M', strtotime($s->due_date))}} - @endif @endforeach

                                        </td>
                                        <td>{{$statement->customer->mobile_number}}</td>
                                        <td>
                                            @if($view_membership)
                                                <a href="{{route('statement.detail',['id'=>$statement->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            @endif
                                        </td>



                                        </tr>
                                       @endif

                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
@endpermission