@extends('layouts.app') 

@section('title') Add Loan @stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Add Loan</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="white-box">
                <h3 class="box-title m-b-0">Add Loan & Advance</h3>
                <p class="text-muted m-b-30 font-13"> </p>
                <form class="form-horizontal" method="POST" action="{{ route('store.loan') }}"> {{csrf_field()}}
                    <div class="form-group">
                        
                        <div class="col-md-3">
                            <label style="font-weight: 650;"> Employee <b style="color:red;">*</b> </label>
                            <div class="input-group">
                            <div class="input-group-addon"><i class="ti-user"></i></div>
                            <select class="form-control chosen-select" id="name" name="name" required> 
                                @if($employees->count() > 0 )
                                <option value="">Select Employee </option> 
                                @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">{{ $employee->name }}</option> 
                                @endforeach 
                                @endif 
                            </select> 

                            @if ($errors->has('name')) 
                            <span>
                                <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                            </span> 
                            @endif 
                        
                        </div>
                        </div>

                        <div class="col-md-3">
                            <label style="font-weight: 650;">Date<span style="color: red;">*</span></label>
                            <div class="input-group">
                            <div class="input-group-addon"><i class="icon-calender"></i></div>
                            <input type="date" class="form-control" value="{{date('Y-m-d')}}" name="date" id="date" required> 
                        </div>
                        </div>
                        
                        <div class="col-md-3">
                            <label style="font-weight: 650;"> Type <b style="color:red;">*</b> </label>
                            <div class="input-group">
                            <div class="input-group-addon"><i class="icon-calender"></i></div>
                            <select class="form-control chosen-select" id="type" name="type" onchange="return changeemployeename()" required="true">
                                <option>Type</option>
                                <option value="Loan">Loan</option>
                                <option value="Advance">Advance </option>
                            </select> 
                            @if ($errors->has('type')) 
                            <span>
                                <strong class="error_messages" >{{ $errors->first('type') }}</strong>
                            </span> 
                            @endif 
                        </div>
                    </div>

                        <div class="col-md-3">
                            <label style="font-weight: 650;">Amount <b style="color:red;">*</b></label>
                            <div class="input-group">
                                <div class="input-group-addon">Rs</i>
                                </div>
                                <input type="number" class="form-control" placeholder="Type Amount here " value="{{old('loan')}}" name="loan" required> 
                                @if ($errors->has('loan')) 
                                <span>
                                    <strong class="error_messages" >{{ $errors->first('loan') }}</strong>
                                </span> 
                                @endif 
                            </div>                       
                        </div>
                    
                        
                        <div class="col-md-3" style="margin-top: 2rem;">
                            <label style="font-weight: 650;"> Payment Method <b style="color:red;">*</b> </label>

                            <div class="input-group">
                                <div class="input-group-addon"><i class="icon-calender"></i></div>

                            <select class="form-control chosen-select" name="payment_method" onchange="return hideElements(this)" required>
                                <option value="Bank">Bank Transper (IBFT) </option>
                                <option value="Cheque">Cheque /DD/PO </option>
                                <option value="Cash"> Cash </option>
                            </select> 
                            @if ($errors->has('payment_method')) 
                            <span>
                                <strong class="error_messages" >{{ $errors->first('payment_method') }}</strong>
                            </span> 
                            @endif 
                        </div>
                        </div>
                        
                        <div class="col-md-3" style="margin-top: 2rem;">
                            <label style="font-weight: 650;">Due Amount <b style="color:red;"></b></label>
                            <div class="input-group">
                                <div class="input-group-addon">Rs</i></div>
                                <input type="number" class="form-control" value="{{old('due_amount')}}" name="due_amount" id="due_amount" readonly> 
                                @if ($errors->has('due_amount')) 
                                <span>
                                    <strong class="error_messages" >{{ $errors->first('due_amount') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>
                            
                        <div class="col-md-3" style="margin-top: 2rem;">
                            <label style="font-weight: 650;">Receipt No <b style="color:red;">*</b></label>
                            <div class="input-group">
                                <div class="input-group-addon">No</i></div>
                                <input type="text" class="form-control" name="receipt_no" value="REC{{ rand('00000' , '999999')}}" name="receipt_no" required> 

                                @if ($errors->has('receipt_no')) 
                                <span>
                                    <strong class="error_messages" >{{ $errors->first('receipt_no') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>

                     <div class="col-md-3" style="margin-top: 2rem;">
                         <div class="form-group">
                            <label style="font-weight: 650;">Notes</label>
                            
                                <textarea class="form-control" name="notes"></textarea> 
                                @if ($errors->has('notes')) <span class="help-block">
                                        <strong>{{ $errors->first('notes') }}</strong>
                                    </span> 
                                @endif 
                            </div>
                      
                    </div>

                      <div class="col-md-3 Instrument-no" style="margin-top: -2rem;">
                            <label style="font-weight: 650;">Instrument No: <b style="color:red;">*</b></label>
                            <div class="input-group">
                                <div class="input-group-addon">No</i>
                                </div>
                                <input type="number" class="form-control" placeholder="Type Instrument No here " value="{{old('instrument_no')}}" name="instrument_no"  > 
                                @if ($errors->has('instrument_no')) 
                                <span>
                                    <strong class="error_messages" >{{ $errors->first('instrument_no') }}</strong>
                                </span> 
                                @endif 
                            </div>                       
                        </div>
                        
                        <div class="form-group">
                            <div class="col-md-12" style="margin-left: 1rem; margin-top: 1%;">
                                <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                            </div>
                        </div>
                </form>
                </div>
            </div>
        </div>
    </div> 
    @stop 
    @section('js') 

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


<script type="text/javascript">


function changeemployeename() 
{

 var employee_id = $('#name').val();
  if(employee_id < 1 ){
    alert('Select Employee First');

    return false;
  }
 var type = $('#type').val();
  if(type == "Type" ){
    alert('Select Type');

    return false;
  }

  $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('show.remaning.loan.advance') }}",
        method:'GET',
        dataType:'json',
        data: { employee_id: employee_id, type: type },
        success:function(data)
        {
           
           $("#due_amount").val(data);
        }
        })
        
}

 function hideElements(self) 
    {
        if ($(self).val() == 'Cash')    
        {
          $('.Instrument-no').hide();
          
        }
        else
        {
           $('.Instrument-no').show();
        }

      return false;
    }
        
  </script> 


    @stop