@extends('layouts.app')

@section('title')
Loan Adjustment 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Loan Adjustment</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Loan Adjustment</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{ route('adjustment.insert.loan')}}">
                            	 {{csrf_field()}}
                                <div class="form-group">


                                        <input type="hidden" name="employee_id" id="employee_id" value="{{$loan->employ_id}}">
                                        
                                        <input type="hidden" name="loan_id" id="loan_id" value="{{$loan->id}}">
                                
                                        <div class="col-md-3">
                                            <label style="font-weight: 700;">Date<span style="color: red;">*</span></label>
                                            <input type="date"  class="form-control" value="{{
                                                $loan->date}}" name="date" id="date" required>
                                            </div>

                                         <div class="col-md-3" >
                                    <label >
                                        Type 
                                    </label>
                                        <select class="form-control chosen-select" name="type" required="true" readonly> 
                                        
                                          <option <?php if($loan && $loan->type=='Loan') {echo "selected";}?> value="Loan">Loan</option>
                                          <option <?php if($loan && $loan->type=='Advance') {echo "selected";}?> value="Advance">Advance </option>

                                        </select>

                                        @if ($errors->has('type'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('type') }}</strong>
                                        </span>
                                        @endif


                                        </div>
                               
                                          
                                    <div class="col-md-3" >
                                    <label >Reaming Loan </label>

                                    <div class="input-group">
                                    <div class="input-group-addon">Rs</i></div>

                                    <input type="number" class="form-control" placeholder ="Type loan here " value="{{$loan->remaning}}" name="loan" readonly>
                                    @if ($errors->has('loan'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('loan') }}</strong>
                                    </span>
                                    @endif

                                    </div>

                                    </div>

                                    <div class="col-md-3" >
                                    <label >Addjustment <b style="color:red;">*</b></label>

                                    <div class="input-group">
                                    <div class="input-group-addon">Rs</i></div>

                                    <input type="number" class="form-control" placeholder ="Type loan here " value="{{-- {{$loan->loan_amount}} --}}" name="adjustment" required>
                                    @if ($errors->has('loan'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('loan') }}</strong>
                                    </span>
                                    @endif

                                    </div>

                                    </div>

                                </div>
                               
                                <div class="form-group">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop 

@section('js')  


@stop