@extends('layouts.app')

@section('title')
 Loan List
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Loans</li>
      </ol>
@stop
@section('css')
<style>
table.dataTable thead .sorting_asc {
   background-image: none !important;
}

.table.dataTable,
table.dataTable {
   width: 99.8%!important;
}


button.dt-button, div.dt-button, a.dt-button, input.dt-button {
    background: gray;
    color: #fff;
    white-space: nowrap;
    /* border-color: #d4af37; */
    background: rgb(153 142 142 / 15%);
    color: #2b2b2b;
    border-color: #fff;
    border: 1px solid rgb(0 0 0 / 24%);
    border-radius: 2px;
    cursor: pointer;
    font-size: .88em;
    line-height: 1.6em;
    padding: 0.5em 1em;
    overflow: hidden;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current, .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: gray;
    color: #fff !important;
    white-space: nowrap;
    border-color: #d4af37;
  }

  .badge {
    text-transform: none !important; 
    font-weight: 500 !important;
    padding: 7px 7px !important;
    font-size: 13px !important;
    margin-top: 4px !important;

  }    
</style> 
   
@stop
@section('content')
  <div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="white-box">
                <h3 style="" class="box-title m-b-0"> Employees Loan  List </h3>
                <div style="margin-left: 74rem;">
                    <form class="d-flex" style="padding-left: 15rem;" method="post" action="{{route('hrmemployee.loan.advance.document.insert')}}" enctype="multipart/form-data"> 
                        {{csrf_field()}}
                        <div class="row">
                            <div class="col-sm-8">
                                <input type="hidden" name="employee_id" value="{{$employee_id }}">
                                <label style="font-weight: 600;">Upload docx <small>(image, pdf)</small></label>
                                <input name="file" id="file" class="form-control me-2" type="file" aria-label="Search" required style="background: #dfdfeb;"> 
                            </div>
                            <div class="col-sm-4" style="margin-top: 2.5rem;">
                                <button id="upload_btn" class="btn btn-outline-info" type="submit" style="background: #dfdfeb !important;">Upload</button>
                            </div>
                        </div>
                    </form>
                </div>
                
                    @if(Session::has('success'))
                    <div id="successMessage" class="alert alert-success" role="alert"> 
                     {{ Session::get('success') }} 
                    </div> 
                    @endif
                    {{-- <div class="table-responsive" style="margin-top: 3rem"> --}} 
                    <table id="myTableData" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                        <thead>
                            <tr role="row">
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">S.No</th>
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Date</th>
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Type</th>
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Amount</th>
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Recived</th>
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Remaining Loan</th>
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">status</th>
                                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">status approve </th>
                                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Action</th>
                            </tr>
                        </thead>
                        <tbody> 
                            @php 
                            $count= 1; 
                            @endphp 
                            @foreach( $loan as $list ) 
                            @php 
                            $total = \App\HrmEmployeeLoanAdjusment::getData($list->id , $list->employ_id); 
                            @endphp
                            <tr role="row" class="odd">
                                <td>{{$count++}}</td>
                                <td>{{$list->date}}</td>
                                <td>{{$list->type}}</td>
                                <td>{{$list->loan_amount}}</td>
                                <td>{{$total[0]}}</td>
                                <td>{{$list->remaning}}</td>
                                <td>
                                 @if($list->remaning == 0 )
                                    <li id="completed" class="badge badge-success" style="background: green;"> Completed </a>
                                    </li>
                                     @elseif($list->remaning != 0)
                                    <li id="pending" class="badge badge-success">Pending </a>
                                    </li>
                                     @endif 
                                 </td>
                                 <td>
                                 @if($list->is_approved == 0 )
                                    <li id="completed" class="badge badge-success"> Not Approved </a>
                                    </li>
                                     @elseif($list->is_approved != 0)
                                    <li id="pending" class="badge badge-success" style="background: green;">Approved </a>
                                    </li>
                                     @endif 
                                 </td>
                                <td>
                                  @if($list->is_approved != 1 ) 
                                  <a class="btn btn-info btn-sm" href="{{ route('edit.loan.advance',[$list->id] ) }}">Edit</a> &nbsp;
                                 <a class="btn btn-danger btn-sm" onclick="return validate();" href="{{ route('delete.loan',[$list->id] ) }}">Delete</a>
                                  
                                  
                                 <a class="btn btn-info btn-sm" href="{{route('approved-loan-advance',['is_approved'=>1,'id'=>$list->id,'employ_id'=>$list->employ_id] )}}">Approve</a>
                                 @endif

                                 @if($list->is_approved != 0 ) 
                                 <a class="btn btn-info btn-sm" href="{{route('employee.receipt',['id'=>$list->id, 'employ_id'=>$list->employ_id] )}}">Receipt</a>
                                 @endif

                                 </td>
                              
                            </tr> 
                        @endforeach 
                    </tbody>
                    </table>
        {{-- </div> --}}
    </div>
</div>

{{-- file bank --}}
                <div class="row container-fluid">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title" style="display: inline-block;">File Bank</h3>
                           <hr>
                            
                                    <div class="table-responsive col-md-12">
                                        
                                             
                                               <?php $c =1;?>

                                                 @foreach($employee_document as $d)

                                           
                                                 <div class="col-md-3">
                                                    <label ><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{$c++}}.</b> &nbsp;&nbsp;<a  onclick="openFileModal()" style="font-size: 12px;cursor: pointer;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</i></a></label><br>

                                                    <a target="_blank" href="{{asset('storage/loanAdvanceDocument/'.$d->document_url)}}">

                                                        @if(strpos($d->document_url, 'docx') !== false)

                                                        <img src="{{asset('uploads/word.png')}}" width="175" height="100" />

                                                        @elseif(strpos( $d->document_url,'pdf') !== false)

                                                       
                                                        </script>

                                                        <iframe src="{{asset('storage/loanAdvanceDocument/'.$d->document_url)}}" width="175" height="100" />
                                                        </iframe>



                                                            @else

                                                            <embed src="{{asset('storage/loanAdvanceDocument/'.$d->document_url)}}" width="175" height="100" />

                                                            @endif

                                                    
                                                    <br>
                                                    <label style="font-size: 12px; cursor: pointer;"><b>&nbsp;</b></label>
                                                     </a>
                                                    <br>
                                                    @if(strpos($d->document_url, 'docx') !== false)
                                                    <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px" href="{{asset('storage/loanAdvanceDocument/'.$d->document_url)}}"><i class="fa fa-download" style="text-transform: none;">&nbsp;</i>Download </a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                                                    @else
                                                    <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px" href="{{asset('storage/loanAdvanceDocument/'.$d->document_url)}}"><i class="fa fa-eye" style="text-transform: none;">&nbsp;</i>Preview</a>&nbsp;&nbsp;

                                                    <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px" href="{{asset('storage/loanAdvanceDocument/'.$d->document_url)}}" download=""> <i class="fa fa-download" style="text-transform: none;">&nbsp;</i>Download</a>&nbsp;&nbsp;

                                                    @endif
                                                    <a style="color:red;text-decoration: underline;font-size: 11px" href="{{route('delete.document',['id'=>$d->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?"> <i class="fa fa-trash" style="text-transform: none;">&nbsp;</i>Delete</a>
                                            </div>
                                             @endforeach
                                   
                                    </div>

                        </div>
                    </div>
                </div>
</div>
</div>






  
@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTableData').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });


    function validate()
    { 
        if(!confirm('Are you sure you want to delete?'))
        {
            return false;
        } 
    }

        
    </script>

@stop