@extends('layouts.app') 

@section('title') Update {{$loan->type}}  @stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Add Loan</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="white-box">
                <h3 class="box-title m-b-0">Update {{$loan->type}}</h3>
                <p class="text-muted m-b-30 font-13"> </p>
                <form class="form-horizontal" method="POST" action="{{ route('update.loan.advance', ['id' => $loan->id]) }}"> 
                    {{csrf_field()}}
                    <div class="form-group">
                        
                        <div class="col-md-3">
                            <label style="font-weight: 650;"> Employee <b style="color:red;">*</b> </label>
                            <div class="input-group">
                            <div class="input-group-addon"><i class="ti-user"></i></div>
                            <select class="form-control chosen-select" name="name" required> 
                                        @if($employees->count() > 0 ) 
                                        <option value="">Select Employee </option>
                                        @foreach($employees as $employee)

                                         <option <?php if($loan && $employee->id == $loan->employ_id) {echo "selected";}?>
                                          value="{{ $employee->id }}">{{ $employee->name }}</option> 
                                         @endforeach
                                         @endif

                                        </select> 

                            @if ($errors->has('name')) 
                            <span>
                                <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                            </span> 
                            @endif 
                        
                        </div>
                        </div>

                        <div class="col-md-3">
                            <label style="font-weight: 650;">Date<span style="color: red;">*</span></label>
                            <div class="input-group">
                            <div class="input-group-addon"><i class="icon-calender"></i></div>
                            <input type="date" class="form-control" value="{{$loan->date}}" name="date" id="date" required> 
                        </div>
                        </div>
                        
                        <div class="col-md-3">
                            <label style="font-weight: 650;"> Type <b style="color:red;">*</b> </label>
                            <div class="input-group">
                            <div class="input-group-addon"><i class="icon-calender"></i></div>
                            <select class="form-control chosen-select" name="type" required="true">        
                              <option <?php if($loan && $loan->type=='Loan') {echo "selected";}?> value="Loan">Loan</option>
                              <option <?php if($loan && $loan->type=='Advance') {echo "selected";}?> value="Advance">Advance </option>

                           </select>
                            @if ($errors->has('type')) 
                            <span>
                                <strong class="error_messages" >{{ $errors->first('type') }}</strong>
                            </span> 
                            @endif 
                        </div>
                    </div>

                        <div class="col-md-3">
                            <label style="font-weight: 650;">Amount <b style="color:red;">*</b></label>
                            <div class="input-group">
                                <div class="input-group-addon">Rs</i>
                                </div>
                                <input type="number" class="form-control" placeholder="Type Amount here " value="{{$loan->loan_amount}}" name="loan" required> 
                                @if ($errors->has('loan')) 
                                <span>
                                    <strong class="error_messages" >{{ $errors->first('loan') }}</strong>
                                </span> 
                                @endif 
                            </div>                       
                        </div>
                    
                        
                        <div class="col-md-3" style="margin-top: 2rem;">
                            <label style="font-weight: 650;"> Payment Method <b style="color:red;">*</b> </label>

                            <div class="input-group">
                                <div class="input-group-addon"><i class="icon-calender"></i></div>

                            <select class="form-control chosen-select" name="payment_method" onchange="return hideElements(this)" required>
                                <option <?php if($loan && $loan->type=='Bank') {echo "selected";}?> value="Bank">Bank Transper (IBFT) </option>
                                <option <?php if($loan && $loan->type=='Loan') {echo "selected";}?> value="Cheque">Cheque /DD/PO </option>
                                <option <?php if($loan && $loan->type=='Cash') {echo "selected";}?> value="Cash"> Cash </option>
                                
                            </select> 
                            @if ($errors->has('payment_method')) 
                            <span>
                                <strong class="error_messages" >{{ $errors->first('payment_method') }}</strong>
                            </span> 
                            @endif 
                        </div>
                        </div>
                        
                        <div class="col-md-3" style="margin-top: 2rem;">
                            <label style="font-weight: 650;">Due Amount <b style="color:red;"></b></label>
                            <div class="input-group">
                                <div class="input-group-addon">Rs</i></div>
                                <input type="number" class="form-control" value="{{old('due_amount')}}" name="due_amount" id="due_amount" readonly> 
                                @if ($errors->has('due_amount')) 
                                <span>
                                    <strong class="error_messages" >{{ $errors->first('due_amount') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>
                            
                        <div class="col-md-3" style="margin-top: 2rem;">
                            <label style="font-weight: 650;">Receipt No <b style="color:red;">*</b></label>
                            <div class="input-group">
                                <div class="input-group-addon">No</i></div>
                                <input type="text" class="form-control" name="receipt_no" value="{{$loan->receipt_no}}" name="receipt_no" required readonly> 

                                @if ($errors->has('receipt_no')) 
                                <span>
                                    <strong class="error_messages" >{{ $errors->first('receipt_no') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>

                     <div class="col-md-3" style="margin-top: 2rem;">
                         <div class="form-group">
                            <label style="font-weight: 650;">Notes</label>
                            
                                <textarea class="form-control" name="notes">{{$loan->notes}}</textarea> 
                                @if ($errors->has('notes')) <span class="help-block">
                                        <strong>{{ $errors->first('notes') }}</strong>
                                    </span> 
                                @endif 
                            </div>
                      
                    </div>
                        @if($loan->instrument_no)
                        <div class="col-md-3 Instrument-no" style="margin-top: -2rem;">
                            <label style="font-weight: 650;">Instrument No: <b style="color:red;">*</b></label>
                            <div class="input-group">
                                <div class="input-group-addon">No</i>
                                </div>
                                <input type="number" class="form-control" placeholder="Type Instrument No here " value="{{$loan->instrument_no}}" name="instrument_no" required> 
                                @if ($errors->has('instrument_no')) 
                                <span>
                                    <strong class="error_messages" >{{ $errors->first('instrument_no') }}</strong>
                                </span> 
                                @endif 
                            </div>                       
                        </div>

                        @endif
                        <div class="form-group">
                            <div class="col-md-12"style="margin-left: 120rem;">
                                <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                            </div>
                        </div>
                </form>
                </div>
            </div>
        </div>
    </div> 
    @stop 
    @section('js') 

    <script type="text/javascript">
        
        function hideElements(self) 
    {
        if ($(self).val() == 'Cash')    
        {
          $('.Instrument-no').hide();
          
        }
        else
        {
           $('.Instrument-no').show();
        }

      return false;
    }
    </script>

    @stop