@extends('layouts.app')

@section('title')
Update Loan
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Update Loan</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Update Loan</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{-- {{ route('update.loan', ['id' => $loan->id]) }} --}}">
                            	 {{csrf_field()}}
                                <div class="form-group">

                                <div class="col-md-3">
                                    <label >
                                        Employee 
                                        <b style="color:red;">*</b>
                                    </label>
                                        <select class="form-control chosen-select" name="name" required> 
                                        @if($employees->count() > 0 ) 
                                        <option value="">Select Employee </option>
                                        @foreach($employees as $employee)

                                         <option <?php if($loan && $employee->id == $loan->employ_id) {echo "selected";}?>
                                          value="{{ $employee->id }}">{{ $employee->name }}</option> 
                                         @endforeach
                                         @endif

                                        </select>

                                        @if ($errors->has('name'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                                        </span>
                                        @endif


                                        </div>
                                        <div class="col-md-3">
                                            <label style="font-weight: 700;">Date<span style="color: red;">*</span></label>
                                            <input type="date"  class="form-control" value="{{
                                                $loan->date}}" name="date" id="date" required>
                                            </div>

                                         <div class="col-md-3" >
                                    <label >
                                        Type 
                                        <b style="color:red;">*</b>
                                    </label>
                                        <select class="form-control chosen-select" name="type" required="true"> 
                                        
                                          <option <?php if($loan && $loan->type=='Loan') {echo "selected";}?> value="Loan">Loan</option>
                                          <option <?php if($loan && $loan->type=='Advance') {echo "selected";}?> value="Advance">Advance </option>

                                        </select>

                                        @if ($errors->has('type'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('type') }}</strong>
                                        </span>
                                        @endif


                                        </div>
                               
                                          
                                    <div class="col-md-3" >
                                    <label >Loan <b style="color:red;">*</b></label>

                                    <div class="input-group">
                                    <div class="input-group-addon">Rs</i></div>

                                    <input type="number" class="form-control" placeholder ="Type loan here " value="{{$loan->loan_amount}}" name="loan" required>
                                    @if ($errors->has('loan'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('loan') }}</strong>
                                    </span>
                                    @endif

                                    </div>

                                    </div>

                                </div>
                               
                                <div class="form-group">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop 

@section('js')  


@stop