@extends('layouts.app') 

@section('title')Employee Receipt
@stop 

@section('css')
<style type="text/css">
/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

.container-fluid {
    padding: 3px 30px 0;
}

@media print {
    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    h3 {
        margin: 0;
        line-height: 1;
    }
    .white-box {
        border: none !important;
    }
}
</style> 
@stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
    <li><a href="#">Payment Receipt</a></li> 
   
    <li class="active">Receipt Detail</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>
        <div class="row no-print">
            <div class="col-sm-12">
                <div class="white-box" style="border:0px solid black !important;">
                    <h3 class="box-title">

                        <div class="row">
                            <div class="col-sm-6" style="margin-top: 1rem;">
                                  <span> Receipt Information</span>
                            </div>

                          
                        </div>
                         
                    </h3>
                    <hr>
                    
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>Receipt #</td>
                                    <td>{{$receipt->receipt_no}}</td>
                                </tr>
                                <tr>
                                    <td>Date</td>
                                    <td>{{date('d-m-Y',strtotime($receipt->date))}}</td>
                                </tr>
                                <tr>
                                    <td>Employee</td>
                                    <td>{{$employee->name}}</td>
                                </tr>

                                <tr>
                                    <td>Type</td>
                                    <td>{{$receipt->type}}</td>
                                </tr>
                                
                                <tr>
                                    <td>Payment Method</td>
                                    <td>{{$receipt->payment_method}}</td>
                                </tr>

                                <tr>
                                    <td>Instrument No</td>
                                    <td>{{$receipt->instrument_no}}</td>
                                </tr>

                            </tbody>
                        
                        </table> 


                    </div>
            
                </div>
            
            </div>
        </div>
                
        <div class="col-lg-12">
            <div class="white-box" style="border:0px solid black !important;">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>{{env('APP_NAME')}}</strong></h3>
                        <h3><strong>Payment Receipt</strong></h3> <span class="payment">Office Copy</span> 
                    </div>
                            
                    <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-3 col-sm-3"> 
                                <span class="pull-left">Receipt No.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">{{$receipt->receipt_no}}</span>
                                  
                                </div>
                            </div>

                            <div class="col-xs-3 col-sm-3"> 
                                <span class="pull-left">Instrument No.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">&nbsp;{{$receipt->instrument_no}}</span>
                                  
                                </div>
                            </div>
                          
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4" style="float: right;">
                               
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    {{date('d-m-Y',strtotime($receipt->date))}}
                                </div>
                            </div>

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Received with thanks from Mr./Ms./Mrs.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 20rem;">{{$employee->name}}</span>
                                    
                                </div>
                            </div>


                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">CNIC#</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 30rem;"> {{$employee->cnic}}</span>
                                    
                                </div>
                            </div>
                            
                            
                          
                             <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Payment Method:&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 40rem;">{{$receipt->payment_method}}
                                   </span>
                                </div>
                            </div>

                            

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">{{$receipt->type}} PKR</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 50rem;">{{number_format($receipt->loan_amount)}}</span>
                                  
                                </div>
                            </div>
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-sm-3 col-xs-4">Amount in words (PKR)</div>
                            <div class="col-sm-9 col-xs-8 AoumtInWords"><b></b></div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>

                           <div class="col-sm-4 col-xs-4" style="text-align:center;"> 
                                <b style="border-top: 1px solid;">Accountant</b> 
                            </div>

                            <div class="col-sm-4 col-xs-4" style="text-align:right;"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="sperator"></div>

        <div class="col-lg-12">
            <div class="white-box" style="border:0px solid black !important;">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>{{env('APP_NAME')}}</strong></h3>
                        <h3><strong>Payment Receipt</strong></h3> <span class="payment">Accounts Copy</span> 
                    </div>
                            
                     <div class="col-sm-12 col-xs-12">
                                
                         <div class="row">
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-3 col-sm-3"> 
                                <span class="pull-left">Receipt No.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">{{$receipt->receipt_no}}</span>
                                  
                                </div>
                            </div>

                            <div class="col-xs-3 col-sm-3"> 
                                <span class="pull-left">Instrument No.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">&nbsp;{{$receipt->instrument_no}}</span>
                                  
                                </div>
                            </div>
                          
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4" style="float: right;">
                               
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    {{date('d-m-Y',strtotime($receipt->date))}}
                                </div>
                            </div>

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Received with thanks from Mr./Ms./Mrs.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 20rem;">{{$employee->name}}</span>
                                    
                                </div>
                            </div>


                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">CNIC#</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 30rem;"> {{$employee->cnic}}</span>
                                    
                                </div>
                            </div>
                            
                            
                          
                             <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Payment Method:&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 40rem;">{{$receipt->payment_method}}
                                   </span>
                                </div>
                            </div>

                            

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">{{$receipt->type}} PKR</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 50rem;">{{number_format($receipt->loan_amount)}}</span>
                                  
                                </div>
                            </div>
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-sm-3 col-xs-4">Amount in words (PKR)</div>
                            <div class="col-sm-9 col-xs-8 AoumtInWords"><b></b></div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>

                           <div class="col-sm-4 col-xs-4" style="text-align:center;"> 
                                <b style="border-top: 1px solid;">Accountant</b> 
                            </div>

                            <div class="col-sm-4 col-xs-4" style="text-align:right;"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="sperator"></div>

        <div class="col-lg-12">
            <div class="white-box" style="border:0px solid black !important;">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>{{env('APP_NAME')}}</strong></h3>
                        <h3><strong>Payment Receipt</strong></h3> <span class="payment">Employee Copy</span> 
                    </div>
                            
                    <div class="col-sm-12 col-xs-12">
                                
                         <div class="row">
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-3 col-sm-3"> 
                                <span class="pull-left">Receipt No.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">{{$receipt->receipt_no}}</span>
                                  
                                </div>
                            </div>

                            <div class="col-xs-3 col-sm-3"> 
                                <span class="pull-left">Instrument No.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">&nbsp;{{$receipt->instrument_no}}</span>
                                  
                                </div>
                            </div>
                          
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4" style="float: right;">
                               
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    {{date('d-m-Y',strtotime($receipt->date))}}
                                </div>
                            </div>

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Received with thanks from Mr./Ms./Mrs.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 20rem;">{{$employee->name}}</span>
                                    
                                </div>
                            </div>


                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">CNIC#</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 30rem;"> {{$employee->cnic}}</span>
                                    
                                </div>
                            </div>
                            
                            
                          
                             <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Payment Method:&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 40rem;">{{$receipt->payment_method}}
                                   </span>
                                </div>
                            </div>

                            

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">{{$receipt->type}} PKR</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 50rem;">{{number_format($receipt->loan_amount)}}</span>
                                  
                                </div>
                            </div>
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-sm-3 col-xs-4">Amount in words (PKR)</div>
                            <div class="col-sm-9 col-xs-8 AoumtInWords"><b></b></div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>

                           <div class="col-sm-4 col-xs-4" style="text-align:center;"> 
                                <b style="border-top: 1px solid;">Accountant</b> 
                            </div>

                            <div class="col-sm-4 col-xs-4" style="text-align:right;"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
                
    </div>
    <div style="display: inline-block; ">
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
            <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>

</div>
<!-- /.container-fluid -->



@stop

@section('js')

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>

<script type="text/javascript">

$( document ).ready(function() {

    var inWordAmount =  inWords('{{round($receipt->loan_amount)}}')
    $('.AoumtInWords').html(inWordAmount)
    });

var a = ['','one ','two ','three ','four ', 'five ','six ','seven ','eight ','nine ','ten ','eleven ','twelve ','thirteen ','fourteen ','fifteen ','sixteen ','seventeen ','eighteen ','nineteen '];
var b = ['', '', 'twenty','thirty','forty','fifty', 'sixty','seventy','eighty','ninety'];
function inWords (num) {
   
    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lakh ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + '' : '';
  return ' '+str+'Rupees Only';
}

</script>
@stop


