 @extends('layouts.app')

@section('title')
All Employees 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Employees Attandance</li>
      </ol>
@stop

@section('css')



<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>
<style>


table.dataTable thead .sorting_asc {
    background-image: none !important;
    
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
#myTable tbody tr td {
    text-align: left;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current, .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: gray;
    color: #fff !important;
    white-space: nowrap;
    border-color: #d4af37;

}

.fa {
    font: normal normal normal 14px/1 FontAwesome;
    font-size: 20px !important;
    text-rendering: auto;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}  

.custom-class
{
        margin-top: -120px;
}
</style>

@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <div class="pull-right">
                                
                            </div>
                            <h3 class="box-title">All Employees </h3>
                            
                            <h3 style="text-align: right;" class="box-title m-b-0">
                                <button style="margin-top: -9rem;" class="btn btn-info" data-toggle="modal" data-target="#createModal"><i class="dripicons-plus"></i>Add Attendance </button>
                                </h3>

                            <div class="custom-class">
                            <div style="position: relative;top: 12rem;">
                                <a href="{{route('hrmsample.download')}}" class="btn btn-primary btn-sm">Download</a>
                            <br>
                            <small>Download  Fill Attendence And Then Upload.</small>
                            </div>
                            
                             <h3 style="text-align: right;" class="box-title m-b-0">
                             <div style="margin-left: 74rem;">
                                <form class="d-flex" style="padding-left: 15rem;" method="post" action="{{route('attendance.file.import')}}" enctype="multipart/form-data"> 
                                {{csrf_field()}}
                                <div class="row" style="position: relative;right: 42rem;top: 3.5rem;">
                                <div class="col-sm-8">
                                <input type="hidden" name="employee_id" value="">
                                <label style="font-weight: 600; color: blue;">Upload Attendance <small style="color:black;">(File, Excel)</small></label>
                                <input name="file" id="file" class="form-control me-2" type="file" aria-label="Search" required style="background: #dfdfeb;"> 
                                </div>
                                <div class="col-sm-4" style="margin-top: 3.4rem;">
                                <button id="upload_btn" class="btn btn-outline-info" type="submit" style="background: #dfdfeb !important;">Upload</button>
                                </div>
                                </div>
                                </form>
                                
                                </div>
                            </h3>
                               
                            
                            <div class="table-responsive">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                            <div class="table-responsive">
                                <table id="myTableData" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Designation </th>
                                            <th>Date Of Joining </th>
                                            <th> Percentage</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                          $couter = 1;
                                        @endphp
                                         
                                         
                                        @foreach($HrmEmployees as $HrmEmployee ) 
                                        
                                        <tr>
                                            <td>{{$couter++}}</td>
                                            <td>{{$HrmEmployee->name}}</td>
                                            <td>{{$HrmEmployee->company_detail->designation->name}}</td>
                                            <td>{{date('d-F-Y',strtotime($HrmEmployee->company_detail->date_of_joining))}}</td>

                                            <td>{{\App\HrmAttendance::getMonthlyAttandancePer($HrmEmployee->id , $HrmEmployee->company_detail->date_of_joining)}}%</td>
                                         
                                            <td class="text-nowrap">
                                                <a href="{{route('detail.employee.attendance',[$HrmEmployee->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                            </td>
                                        </tr>
                                        @endforeach
                                    

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
               
              </div>
          </div>
           

            {{-- add Attndance  --}}
    <div id="createModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
        <div role="document" class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title">Add Attendance</h5>
                    <button type="button" data-dismiss="modal" aria-label="Close" class="close">
                        <span aria-hidden="true">x</span></button>
                </div>
                
                <div class="modal-body">
                  <p class="italic"><small style="color: red; font-size: 14px;">The field labels marked with * are required input fields.</small></p>
                    <form method="POST" autocomplete="off" action="{{route('store.attendance')}}">
                        {{csrf_field()}}
                        <div class="row">
                        <div class="col-md-6 form-group">
                            <label>Employee<span style="color: red;">*</span> </label>
                            
                            <select class="form-control chosen-select"  multiple="multiple" name="employee_id[]" required>
                                  
                                   <option value="">Select Employee </option>
                                    @foreach($HrmEmployees as $Employee)

                                    <option value="{{ $Employee->id }}">{{ $Employee->name }}</option> 
                                    @endforeach
                                   
                               
                            </select>
                        </div>
                            <div class="col-md-6 form-group">
                            <label>Date<span style="color: red;">*</label>
                            <input type="date" name="date" class="form-control date" value="{{date('Y-m-d')}}" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <label for="recipient-name" class="col-form-label">Status<span style="color: red;">*</label>
                          <select id="month"  class="form-control select2" onchange="return hideElements(this)" name="status">
                              <option value="0">Absent</option>
                              <option selected value="1">Present</option>
                              <option value="2">Leave</option> 
                          </select>
                        </div>

                        <div class="col-md-6 form-group" id="leave" style="visibility: hidden;">
                            <label>Leave Type <span style="color: red;">*</span> </label>
                            
                              <select class="form-control select" name="leave_type" >
                              <option selected value="0">Medical Leave </option>
                              <option value="1">Anual Leave </option>
                              <option value="3">Special Leave </option> 
                              <option value="4">Weekend Leave </option>
                              <option value="2">Other Leave </option> 
                               
                            </select>
                        </div>

                        
                        <div class="col-md-6 form-group" id="checkin_div">
                            <label>CheckIn<span style="color: red;">*</label>
                            <input type="time" id="checkin" name="checkin" class="form-control" value="" >
                        </div>
                        <div class="col-md-6 form-group" id="checkout_div">
                            <label>CheckOut <span style="color: red;">* </label>
                            <input type="time" id="checkout" name="checkout" class="form-control">
                        </div>
                        
                    </div>
                    <div class="form-group">
                        <center><button type="submit" class="btn btn-lg btn-primary" style="width: 100%;">submit</button></center>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@stop

@section('js')

{{-- <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script> --}}

<script>
    $(function() {
        $('#myTableData').DataTable({
            'pageLength':25,
            'sorting':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>
    <script>
  
    function hideElements(self) 
    {
        if ($(self).val() == '2')  
        {
             $('#leave').css("visibility", "visible");
        }
        else{
            $('#leave').css("visibility", "hidden");
        }
      
        if ($(self).val() == '0' || $(self).val() == '2')  
        {
          $('#checkin_div').hide();
          $('#checkout_div').hide();
        }
        else
        {
            $('#checkin_div').show();
            $('#checkout_div').show();
        }

      return false;
    }


        
        function GeneratePaySlip(self , id) 
        {
           
            $('#employee_id').val(id)
            $('#generate_slip').modal('show');
        }
    </script>

    {{-- <script>

       // Add the following code if you want the name of the file appear on select
        $(".custom-file-input").on("change", function() {
        var fileName = $(this).val().split("\\").pop();
        $(this).siblings(".custom-file-label").addClass("selected").html(fileName);
        });

    </script> --}}
@stop


