@extends('layouts.app')


@section('title')
Add New Employee 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        
        <li ><a href="{{route('employee.sheet')}}">All Employees</a></li>
       
        <li class="active">Add Employee</li>
      </ol>
@stop

@section('content')
<div class="container-fluid">
  <!--.row-->
  <div class="row">
    <div class="col-md-12">
       @if(Session::has('error')) <div id="successMessage" class="alert alert-success" role="alert">
        {{ Session::get('error') }}
      </div> @endif <div class="white-box">
        <div class="row">
          <div class="col-md-6" align="center">
            <h3 class="box-title m-b-0">
              <i class="icon-user fa-fw"></i>Employee Persional Information
            </h3>
            <hr style="border-width: 25px;">
          </div>
          <div class="col-md-6" align="center">
            <h3 class="box-title m-b-0">
              <i class="icon-user fa-fw"></i> Company Details
            </h3>
            <hr style="border-width: 25px;">
          </div>
        </div>
        <form class="form-horizontal" action="{{route('hrmemployee.store')}}" method="post" autocomplete="off" onto enctype="multipart/form-data">
          {{csrf_field()}}
          <div class=" row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-user"></i>
                    </div>
                    <input type="text" class="form-control" name="name" value="{{old('name')}}" id="uname" placeholder="Enter Name"> 
                    @if ($errors->has('name')) 
                    <span class="help-block">
                      <strong>{{ $errors->first('name') }}</strong>
                    </span> 
                    @endif
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="ecode" class="col-sm-2 control-label">Employee ID <span style="color: red"></span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-lock"></i>
                    </div>
                    <input type="text" class="form-control" name="employee_id" value="{{old('employee_id')}}" id="ecode" placeholder="Enter Code"> 
                    @if ($errors->has('employee_id')) 
                    <span class="help-block">
                      <strong>{{ $errors->first('employee_id') }}</strong>
                    </span> 
                    @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="cnic" class="col-sm-2 control-label">CNIC <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-credit-card"></i>
                    </div>
                    <input type="text" class="form-control" value="{{old('cnic')}}" name="cnic" id="cnic" data-inputmask="'mask': '99999-9999999-9'" placeholder="XXXXX-XXXXXXX-X"> @if ($errors->has('cnic')) <span class="help-block">
                      <strong>{{ $errors->first('cnic') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="address" class="col-sm-2 control-label">Department <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="fa fa-user-secret"></i>
                    </div>
                    <select class="form-control select2" name="department"> @if($DepartmentLists->count() > 0 ) <option value="">Select Department </option> @foreach($DepartmentLists as $DepartmentList) <option value="{{ $DepartmentList->id }}">{{ $DepartmentList->department_name }}</option> @endforeach @endif </select> @if ($errors->has('department')) <span class="help-block">
                      <strong>{{ $errors->first('department') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputuname" class="col-lg-2 control-label">Gender <span style="color: red">*</span>
                </label>
                <div class="col-lg-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-user"></i>
                    </div>
                    <label class="radio-inline">
                      <input type="radio" value="Male" name="gender" checked>Male </label>
                    <label class="radio-inline">
                      <input type="radio" value="Female" name="gender">Female </label>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="address" class="col-sm-2 control-label">Country <span style="color: red"></span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-world"></i>
                    </div>
                    <select class="form-control select2" id="country_id" name="country">
                      <option>Select Country</option> @foreach($country as $count) <option value="{{$count->id}}">{{$count->name}}</option> @endforeach
                    </select> @if ($errors->has('country')) <span class="help-block">
                      <strong>{{ $errors->first('country') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>

              {{-- <div class="form-group">
                <label for="address" class="col-sm-2 control-label">City <span style="color: red"></span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-location-pin"></i>
                    </div>
                    <select class="form-control select2" id="city_id" name="city">
                      <option>Select Country</option> @foreach($city as $cit) <option value="{{$cit->id}}">{{$cit->name}}</option> @endforeach
                    </select> @if ($errors->has('city')) <span class="help-block">
                      <strong>{{ $errors->first('city') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div> --}}
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="cnic" class="col-sm-2 control-label">Date of Birth <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-calender"></i>
                    </div>
                    <input type="date" class="form-control" value="{{old('dob')}}" max="{{date('Y-m-d')}}" name="dob" id="dob"> @if ($errors->has('dob')) <span class="help-block">
                      <strong>{{ $errors->first('dob') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="address" class="col-sm-2 control-label">City <span style="color: red"></span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-location-pin"></i>
                    </div>
                    <select class="form-control select2" id="city_id" name="city">
                      <option>Select City</option> @foreach($city as $cit) <option value="{{$cit->id}}">{{$cit->name}}</option> @endforeach
                    </select> @if ($errors->has('city')) <span class="help-block">
                      <strong>{{ $errors->first('city') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div> 
              </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputEmail1" class="col-sm-2 control-label">Phone Number <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-phone"></i>
                    </div>
                    <input type="text" class="form-control" maxlength="12" data-inputmask="'mask': '0399-99999999'" type='number' name="phone_number" value="{{old('phone_number')}}" placeholder="Enter Phone Number"> @if ($errors->has('phone_number')) <span class="help-block">
                      <strong>{{ $errors->first('phone_number') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="cnic" class="col-sm-2 control-label">Date of Joining <span style="color: red"></span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-calender"></i>
                    </div>
                    <input type="date" class="form-control" name="date_of_joing" value="{{old('dob')}}" max="{{date('Y-m-d')}}" name="date_of_joing" id="date_of_joing"> @if ($errors->has('date_of_joing')) <span class="help-block">
                      <strong>{{ $errors->first('date_of_joing') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="address" class="col-sm-2 control-label">Residential Address <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-location-pin"></i>
                    </div>
                    <input type="text" class="form-control" name="Resi_address" value="{{old('Resi_address')}}" id="address1" placeholder="Enter Residential Address..."> @if ($errors->has('Resi_address')) <span class="help-block">
                      <strong>{{ $errors->first('Resi_address') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
             <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputuname" class="col-sm-2 control-label">Monthly Salary <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-user"></i>
                    </div>
                    <input type="text" class="form-control" name="salary" value="{{old('salary')}}" id="exampleInputuname" placeholder="Enter Monthly Salary"> @if ($errors->has('salary')) <span class="help-block">
                      <strong>{{ $errors->first('salary') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="address" class="col-sm-2 control-label">Permanent Address <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-location-pin"></i>
                    </div>
                    <input type="text" class="form-control" name="per_address" value="{{old('per_address')}}" id="address1" placeholder="Enter Permanent Address..."> @if ($errors->has('per_address')) <span class="help-block">
                      <strong>{{ $errors->first('per_address') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputuname" class="col-lg-2 control-label">Salary Method  <span style="color: red">*</span>
                </label>
                <div class="col-lg-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-user"></i>
                    </div>
                    <label class="radio-inline">
                      <input type="radio" value="cheque" name="salary_method" checked>Cheque</label>
                    <label class="radio-inline">
                      <input type="radio" value="cash" name="salary_method">Cash</label>
                    <label class="radio-inline">
                      <input type="radio" value="bank" name="salary_method">Bank</label>
                  </div>
                </div>
              </div>
            </div>
            
                    {{-- <div class="col-md-6">
                      <div class="form-group">
                        <label for="exampleInputuname" class="col-sm-2 control-label">Designation <span style="color: red"></span>
                        </label>
                        <div class="col-sm-10">
                          <div class="input-group">
                            <div class="input-group-addon">
                              <i class="ti-user"></i>
                            </div>
                            <input type="text" class="form-control" name="designation" value="{{old('designation')}}" id="exampleInputuname" placeholder="Enter designation..."> @if ($errors->has('designation')) <span class="help-block">
                              <strong>{{ $errors->first('designation') }}</strong>
                            </span> @endif
                          </div>
                        </div>
                      </div>
                    </div> --}}
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="address" class="col-sm-2 control-label">Role <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="fa fa-user-secret"></i>
                    </div>
                    <select class="form-control select2" name="role_name">
                      <option value="">Select role</option> @if($roles->count() > 0 ) @foreach($roles as $list) <option value="{{ $list->id }}">{{ $list->name }}</option> @endforeach @endif
                    </select> @if ($errors->has('role_name')) <span class="help-block">
                      <strong>{{ $errors->first('role_name') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label for="address" class="col-sm-2 control-label">Designation <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="fa fa-user-secret"></i>
                    </div>
                    <select class="form-control select2" name="designation">
                     @if($DesignationLists->count() > 0 ) 
                     <option value="">Select Designation </option>
                      @foreach($DesignationLists as $DesignationList)
                       <option value="{{ $DesignationList->id }}">{{ $DesignationList->name }}</option>
                        @endforeach
                        @endif </select> @if ($errors->has('designation')) 
                        <span class="help-block">
                      <strong>{{ $errors->first('designation') }}</strong>
                    </span>
                     @endif
                  </div>
                </div>
              </div>
            </div>
              

          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputEmail1" class="col-sm-2 control-label">Email <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-email"></i>
                    </div>
                    <input type="email" class="form-control" name="email" value="" id="exampleInputEmail1" placeholder="Enter email" autocomplete="off"> @if ($errors->has('email')) <span class="help-block">
                      <strong>{{ $errors->first('email') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label for="address" class="col-sm-2 control-label">Contract Type <span style="color: red"></span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="fa fa-user-secret"></i>
                    </div>
                    <select class="form-control select2" name="contract_type">
                      <option value="full_time" selected="">Full Time </option>
                      <option value="contract" selected="">Contract </option>
                      <option value="" selected="">Select Type </option>
                    </select> @if ($errors->has('contract_type')) <span class="help-block">
                      <strong>{{ $errors->first('contract_type') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>

          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputEmail1" class="col-sm-2 control-label">Password <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-key"></i>
                    </div>
                    <input type="password" class="form-control" name="password" value="" id="exampleInputEmail1" placeholder="Enter password" autocomplete="off"> @if ($errors->has('password')) <span class="help-block">
                      <strong>{{ $errors->first('password') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
          <hr style="border-width: 25px;">
          <hr>
          <div class="row">
            <div class="col-md-6" align="center">
              <h3 class="box-title m-b-0">
                <i class="icon-user fa-fw"></i> Bank Account Details
              </h3>
              <hr style="border-width: 25px;">
            </div>
          </div>
          <div class="row">
           {{--  <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputEmail1" class="col-sm-3 control-label">Certificate <span style="color: red"></span>
                </label>
                <div class="col-sm-9">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-picture"></i>
                    </div>
                    <input type="file" class="form-control" name="file_certificate" placeholder="Upload Certificate"> @if ($errors->has('file_certificate')) <span class="help-block">
                      <strong>{{ $errors->first('file_certificate') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div> --}}
            <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red"></span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-user"></i>
                    </div>
                    <input type="text" class="form-control" name="holder_name" value="{{old('holder_name')}}" id="exampleInputuname" placeholder="Enter Account Holder Name"> @if ($errors->has('holder_name')) <span class="help-block">
                      <strong>{{ $errors->first('holder_name') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            {{-- <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputEmail1" class="col-sm-3 control-label">Resume <span style="color: red"></span>
                </label>
                <div class="col-sm-9">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-picture"></i>
                    </div>
                    <input type="file" class="form-control" name="file_resume" placeholder="Upload Resume"> @if ($errors->has('file_resume')) <span class="help-block">
                      <strong>{{ $errors->first('file_resume') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div> --}}
            <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputuname" class="col-sm-2 control-label">Bank Name <span style="color: red"></span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-user"></i>
                    </div>
                    <input type="text" class="form-control" name="bank_name" value="{{old('bank_name')}}" id="exampleInputuname" placeholder="Enter Bank Name..."> @if ($errors->has('bank_name')) <span class="help-block">
                      <strong>{{ $errors->first('bank_name') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class=" row">
            {{-- <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputEmail1" class="col-sm-3 control-label">Photo <span style="color: red"></span>
                </label>
                <div class="col-sm-9">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-picture"></i>
                    </div>
                    <input type="file" class="form-control" name="file_photo" placeholder="Upload Photo..."> @if ($errors->has('file_photo')) <span class="help-block">
                      <strong>{{ $errors->first('file_photo') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div> --}}
            <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputuname" class="col-sm-2 control-label">Location <span style="color: red"></span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-user"></i>
                    </div>
                    <input type="text" class="form-control" name="location" value="{{old('location')}}" id="exampleInputuname" placeholder="Enter Branch Location..."> @if ($errors->has('location')) <span class="help-block">
                      <strong>{{ $errors->first('location') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            {{-- <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputEmail1" class="col-sm-3 control-label">Other <span style="color: red"></span>
                </label>
                <div class="col-sm-9">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="icon-picture"></i>
                    </div>
                    <input type="file" class="form-control" name="file_other" placeholder="Upload Other..."> @if ($errors->has('file_other')) <span class="help-block">
                      <strong>{{ $errors->first('file_other') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
            </div> --}}
            <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputuname" class="col-sm-2 control-label">Account Number <span style="color: red"></span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-user"></i>
                    </div>
                    <input type="number" class="form-control" name="account_no" value="{{old('account_no')}}" id="exampleInputuname" placeholder="Account No."> @if ($errors->has('account_no')) <span class="help-block">
                      <strong>{{ $errors->first('account_no') }}</strong>
                    </span> @endif
                  </div>
                </div>
              </div>
              <div class="col-md-12">
                <div class="form-group">
                  <label for="exampleInputuname" class="col-sm-2 control-label">Code <span style="color: red"></span>
                  </label>
                  <div class="col-sm-10">
                    <div class="input-group">
                      <div class="input-group-addon">
                        <i class="ti-user"></i>
                      </div>
                      <input type="number" class="form-control" name="bank_code" value="{{old('name')}}" id="exampleInputuname" placeholder="Bank Identifier Code.."> @if ($errors->has('bank_code')) <span class="help-block">
                        <strong>{{ $errors->first('bank_code') }}</strong>
                      </span> @endif
                    </div>
                  </div>
                </div>
              </div>
            </div>
            {{-- <hr style="border-width: 30px;">
            <hr> --}}
            <div class=" col-sm-12">&nbsp;</div>
            <div class=" col-sm-12">
              <div class="form-group">
                <hr style="border-width: 3px;">
                <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
              </div>
            </div>
        </form>
      </div>
    </div>
  </div>
  <!--./row-->
</div>
<!-- /.container-fluid -->
@stop


@section('js')


    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    {{-- <script>
    $(":input").inputmask();
$('#country_id').change(function() {
    $('.preloader').fadeIn();
        var data = { 'country_id': $(this).val() };

        $.get('/getCitiesByCountry', data, function (data) {
           var model = $('#city_id');
                    model.empty();

                     model.append("<option value='' disabled selected>" + '' + "</option>");


                    $.each(data, function(index, element) {
                        model.append("<option value='"+ element.id +"'>" + element.name + "</option>");
                    });
        });
         $('.preloader').fadeOut();
    });

function percentCheckbox() {

        if($('#rebate_in_percent').prop("checked") == false) {
            document.getElementById('rebate_input').innerHTML = 'PKR';
        }
        else {
            document.getElementById('rebate_input').innerHTML = '%';
        }
    }
   </script>

   <script type="text/javascript">
        // add row
        $("#addRow").click(function () {
            var html = '';
            html += '<div id="inputFormRow">';
            html += '<div class="input-group mb-3">';
            html += '<input type="text" name="title[]" class="form-control m-input" placeholder="Enter title" autocomplete="off">';
            html += '<div class="input-group-append">';
            html += '<button id="removeRow" type="button" class="btn btn-danger">Remove</button>';
            html += '</div>';
            html += '</div>';

            $('#newRow').append(html);
        });

        // remove row
        $(document).on('click', '#removeRow', function () {
            $(this).closest('#inputFormRow').remove();
        });
    </script> --}}
@stop