@extends('layouts.app')

@section('title')
Active Employees Monthly Payroll Sheet
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Employees Salary</li>
      </ol>
@stop

@section('css')
<style>


#myTable1 tbody tr td {
    text-align: left;
}
#myTable2 tbody tr td {
    text-align: left;
}
#myTable3 tbody tr td {
    text-align: left;
}
#myTable4 tbody tr td {
    text-align: left; 
}

.us_sty {
    text-align: center;
    top: 9rem;
    z-index: 999;
}

.fa {
    font-size: 20px !important;
        }

  a.dt-button, button.dt-button, div.dt-button {
    background: rgb(153 142 142 / 15%);
    color: #2b2b2b;
    border-color: #fff;
    border: 1px solid rgb(0 0 0 / 24%);
    border-radius: 2px;
    cursor: pointer;
    font-size: .88em;
    line-height: 1.6em;
    padding: 0.5em 1em;
    overflow: hidden;
}       
</style>
@stop


@section('content')


   <div class="container-fluid">
    <!-- /row -->
    <div class="row">
        <div class="col-sm-12">
            <div class="white-box" style="border: none;">
                <center>
                    <h3 class="box-title no-print"> Employees Monthly Payroll </h3></center>
                    <br>
                <!-- Nav tabs -->
                <form method="GET" style="" action="{{ route('all-employee.salary.list')}}">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group no-print">
                                <label for="recipient-name" class="col-form-label"><strong>Month:</strong></label>
                                <select id="month" class="form-control " name="month">
                                    <option <?=( $month==1 ) ? 'selected' : '' ?> value="1">January</option>
                                    <option <?=( $month==2 ) ? 'selected' : '' ?> value="2">February</option>
                                    <option <?=( $month==3 ) ? 'selected' : '' ?> value="3">March</option>
                                    <option <?=( $month==4 ) ? 'selected' : '' ?> value="4">April</option>
                                    <option <?=( $month==5 ) ? 'selected' : '' ?> value="5">May</option>
                                    <option <?=( $month==6 ) ? 'selected' : '' ?> value="6">June</option>
                                    <option <?=( $month==7 ) ? 'selected' : '' ?> value="7">July</option>
                                    <option <?=( $month==8 ) ? 'selected' : '' ?> value="8">August</option>
                                    <option <?=( $month==9 ) ? 'selected' : '' ?> value="9">September</option>
                                    <option <?=( $month==10) ? 'selected' : '' ?> value="10">October</option>
                                    <option <?=( $month==11) ? 'selected' : '' ?> value="11">November</option>
                                    <option <?=( $month==12) ? 'selected' : '' ?> value="12">December</option> 
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-5 no-print">
                            <label for="recipient-name" class="col-form-label"><strong>Year:</strong></label>
                            <select class="form-control" name="year">
                                <?php
                                    for ($year = (int)date('Y'); 1900 <= $year; $year--): ?>
                                    <option <?=( $curent_year==$year) ? 'selected' : '' ?> value="
                                        <?=$year;?>">
                                            <?=$year;?>
                                    </option>
                                    <?php endfor; ?>
                            </select>
                        </div>
                        <button type="submit" style="margin-top: 2.5rem;" class="btn btn-info no-print">Filter</button>
                    </div>
                </form>
                <ul class="nav customtab nav-tabs no-print" role="tablist">
                    <li role="presentation" class=""><a href="#home1" onclick="changetitle('Active Employees-Monthly Payroll')" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Active Employees</span></a></li>
                    <li role="presentation" class=""><a href="#home2" onclick="changetitle('Resigned Employees-Monthly Payroll')" aria-controls="home2" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">List Of Ressigned</span></a></li>
                    <li role="presentation" class=""><a href="#home3" onclick="changetitle('Terminated Employees-Monthly Payroll')" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Terminated Employees</span></a></li>
                    <li role="presentation" class=""><a href="#home4" onclick="changetitle('List of New Employees-Monthly Payroll')" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">List of New Employees</span></a></li>
                </ul> 
                    @if(Session::has('success'))
                        <div id="successMessage" class="alert alert-success" role="alert"> 
                        {{ Session::get('success') }} 
                        </div> 
                    @endif
                <!-- Tab panes -->
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane fade active in" id="home1">
                        <h2 style="text-align: center; color: black;"><strong>{{env('APP_NAME')}}</strong></h2>
                        <h2  style="text-align: center; color: black;"><b>LIST OF ACTIVE EMPLOYEES - MONTHLY PAYROLL</b></h2>
                        <h3 style="text-align: center; color: white; background: gray; border-radius: 5px;"> TAX YEAR - 2021-22--------------MONTH - {{date('F', mktime(0, 0, 0, $month))}} - {{$curent_year}}</h3>
                        <div class="table table-responsive ">
                        <table id="myTable1" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info" class="table table-striped" id="home1">
                            <thead>

                                <tr>
                                <td style="border-right:none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-left:none;  border-right:none;"></td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"> </td>

                                <td style="border-left:none; border-right:none;font-weight: bold;">Deductions</td>
                                <td style="border-left:none; border-right:none;"></td>
                                


                                <td style=" border-right:none;border-left: none;"></td>
                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; "></td>


                                
                                <td style="border-left:none; "></td>
                            

                                </tr>



                                <tr>
                                <td style="border-right:none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-left: none;"></td>


                                <td style="border-right:none; "></td>
                                <td style="border-right:none; border-left: none;font-weight: bold;">Loan</td>
                                <td style="border-left:none; "></td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"> </td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"></td>


                                <td style=" border-right:none;"></td>
                                <td style="border-left:none; border-right:none;text-align: right;font-weight: bold;">Benevolent</td>
                                <td style="border-left:none; border-right:none;text-align: left;font-weight: bold;">Fund</td>
                                <td style="border-left:none; "></td>


                                
                                <td style="border-left:none; "></td>
                            

                                </tr>


                                <tr>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">S.No.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Designation</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Date of Joining & Length of service</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Location</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Month/Year</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Basic Salary </th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">House Rent Allownace</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Medical Allowance</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Utility Allowance</th>
                                    
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Arears, if any.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Others / Allowances</th>

                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Total Salary P.M.</th>

                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Sub Total.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Leave without Pay</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Advance Salary</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Opening Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Deduction Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Closing Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> EOBI (Employee Cont)</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> SESSI</th>
                                    
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Tax</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Opening</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Deduction</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Company Cont.</th>
                                    
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Closing </th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Net Salary</th>
                                    
                                </tr>
                            </thead>
                            <tbody> 
                                @php
                                   $grand_total_active_emp = 0; 
                                @endphp
                                @foreach($arrayTotal as $list)

                                @php 
                                    $total_basic_salary = 0;
                                    $total_net_salary = 0; 
                                    $total_monthly_earning = 0; 
                                    $total_monthly_tax = 0;
                                    $total_b_found = 0; 
                                    $total_monthly_deduction = 0;
                                    $total_loan = 0;
                                    $total_opning_loan = 0;
                                    $total_closing_loan = 0;
                                    $total_advance = 0;
                                    $benevolent_found_opning = 0;
                                    $benevolent_found_deduction = 0;
                                    $benevolent_found_comp_con = 0;
                                    $closing_benevolent_found = 0;
                                    $count = 1;
                                    
                                    $total_employee_basic_salary = 0; 
                                    $house_rent_allowance = 0 ;
                                    $medical_allowance = 0 ;
                                    $utility_allowance = 0 ;
                                    $arears_allowance = 0 ;
                                    $others_allowance = 0 ;
                                    $total_per_month_salaries = 0;
                                    $basic_salary_with_allowances = 0;
                                    $total_basic_salary_with_allowances = 0;

                                    $total_eobi = 0 ;
                                    $total_sessie = 0 ;

                                    
                                @endphp

                                <tr>
                                <td><b>{{$list['department']}}</b></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>

                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>

                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            
                                </tr>
                                @foreach($list['dataArray'] as $employees_salary )
                                @foreach($employees_salary_approved as $salary_approved ) 

                                  @if($employees_salary->company_detail->department->id == $list['deprt_id'])
                                 @php
                                   $total = \App\HrmEmployeeMonthlyEarningDeduction::getData($employees_salary->id , $month , $curent_year );
                                 @endphp 

                                  @if( $employees_salary->status == '1' && ($total[0] > 0 && $total[1] > 0 && $employees_salary->id == $salary_approved->employ_id )  && strtotime($employees_salary->company_detail->date_of_joining) < strtotime('-30 days') )
                                <tr style="text-align: center;" role="row" class="odd">
                                    
                                    <td>{{$count++}}</td>
                                    <td>{{$employees_salary->name}}</td>
                                    <td>{{$employees_salary->company_detail->designation->name}}</td>
                                    
                                    <?php
                                        $date1 =  date('d-F-Y',strtotime($employees_salary->company_detail ? $employees_salary->company_detail->date_of_joining : ''));
                                        $date2 = date('d-F-Y');

                                        $diff = abs(strtotime($date2) - strtotime($date1));

                                        $years = floor($diff / (365*60*60*24));
                                        $months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
                                        $days = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));  

                                        $total_p_m = 0;
                                       
                                                                              
                                      ?>
                                      <td>{{$date1}} , <?php printf("%d years(s), %d month(s), %d day(s)\n", $years, $months, $days); ?></td>
                                      <td>{{$employees_salary->pemanent_address}}</td>
                                      <td>{{date('d-F-Y', mktime(0, 0, 0, $month))}}</td>
                                    
                                    @foreach($total[12] as $earning_amount)

                                    <td>{{number_format($earning_amount['basic_salary'])}}</td> 
                                    <td>{{number_format($earning_amount['house_rent'])}}</td>
                                    <td>{{number_format($earning_amount['medical'])}}</td>
                                    <td>{{number_format($earning_amount['utility'])}}</td>
                                    <td>{{number_format($earning_amount['arears'])}}</td>
                                    <td>{{number_format($earning_amount['others'])}}</td>

                                     

                                    @php

                                     $total_p_m = ( $earning_amount['house_rent'] + $earning_amount['medical'] + $earning_amount['utility'] + $earning_amount['arears'] + $earning_amount['others']);

                                     $basic_salary_with_allowances = $total_p_m + $earning_amount['basic_salary'];
                                     
                                     $total_employee_basic_salary += $earning_amount['basic_salary'];
                                     $house_rent_allowance += $earning_amount['house_rent'];
                                     $medical_allowance += $earning_amount['medical'];
                                     $utility_allowance += $earning_amount['utility'];
                                     $arears_allowance += $earning_amount['arears'];
                                     $others_allowance += $earning_amount['others'];
                                   
                                     $total_per_month_salaries +=  $total_p_m;

                                     $total_basic_salary_with_allowances += $basic_salary_with_allowances;


                                    @endphp

                                    @endforeach

                                    <td>{{number_format($total_p_m)}}</td>

                                    <td>{{number_format($basic_salary_with_allowances)}}</td>
                                    <td>0</td>
                                    <td>{{number_format($total[6])}}</td>
                                    <td>{{number_format($total[8])}}</td>
                                    <td>{{number_format($total[5])}}</td>
                                    <td>{{number_format($total[7])}}</td>

                                    
                                    @foreach($total[13] as $deduction_amount)

                                    <td>{{number_format($deduction_amount['eobi'])}}</td>
                                    <td>{{number_format($deduction_amount['sessie'])}}</td>
                                    
                                     @php  
                                       
                                     $total_eobi += $deduction_amount['eobi'] ;
                                     $total_sessie += $deduction_amount['sessie'] ;

                                    @endphp

                                    @endforeach

                                    <td>{{number_format($total[3])}}</td>
                                    <td>{{number_format($total[10])}}</td>
                                    <td>{{number_format($total[11])}}</td>
                                    <td>{{number_format($total[9])}}</td>
                                    <td>{{number_format($total[14])}}</td>

                                     @php
                                      $total_basic_salary += $employees_salary->company_detail->monthly_salary ; 
                                      $total_monthly_earning += $total[0]; 
                                      $total_monthly_tax += $total[3]; 
                                      $total_b_found += $total[4]; 
                                      $total_opning_loan += $total[8]; 
                                      $total_loan += $total[5]; 
                                      $total_closing_loan += $total[7]; 
                                      $benevolent_found_opning += $total[10]; 
                                      $benevolent_found_deduction += $total[11]; 
                                      $benevolent_found_comp_con += $total[9]; 
                                      $closing_benevolent_found += $total[14]; 
                                      $total_advance += $total[6]; 
                                      $total_monthly_deduction += $total[1]; 
                                      $net_salary = ($total[0]-$total[1]-$total[3]-$total[4]-$total[5]-$total[6] );
                                      $total_net_salary += $net_salary;
                                     @endphp

                                    <td> {{ number_format($net_salary) }} </td>

                                    

                                </tr>
                                @endif
                                @endif
                                @endforeach
                                @endforeach

                                 <tr style="background: lightgray !important;">
                                    <td><strong>Sub Total</strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong>{{number_format($total_employee_basic_salary)}}</strong></td>
                                    <td><strong>{{number_format($house_rent_allowance )}}</strong></td>
                                    <td><strong>{{number_format($medical_allowance )}}</strong></td>
                                    <td><strong>{{number_format($utility_allowance )}}</strong></td>
                                    <td><strong>{{number_format($arears_allowance )}}</strong></td>
                                    <td><strong>{{number_format($others_allowance)}}</strong></td>
                                    <td><strong>{{number_format($total_per_month_salaries)}}</strong></td>
                                    <td><strong>{{number_format($total_basic_salary_with_allowances)}}</strong></td>
                                    <td><strong>0</strong></td>
                                    <td><strong>{{number_format($total_advance)}}</strong></td>
                                    <td><strong>{{number_format($total_opning_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_closing_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_eobi)}}</strong></td>
                                    <td><strong>{{number_format($total_sessie)}}</strong></td>
                                    <td><strong>{{number_format($total_monthly_tax)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_opning)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_deduction)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_comp_con)}}</strong></td>
                                    <td><strong>{{number_format($closing_benevolent_found)}}</strong></td>
                                    <td ><strong>{{number_format($total_net_salary )}}</strong></td>
                                    
                                    
                                </tr>
                                 @php

                                   $grand_total_active_emp +=  $total_net_salary;

                                 @endphp
                                

                                 @endforeach

                                 <tr>
                                    <td><strong style="font-weight: 1000">Grand Total</strong></td>
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td><strong style="font-weight: 1000">{{number_format($grand_total_active_emp)}}</strong></td>  
                                
                                    
                                </tr>
                                
                            </tbody>
                        </table>
                        </div>
                        
                        <div class="clearfix"></div>
                    </div>
                    <div role="tabpanel" class="tab-pane fade" id="home2">
                        <h2 style="text-align: center; color: black;"><strong>{{env('APP_NAME')}}</strong></h2>
                        <h3  style="text-align: center; color: black;"><b>LIST OF RESIGNED EMPLOYEES - MONTHLY PAYROLL</b></h3>
                        <h3 style="text-align: center; color: white; background: gray; border-radius: 5px;"> TAX YEAR - 2021-22--------------MONTH - {{date('F', mktime(0, 0, 0, $month))}} - {{$curent_year}}</h3>
                        <div>
                        <div class="table table-responsive ">

                            <table id="myTable2" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info" class="table table-striped" id="home2">
                                <thead>
                                 <tr>
                                    <tr>
                                <td style="border-right:none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-left:none;  border-right:none;"></td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"> </td>

                                <td style="border-left:none; border-right:none;font-weight: bold;">Deductions</td>
                                <td style="border-left:none; border-right:none;"></td>
                                


                                <td style=" border-right:none;border-left: none;"></td>
                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; "></td>


                                
                                <td style="border-left:none; "></td>
                            

                                </tr>



                                <tr>
                                <td style="border-right:none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-left: none;"></td>


                                <td style="border-right:none; "></td>
                                <td style="border-right:none; border-left: none;font-weight: bold;">Loan</td>
                                <td style="border-left:none; "></td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"> </td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"></td>


                                <td style=" border-right:none;"></td>
                                <td style="border-left:none; border-right:none;text-align: right;font-weight: bold;">Benevolent</td>
                                <td style="border-left:none; border-right:none;text-align: left;font-weight: bold;">Fund</td>
                                <td style="border-left:none; "></td>


                                
                                <td style="border-left:none; "></td>
                            

                                </tr>


                                <tr>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">S.No.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Designation</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Date of Joining & Length of service</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Location</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Month/Year</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Basic Salary </th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">House Rent Allownace</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Medical Allowance</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Utility Allowance</th>
                                    
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Arears, if any.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Others / Allowances</th>

                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Total Salary P.M.</th>

                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Sub Total.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Leave without Pay</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Advance Salary</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Opening Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Deduction Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Closing Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> EOBI (Employee Cont)</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> SESSI</th>
                                    
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Tax</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Opening</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Deduction</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Company Cont.</th>
                                    
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Closing </th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Net Salary</th>
                                    
                                </tr>
                                </thead>
                                <tbody>
                                
                                 @php
                                  $grand_total_resign_emp = 0;
                                 @endphp
                                 @foreach($arrayTotal as $list)
                                  @php 
                                    $total_basic_salary = 0;
                                    $total_net_salary = 0; 
                                    $total_monthly_earning = 0; 
                                    $total_monthly_tax = 0;
                                    $total_b_found = 0; 
                                    $total_monthly_deduction = 0;
                                    $total_loan = 0;
                                    $total_opning_loan = 0;
                                    $total_closing_loan = 0;
                                    $total_advance = 0;
                                    $benevolent_found_opning = 0;
                                    $benevolent_found_deduction = 0;
                                    $benevolent_found_comp_con = 0;
                                    $closing_benevolent_found = 0;
                                    $count = 1;
                                    
                                    $total_employee_basic_salary = 0; 
                                    $house_rent_allowance = 0 ;
                                    $medical_allowance = 0 ;
                                    $utility_allowance = 0 ;
                                    $arears_allowance = 0 ;
                                    $others_allowance = 0 ;
                                    $total_per_month_salaries = 0;
                                    $basic_salary_with_allowances = 0;
                                    $total_basic_salary_with_allowances = 0;

                                    $total_eobi = 0 ;
                                    $total_sessie = 0 ;
                                 @endphp 
                                 <tr>
                                    <td><b>{{$list['department']}}</b></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                 
                                 </tr>
                                 @foreach($list['dataArray'] as $employees_salary ) 
                                 @foreach($employees_salary_approved as $salary_approved ) 
                                 @if($employees_salary->company_detail->department->id == $list['deprt_id'])
                                 @php
                                  $total = \App\HrmEmployeeMonthlyEarningDeduction::getData($employees_salary->id , $month , $curent_year ); 
                                 @endphp 
                                 @if( $employees_salary->status == '0' && ($total[0] > 0 && $total[1] > 0 && $employees_salary->id == $salary_approved->employ_id))
                                    

                                <tr style="text-align: center;" role="row" class="odd">
                                    
                                    <td>{{$count++}}</td>
                                    <td>{{$employees_salary->name}}</td>
                                    <td>{{$employees_salary->company_detail->designation->name}}</td>
                                    
                                    <?php
                                        $date1 =  date('d-F-Y',strtotime($employees_salary->company_detail ? $employees_salary->company_detail->date_of_joining : ''));
                                        $date2 = date('d-F-Y');

                                        $diff = abs(strtotime($date2) - strtotime($date1));

                                        $years = floor($diff / (365*60*60*24));
                                        $months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
                                        $days = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));  

                                        $total_p_m = 0;
                                       
                                                                              
                                      ?>
                                      <td>{{$date1}} , <?php printf("%d years(s), %d month(s), %d day(s)\n", $years, $months, $days); ?></td>
                                      <td>{{$employees_salary->pemanent_address}}</td>
                                      <td>{{date('d-F-Y', mktime(0, 0, 0, $month))}}</td>
                                    
                                    @foreach($total[12] as $earning_amount)

                                    <td>{{number_format($earning_amount['basic_salary'])}}</td> 
                                    <td>{{number_format($earning_amount['house_rent'])}}</td>
                                    <td>{{number_format($earning_amount['medical'])}}</td>
                                    <td>{{number_format($earning_amount['utility'])}}</td>
                                    <td>{{number_format($earning_amount['arears'])}}</td>
                                    <td>{{number_format($earning_amount['others'])}}</td>

                                     

                                    @php

                                     $total_p_m = ( $earning_amount['house_rent'] + $earning_amount['medical'] + $earning_amount['utility'] + $earning_amount['arears'] + $earning_amount['others']);

                                     $basic_salary_with_allowances = $total_p_m + $earning_amount['basic_salary'];
                                     
                                     $total_employee_basic_salary += $earning_amount['basic_salary'];
                                     $house_rent_allowance += $earning_amount['house_rent'];
                                     $medical_allowance += $earning_amount['medical'];
                                     $utility_allowance += $earning_amount['utility'];
                                     $arears_allowance += $earning_amount['arears'];
                                     $others_allowance += $earning_amount['others'];
                                   
                                     $total_per_month_salaries +=  $total_p_m;

                                     $total_basic_salary_with_allowances += $basic_salary_with_allowances;


                                    @endphp

                                    @endforeach

                                    <td>{{number_format($total_p_m)}}</td>

                                    <td>{{number_format($basic_salary_with_allowances)}}</td>
                                    <td>0</td>
                                    <td>{{number_format($total[6])}}</td>
                                    <td>{{number_format($total[8])}}</td>
                                    <td>{{number_format($total[5])}}</td>
                                    <td>{{number_format($total[7])}}</td>

                                    
                                    @foreach($total[13] as $deduction_amount)

                                    <td>{{number_format($deduction_amount['eobi'])}}</td>
                                    <td>{{number_format($deduction_amount['sessie'])}}</td>
                                    
                                     @php  
                                       
                                     $total_eobi += $deduction_amount['eobi'] ;
                                     $total_sessie += $deduction_amount['sessie'] ;

                                    @endphp

                                    @endforeach

                                    <td>{{number_format($total[3])}}</td>
                                    <td>{{number_format($total[10])}}</td>
                                    <td>{{number_format($total[11])}}</td>
                                    <td>{{number_format($total[9])}}</td>
                                    <td>{{number_format($total[14])}}</td>

                                     @php
                                      $total_basic_salary += $employees_salary->company_detail->monthly_salary ; 
                                      $total_monthly_earning += $total[0]; 
                                      $total_monthly_tax += $total[3]; 
                                      $total_b_found += $total[4]; 
                                      $total_opning_loan += $total[8]; 
                                      $total_loan += $total[5]; 
                                      $total_closing_loan += $total[7]; 
                                      $benevolent_found_opning += $total[10]; 
                                      $benevolent_found_deduction += $total[11]; 
                                      $benevolent_found_comp_con += $total[9]; 
                                      $$closing_benevolent_found += $total[14]; 
                                      $total_advance += $total[6]; 
                                      $total_monthly_deduction += $total[1]; 
                                      $net_salary = ($total[0]-$total[1]-$total[3]-$total[4]-$total[5]-$total[6] );
                                      $total_net_salary += $net_salary;
                                     @endphp

                                    <td> {{ number_format($net_salary) }} </td>
                                    
                                  </tr>
                                    @endif 
                                    @endif
                                    @endforeach
                                    @endforeach

                                  <tr style="background: lightgray !important;">
                                    <td><strong>Sub Total</strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong>{{number_format($total_employee_basic_salary)}}</strong></td>
                                    <td><strong>{{number_format($house_rent_allowance )}}</strong></td>
                                    <td><strong>{{number_format($medical_allowance )}}</strong></td>
                                    <td><strong>{{number_format($utility_allowance )}}</strong></td>
                                    <td><strong>{{number_format($arears_allowance )}}</strong></td>
                                    <td><strong>{{number_format($others_allowance)}}</strong></td>
                                    <td><strong>{{number_format($total_per_month_salaries)}}</strong></td>
                                    <td><strong>{{number_format($total_basic_salary_with_allowances)}}</strong></td>
                                    <td><strong>0</strong></td>
                                    <td><strong>{{number_format($total_advance)}}</strong></td>
                                    <td><strong>{{number_format($total_opning_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_closing_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_eobi)}}</strong></td>
                                    <td><strong>{{number_format($total_sessie)}}</strong></td>
                                    <td><strong>{{number_format($total_monthly_tax)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_opning)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_deduction)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_comp_con)}}</strong></td>
                                    <td><strong>{{number_format($closing_benevolent_found)}}</strong></td>
                                    <td ><strong>{{number_format($total_net_salary )}}</strong></td>
                            
                                    
                                </tr>


                                    @php

                                    $grand_total_resign_emp +=  $total_net_salary;
                                    @endphp


                                    @endforeach

                                    <tr>
                                    <td><strong style="font-weight: 1000">Grand Total</strong></td>
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>

                                    <td><strong style="font-weight: 1000">{{number_format($grand_total_resign_emp)}}</strong></td>
                                    

                                    </tr>
                                    
                                </tbody>
                            </table>
                        </div>
                             
                        </div>
                        <div class="clearfix"></div>
                    </div>
                   

                    <div role="tabpanel" class="tab-pane fade" id="home3">
                        <h2 style="text-align: center; color: black;"><strong>{{env('APP_NAME')}}</strong></h2>
                        <h3 style="text-align: center; color: black;"><b>LIST OF TERMINETED EMPLOYEES - MONTHLY PAYROLL</b></h3>
                        <h3 style="text-align: center; color: white; background: gray; border-radius: 5px;"> TAX YEAR - 2021-22--------------MONTH - {{date('F', mktime(0, 0, 0, $month))}} - {{$curent_year}}</h3>
                        <div>
                          <div class="table table-responsive "> 
                            <table id="myTable3" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info" class="table table-striped" id="home3">
                                <thead>
                                <tr>
                                <td style="border-right:none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-left:none;  border-right:none;"></td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"> </td>

                                <td style="border-left:none; border-right:none;font-weight: bold;">Deductions</td>
                                <td style="border-left:none; border-right:none;"></td>
                                


                                <td style=" border-right:none;border-left: none;"></td>
                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; "></td>


                                
                                <td style="border-left:none; "></td>
                            

                                </tr>



                                <tr>
                                <td style="border-right:none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-left: none;"></td>


                                <td style="border-right:none; "></td>
                                <td style="border-right:none; border-left: none;font-weight: bold;">Loan</td>
                                <td style="border-left:none; "></td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"> </td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"></td>


                                <td style=" border-right:none;"></td>
                                <td style="border-left:none; border-right:none;text-align: right;font-weight: bold;">Benevolent</td>
                                <td style="border-left:none; border-right:none;text-align: left;font-weight: bold;">Fund</td>
                                <td style="border-left:none; "></td>


                                
                                <td style="border-left:none; "></td>
                            

                                </tr>


                                <tr>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">S.No.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Designation</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Date of Joining & Length of service</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Location</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Month/Year</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Basic Salary </th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">House Rent Allownace</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Medical Allowance</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Utility Allowance</th>
                                    
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Arears, if any.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Others / Allowances</th>

                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Total Salary P.M.</th>

                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Sub Total.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Leave without Pay</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Advance Salary</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Opening Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Deduction Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Closing Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> EOBI (Employee Cont)</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> SESSI</th>
                                    
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Tax</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Opening</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Deduction</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Company Cont.</th>
                                    
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Closing </th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Net Salary</th>
                                    
                                </tr>
                                </thead>
                                <tbody> 
                                     @php
                                      $grand_total_terminated_emp = 0;
                                     @endphp
                                    @foreach($arrayTotal as $list)

                                    @php 
                                    $total_basic_salary = 0;
                                    $total_net_salary = 0; 
                                    $total_monthly_earning = 0; 
                                    $total_monthly_tax = 0;
                                    $total_b_found = 0; 
                                    $total_monthly_deduction = 0;
                                    $total_loan = 0;
                                    $total_opning_loan = 0;
                                    $total_closing_loan = 0;
                                    $total_advance = 0;
                                    $benevolent_found_opning = 0;
                                    $benevolent_found_deduction = 0;
                                    $benevolent_found_comp_con = 0;
                                    $closing_benevolent_found = 0;
                                    $count = 1;
                                    
                                    $total_employee_basic_salary = 0; 
                                    $house_rent_allowance = 0 ;
                                    $medical_allowance = 0 ;
                                    $utility_allowance = 0 ;
                                    $arears_allowance = 0 ;
                                    $others_allowance = 0 ;
                                    $total_per_month_salaries = 0;
                                    $basic_salary_with_allowances = 0;
                                    $total_basic_salary_with_allowances = 0;

                                    $total_eobi = 0 ;
                                    $total_sessie = 0 ;  
                                    @endphp


                                 <tr>
                                    <td><b>{{$list['department']}}</b></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    
                                 </tr>
                                    @foreach($list['dataArray'] as $employees_salary )
                                    @foreach($employees_salary_approved as $salary_approved ) 
                                    @if($employees_salary->company_detail->department->id == $list['deprt_id']) 
                                    @php 
                                    $total = \App\HrmEmployeeMonthlyEarningDeduction::getData($employees_salary->id , $month , $curent_year ); 
                                    @endphp 
                                    @if( $employees_salary->status == '2' && ($total[0] > 0 && $total[1] > 0 && $employees_salary->id == $salary_approved->employ_id ))
                                    <tr style="text-align: center;" role="row" class="odd">
                                        
                                    <td>{{$count++}}</td>
                                    <td>{{$employees_salary->name}}</td>
                                    <td>{{$employees_salary->company_detail->designation->name}}</td>
                                    
                                    <?php
                                        $date1 =  date('d-F-Y',strtotime($employees_salary->company_detail ? $employees_salary->company_detail->date_of_joining : ''));
                                        $date2 = date('d-F-Y');

                                        $diff = abs(strtotime($date2) - strtotime($date1));

                                        $years = floor($diff / (365*60*60*24));
                                        $months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
                                        $days = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));  

                                        $total_p_m = 0;
                                       
                                                                              
                                      ?>
                                      <td>{{$date1}} , <?php printf("%d years(s), %d month(s), %d day(s)\n", $years, $months, $days); ?></td>
                                      <td>{{$employees_salary->pemanent_address}}</td>
                                      <td>{{date('d-F-Y', mktime(0, 0, 0, $month))}}</td>
                                    
                                    @foreach($total[12] as $earning_amount)

                                    <td>{{number_format($earning_amount['basic_salary'])}}</td> 
                                    <td>{{number_format($earning_amount['house_rent'])}}</td>
                                    <td>{{number_format($earning_amount['medical'])}}</td>
                                    <td>{{number_format($earning_amount['utility'])}}</td>
                                    <td>{{number_format($earning_amount['arears'])}}</td>
                                    <td>{{number_format($earning_amount['others'])}}</td>

                                     

                                    @php

                                     $total_p_m = ( $earning_amount['house_rent'] + $earning_amount['medical'] + $earning_amount['utility'] + $earning_amount['arears'] + $earning_amount['others']);

                                     $basic_salary_with_allowances = $total_p_m + $earning_amount['basic_salary'];
                                     
                                     $total_employee_basic_salary += $earning_amount['basic_salary'];
                                     $house_rent_allowance += $earning_amount['house_rent'];
                                     $medical_allowance += $earning_amount['medical'];
                                     $utility_allowance += $earning_amount['utility'];
                                     $arears_allowance += $earning_amount['arears'];
                                     $others_allowance += $earning_amount['others'];
                                   
                                     $total_per_month_salaries +=  $total_p_m;

                                     $total_basic_salary_with_allowances += $basic_salary_with_allowances;


                                    @endphp

                                    @endforeach

                                    <td>{{number_format($total_p_m)}}</td>

                                    <td>{{number_format($basic_salary_with_allowances)}}</td>
                                    <td>0</td>
                                    <td>{{number_format($total[6])}}</td>
                                    <td>{{number_format($total[8])}}</td>
                                    <td>{{number_format($total[5])}}</td>
                                    <td>{{number_format($total[7])}}</td>

                                    
                                    @foreach($total[13] as $deduction_amount)

                                    <td>{{number_format($deduction_amount['eobi'])}}</td>
                                    <td>{{number_format($deduction_amount['sessie'])}}</td>
                                    
                                     @php  
                                       
                                     $total_eobi += $deduction_amount['eobi'] ;
                                     $total_sessie += $deduction_amount['sessie'] ;

                                    @endphp

                                    @endforeach

                                    <td>{{number_format($total[3])}}</td>
                                    <td>{{number_format($total[10])}}</td>
                                    <td>{{number_format($total[11])}}</td>
                                    <td>{{number_format($total[9])}}</td>
                                    <td>{{number_format($total[14])}}</td>

                                     @php
                                      $total_basic_salary += $employees_salary->company_detail->monthly_salary ; 
                                      $total_monthly_earning += $total[0]; 
                                      $total_monthly_tax += $total[3]; 
                                      $total_b_found += $total[4]; 
                                      $total_opning_loan += $total[8]; 
                                      $total_loan += $total[5]; 
                                      $total_closing_loan += $total[7]; 
                                      $benevolent_found_opning += $total[10]; 
                                      $benevolent_found_deduction += $total[11]; 
                                      $benevolent_found_comp_con += $total[9]; 
                                      $closing_benevolent_found += $total[14]; 
                                      $total_advance += $total[6]; 
                                      $total_monthly_deduction += $total[1]; 
                                      $net_salary = ($total[0]-$total[1]-$total[3]-$total[4]-$total[5]-$total[6] );
                                      $total_net_salary += $net_salary;
                                     @endphp

                                    <td> {{ number_format($net_salary) }} </td>
                                        
                                    </tr> 
                                    @endif
                                    @endif 
                                    @endforeach
                                    @endforeach
                                    <tr style="background: lightgray !important;">
                                    <td><strong>Sub Total</strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong>{{number_format($total_employee_basic_salary)}}</strong></td>
                                    <td><strong>{{number_format($house_rent_allowance )}}</strong></td>
                                    <td><strong>{{number_format($medical_allowance )}}</strong></td>
                                    <td><strong>{{number_format($utility_allowance )}}</strong></td>
                                    <td><strong>{{number_format($arears_allowance )}}</strong></td>
                                    <td><strong>{{number_format($others_allowance)}}</strong></td>
                                    <td><strong>{{number_format($total_per_month_salaries)}}</strong></td>
                                    <td><strong>{{number_format($total_basic_salary_with_allowances)}}</strong></td>
                                    <td><strong>0</strong></td>
                                    <td><strong>{{number_format($total_advance)}}</strong></td>
                                    <td><strong>{{number_format($total_opning_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_closing_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_eobi)}}</strong></td>
                                    <td><strong>{{number_format($total_sessie)}}</strong></td>
                                    <td><strong>{{number_format($total_monthly_tax)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_opning)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_deduction)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_comp_con)}}</strong></td>
                                    <td><strong>{{number_format($closing_benevolent_found)}}</strong></td>
                                    <td ><strong>{{number_format($total_net_salary )}}</strong></td>
                                    
                                    
                                        
                                    </tr>
                                    @php

                                    $grand_total_terminated_emp +=  $total_net_salary;
                                    @endphp


                                    @endforeach

                                    <tr>
                                    <td><strong style="font-weight: 1000">Grand Total</strong></td>
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>

                                    <td><strong style="font-weight: 1000">{{number_format($grand_total_terminated_emp)}}</strong></td>
                                    

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                                 
                        </div>
                        <div class="clearfix"></div>
                    </div>

                    <div role="tabpanel" class="tab-pane fade" id="home4">
                        <h2 style="text-align: center; color: black;"><strong>{{env('APP_NAME')}}</strong></h2>
                        <h3  style="text-align: center; color: black;"><b>LIST OF NEW EMPLOYEES - MONTHLY PAYROLL</b></h3>
                        <h3 style="text-align: center; color: white; background: gray; border-radius: 5px;"> TAX YEAR - 2021-22--------------MONTH - {{date('F', mktime(0, 0, 0, $month))}} - {{$curent_year}}</h3>
                       <div class="table table-responsive">

                        <table id="myTable4" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info" class="table table-striped" id="home4">
                            <thead>
                                <tr>
                                <td style="border-right:none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-left:none;  border-right:none;"></td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"> </td>

                                <td style="border-left:none; border-right:none;font-weight: bold;">Deductions</td>
                                <td style="border-left:none; border-right:none;"></td>
                                


                                <td style=" border-right:none;border-left: none;"></td>
                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; "></td>


                                
                                <td style="border-left:none; "></td>
                            

                                </tr>



                                <tr>
                                <td style="border-right:none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>


                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-right:none; border-left: none;"></td>
                                <td style="border-left: none;"></td>


                                <td style="border-right:none; "></td>
                                <td style="border-right:none; border-left: none;font-weight: bold;">Loan</td>
                                <td style="border-left:none; "></td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"> </td>


                                <td style="border-left:none; border-right:none;"></td>
                                <td style="border-left:none; border-right:none;"></td>


                                <td style=" border-right:none;"></td>
                                <td style="border-left:none; border-right:none;text-align: right;font-weight: bold;">Benevolent</td>
                                <td style="border-left:none; border-right:none;text-align: left;font-weight: bold;">Fund</td>
                                <td style="border-left:none; "></td>


                                
                                <td style="border-left:none; "></td>
                            

                                </tr>


                                <tr>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">S.No.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Designation</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Date of Joining & Length of service</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Location</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Month/Year</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Basic Salary </th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">House Rent Allownace</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Medical Allowance</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Utility Allowance</th>
                                    
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Arears, if any.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Others / Allowances</th>

                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Total Salary P.M.</th>

                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Sub Total.</th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Leave without Pay</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Advance Salary</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Opening Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Deduction Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Closing Loan</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> EOBI (Employee Cont)</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> SESSI</th>
                                    
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Tax</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;"> Opening</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Deduction</th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Company Cont.</th>
                                    
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Closing </th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Net Salary</th>
                                    
                                </tr>
                            </thead>
                            <tbody> 

                                @php
                                  $grand_total_new_emp = 0;
                                @endphp

                                @foreach($arrayTotal as $list)
                                  @php
                                    $total_basic_salary = 0;
                                    $total_net_salary = 0; 
                                    $total_monthly_earning = 0; 
                                    $total_monthly_tax = 0;
                                    $total_b_found = 0; 
                                    $total_monthly_deduction = 0;
                                    $total_loan = 0;
                                    $total_opning_loan = 0;
                                    $total_closing_loan = 0;
                                    $total_advance = 0;
                                    $benevolent_found_opning = 0;
                                    $benevolent_found_deduction = 0;
                                    $benevolent_found_comp_con = 0;
                                    $closing_benevolent_found = 0;
                                    $count = 1;
                                    
                                    $total_employee_basic_salary = 0; 
                                    $house_rent_allowance = 0 ;
                                    $medical_allowance = 0 ;
                                    $utility_allowance = 0 ;
                                    $arears_allowance = 0 ;
                                    $others_allowance = 0 ;
                                    $total_per_month_salaries = 0;
                                    $basic_salary_with_allowances = 0;
                                    $total_basic_salary_with_allowances = 0;

                                    $total_eobi = 0 ;
                                    $total_sessie = 0 ;  
                                 @endphp
                                <tr>
                                <td><b>{{$list['department']}}</b></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            
                                </tr>
                                @foreach($list['dataArray'] as $employees_salary ) 
                                @foreach($employees_salary_approved as $salary_approved ) 
                                @if($employees_salary->company_detail->department->id == $list['deprt_id'])
                                 @php
                                   $total = \App\HrmEmployeeMonthlyEarningDeduction::getData($employees_salary->id , $month , $curent_year );
                                 @endphp 
                                  @if( $employees_salary->status == '1' && ($total[0] > 0 && $total[1] > 0 && $employees_salary->id == $salary_approved->employ_id ) && strtotime($employees_salary->company_detail->date_of_joining) > strtotime('-30 days') )
                                <tr style="text-align: center;" role="row" class="odd">
                                    
                                    <td>{{$count++}}</td>
                                    <td>{{$employees_salary->name}}</td>
                                    <td>{{$employees_salary->company_detail->designation->name}}</td>
                                    
                                    <?php
                                        $date1 =  date('d-F-Y',strtotime($employees_salary->company_detail ? $employees_salary->company_detail->date_of_joining : ''));
                                        $date2 = date('d-F-Y');

                                        $diff = abs(strtotime($date2) - strtotime($date1));

                                        $years = floor($diff / (365*60*60*24));
                                        $months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
                                        $days = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));  

                                        $total_p_m = 0;
                                       
                                                                              
                                      ?>
                                      <td>{{$date1}} , <?php printf("%d years(s), %d month(s), %d day(s)\n", $years, $months, $days); ?></td>
                                      <td>{{$employees_salary->pemanent_address}}</td>
                                      <td>{{date('d-F-Y', mktime(0, 0, 0, $month))}}</td>
                                    
                                    @foreach($total[12] as $earning_amount)

                                    <td>{{number_format($earning_amount['basic_salary'])}}</td> 
                                    <td>{{number_format($earning_amount['house_rent'])}}</td>
                                    <td>{{number_format($earning_amount['medical'])}}</td>
                                    <td>{{number_format($earning_amount['utility'])}}</td>
                                    <td>{{number_format($earning_amount['arears'])}}</td>
                                    <td>{{number_format($earning_amount['others'])}}</td>

                                     

                                    @php

                                     $total_p_m = ( $earning_amount['house_rent'] + $earning_amount['medical'] + $earning_amount['utility'] + $earning_amount['arears'] + $earning_amount['others']);

                                     $basic_salary_with_allowances = $total_p_m + $earning_amount['basic_salary'];
                                     
                                     $total_employee_basic_salary += $earning_amount['basic_salary'];
                                     $house_rent_allowance += $earning_amount['house_rent'];
                                     $medical_allowance += $earning_amount['medical'];
                                     $utility_allowance += $earning_amount['utility'];
                                     $arears_allowance += $earning_amount['arears'];
                                     $others_allowance += $earning_amount['others'];
                                   
                                     $total_per_month_salaries +=  $total_p_m;

                                     $total_basic_salary_with_allowances += $basic_salary_with_allowances;


                                    @endphp

                                    @endforeach

                                    <td>{{number_format($total_p_m)}}</td>

                                    <td>{{number_format($basic_salary_with_allowances)}}</td>
                                    <td>0</td>
                                    <td>{{number_format($total[6])}}</td>
                                    <td>{{number_format($total[8])}}</td>
                                    <td>{{number_format($total[5])}}</td>
                                    <td>{{number_format($total[7])}}</td>

                                    
                                    @foreach($total[13] as $deduction_amount)

                                    <td>{{number_format($deduction_amount['eobi'])}}</td>
                                    <td>{{number_format($deduction_amount['sessie'])}}</td>
                                    
                                     @php  
                                       
                                     $total_eobi += $deduction_amount['eobi'] ;
                                     $total_sessie += $deduction_amount['sessie'] ;

                                    @endphp

                                    @endforeach

                                    <td>{{number_format($total[3])}}</td>
                                    <td>{{number_format($total[10])}}</td>
                                    <td>{{number_format($total[11])}}</td>
                                    <td>{{number_format($total[9])}}</td>
                                    <td>{{number_format($total[14])}}</td>

                                     @php
                                      $total_basic_salary += $employees_salary->company_detail->monthly_salary ; 
                                      $total_monthly_earning += $total[0]; 
                                      $total_monthly_tax += $total[3]; 
                                      $total_b_found += $total[4]; 
                                      $total_opning_loan += $total[8]; 
                                      $total_loan += $total[5]; 
                                      $total_closing_loan += $total[7]; 
                                      $benevolent_found_opning += $total[10]; 
                                      $benevolent_found_deduction += $total[11]; 
                                      $benevolent_found_comp_con += $total[9]; 
                                      $closing_benevolent_found += $total[14]; 
                                      $total_advance += $total[6]; 
                                      $total_monthly_deduction += $total[1]; 
                                      $net_salary = ($total[0]-$total[1]-$total[3]-$total[4]-$total[5]-$total[6] );
                                      $total_net_salary += $net_salary;
                                     @endphp

                                    <td> {{ number_format($net_salary) }} </td>
                                    
                                </tr>
                                 @endif
                                 @endif
                                 @endforeach
                                 @endforeach

                                 <tr style="background: lightgray !important;">
                                    <td><strong>Sub Total</strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong></strong></td>
                                    <td><strong>{{number_format($total_employee_basic_salary)}}</strong></td>
                                    <td><strong>{{number_format($house_rent_allowance )}}</strong></td>
                                    <td><strong>{{number_format($medical_allowance )}}</strong></td>
                                    <td><strong>{{number_format($utility_allowance )}}</strong></td>
                                    <td><strong>{{number_format($arears_allowance )}}</strong></td>
                                    <td><strong>{{number_format($others_allowance)}}</strong></td>
                                    <td><strong>{{number_format($total_per_month_salaries)}}</strong></td>
                                    <td><strong>{{number_format($total_basic_salary_with_allowances)}}</strong></td>
                                    <td><strong>0</strong></td>
                                    <td><strong>{{number_format($total_advance)}}</strong></td>
                                    <td><strong>{{number_format($total_opning_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_closing_loan)}}</strong></td>
                                    <td><strong>{{number_format($total_eobi)}}</strong></td>
                                    <td><strong>{{number_format($total_sessie)}}</strong></td>
                                    <td><strong>{{number_format($total_monthly_tax)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_opning)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_deduction)}}</strong></td>
                                    <td><strong>{{number_format($benevolent_found_comp_con)}}</strong></td>
                                    <td><strong>{{number_format($closing_benevolent_found)}}</strong></td>
                                    <td ><strong>{{number_format($total_net_salary )}}</strong></td>
                                    
                                    </td>

                                    
                                </tr>
                                 @php

                                   $grand_total_new_emp +=  $total_net_salary;
                                 @endphp
                                

                                 @endforeach

                                 <tr>
                                    <td><strong style="font-weight: 1000">Grand Total</strong></td>
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td>   
                                    <td></td> 
                                    
                                    <td><strong style="font-weight: 1000">{{number_format($grand_total_new_emp)}}</strong></td>
                                    
                                    
                                </tr>
                                
                            </tbody>

                        </table>
                             
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('js')
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>
<script>
    $(function() {
        $('#myTable1').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
            'ordering':false,
            'paging' : false,
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>   
 <script>
    $(function() {
        $('#myTable2').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
            'ordering':false,
            'paging' : false,
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
  </script>

  <script>
    $(function() {
        $('#myTable3').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
            'ordering':false,
            'paging' : false,
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>

    <script>
    $(function() {
        $('#myTable4').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
            'ordering':false,
            'paging' : false,
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>      

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>
$(function () {
$("#print").on("click", function () {
window.print();
});
}); 
$(function () {
$("#print1").on("click", function () {
window.print();
});
});

$(function () {
$("#print3").on("click", function () {
window.print();
});
}); 

$(function () {
$("#print4").on("click", function () {
window.print();
});
}); 



    function changetitle(argument) 
    {
     $('title').html(argument);
    }     
    </script>

   
    
@stop