@extends('layouts.app')

@section('title')
  
 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Employees Attendance</li>
      </ol>
@stop

@section('css')

<style type="text/css">
  
  .fa{

    font-size: 19px !important;
  }
</style>

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

.us_sty
{
  position: relative;
    top: 9rem;
    z-index: 999;
}
table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}

#myTable tbody tr td {
    text-align: left;
}

@media print {
  .atten-div {
    margin-top: -15rem !important; 
  }
}
@media print {
  .mon-year {
    margin-top: -3rem !important; 
  }
} 

</style>

@stop
 
@section('content')


            <div class="container-fluid" >
                <!-- /row -->
                <div class="row">

                    <div class="col-sm-12">
                        <div class="white-box" id="printableSection">
                           <div class="col-sm-12" style="text-align:right;">
                            <a class="btn btn-info avoid-this" id="print" style="margin-top: 1rem; background: #167ab3" href="#">Print</a>
                           </div>
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif
                            <center><h6 class="box-title"> Monthly Attendance Report</h6></center>
                            
                            <div class="col-lg-6">
                              <h4 style="color: black;">{{ucfirst($HrmEmployees->name)}}</h4>  
                            </div>
                            <div class="col-lg-6 mon-year" style="text-align: right;">

                              <h4 class="mon-year" style="color: black">{{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_}}</h4>
                            </div>
                            <div class="col-lg-6" style="text-align: right;">
                              
                            </div>
                            
                            
                            <div class="col-lg-12 no-print">
                              <form method="GET" style="margin-top: -7rem;" action="{{ route('detail.employee.attendance' , [$HrmEmployees->id]) }}">
                          
                              <input type="hidden" name="employee_id" value="{{$HrmEmployees->id}}">
                              <div class="row">

                                <div class="col-sm-4">
                                  <div class="form-group us_sty">
                                <label for="recipient-name" class="col-form-label">Month:</label>
                                <select id="month" class="form-control " name="month">
                                
                                  <option  <?= ( $month == 1) ? 'selected' : '' ?> value="1">January</option>
                                  <option <?= ( $month == 2) ? 'selected' : '' ?> value="2">February</option>
                                  <option <?= ( $month == 3) ? 'selected' : '' ?> value="3">March</option>
                                  <option <?= ( $month == 4) ? 'selected' : '' ?> value="4">April</option>
                                  <option <?= ( $month == 5) ? 'selected' : '' ?> value="5">May</option>
                                  <option <?= ( $month == 6) ? 'selected' : '' ?> value="6">June</option>
                                  <option <?= ( $month == 7) ? 'selected' : '' ?> value="7">July</option>
                                  <option <?= ( $month == 8) ? 'selected' : '' ?> value="8">August</option>
                                  <option <?= ( $month == 9) ? 'selected' : '' ?> value="9">September</option>
                                  <option <?= ( $month == 10) ? 'selected' : '' ?> value="10">October</option>
                                  <option <?= ( $month == 11) ? 'selected' : '' ?> value="11">November</option>
                                  <option <?= ( $month == 12) ? 'selected' : '' ?> value="12">December</option>>
                                </select>
                                </div>
                              </div> 

                               <div class="col-sm-4">
                                  <label for="recipient-name" class="col-form-label us_sty">Year:</label>
                                  <select class="form-control us_sty" name="year">
                                  <?php
                                  for ($year = (int)date('Y'); 1900 <= $year; $year--): ?>
                                  <option <?= ( request()->get('year') == $year) ? 'selected' : '' ?> value="<?=$year;?>"><?=$year;?></option>
                                  <?php endfor; ?>
                                  </select>
                                  </div>
                                   
                                   <button type="submit" style="margin-top: 2.5rem;" class="btn btn-info us_sty">Filter</button>
                                 </div>
                          </form>
                            </div>
                            
                    
                            <h3 style="text-align: right;" class="box-title m-b-0">
                                <div class="container-fluid">
                                   
                                </div>
                            </h3>
                            

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped table-bordered dataTable color-table info-table" role="grid">
                                    <thead>
                                        <tr>
                                         
                                            <th>Date</th>
                                            <th>Status </th>
                                            <th>CheckIn </th>
                                            <th>CheckOut</th>
                                            <th>Time</th>
                                            <th>Created By</th>
                                            <th style="width:0px !important;" class="no-print">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                         
                                         $num_of_days = $num_of_days 

                                         @endphp
                                         
                                         @for($i=1; $i<=$num_of_days; $i++)

                                         @php

                                            $day =  $i;
                                            $date = null;
                                            $present_absent = '-';
                                            $check_in = '-';
                                            $checkout = '-';
                                            $name = '-';
                                            $id=0;

                                         @endphp


                                          @if($employee_attendance->count() > 0 ) 

                                           @foreach($employee_attendance as $key=>$attendance)


                                                
                                             @php 

                                                $employee = \App\HrmEmployee::find($attendance->employ_id);
                                                $user = \App\User::find($attendance->user_id);

                                              

                                              if(date('d',strtotime($attendance->date)) == $i) 

                                              {
                                                  $date = date('d-D',strtotime($attendance->date));

                                                  $present_absent = $attendance->present_absent;
                                                  $check_in  = date('h:i a',strtotime($attendance->checkin));
                                                  $checkout =  date('h:i a',strtotime($attendance->checkout));
                                                  $status   =  $attendance->status;
                                                  $name = $user->name;
                                                  $id   =  $attendance->id;

                                              }



                                             @endphp

                                          @endforeach
                                           @endif

                                            
                                            

                                            <tr>
                                               
                                          

                                              <td>
                                                @if(!empty($date))
                                                {{$date}}
                                                 @php
                                                    $Day = "";
                                                    $flag = 0;
                                                    for ($z=3; $z < 6; $z++) { 
                                                      $Day = $Day.$date[$z];
                                                    }
                                                    $len = count($offday);
                                                    for($y=0; $y<$len; $y++){
                                                      if ($offday[$y] == $Day) {
                                                        $flag = 1;
                                                      }
                                                    }
                                                  @endphp
                                                @else
                                                {{$D = date('d-D' , strtotime($i.'-'.$month.'-'.$year_))}} 
                                                @php
                                                    $Day = "";
                                                    $flag = 0;
                                                    for ($z=3; $z < 6; $z++) { 
                                                      $Day = $Day.$D[$z];
                                                    }
                                                    $len = count($offday);
                                                    for($y=0; $y<$len; $y++){
                                                      if ($offday[$y] == $Day) {
                                                        $flag = 1;
                                                      }
                                                    }
                                                  @endphp
                                              @endif
                                              </td>
                                              <td>
                                                
                                                @if($flag == 1)
                                                
                                                <span class="label label" style="color: yellow;">offday</span>
                                                @else
                                                  
                                                @if( $present_absent=='1' )

                                                <span class="label label-success">Present</span>

                                                @elseif($present_absent=='0')

                                                <span class="label label" style="background-color: red">Absent </span>

                                                @elseif( $present_absent== '2')

                                                <span class="label label-warning">Leave</span>

                                                @else
                                                -

                                                @endif
                                                @endif                                                 
                                            
                                              </td>

                                              <td>



                                                @if( $present_absent != '-' && $present_absent != '2' && $present_absent != '0' )

                                                 {{$check_in}}

                                                @else
                                                -
                                                @endif

                                              </td>

                                              <td>

                                                 @if($present_absent != '-' && $present_absent != '2' && $present_absent != '0')
                                                    {{$checkout}}
                                              
                                                 @else
                                                -
                                                @endif

                                              </td>


                                            <td>

                                                @if($flag == 1)
                                                
                                                <span class="label label" style="color: yellow;">offday</span>
                                                @else

                                            @if($present_absent== '1') 

                                            @if($status )

                                            <span class="label label-info">OnTime</span>


                                            @else

                                            <span class="label label-danger">Late</span>

                                            @endif

                                            

                                            @elseif( $present_absent== '0')

                                            <span class="label label" style="background-color: red">Absent</span>


                                            @elseif($present_absent=='2')

                                            <span class="label label-warning">Leave</span>

                                              @else

                                                  -

                                            @endif

                                              @endif

                                            </td>
                                             
                                             <td>{{$name}}</td>

                                        <td class="no-print">
                                        @if($id > 0)

                                        <a href="#" onclick="return editAttendance(this , '{{$id}}')" data-original-title="Edit">
                                        <i class="fa fa-pencil"></i>
                                        </a>

                                        &nbsp;&nbsp;&nbsp;

                                         <a href="{{ route('employee-attendance.delete',[$id] ) }}" data-toggle="tooltip" data-original-title="Delete" onclick="return confirm('Ary You Sure To delete?')"> 
                                          <i class="fa fa-close text-danger"></i> 
                                        </a>

                                        @endif


                                        </td>                        
                                        </tr>
                                        

                                         @endfor


                                    </tbody>
                                </table>


                                  <div class="row">
                                    <div class="col-lg-6" style="text-align: left;">
                                      

                                    <div style="margin-top: 1rem;">
                                      <b> Medical leave :  </b>{{$employee_medical_leaves }} , (<b> Remaining : </b> {{ $employee_medical_leaves - $medical_leave  }})
                                    </div>

                                    <div style="margin-top: 1rem;">
                                      <b> Anual Leaves : </b>{{$employee_anual_leaves}} , (<b> Remaining : </b>{{ $employee_anual_leaves - $anual_leave   }}) 
                                    </div>

                                    <div style="margin-top: 1rem;">
                                      <b> Other Leaves : </b> {{$employee_other_leaves}} , (<b> Remaining : </b>{{$employee_other_leaves - $other_leave}} )
                                    </div>
                                    <div style="margin-top: 1rem;">
                                      <b> Special Leaves : </b>{{$employee_special_leaves}} , (<b> Remaining :</b> {{ $employee_special_leaves - $special_leave  }})  
                                    </div>
                                    <div style="margin-top: 1rem;">
                                      <b> Weekend Leaves : </b>{{$employee_weekend_leaves}} , (<b> Remaining : </b> {{$employee_weekend_leaves - $weekend_leave }}) 
                                    </div>

                                    </div>
                                    <div class="col-lg-6 atten-div" style="text-align: right;">
                                      
                                      <div style="margin-top: 1rem;">
                                      <b> Presents for {{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_}} : </b> {{$presents}}
                                    </div>

                                    <div style="margin-top: 1rem;">
                                      <b> Absents for {{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_ }} : </b> {{$absents}}
                                    </div>

                                    <div style="margin-top: 1rem;">
                                      <b> Leaves for {{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_}} : </b> {{$leaves}}
                                    </div>

                                    <div style="margin-top: 1rem;">
                                      <b> Ontime for {{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_}} : </b> {{$ontime}}
                                    </div>
                                    <div style="margin-top: 1rem;">
                                      <b> Late for {{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_}} : </b> {{$late}}
                                    </div>

                                    </div>

                      
                                </div>
                                <br>
                        
                    </div>
                </div>
            </div>
        </div>
       
      </div>


    {{-- add Attndance  --}}
    <div id="editAttendance" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
        <div role="document" class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title">Update Attendance</h5>
                    <button type="button" data-dismiss="modal" aria-label="Close" class="close">
                        <span aria-hidden="true">x</span></button>
                </div>
                
                <div class="modal-body">
                  <p class="italic"><small style="color: red; font-size: 14px;">The field labels marked with * are required input fields.</small></p>
                    <form method="POST" autocomplete="off" action="{{route('employee_attendance.update')}}">
                        {{csrf_field()}}

                        <input type="hidden" name="record_id" id="record_id" value="">

                        <div class="row">
                      
                            <div class="col-md-12 form-group">
                            <label>Date<span style="color: red;">*</label>
                            <input type="date" id="date" name="date" class="form-control date" value="" required>
                        </div>

                        <div class="col-md-6 form-group">
                            <label for="recipient-name" class="col-form-label">Status<span style="color: red;">*</label>
                          <select id="status"  class="form-control select2" onchange="return hideElements(this)" name="status">
                              <option value="0">Absent</option>
                              <option value="1">Present</option>
                              <option value="2">Leave</option> 
                               
                            
                          </select>
                        </div>

                        <div class="col-md-6 form-group" id="leave" style="visibility: hidden;">
                            <label>Leave Type <span style="color: red;">*</span> </label>
                            
                            <select class="form-control select" name="leave_type" >
                              <option selected value=null>None </option>

                              <option value="0">Medical Leave </option>
                              <option value="1">Anual Leave </option>
                              <option value="3">Special Leave </option> 
                              <option value="4">Weekend Leave </option>
                              <option value="2">Other Leave </option> 
                               
                            </select>
                        </div>

                        
                        <div class="col-md-6 form-group" id="checkin_div">
                            <label>CheckIn<span style="color: red;">*</label>
                            <input type="time" id="checkin" name="checkin" class="form-control" value="" >
                        </div>
                        <div class="col-md-6 form-group" id="checkout_div">
                            <label>CheckOut <span style="color: red;">* </label>
                            <input type="time" id="checkout" name="checkout" class="form-control">
                        </div>
                        
                    </div>
                    <div class="form-group">
                        <center><button type="submit" class="btn btn-lg btn-primary" style="width: 100%;">submit</button></center>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

       
@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':31,
            'dom': 'Bfrtip',
        'buttons': [
             
        ]
        });
    });

    // $('table'). dataTable({searching: false});
    </script>
    <script>

    function editAttendance(self , id) {

      $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('get_attendance') }}",
        method:'POST',
        dataType:'json',
        data: {id:id },
        success:function(data)
        {
          if (data.response == 'yes') 
          { 
              $('#date').val(data.date)
              $('#status').val(data.present_absent)
              $('#checkin').val(data.checkin)
              $('#checkout').val(data.checkout)
              $('#record_id').val(data.id)
              $('#editAttendance').modal('show') 
          }
          
        }
        })
  }


  function hideElements(self) 
    {
        if ($(self).val() == '2')  
        {
             $('#leave').css("visibility", "visible");
        }
        else{
            $('#leave').css("visibility", "hidden");
        }
      
        if ($(self).val() == '0' || $(self).val() == '2')  
        {
          $('#checkin_div').hide();
          $('#checkout_div').hide();
        }
        else
        {
            $('#checkin_div').show();
            $('#checkout_div').show();
        }

      return false;
    }

        
    </script>
@stop

