@extends('layouts.app')


@section('title')
Employee Detail
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        
        <li ><a href="{{route('employee.sheet')}}">All Employees</a></li>
      
        <li class="active">Employee Details </li>
      </ol>
@stop

@section('css')
<style>

.us_sty
{
  position: relative;
    top: 8rem;
    z-index: 999;
}
table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
    height: 30.8%!important;
}

#myTable tbody tr td {
    text-align: left;
}

@media print {
  .atten-div {
    margin-top: -15rem !important; 
  }
}
@media print {
  .mon-year {
    margin-top: -3rem !important; 
  }
} 

</style>

@stop

@section('content')
            <div class="container-fluid">
                <div class="row colorbox-group-widget">
                     <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="profile-widget">
                                <div class="profile-img">
                                    <img src="{{asset('plugins/images/users/jeffery.png')}}" height="70px" width="auto" alt="user-img" class="img-circle">
                                     <p class="m-t-10 m-b-5"><a href="javascript:void(0);" class="profile-text font-22 font-semibold">{{$HrmEmployees ? $HrmEmployees->name : ''}}</a></p>
                                     <p class="m-t-10 m-b-5"><a  class="profile-text font-16 font-semibold"></a></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-primary">
                                <div class="media-body">
                                    <h3 class="info-count"><span class="pull-right"><i class="mdi mdi-comment-text-outline"></i></span></h3>
                                    <p class="info-text font-12">Designation</p>
                                    <p class="info-ot font-20">{{$HrmEmployeeDesignation ? $HrmEmployeeDesignation->designation->name : ''}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-info">
                                <div class="media-body">
                                    <h3 class="info-count"><span class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                                    <p class="info-text font-12">Date of Joining</p>
                                    <p class="info-ot font-20">{{date("d-m-Y", strtotime($HrmEmployees->companyDetail ? $HrmEmployees->companyDetail->date_of_joining : ''))}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-success">
                                <div class="media-body">
                                    <h3 class="info-count"><span class="pull-right"><i class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                    <p class="info-text font-12">Department  </p>
                                    <p class="info-ot font-20">{{$HrmEmployeeDepartment->department ? $HrmEmployeeDepartment->department->department_name : ''}}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Basic Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>CNIC</td>
                                                    <td>{{$HrmEmployees->cnic}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Gender</td>
                                                    <td>{{$HrmEmployees->gender}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Date oF Birth</td>
                                                    <td>{{date("d-m-Y", strtotime($HrmEmployees->dob))}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Phone Number</td>
                                                    <td>{{$HrmEmployees->phone_no}}</td>
                                                </tr>
                                                <tr>                    
                                                    <td>Residental Address</td>
                                                    
                                                    <td>{{$HrmEmployees->residential_address}}</td>
                                                   
                                                </tr>
                                                

                                                <tr>
                                                    <td>Permanent Address</td>
                                                    <td>{{$HrmEmployees->pemanent_address}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Email</td>
                                                    <td>{{$HrmEmployees->email}}</td>
                                                </tr>
                                            
                                                
                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->

                @if($HrmEmployeeDepartment != null)

                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box user-table">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4 class="box-title">Company Details </h4>
                                </div>


                            </div><hr>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    
                                    <tbody>

                                    <tr>
                                        <th>Employee Code</th>
                                        <td>{{$HrmEmployees->companyDetail->employee_code}}</td>
                                     </tr>
                                     <tr>   
                                        <th>Date of Joining</th>
                                         <td>{{$HrmEmployees->companyDetail->date_of_joining}}</td>
                                      </tr>  
                                      <tr>
                                          <th>Monthly Salary</th>
                                          <td>{{number_format($HrmEmployees->companyDetail->monthly_salary)}}</td>
                                      </tr>
                                        <tr>
                                            <th>Designation</th>
                                            <td>{{$HrmEmployeeDesignation ? $HrmEmployeeDesignation->designation->name : ''}}</td>
                                        </tr>
                                        <tr>
                                             <th>Contract Type</th>
                                             <td>
                                             @if($HrmEmployees->companyDetail->contract_type=='full_time')
                                            {{"Full Time"}}
                                              @else
                                              {{"Contract"}}
                                              @endif
                                        </td>
                                        </tr>


                                    </tbody>
                                    

                                    <tfoot>
                                      
                </tfoot>
                                </table>
                            </div>

                        </div>

                    </div>

                </div>
                @endif
                  @if($HrmEmployees->accountDetail)
                  <div class="row">
                    <div class="col-md-12">
                        <div class="white-box user-table">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4 class="box-title">Account Details </h4>
                                </div>


                            </div><hr>
                            <div class="table-responsive" style=" overflow-y: auto; max-height: 400px">
                                <table class="table table-responsive" >
                                    
                                    <tbody>
                                        <tr>
                                             <th>Accoun Holder Name</th>
                                             <td>{{$HrmEmployees->accountDetail->account_holder_name}}</td>
                                        </tr>
                                        <tr>
                                            <th>Bank Name</th> 
                                            <td>{{$HrmEmployees->accountDetail->bank_name}}</td>
                                        </tr>

                                        <tr>
                                             <th>Location</th>
                                             <td>{{$HrmEmployees->accountDetail->branch_location}}</td>
                                        </tr>
                                       
                                        <tr>
                                               <th>Account No</th>
                                               <td>{{$HrmEmployees->accountDetail->account_no}}</td>
                                        </tr>
                                         <tr>
                                            <th>Bank Code</th>
                                            <td>{{$HrmEmployees->accountDetail->bank_code}}</td> 

                                         </tr>    
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

               @endif

               {{-- file bank --}}
                <div class="row container-fluid">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title" style="display: inline-block;">File Bank</h3>
                            <a class="btn btn-primary" onclick="$('#exampleModal').modal();" style="font-size: 16px; text-decoration-line: underline; display: inline-block;float: right;"><i class="fa fa-file" style="text-transform: none;">&nbsp;</i>Add New </a><hr>
                                    <div class="table-responsive col-md-12">
                                        
                                             
                                               <?php $c =1;?>
                                                    @foreach($employee_document as $d)

                                           
                                                 <div class="col-md-3">
                                                    <label ><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{$c++}}.</b> &nbsp;&nbsp;<a  onclick="openFileModal()" style="font-size: 12px;cursor: pointer;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</i></a></label><br>

                                                    <a target="_blank" href="{{asset('storage/'.$d->certificate)}}">

                                                        @if(strpos($d->certificate, 'docx') !== false)

                                                        <img src="{{asset('uploads/word.png')}}" width="175" height="100" />

                                                        @elseif(strpos( $d->certificate,'pdf') !== false)

                                                       
                                                        </script>

                                                        <iframe src="{{asset('storage/'.$d->certificate)}}" width="175" height="100" />
                                                        </iframe>



                                                            @else

                                                            <embed src="{{asset('storage/'.$d->certificate)}}" width="175" height="100" />

                                                            @endif

                                                    
                                                    <br>
                                                    <label style="font-size: 12px; cursor: pointer;"><b>&nbsp;</b></label>
                                                     </a>
                                                    <br>
                                                    @if(strpos($d->certificate, 'docx') !== false)
                                                    <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px" href="{{asset('storage/'.$d->certificate)}}"><i class="fa fa-download" style="text-transform: none;">&nbsp;</i>Download </a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                                                    @else
                                                    <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px" href="{{asset('storage/'.$d->certificate)}}"><i class="fa fa-eye" style="text-transform: none;">&nbsp;</i>Preview</a>&nbsp;&nbsp;

                                                    <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px" href="{{asset('storage/'.$d->certificate)}}" download=""> <i class="fa fa-download" style="text-transform: none;">&nbsp;</i>Download</a>&nbsp;&nbsp;

                                                    @endif
                                                    <a style="color:red;text-decoration: underline;font-size: 11px" href="{{route('employee.delete.document',['id'=>$d->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?"> <i class="fa fa-trash" style="text-transform: none;">&nbsp;</i>Delete</a>
                                            </div>
                                             @endforeach
                                   
                                    </div>

                        </div>
                    </div>
                </div>

              <div class="row">
                    <div class="col-md-12">
                        <div class="white-box user-table">
                            <div class="row">
                                
                                <div class="col-sm-6">
                                    <h4 class="box-title">Payroll History</h4>
                                </div>

                                <div class="col-lg-6">
                                    
                                </div>

                                   <div class="col-lg-12 no-print">
                          <form method="GET" style="" action="{{ route('hrmemployee.detail',['id'=>$HrmEmployees->id])}}">
                          
                              <input type="hidden" name="employee_id" value="{{$HrmEmployees->id}}">
                              <div class="row">

                                <div class="col-sm-4">
                                  <div class="form-group us_sty">
                                <label for="recipient-name" class="col-form-label">Month:</label>
                                <select id="month" class="form-control " name="month">
                                
                              <option  <?= ( $month == 1) ? 'selected' : '' ?> value="1">January</option>
                              <option <?= ( $month == 2) ? 'selected' : '' ?> value="2">February</option>
                              <option <?= ( $month == 3) ? 'selected' : '' ?> value="3">March</option>
                              <option <?= ( $month == 4) ? 'selected' : '' ?> value="4">April</option>
                              <option <?= ( $month == 5) ? 'selected' : '' ?> value="5">May</option>
                              <option <?= ($month == 6) ? 'selected' : '' ?> value="6">June</option>
                              <option <?= ( $month == 7) ? 'selected' : '' ?> value="7">July</option>
                              <option <?= ( $month == 8) ? 'selected' : '' ?> value="8">August</option>
                              <option <?= ( $month == 9) ? 'selected' : '' ?> value="9">September</option>
                              <option <?= ( $month == 10) ? 'selected' : '' ?> value="10">October</option>
                              <option <?= ( $month == 11) ? 'selected' : '' ?> value="11">November</option>
                              <option <?= ( $month == 12) ? 'selected' : '' ?> value="12">December</option>
                                </select>
                                </div>
                              </div> 

                               <div class="col-sm-4">
                                  <label for="recipient-name" class="col-form-label us_sty">Year:</label>
                                  <select class="form-control us_sty" name="year">
                                  <?php
                                  for ($year = (int)date('Y'); 1900 <= $year; $year--): ?>
                                  <option <?= ( $year_ == $year) ? 'selected' : '' ?> value="<?=$year;?>"><?=$year;?></option>
                                  <?php endfor; ?>
                                  </select>
                                  </div>

                                    <input type="hidden" name="employee_id" value="{{$HrmEmployees->id}}">
                                   
                                   <button type="submit" style="margin-top: 11rem; border-radius: 5px !important; font-size: 15px;" class="btn-info ">Filter</button>
                                 </div>
                          </form>
                            </div>

                            </div>
                            <hr>
                             <div class="table-responsive">

                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Month / Year</th>
                                            <th> Earning </th>
                                            <th> Tax </th>
                                            <th> Deduction </th>
                                            <th>Net Salary </th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                       
                                    <tr>
                                    <td> {{date('F', mktime(0, 0, 0, $month))}} / {{$year_}}</td>
                                    <td>{{number_format($total_calculated_monthly_earning)}}</td>
                                    <td>{{number_format($total_calculated_monthly_tax)}}</td>
                                    <td>{{number_format($total_monthly_deduction)}}</td>
                                    <td>{{number_format($total_calculated_monthly_earning - $total_monthly_deduction - $total_calculated_monthly_tax)}}</td>

                                    <td>

                                    @if($already_exist == 0)
                                        <a href="{{route('view.payslip' , ['month' => $month , 'year' => $year_  , 'employee_id' => $HrmEmployees->id ])}}" >
                                            <div>
                                            <i class="fa fa-eye text-inverse m-r-10"></i>
                                            </div>
                                        </a>
                                    @else
                                             <span style="padding: 2px 15px 3px 15px;background: #f7ab007a;border-radius: 1rem;color: white;">
                                             {{'PaySlip Not Generate'}}
                                             </span>
                                    @endif

                                    </td>


                                    </tr>
                                         
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="container-fluid" >
                <!-- /row -->
                <div class="row" style="height: 30px;">

                    <div class="col-sm-12">
                        <div class="white-box" id="printableSection">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4 class="box-title">Attendance  History</h4>
                                </div>

                            </div><hr>
                           <div class="col-sm-12" style="text-align:right;">
                            <a class="btn btn-info avoid-this" id="print" style="margin-top: 1rem;" href="#">Print</a>
                           </div>
                            <center><h6 class="box-title"> Monthly Attendance Report</h6></center>
                            
                            <div class="col-lg-6">
                              <h4 style="color: black;">{{ucfirst($HrmEmployees->name)}}</h4>  
                            </div>
                            <div class="col-lg-6 mon-year" style="text-align: right;">

                              <h4 class="mon-year" style="color: black">{{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_}}</h4>
                            </div>
                            <div class="col-lg-6" style="text-align: right;">
                              
                            </div>
                            
                            
                            <div class="col-lg-12 no-print">
                              <form method="GET" style="margin-top: -7rem;" action="{{ route('hrmemployee.detail' , ['id'=>$HrmEmployees->id]) }}">
                          
                              <input type="hidden" name="employee_id" value="{{$HrmEmployees->id}}">
                              <div class="row">

                                <div class="col-sm-4">
                                  <div class="form-group us_sty">
                                <label for="recipient-name" class="col-form-label">Month:</label>
                                <select id="month" class="form-control " name="month">
                                
                              <option  <?= ( $month == 1) ? 'selected' : '' ?> value="1">January</option>
                              <option <?= ( $month == 2) ? 'selected' : '' ?> value="2">February</option>
                              <option <?= ( $month == 3) ? 'selected' : '' ?> value="3">March</option>
                              <option <?= ( $month == 4) ? 'selected' : '' ?> value="4">April</option>
                              <option <?= ( $month == 5) ? 'selected' : '' ?> value="5">May</option>
                              <option <?= ($month == 6) ? 'selected' : '' ?> value="6">June</option>
                              <option <?= ( $month == 7) ? 'selected' : '' ?> value="7">July</option>
                              <option <?= ( $month == 8) ? 'selected' : '' ?> value="8">August</option>
                              <option <?= ( $month == 9) ? 'selected' : '' ?> value="9">September</option>
                              <option <?= ( $month == 10) ? 'selected' : '' ?> value="10">October</option>
                              <option <?= ( $month == 11) ? 'selected' : '' ?> value="11">November</option>
                              <option <?= ( $month == 12) ? 'selected' : '' ?> value="12">December</option>
                                </select>
                                </div>
                              </div> 

                               <div class="col-sm-4">
                                  <label for="recipient-name" class="col-form-label us_sty">Year:</label>
                                  <select class="form-control us_sty" name="year">
                                  <?php
                                  for ($year = (int)date('Y'); 1900 <= $year; $year--): ?>
                                  <option <?= ( $year_ == $year) ? 'selected' : '' ?> value="<?=$year;?>"><?=$year;?></option>
                                  <?php endfor; ?>
                                  </select>
                                  </div>
                                   
                                   <button type="submit" style="margin-top: 2.5rem;" class="btn btn-info us_sty">Filter</button>
                                 </div>
                          </form>
                            </div>
                            <h3 style="text-align: right;" class="box-title m-b-0">
                                <div class="container-fluid">
                                   
                                </div>
                            </h3>

                            <br>
                           
                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped table-bordered dataTable color-table info-table" role="grid">
                                    <thead>
                                        <tr>
                                         
                                            <th>Date</th>
                                            <th>Status </th>
                                            <th>CheckIn </th>
                                            <th>CheckOut</th>
                                            <th>Time</th>
                                            <th>Created By</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                         
                                         $num_of_days = $num_of_days
                                         @endphp
                                         
                                         @for($i=1; $i<=$num_of_days; $i++)

                                         @php

                                            $day =  $i;
                                            $date = null;
                                            $present_absent = '-';
                                            $check_in = '-';
                                            $checkout = '-';
                                            $name = '-';

                                         @endphp


                                          @if($employee_attendance->count() > 0 ) 

                                           @foreach($employee_attendance as $key=>$attendance)


                                                
                                             @php 
                                                $employee = \App\HrmEmployee::find($attendance->employ_id);
                                                $user = \App\User::find($attendance->user_id);

                                              

                                              if(date('d',strtotime($attendance->date)) == $i) 

                                              {
                                                  $date = date('d-D',strtotime($attendance->date));

                                                  $present_absent = $attendance->present_absent;
                                                  $check_in  = date('h:i a',strtotime($attendance->checkin));
                                                  $checkout =  date('h:i a',strtotime($attendance->checkout));
                                                  $status   =  $attendance->status;
                                                  $name = $user->name;

                                              }



                                             @endphp

                                          @endforeach
                                           @endif



                                            <tr>
                                               
                                          

                                              <td>
                                                @if(!empty($date))
                                                {{$date}} 
                                                 @php
                                                    $Day = "";
                                                    $flag = 0;
                                                    for ($z=3; $z < 6; $z++) { 
                                                      $Day = $Day.$date[$z];
                                                    }
                                                    $len = count($offday);
                                                    for($y=0; $y<$len; $y++){
                                                      if ($offday[$y] == $Day) {
                                                        $flag = 1;
                                                      }
                                                    }
                                                  @endphp
                                                @else
                                                {{$D = date('d-D' , strtotime($i.'-'.$month.'-'.$year_))}}
                                                @php
                                                    $Day = "";
                                                    $flag = 0;
                                                    for ($z=3; $z < 6; $z++) { 
                                                      $Day = $Day.$D[$z];
                                                    }
                                                    $len = count($offday);
                                                    for($y=0; $y<$len; $y++){
                                                      if ($offday[$y] == $Day) {
                                                        $flag = 1;
                                                      }
                                                    }
                                                  @endphp
                                              @endif
                                              </td>
                                              <td>
                                                
                                                @if($flag == 1)
                                                
                                                <span class="label label" style="color: yellow;">offday</span>
                                                @else
                                                  
                                                    @if( $present_absent=='1' )

                                                    <span class="label label-success">Present</span>

                                                    @elseif($present_absent=='0')

                                                    <span class="label label" style="background-color: red">Absent </span>

                                                    @elseif( $present_absent== '2')

                                                    <span class="label label-warning">Leave</span>

                                                    @else
                                                    -
                                                       
                                                    @endif
                                                  @endif                                                 
                                            
                                              </td>

                                              <td>



                                                @if( $present_absent != '-' && $present_absent != '2' && $present_absent != '0' )

                                                {{$check_in}}

                                                @else
                                                -
                                                @endif

                                              </td>

                                              <td>

                                                 @if($present_absent != '-' && $present_absent != '2' && $present_absent != '0')

                                                {{$checkout}}
                                                 @else
                                                -
                                                @endif

                                              </td>


                                            <td>

                                                   @if($flag == 1)
                                                
                                                <span class="label label" style="color: yellow;">offday</span>
                                                @else


                                            @if($present_absent== '1') 

                                            @if($status )

                                            <span class="label label-info">OnTime</span>


                                            @else

                                            <span class="label label-danger">Late</span>

                                            @endif

                                         

                                            @elseif( $present_absent== '0')

                                            <span class="label label" style="background-color: red">Absent</span>


                                            @elseif($present_absent=='2')

                                            <span class="label label-warning">Leave</span>

                                              @else

                                                  -


                                            @endif

                                            @endif

                                            </td>
                                            
                                             <td>{{$name}}</td>

                                           </tr>

                                         @endfor


                                    </tbody>
                                </table>


                                  <div class="row">
                                    <div class="col-lg-6" style="text-align: left;">
                                      

                                    <div style="margin-top: 1rem;">
                                      <b> Medical leave :  </b>{{$employee_medical_leaves }} , (<b> Remaining : </b> {{ $employee_medical_leaves - $medical_leave  }})
                                    </div>

                                    <div style="margin-top: 1rem;">
                                      <b> Anual Leaves : </b>{{$employee_anual_leaves}} , (<b> Remaining : </b>{{ $employee_anual_leaves - $anual_leave   }}) 
                                    </div>

                                     <div style="margin-top: 1rem;">
                                      <b> Other Leaves : </b> {{$employee_other_leaves}} , (<b> Remaining : </b>{{$employee_other_leaves - $other_leave}} )
                                    </div>
                                    <div style="margin-top: 1rem;">
                                      <b> Special Leaves : </b>{{$employee_special_leaves}} , (<b> Remaining :</b> {{ $employee_special_leaves - $special_leave  }})  
                                    </div>
                                    {{-- <div style="margin-top: 1rem;">
                                      <b> Weekend Leaves : </b>{{$employee_weekend_leaves}} , (<b> Remaining : </b> {{$employee_weekend_leaves -$weekend_leave }}) 
                                    </div> --}}


                                    </div>
                                    <div class="col-lg-6 atten-div" style="text-align: right;">
                                      
                                      <div style="margin-top: 1rem;">
                                      <b> Presents for {{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_}} : </b> {{$presents}}
                                    </div>

                                    <div style="margin-top: 1rem;">
                                      <b> Absents for {{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_ }} : </b> {{$absents}}
                                    </div>

                                    <div style="margin-top: 1rem;">
                                      <b> Leaves for {{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_}} : </b> {{$leaves}}
                                    </div>

                                    <div style="margin-top: 1rem;">
                                      <b> Ontime for {{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_}} : </b> {{$ontime}}
                                    </div>
                                    <div style="margin-top: 1rem;">
                                      <b> Late for {{  date('F', mktime(0, 0, 0, $month, 10))  }}, {{$year_}} : </b> {{$late}}
                                    </div>

                                    </div>

                      
                                </div>
                                <br>
                        
                    </div>
                </div>
            </div>
        </div>
       
      </div>

             
              </div>  
            
            {{-- file modele --}}

            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

                <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header" style="text-align: center;">
        <h5 class="modal-title" id="exampleModalLabel" >New File</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form method="post" action="{{route('hrmemployee.document.insert')}}" enctype="multipart/form-data" >
        {{csrf_field()}}
      <div class="modal-body" style="height: 250px;">
        <input type="hidden" name="employee_id" value="{{$HrmEmployees->id}}">

        <div class="form-group form-group-sm">
            <div class="col-xs-4">
                <label>File</label>
            </div>
            <div class="col-xs-8">
                <input type="file"  name="file" class="form-control" >
            </div>
        </div>
        <br>
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Upload</button>
      </div>
      </form>
    </div>
  </div>
  
</div>

            {{-- end file model --}}
       

    
     
@stop

@section('js')

    <script>



    function GeneratePaySlip(self) {
    $(self).closest('td').find('#payslip_form').submit()
    }

    </script>
 @stop