@extends('layouts.app')


@section('title')
Update Employee 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-dealer')
        <li ><a href="{{route('employee.sheet')}}">All Employees</a></li>
        @endpermission
        <li class="active">Update Employee</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">
    <div class="col-md-12"> @if($errors->any())
        <div class="white-box">
            <h2>Errors</h2>
            <ul> {!! implode('', $errors->all('
                <li><span class="help-block"><strong>:message</strong></span></li>')) !!} </ul>
        </div>@endif
        <div class="white-box">
            <div class="row">
                <div class="col-md-6" align="center">
                    <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i>Employee Persional Information</h3>
                    <hr style="border-width: 30px;"> </div>
                <div class="col-md-6" align="center">
                    <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Company Details </h3>
                    <hr style="border-width: 30px;"> </div>
            </div>
            <form class="form-horizontal" action="{{route('hrmemployee.update',['id' =>$HrmEmployees->id])}}" method="post" autocomplete="off" enctype="multipart/form-data"> {{csrf_field()}}
                <div class=" row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red"></span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="name" value="{{$HrmEmployees->name}}" id="exampleInputuname" placeholder="Enter Name"> @if ($errors->has('name')) <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label">Employee ID <span style="color: red"></span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-lock"></i></div>
                                    <input type="text" class="form-control" name="employee_id" value="{{$HrmEmployees->companyDetail ? $HrmEmployees->companyDetail->employee_code : ''}}" id="exampleInputuname" placeholder="Enter Code"> @if ($errors->has('employee_id')) <span class="help-block">
                                        <strong>{{ $errors->first('employee_id') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cnic" class="col-sm-2 control-label">CNIC <span style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                    <input type="text" class="form-control" value="{{$HrmEmployees->cnic}}" name="cnic" id="cnic" data-inputmask="'mask': '99999-9999999-9'" placeholder="XXXXX-XXXXXXX-X"> @if ($errors->has('cnic')) <span class="help-block">
                                        <strong>{{ $errors->first('cnic') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Department <span style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user-secret"></i></div>
                                    <select class="form-control select2" name="department"> 
                                        @if($DepartmentLists->count() > 0 )
                                        <option value="">Select Department </option>
                                         @foreach($DepartmentLists as $DepartmentList)
                                        <option <?php if($HrmEmployeeDepartment && $DepartmentList->id == $HrmEmployeeDepartment->department->id) {echo "selected";}?> value="{{ $DepartmentList->id }}">{{ $DepartmentList->department_name }}</option>
                                         @endforeach 
                                      @endif 
                                 </select> 
                                   @if ($errors->has('department'))
                                     <span class="help-block">
                                        <strong>{{ $errors->first('department') }}</strong>
                                    </span>
                                   @endif 
                                 </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-lg-2 control-label">Gender <span style="color: red">*</span></label>
                            <div class="col-lg-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <label class="radio-inline">
                                        <input type="radio" name="gender" value="Male" {{ $HrmEmployees->gender =='Male' ? 'checked' : ''}} >Male</label>
                                    <label class="radio-inline">
                                        <input type="radio" name="gender" value="Female" {{ $HrmEmployees->gender == 'Female' ? 'checked' : ''}}>Female</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Country <span style="color: red"></span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-world"></i></div>
                                    <select class="form-control select2" id="country_id" name="country">
                                        <option>Select Country</option> @foreach($country as $count)
                                        <option <?php if($HrmEmployeeCountry && $count->id == $HrmEmployeeCountry->country->id) {echo "selected";}?> value="{{$count->id}}">{{$count->name}}</option> @endforeach </select> @if ($errors->has('country')) <span class="help-block">
                                        <strong>{{ $errors->first('country') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cnic" class="col-sm-2 control-label">Date of Birth <span style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-calender"></i></div>
                                    <input type="date" class="form-control" value="{{$HrmEmployees->dob}}" max="{{date('Y-m-d')}}" name="dob" id="dob"> @if ($errors->has('dob')) <span class="help-block">
                                        <strong>{{ $errors->first('dob') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">City <span style="color: red"></span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                    <select class="form-control select2" id="city_id" name="city">
                                        <option>Select City</option> @foreach($city as $cit)
                                        <option <?php if($HrmEmployeeCity && $cit->id == $HrmEmployeeCity->city->id) {echo "selected";}?> value="{{$cit->id}}">{{$cit->name}}</option> @endforeach </select> @if ($errors->has('city')) <span class="help-block">
                                        <strong>{{ $errors->first('city') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Phone Number<span style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                    <input type="text" class="form-control" maxlength="12" data-inputmask="'mask': '0399-99999999'" type='number' name="phone_number" value="{{$HrmEmployees->phone_no}}" placeholder="Enter Phone Number"> @if ($errors->has('phone_number')) <span class="help-block">
                                        <strong>{{ $errors->first('phone_number') }}</strong>
                                    </span> @endif</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cnic" class="col-sm-2 control-label">Date of Joining <span style="color: red"></span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-calender"></i></div>
                                    <input type="date" class="form-control" name="date_of_joing" value="{{$HrmEmployees->companyDetail ? $HrmEmployees->companyDetail->date_of_joining : ''}}" max="{{date('Y-m-d')}}" name="date_of_joing" id="date_of_joing"> @if ($errors->has('date_of_joing')) <span class="help-block">
                                        <strong>{{ $errors->first('date_of_joing') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Residential Address<span style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                    <input type="text" class="form-control" name="Resi_address" value="{{$HrmEmployees->residential_address}}" id="address1" placeholder="Enter Residential Address..."> @if ($errors->has('Resi_address')) <span class="help-block">
                                        <strong>{{ $errors->first('Resi_address') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label">Monthly Salary <span style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="salary" value="{{$HrmEmployees->companyDetail ? $HrmEmployees->companyDetail->monthly_salary : ''}}" id="exampleInputuname" placeholder="Enter Name"> @if ($errors->has('salary')) <span class="help-block">
                                        <strong>{{ $errors->first('salary') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Permanent Address</label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                    <input type="text" class="form-control" name="per_address" value="{{$HrmEmployees->pemanent_address}}" id="address1" placeholder="Enter Permanent Address..."> @if ($errors->has('per_address')) <span class="help-block">
                                        <strong>{{ $errors->first('per_address') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
              <div class="form-group">
                <label for="exampleInputuname" class="col-lg-2 control-label">Salary Method  <span style="color: red">*</span>
                </label>
                <div class="col-lg-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="ti-user"></i>
                    </div>
                    <label class="radio-inline">
                      <input type="radio" value="cheque" {{ $HrmEmployees->companyDetail->salary_method =='cheque' ? 'checked' : ''}} name="salary_method" checked>Cheque</label>
                    <label class="radio-inline">
                      <input type="radio" value="cash" {{ $HrmEmployees->companyDetail->salary_method =='cash' ? 'checked' : ''}} name="salary_method">Cash</label>
                    <label class="radio-inline">
                      <input type="radio" value="bank" {{ $HrmEmployees->companyDetail->salary_method =='bank' ? 'checked' : ''}} name="salary_method">Bank</label>
                  </div>
                </div>
              </div>
            </div>
                    
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Role <span style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user-secret"></i></div>
                                    <select class="form-control select2" name="role_name">
                                        <option value="">Select role</option> @if($roles->count() > 0 ) @foreach($roles as $list)
                                        <option <?php if($list->id == $HrmEmployeeRole->role->id) {echo "selected";}?> value="{{ $list->id }}">{{ $list->name }}</option> @endforeach @endif </select> @if ($errors->has('role_name')) <span class="help-block">
                                        <strong>{{ $errors->first('role_name') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                     <div class="col-md-6">
              <div class="form-group">
                <label for="address" class="col-sm-2 control-label">Designation <span style="color: red">*</span>
                </label>
                <div class="col-sm-10">
                  <div class="input-group">
                    <div class="input-group-addon">
                      <i class="fa fa-user-secret"></i>
                    </div>
                    <select class="form-control select2" name="designation">
                     @if($DesignationLists->count() > 0 ) 
                     <option value="">Select Designation </option>
                      @foreach($DesignationLists as $DesignationList)
                       <option <?php if($HrmEmployeeDesignation && $DesignationList->id == $HrmEmployeeDesignation->designation->id) {echo "selected";}?> value="{{ $DesignationList->id }}">{{ $DesignationList->name }}</option>
                        @endforeach

                        @endif </select> @if ($errors->has('designation')) 
                        <span class="help-block">
                      <strong>{{ $errors->first('designation') }}</strong>
                    </span>
                     @endif
                  </div>
                </div>
              </div>
            </div>
                    
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Email <span style="color: red">*</span> </label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-email"></i></div>
                                    <input type="email" class="form-control" name="email" value="{{$HrmEmployees->email}}" id="exampleInputEmail1" placeholder="Enter email"> @if ($errors->has('email')) <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                     @if($HrmEmployees->companyDetail)
                     <div class="col-md-6">
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Contract Type <span style="color: red"></span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user-secret"></i></div>
                                    <select class="form-control select2" name="contract_type">
                                        <option <?php if($HrmEmployees->companyDetail && $HrmEmployees->companyDetail->contract_type=='full_time') {echo "selected";}?> value="full_time" >Full Time </option>
                                        <option <?php if($HrmEmployees->companyDetail && $HrmEmployees->companyDetail->contract_type=='contract') {echo "selected";}?> value="Contract" >Contract </option>
                                    </select> @if ($errors->has('contract_type')) <span class="help-block">
                                        <strong>{{ $errors->first('contract_type') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                        </div> 
                        @endif
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Password<span style="color: red">*</span> </label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-key"></i></div>
                                    <input type="password" class="form-control" name="password" value="{{$HrmEmployees->password}}" id="exampleInputEmail1" placeholder="Enter password"> @if ($errors->has('password')) <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr style="border-width: 30px;">
                <hr>
                <div class="row">
            <div class="col-md-6" align="center">
              <h3 class="box-title m-b-0">
                <i class="icon-user fa-fw"></i> Bank Account Details
              </h3>
              <hr style="border-width: 25px;">
            </div>
            
          </div>
                <div class="row">
                    {{-- <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Certificate <span style="color: red"></span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-picture"></i></div>
                                    <input type="file" class="form-control" name="file_Certificate" placeholder="Upload Certificate"> @if ($errors->has('file_Certificate')) <span class="help-block">
                                        <strong>{{ $errors->first('file_Certificate') }}</strong>
                                    </span> @endif</div>
                            </div>
                        </div>
                    </div> --}}
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red"></span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="holder_name" value="{{$HrmEmployees->accountDetail ? $HrmEmployees->accountDetail->account_holder_name : ''}}" id="exampleInputuname" placeholder="Enter Account Holder Name"> @if ($errors->has('holder_name')) <span class="help-block">
                                        <strong>{{ $errors->first('holder_name') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    {{-- <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Resume <span style="color: red"></span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-picture"></i></div>
                                    <input type="file" class="form-control" name="file_resume" placeholder="Upload Resume"> @if ($errors->has('file_resume')) <span class="help-block">
                                        <strong>{{ $errors->first('file_resume') }}</strong>
                                    </span> @endif</div>
                            </div>
                        </div>
                    </div> --}}
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label">Bank Name <span style="color: red"></span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="bank_name" value="{{$HrmEmployees->accountDetail ? $HrmEmployees->accountDetail->bank_name : ''}}" id="exampleInputuname" placeholder="Enter Bank Name..."> @if ($errors->has('bank_name')) <span class="help-block">
                                        <strong>{{ $errors->first('bank_name') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=" row">
                    {{-- <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Photo <span style="color: red"></span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-picture"></i></div>
                                    <input type="file" class="form-control" name="file_photo" placeholder="Upload Photo..."> @if ($errors->has('file_photo')) <span class="help-block">
                                        <strong>{{ $errors->first('file_photo') }}</strong>
                                    </span> @endif</div>
                            </div>
                        </div>
                    </div> --}}
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label">Location <span style="color: red"></span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="location" value="{{$HrmEmployees->accountDetail ? $HrmEmployees->accountDetail->branch_location : ''}}" id="exampleInputuname" placeholder="Enter Branch Location..."> @if ($errors->has('location')) <span class="help-block">
                                        <strong>{{ $errors->first('location') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    {{-- <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Other <span style="color: red"></span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-picture"></i></div>
                                    <input type="file" class="form-control" name="file_other" placeholder="Upload Other..."> @if ($errors->has('file_other')) <span class="help-block">
                                        <strong>{{ $errors->first('file_other') }}</strong>
                                    </span> @endif</div>
                            </div>
                        </div>
                    </div> --}}
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label">Account Number <span style="color: red"></span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="number" class="form-control" name="account_no" value="{{$HrmEmployees->accountDetail ? $HrmEmployees->accountDetail->account_no : ''}}" id="exampleInputuname" placeholder="Account No.."> @if ($errors->has('account_no')) <span class="help-block">
                                        <strong>{{ $errors->first('account_no') }}</strong>
                                    </span> @endif </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label">Code <span style="color: red"></span></label>
                                <div class="col-sm-10">
                                    <div class="input-group">
                                        <div class="input-group-addon"><i class="ti-user"></i></div>
                                        <input type="number" class="form-control" name="bank_code" value="{{$HrmEmployees->accountDetail ? $HrmEmployees->accountDetail->bank_code : ''}}" id="exampleInputuname" placeholder="Bank Identifier Code.."> @if ($errors->has('bank_code')) <span class="help-block">
                                        <strong>{{ $errors->first('bank_code') }}</strong>
                                    </span> @endif </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- <hr style="border-width: 30px;">
                    <hr> --}}
                    <div class=" col-sm-12">&nbsp;</div>
                    <div class=" col-sm-12">
                        <div class="form-group">
                            <hr style="border-width: 3px;">
                            <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
                        </div>
                    </div>
            </form>
            </div>
        </div>
    </div>
              
            </div>
       

@stop


@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
    $(":input").inputmask();
    $('#country_id').change(function() {
    $('.preloader').fadeIn();
        var data = { 'country_id': $(this).val() };

        $.get('/getCitiesByCountry', data, function (data) {
           var model = $('#city_id');
                    model.empty();

                     model.append("<option value='' disabled selected>" + '' + "</option>");


                    $.each(data, function(index, element) {
                        model.append("<option value='"+ element.id +"'>" + element.name + "</option>");
                    });
        });
         $('.preloader').fadeOut();
    });

function percentCheckbox() {

        if($('#rebate_in_percent').prop("checked") == false) {
            document.getElementById('rebate_input').innerHTML = 'PKR';
        }
        else {
            document.getElementById('rebate_input').innerHTML = '%';
        }
    }
   </script>
@stop


