@extends('layouts.app')


@section('title')
Update Employee 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-dealer')
        <li ><a href="{{route('employee.sheet')}}">All Employees</a></li>
        @endpermission
        <li class="active">Update Employee</li>
      </ol>
@stop
@section('css')
<style type="text/css">
 .form-group {
    margin-bottom: 15px !important;
}
   
</style>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">
    <div class="col-md-12"> @if($errors->any())
        <div class="white-box">
            <h2>Errors</h2>
            <ul> {!! implode('', $errors->all('
                <li><span class="help-block"><strong>:message</strong></span></li>')) !!} </ul>
        </div>@endif
        <div class="white-box">
            <div class="row">
                <div class="col-md-6" align="center">
                    <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i>Earning </h3>
                    <hr style="border-width: 30px;"> </div>
                <div class="col-md-6" align="center">
                    <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Deduction </h3>
                    <hr style="border-width: 30px;"> </div>
            </div>
            <form method="post" action="{{route('update-pending-payroll', ['employ_id'=>$employee_id])}}">

               {{csrf_field()}}

               <input type="hidden" name="year" value="{{$year}}">
               <input type="hidden" name="month" value="{{$month}}">
               <input type="hidden" name="employee_id" value="{{$employee_id}}">
               
               <input type="hidden" name="lon_adv_id" value="{{$lon_adv_id}}">
 
               <div class="row">
                  
                  <div class="col-lg-6" >
                     <p style="text-align: center; border-image: 2px;"><strong>Allowances </strong></p>
                     <hr>


                     <div class="row">
                        <div class="col-sm-5 text-cent">
                           <label for="message-text" class="col-form-label"><strong>Title:</strong></label>
                        </div>
                        <div class="col-sm-5">
                           <label for="message-text" class="col-form-label"><strong>Amount:</strong></label>
                        </div>
                        <div class="col-sm-2">
                           <div class="form-group" style="margin-bottom: 0;">
                             {{--  <button type="button" onclick="return addNewRow(this)" class="btn btn-primary">+</button> --}}
                           </div>
                        </div>
                     </div>

                     

                     <div id="earning_parent_div">
                      @foreach($earnings  as $earning)
                      
                        <div class="row">
                            <input type="hidden" name="id[]" value="{{$earning->id}}">
                            <div class="col-sm-5">
                                <div class="form-group">
                                    <input type="text" class="form-control" readonly name="earning_title[]" value="{{$earning->title}}" id="exampleInputuname" placeholder=" Title">
                                </div>
                            </div>
                            <div class="col-sm-5">
                                <div class="form-group"> 
                                    <input type="Number" class="form-control" name="earning_amount[]"  value="{{$earning->amount}}" id="exampleInputuname" placeholder=" Amount">
                                </div>
                            </div>
                        </div>

                        @endforeach
                        
                     </div>
                  
                  </div>

                  <div class="col-lg-6" style="border-left: 1px solid black; ">
                     
                     <p style="text-align: center;"><strong>Deductions</strong> </p>
                     <hr>
                     <div class="row">
                        <div class="col-sm-5 text-cent">
                           <label for="message-text" class="col-form-label"><strong>Title:</strong></label>
                        </div>
                        <div class="col-sm-5">
                           <label for="message-text" class="col-form-label"><strong>Amount:</strong></label>
                        </div>
                        <div class="col-sm-2">
                           <div class="form-group" style="margin-bottom: 0;">
                             {{--  <button type="button" onclick="return addNewRowToDeduction(this)" class="btn btn-primary">+</button> --}}
                           </div>
                        </div>
                     </div>
                     
                     <div id="deduction_parent_div">
                      <div class="row">
                        <div class="col-sm-5">

                            <select class="form-control chosen-select" name="type" id="type" >
                               
                                <option value="">Select Type</option>
                                <option  <?php if($loans ? $loans->type:'' =='Loan') {echo "selected";}?> value="Loan">Loan</option>
                                <option <?php if($loans ? $loans->type:'' =='Advance') {echo "selected";}?> value="Advance">Advance </option>
                            </select>
                        </div>
                        <div class="col-sm-5">
                            <div class="form-group">
                                <input type="hidden" name="loan_id" id="loan_id" value="{{$loans ? $loans->id:''}}">
                                <input type="Number" class="form-control" name="adjustment_amount" value="{{$loans ? $loans->adjustment_amount:''}}" id="exampleInputuname">
                            </div>
                        </div>
                    </div>

                     <div class="row">
                        <div class="col-sm-5">
                            <div class="form-group">
                                <input type="text" class="form-control" readonly value="" id="exampleInputuname" placeholder=" Benevolent Fund">
                            </div>
                        </div>
                        <div class="col-sm-5">
                            <div class="form-group">
                               <input type="hidden" name="bf_id" id="bf_id" value="{{$bf->id}}"> 
                               <input type="Number" class="form-control" name="bf" value="{{$bf->bf_fund}}" id="exampleInputuname" placeholder="">
                        </div>
                    </div>
                </div>

                    @foreach($deductions as $deduction)
                    <div class="row">
                        <input type="hidden" name="deduction_id[]" value="{{$deduction->id}}">
                        <div class="col-sm-5">
                            <div class="form-group">
                                <input type="text" class="form-control" readonly name="deduction_title[]" value="{{$deduction->title}}" id="exampleInputuname" placeholder=" Title">
                            </div>
                        </div>
                        <div class="col-sm-5"><div class="form-group"> <input type="Number" class="form-control" name="deduction_amount[]" id="exampleInputuname" value="{{$deduction->amount}}">
                        </div>
                    </div>
                </div>
                @endforeach
                         
                     </div>
                  
                  </div>
               </div>
               <div class="modal-footer">
                  
                  <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
               </div>
         </div>
      </div>
      </form>
            </div>
        </div>
    </div>
              
            </div>
       

@stop


@section('js')

    
@stop


