@extends('layouts.app')

@section('title')
Employee Payroll 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Employees Monthly Payroll </li>
      </ol>
@stop


@section('content')

<div class="container-fluid">
    <!-- /row -->
    <div class="row">
        <div class="col-sm-12">
            <div class="white-box">
                <h3 class="box-title">Employees Monthly Payroll</h3>
                <!-- Nav tabs -->
                <ul class="nav customtab nav-tabs" role="tablist">
                    <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">List</span></a></li> 
                    <li role="presentation" class=""><a href="#home1" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Pending Payroll Sheet</span></a></li>
                   
                    <li role="presentation" class=""><a href="#profile2" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Vouchers</span></a></li>  </ul>
                <!-- Tab panes -->
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane fade active in" id="home">
                        <div class="table-responsive"> {{-- <a href="{{route('control-account.addView',['id'=>\App\ControlAccount::CUSTOMER])}}" target="_blank" class="btn btn-default pull-right"> Add New </a> --}}
                            <br>
                            <br>
                            <div class="clearfix"></div>
                            <table id="myTable8" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                <thead>
                                    <tr role="row">
                                        <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">#:</th>
                                        <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name:</th>
                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Designation: </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count =1;   $total_net_salary = 0;?>

                                     @foreach ($hrmEmployees as $salary)

                                      @php

                                       $total = \App\HrmEmployeeMonthlyEarningDeduction::getData($salary->id , $month , $year );

                                      @endphp

                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$salary->name}}</td>
                                            <td>{{$salary->company_detail->designation->name }}</td>
                                            
                                        </tr>

                                      @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <div role="tabpanel" class="tab-pane fade" id="home1">
                        <div class="table-responsive">
                            <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                <thead>
                                    <tr role="row">

                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Month/Year: </th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Total Earning: </th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Tax: </th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Total Deduction: </th>
                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Net Salary:</th>

                                    <th class="sorting" style="width: 185px!important; background-color: white !important">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $total_net_salary = 0;
                                    $total_net_salary =  $total_monthly_earning  - ($total_monthly_deduction + $total_monthly_tax);

                                    @endphp

                                     
                                    <tr>
                                    <td>{{date('F', mktime(0, 0, 0, $month))}}/{{$year}}</td>
                                    <td><strong>{{number_format($total_monthly_earning)}}</strong></td>
                                    <td><strong>{{number_format($total_monthly_tax)}}</strong></td>
                                    <td><strong>{{number_format($total_monthly_deduction)}}</strong></td>
                                    <td ><strong>{{number_format($total_net_salary )}}</strong></td>

                                    <td class="text-nowrap"> 

                                    <a href="{{route('all-employee.salary.list')}}" target="_blank" class="btn btn-default"> View </a> 

                                    <a href="#"  onclick="$('#voucher-form').submit()"  class="btn btn-primary"> Make Voucher</a>

                                    <form id="voucher-form" method="post" action="{{route('create-voucher')}}">
                                    {{csrf_field()}}

                                    <input type="hidden" name="type" value="">
                                    <input type="hidden" name="id" value="">
                                    <input type="hidden" name="control" value=""> 
                                    </form>

                                    </td>
                                    </tr>
                                    </tbody>
                            </table>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                  
                    <div role="tabpanel" class="tab-pane fade" id="profile2">
                        <div class="table-responsive">
                            <table id="myTable3" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Type</th>
                                        <th>Checked</th>
                                        <th>Posted</th>
                                        <th>Date</th>
                                        <th>Entry No.</th>
                                        <th>ADJ</th>
                                        <th>Account</th>
                                        <th>Memo</th>
                                        <!-- <th>Class</th> -->
                                        <th>Debit/Credit (+/-)</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr> 
                                        <td></td>
                                        <td></td> 
                                        <td></td> 
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td> 
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /.row -->
</div>
            

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'info':true,
            'ordering':false
        });

        
        $('#myTable3').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'info':true,
            'ordering':false
        });

        $('#myTable8').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'info':true,
            'ordering':false
        });
    });

    function paymentVoucher(check_ids) {

        $('#id').val(check_ids);

        $('#voucher-form').submit();
        
    }
        
    </script>
@stop