@extends('layouts.app')

@section('title')
All Employees 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Employees</li>
      </ol>
@stop

@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
#myTable tbody tr td {
    text-align: left;
}
</style>

@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <div class="pull-right">
                          
                               
                                
                            </div>
                            <h3 class="box-title">All Employees Net Salary </h3>
                             <h3 style="text-align: right;" class="box-title m-b-0">
                                </h3>
                             
                           <br>
                            
                            <div class="table-responsive">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                            <div class="table-responsive">
                                <table id="myTableData" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Designation </th>
                                            <th>Earning</th>
                                            <th>Deduction</th>
                                            <th>Basic Salary </th>
                                            <th>Net Salary</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                          $couter = 1;
                                        @endphp
                                        @foreach($HrmEmployees as $employee)  
                                        <tr>
                                            <td>{{$couter++}}</td>
                                            <td>{{$employee->name}}</td>
                                            <td>{{$employee->companyDetail->designation}}</td>
                                            <td></td>
                                            <td></td>
                                            <td>{{$employee->companyDetail->monthly_salary}}</td>
                                            <td></td>

                                            <td class="text-nowrap">
                                               
                                                <a href="{{-- {{route('hrmemployee.detail',[$HrmEmployee->id])}} --}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                
                                                &nbsp;

                                            </td>
                                        </tr>
                                      
                                        @endforeach

                                    </tbody>
                                </table>


                              
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
          </div>
            <!-- /.container-fluid -->
  <div class="modal fade" id="generate_slip" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel"> Generate PaySlip</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="GET" action="{{route('hrmemployee-payslip.detail')}}">
          
          <input type="hidden" name="employee_id" id="employee_id" value="0">
    

          <div class="row">

              <div class="col-sm-6">
              <label for="recipient-name" class="col-form-label">Year:</label>
              <select class="form-control" name="year">
              <?php
              for ($year = (int)date('Y'); 1900 <= $year; $year--): ?>
              <option value="<?=$year;?>"><?=$year;?></option>
              <?php endfor; ?>
              </select>
              </div>


            <div class="col-sm-6">
              <div class="form-group">
            <label for="recipient-name" class="col-form-label">Month:</label>
            <select id="month" class="form-control  " name="month">
             
              <option value="1">January</option>
              <option value="2">February</option>
              <option value="3">March</option>
              <option value="4">April</option>
              <option value="5">May</option>
              <option value="6">June</option>
              <option value="7">July</option>
              <option value="8">August</option>
              <option value="9">September</option>
              <option value="10">October</option>
              <option value="11">November</option>
              <option value="12">December</option>>
            </select>
            </div>
          </div> 


          </div>

    
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Genearate Slip</button>
      </div>
    </form>
    </div>
  </div>
</div>

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


@stop

