@extends('layouts.app')

@section('title')
All Employees 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Employees</li>
      </ol>
@stop

@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Manage Employee Salary </h3>
                            {{--  <h3 style="text-align: right;" class="box-title m-b-0">
                                <a class="btn btn-info btn-sm" href="{{ route('employee.add') }}">Add Employee</a></h3> --}}
                             
                           <br>
                            
                            <div class="table-responsive">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>DESIGNATION </th>
                                            <th>Monthly Salary </th>
                                            
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                          $couter = 1;
                                        @endphp
                                         
                                         @if($HrmEmployees->count() > 0 )
                                    @foreach($HrmEmployees as $HrmEmployee ) 
                                        
                                        <tr>
                                            <td>{{$couter++}}</td>
                                             <td>{{$HrmEmployee->companyDetail ? $HrmEmployee->companyDetail->employee_code : ''}}</td> 
                                            <td>{{$HrmEmployee->name}}</td>
                                           <td>{{$HrmEmployee->companyDetail ? $HrmEmployee->companyDetail->designation : ''}}</td>
                                            
                                            <td>{{$HrmEmployee->companyDetail ? $HrmEmployee->companyDetail->monthly_salary : ''}}</td> 
                                        
                                         
                                            <td class="text-nowrap">
                                               
                                              {{--  <a href=""><div class="badge badge-success">Payslip</div></a>
                                                  &nbsp;&nbsp;&nbsp;
                                               <a href=""><div class="badge badge-success">Click To Paid</div></a> --}}

                                                    &nbsp;&nbsp;&nbsp;

                                                <a href="{{route('employeesetsalary.show',[$HrmEmployee->id])}} " data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                
                                              &nbsp;&nbsp;&nbsp;

                                               
                                            </td>
                                        </tr>
                                        @endforeach
                                        @endif

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>
@stop