@extends('layouts.app') 

@section('title') All Employees @stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
   <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
   <li class="active">All Employees</li>
</ol> 
@stop 

@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">

<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

<style>
table.dataTable thead .sorting_asc {
   background-image: none !important;
}

.table.dataTable,
table.dataTable {
   width: 99.8%!important;
}

#myTable tbody tr td {
   text-align: left;
}

#earning_parent_div .form-group {
   margin-bottom: 15px;
}

#deduction_parent_div .form-group {
   margin-bottom: 15px;
}

#earning_parent_div .form-control,
#deduction_parent_div .form-control {
   border: 0px solid black !important;
   border-bottom: 1px solid black !important;
   border-width: -12px solid black !important;
}

#earning_parent_div .btn-danger,
#deduction_parent_div .btn-danger {
   color: black;
   background: white;
   border-color: white;
}


.dataTables_wrapper .dataTables_info {
  
    margin-top: 6rem;
  }
  .dataTables_wrapper .dataTables_paginate {
    margin-top: 6rem;
}



.dataTables_wrapper .dataTables_paginate .paginate_button.current, .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: gray;
    color: #fff !important;
    white-space: nowrap;
    border-color: #d4af37;
  }

  .badge {
    text-transform: uppercase;
    font-weight: 600;
    padding: 7px 7px;
    font-size: 12px;
    margin-top: 1px;

    }

    .fa {
    font-size: 20px !important;
        } 

    .dropdown-menu {
    position: absolute;
    top: 100%;
    left: -10px;
    z-index: 1000;
    display: none;
    float: left;
    min-width: 82px;
    padding: 0px 0;
    margin: 0px 0 0;
    font-size: 12px;
    background: lightblue !important;
    
    }       
</style> 

@stop 

@section('content')
<div class="container-fluid">
   <!-- /row -->
   <div class="row">
      <div class="col-sm-12">
         <div class="white-box">
            <div class="pull-right"> </div>
            <h3 class="box-title">All Employees </h3>
            <h3 style="text-align: right;" class="box-title m-b-0">

               <a href="#" onclick="return GeneratePaySlip(this , '')">
                  <div class="btn btn-info btn-sm">Generate Payslip</div></a>
                 <a class="btn btn-info btn-sm" href="{{ route('employee.add') }}">Add Employee</a>
              </h3>
            <br>
            <br>
            <div class="table-responsive"> 
               @if(Session::has('success'))
               <div id="successMessage" class="alert alert-success" role="alert"> {{ Session::get('success') }} 
               </div> 
               @endif
               <div class="table-responsive">
                  <table id="myTableData" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                     <thead>
                        <tr class="table-secondary" role="row">
                           <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 100px;">#</th>
                           <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 100px;">Name</th>
                           <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 100px;">Designation </th>
                           <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 100px;">Phone Number </th>
                           <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 100px;">Status</th>
                           <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 100px;">Payroll</th>
                           <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending"  style="width: 100px;">Action</th>
                        </tr>
                     </thead>
                     <tbody> 

                        @php 

                        $couter = 1; 

                        $month =  Carbon\Carbon::now()->month;

                        @endphp 

                        @foreach($HrmEmployees as $HrmEmployee )
                        <tr>
                           <td>{{$couter++}}</td>
                           <td>{{$HrmEmployee->name}}</td>
                           <td>{{$HrmEmployee->company_detail ? $HrmEmployee->company_detail->designation->name : ''}}</td>
                           <td>{{$HrmEmployee->phone_no}}</td>
                           <td> 
                            
                            <div class="dropdown">
                            <button class="badge badge-success" type="button" id="about-us" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="background: #5ca526 !important;">
                              @if($HrmEmployee->status == 1)
                                Active
                                @elseif($HrmEmployee->status == 0)
                                <span style="color: red">Leave</span>
                                @elseif($HrmEmployee->status == 2)
                                <span style="color: red">Terminate</span>
                                @endif
                            <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="about-us">
                                @if($HrmEmployee->status != 1)
                                <li><a href="{{ route('status.update',['status'=>1,'id'=>$HrmEmployee->id])}}">Active</a></li>
                                @endif

                                @if($HrmEmployee->status != 0)
                                <li id="leave"><a href="{{ route('status.update',['status'=>0,'id'=>$HrmEmployee->id])}}">Leave</a></li>
                                @endif

                                @if($HrmEmployee->status != 2)
                                <li id="terminate"><a href="{{ route('status.update',['status'=>2,'id'=>$HrmEmployee->id,])}}">Terminate</a></li>
                                @endif
                            </ul>
                            </div>

                           <td>
                              <a href="{{route('employeesetsalary.show',[$HrmEmployee->id])}} ">
                                 <div class="badge badge-success"> Set Salary </div>
                              </a>
                           </td>
                           <td class="text-nowrap">
                              <a href="{{route('hrmemployee.detail',[$HrmEmployee->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a> &nbsp;
                              <a href="{{route('hrmemployee.edit',[$HrmEmployee->id]) }}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a> &nbsp;
                              <a href="{{ route('hrmemployee.delete',[$HrmEmployee->id] ) }}" data-toggle="tooltip" data-original-title="Delete" onclick="return confirm('Ary You Sure To delete?')"> <i class="fa fa-close text-danger"></i> </a>
                           </td>
                        </tr> 
                        @endforeach 

                     </tbody>
                  </table>
               </div>
            </div>
         </div>
      </div>
      <!-- /.row -->
   </div>
</div>
<!-- /.container-fluid -->
<div class="modal fade" id="generate_slip" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel"><strong>Generate PaySlip</strong></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</strong></span> </button>
         </div>{{-- {{route('hrmemployee-payslip.detail')}} --}}
         <div class="modal-body">

            <form method="post" action="{{route('earningdeduction-update')}}">
               {{csrf_field()}}

               
               
               <div class="row">
                  <div class="col-sm-4">
                     <div class="form-group">
                        <label for="recipient-name" class="col-form-label"><strong>Employee Name:</strong></label>
                        <select id="name" class="form-control" name="name" onchange="return changeemployeename()"> 

                           <option value="">Select Employee </option> 

                           @foreach($HrmEmployees as $HrmEmployeeList)
                           <option value="{{ $HrmEmployeeList->id }}">{{ $HrmEmployeeList->name }}</option> 
                           
                           @endforeach 
                        </select>

                     </div>
                  </div>
                  <div class="col-sm-4">
                     <label for="recipient-name" class="col-form-label"><strong>Year:</strong></label>
                     <select class="form-control" id="payslip_year" onchange="return changeemployeename()" name="year">
                        <?php
                        for ($year = (int)date('Y'); 1900 <= $year; $year--): ?>
                        <option value="<?=$year;?>">
                              <?=$year;?>
                        </option>
                        <?php endfor; ?>
                     </select>
                  </div>
                  <div class="col-sm-4">
                     <div class="form-group">
                        <label for="recipient-name" class="col-form-label"><strong>Month:</strong></label>
                        <select class="form-control" id="payslip_month" onchange="return changeemployeename()" name="month">
                           <option <?=( $month==1 ) ? 'selected' : '' ?> value="1">January</option>
                           <option <?=( $month==2 ) ? 'selected' : '' ?> value="2">February</option>
                           <option <?=( $month==3 ) ? 'selected' : '' ?> value="3">March</option>
                           <option <?=( $month==4 ) ? 'selected' : '' ?> value="4">April</option>
                           <option <?=( $month==5 ) ? 'selected' : '' ?> value="5">May</option>
                           <option <?=( $month==6 ) ? 'selected' : '' ?> value="6">June</option>
                           <option <?=( $month==7 ) ? 'selected' : '' ?> value="7">July</option>
                           <option <?=( $month==8 ) ? 'selected' : '' ?> value="8">August</option>
                           <option <?=( $month==9 ) ? 'selected' : '' ?> value="9">September</option>
                           <option <?=( $month==10) ? 'selected' : '' ?> value="10">October</option>
                           <option <?=( $month==11) ? 'selected' : '' ?> value="11">November</option>
                           <option <?=( $month==12) ? 'selected' : '' ?> value="12">December</option>
                        </select>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <input type="hidden" name="loan_id" id="loan_id">
                  <div class="col-lg-6" style="border-right: 1px solid black;">
                     <p style="text-align: center; border-image: 2px;"><strong>Allowances </strong></p>
                     <hr>
                     <div class="row">
                        <div class="col-sm-5 text-cent">
                           <label for="message-text" class="col-form-label"><strong>Title:</strong></label>
                        </div>
                        <div class="col-sm-5">
                           <label for="message-text" class="col-form-label"><strong>Amount:</strong></label>
                        </div>
                        <div class="col-sm-2">
                           <div class="form-group" style="margin-bottom: 0;">
                              <button type="button" onclick="return addNewRow(this)" class="btn btn-primary">+</button>
                           </div>
                        </div>
                     </div>

                     <div id="earning_parent_div">
                        
                     </div>
                  
                  </div>

                  <div class="col-lg-6">
                     
                     <p style="text-align: center;"><strong>Deductions</strong> </p>
                     <hr>
                     <div class="row">
                        <div class="col-sm-5 text-cent">
                           <label for="message-text" class="col-form-label"><strong>Title:</strong></label>
                        </div>
                        <div class="col-sm-5">
                           <label for="message-text" class="col-form-label"><strong>Amount:</strong></label>
                        </div>
                        <div class="col-sm-2">
                           <div class="form-group" style="margin-bottom: 0;">
                              <button type="button" onclick="return addNewRowToDeduction(this)" class="btn btn-primary">+</button>
                           </div>
                        </div>
                     </div>
                     
                     <div id="deduction_parent_div">
                        
                     </div>
                  
                  </div>
               </div>
               <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  <button type="submit" class="btn btn-primary">Save</button>
               </div>
         </div>
      </div>
      </form>
   </div>
</div>
</div>

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTableData').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>
    <script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
        function GeneratePaySlip(self , id) 
        {
           
            $('#employee_id').val(id)
            $('#loan_id').val(id)

            $('#generate_slip').modal('show');
        }


   function addNewRow(self)
   {

      $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
   });

  $.ajax({
    url:"{{ route('earningdeduction.getByAjax') }}",
    method:'POST',
    dataType:'json',
    data: {type : 'earning'},
    success:function(data)
    {
      if (data.response == 'yes')
      {
        var select = '';

          select += '<select class="form-control" name="earning_title[]">';
          $.each(data.output, function (key, val) {

            select +='<option value="'+val.name+'">'+val.name+' </option>';
          
          });

          select += '</select>';

    $('#earning_parent_div').prepend('<div class="row"><div class="col-sm-5"><div class="form-group">'+select+'</div></div><div class="col-sm-5"><div class="form-group"> <input type="Number" class="form-control" name="earning_amount[]" value="" id="exampleInputuname" placeholder=" Amount"></div></div><div class="col-sm-2"><div class="form-group" style=""><button onclick="return delete_row(this)" type="button" class="btn btn-danger">x</button></div></div></div>');

      }
    }

  })

    return false;
  }

  function addNewRowToDeduction(self)
   {

      $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
   });

  $.ajax({
    url:"{{ route('earningdeduction.getByAjax') }}",
    method:'POST',
    dataType:'json',
    data: {type : 'deduction'},
    success:function(data)
    {
      if (data.response == 'yes')
      {
        var select = '';

          select += '<select class="form-control" name="deduction_title[]">';
          $.each(data.output, function (key, val) {

            select +='<option value="'+val.name+'">'+val.name+' </option>';
          
          });

          select += '</select>';

    $('#deduction_parent_div').prepend('<div class="row"><div class="col-sm-5"><div class="form-group">'+select+'</div></div><div class="col-sm-5"><div class="form-group"> <input type="Number" class="form-control" name="deduction_amount[]" value="" id="exampleInputuname" placeholder=" Amount"></div></div><div class="col-sm-2"><div class="form-group" style=""><button onclick="return delete_row(this)" type="button" class="btn btn-danger">x</button></div></div></div>');

      }
    }

  })

    return false;
  }


  function delete_row(self)
   {
    $(self).closest('.row').remove();

    return false;
  }

  function deduction_delete_row(self) {
     $(self).closest('.row').remove();

    return false;
  }



function changeemployeename (self){

  var loan_type = $('#type').val();
  if (loan_type == undefined) {
    loan_type = "Select Type"
  }
  var tax = $('#tax').val();

  var employee_id = $('#name').val();
 
  var payslip_year = $('#payslip_year').val();
 
  var payslip_month = $('#payslip_month').val();

$("#earning_parent_div").empty();

  $("#deduction_parent_div").empty();

  $('#employee_id').val(employee_id)

  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  $.ajax({
    url:"{{ route('earningdeduction.show') }}",
    method:'POST',
    dataType:'json',
    data: {
      employee_id: employee_id,
      payslip_year: payslip_year,
      payslip_month: payslip_month,
      loan_type: loan_type 

   },
    success:function(data)
    {

      if(data.response == 'yes')
      {

         $("#earning_parent_div").empty();
         $('#deduction_parent_div').empty(); 
         
         $('#earning_parent_div').append(' <div class="row"><div class="col-sm-5"><div class="form-group"><input type="text" class="form-control" readonly name="earning_title[]" value="Monthly Salary" id="exampleInputuname" placeholder=" Title"></div></div><div class="col-sm-5"><div class="form-group"> <input type="Number" class="form-control" name="earning_amount[]" readonly value="' + data.monthly_salary +'" id="exampleInputuname" placeholder=" Amount"></div></div></div> ');

         

         $('#deduction_parent_div').append(' <div class="row"><div class="col-sm-5"><select class="form-control chosen-select" name="type" id="type" onchange="return changeemployeename()" required="true"><option value="'+loan_type+'">'+loan_type+'</option><option value="Loan | Advance">Loan | Advance</option><option value="Loan">Loan</option><option value="Advance">Advance </option></select></div><div class="col-sm-5"><div class="form-group"><input type="Number" class="form-control" name="loan" value="' + data.remaning_loan +'" id="exampleInputuname" placeholder=" Amount"></div></div></div><div class="row"><div class="col-sm-5"><div class="form-group"><input type="text" class="form-control" readonly name="deduction_title[]" value="Tax" id="tax" placeholder=" Title"></div></div><div class="col-sm-5"><div class="form-group"> <input type="Number" class="form-control" name="deduction_amount[]" value="' + data.tax +'" id="exampleInputuname" placeholder=" Amount"></div></div></div> <div class="row"><div class="col-sm-5"><div class="form-group"><input type="text" class="form-control" readonly name="deduction_title[]" value="Late Fine" id="exampleInputuname" placeholder=" Title"></div></div><div class="col-sm-5"><div class="form-group"> <input type="Number" class="form-control" name="deduction_amount[]" value="' + data.late_fine +'" id="exampleInputuname" placeholder=" Amount"></div></div></div><div class="row"><div class="col-sm-5"><div class="form-group"><input type="text" class="form-control" name="deduction_title[]" readonly value="Absent Fine" id="exampleInputuname" placeholder=" Title"></div></div><div class="col-sm-5"><div class="form-group"> <input type="Number" class="form-control" name="deduction_amount[]" value="' + data.absent_fine +'" id="exampleInputuname" placeholder=" Amount"></div></div></div> ');

         if(data.earning != null)
         {

            //loop from 0 index to max index
            for(var i = 0; i < data.earning.length; i++) {

               $('#earning_parent_div').append(' <div class="row"><div class="col-sm-5"><div class="form-group"><input type="text" class="form-control"  name="earning_title[]" value="' + data.earning[i].allownace_title+'" id="exampleInputuname" placeholder=" Title" readonly></div></div><div class="col-sm-5"><div class="form-group"> <input type="Number" class="form-control" name="earning_amount[]" value="' + data.earning[i].allownace_amount+'" id="exampleInputuname" placeholder=" Amount"></div></div><div class="col-sm-2"><div class="form-group" style=""><button onclick="return delete_row(this)" type="button"  class="btn btn-danger">x</button></div></div></div>');

            }
        
        }
        else
        {
            /*$("#earning_parent_div").empty();*/
            $('#earning_parent_div').append('<p>No Earnings</p>');
        }

        if(data.deduction != null)
        {

            //loop from 0 index to max index
            for(var i = 0; i < data.deduction.length; i++) {

               $('#deduction_parent_div').append(' <div class="row"><div class="col-sm-5"><div class="form-group"><input type="text" class="form-control" name="deduction_title[]" value="' + data.deduction[i].deduction_title+'" id="exampleInputuname" placeholder=" Title" readonly></div></div><div class="col-sm-5"><div class="form-group"> <input type="Number" class="form-control" name="deduction_amount[]" value="' + data.deduction[i].deduction_amount+'" id="exampleInputuname" placeholder=" Amount"></div></div><div class="col-sm-2"><div class="form-group" ><button onclick="return delete_row(this)" type="button"  class="btn btn-danger">x</button></div></div></div>');

            }

         }
         else 
         {
            /*$("#deduction_parent_div").empty();*/
            $('#deduction_parent_div').append('<p>No Deductions</p>');
         }
  
      }
      else if(data.response == 'no')
      {
      
         $("#earning_parent_div").empty();
         $('#earning_parent_div').append('<p>No Earnings</p>');

         $("#deduction_parent_div").empty();
         $('#deduction_parent_div').append('<p>No Deductions</p>');
      
      }
      else
      {
         alert('Something Went wrong!');
         location.reload(true);
      }

    }

  })


}

$( function() {
  $('badge-success').click( function() {
    $(this).css('background', '#aaa')
  } );
} );

</script>

@stop

