@extends('layouts.app')
@section('title')
Hrm Dashboard
@stop
@section('breadcrumb')
	<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Hrm Dashboard</li>
    </ol>
@stop
@section('css')
<style type="text/css">
	.table-bordered, .table>
  tbody>
  tr>
  td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th, .table>thead>tr>td, .table>thead>tr>th {
    border: 1px solid #000000;
}

.fa {
     font-size: 20px !important;

    }
</style>  
@stop
@section('content')
            <!-- ===== Page-Container ===== -->
            <div class="container-fluid">
                <div class="row colorbox-group-widget">
                    <div class="col-md-4 col-sm-4 info-color-box">
                        <div class="white-box">
                            <div class="media bg-primary">
                                <div class="media-body">
                                    <h3 class="info-count info-text font-12">Total Employees<span class="pull-right" style="font-size: 20px;"><i class="icon-user-follow fa-fw marked-circle-outline"></i></span></h3>
                                    <p style="font-size: 25px;">{{$all_employees}}</p>    
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-4 info-color-box">
                        <div class="white-box">
                            <div class="media bg-success">
                                <div class="media-body">
                                    <h3 class="info-count info-text font-12">Total Departments <span class="pull-right" style="font-size: 20px;"><i class="mdi mdi-comment-text-outline"></i></span></h3>
                                    <p style="font-size: 25px;">{{$total_departments}}</p>
                                    <p class="info-ot font-15"><span></span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                      <div class="col-md-4 col-sm-4 info-color-box">
                        <div class="white-box">
                            <div class="media bg-danger">
                                <div class="media-body">
                                    <h3 class="info-count info-text font-12">Total Employees {{date("F", mktime(0, 0, 0, $month))}} <span class="pull-right" style="font-size: 20px;"><i class="mdi mdi-comment-text-outline"></i></span></h3>
                                    <p style="font-size: 25px;">{{$current_month_employees}}</p>
                                    <p class="info-ot font-15"><span></span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
          <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right"> </div>
                    <h3 class="box-title">Recently Added Employees </h3>
                    <h3 style="text-align: right;" class="box-title m-b-0">
                     <a class="btn btn-info btn-sm" href="{{ route('employee.add') }}">Add New Employee</a>
                    </h3>
                    <br>
            <div class="table-responsive"> 
               @if(Session::has('success'))
               <div id="successMessage" class="alert alert-success" role="alert"> {{ Session::get('success') }} 
               </div> 
               @endif
               <div class="table-responsive">
                  <table id="myTableData" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                     <thead>
                        <tr lass="table-secondary" role="row">
                           <th>#</th>
                           <th>Name</th>
                           <th>Designation </th>
                           <th>Phone Number </th>
                           <th>Action</th>
                        </tr>
                     </thead>
                     <tbody> 
                        @php 

                        $couter = 1; 

                        @endphp 

                        @foreach($HrmEmployees as $HrmEmployee )
                        <tr>
                           <td>{{$couter++}}</td>
                           <td>{{$HrmEmployee->name}}</td>
                           <td>{{$HrmEmployee->company_detail->designation ? $HrmEmployee->company_detail->designation->name : ''}}</td>
                           <td>{{$HrmEmployee->phone_no}}</td>
                           
                           <td class="text-nowrap">
                              <a href="{{route('hrmemployee.detail',[$HrmEmployee->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a> &nbsp;
                              <a href="{{route('hrmemployee.edit',[$HrmEmployee->id]) }}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a> &nbsp;
                              <a href="{{ route('hrmemployee.delete',[$HrmEmployee->id] ) }}" data-toggle="tooltip" data-original-title="Delete" onclick="return confirm('Ary You Sure To delete?')"> <i class="fa fa-close text-danger"></i> </a>
                           </td>
                        </tr> 
                        @endforeach 
                     </tbody>
                  </table>
               </div>
            </div>
           </div>
       </div>
   </div>  
 

 </div>

@stop