@extends('layouts.app')

 @section('title') All Employees

  @stop 
  @section('breadcrumb') 

  <ol class="breadcrumb pull-right no-print">
  <li>
    <a href="{{route('home')}}">
      <i class="fa fa-dashboard"></i> Home </a>
  </li>
  <li class="active">All Employees</li>
</ol>
 @stop 
 @section('css')
<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">
<style>

@media print 
{
  @page {
  size: <%= @size_card[2] %>cm  <%= @size_card[3] %>cm;
  margin: 0;
}
.bf{
  position: fixed;
  text-align: justify;
}
}  table.dataTable thead .sorting_asc {
    background-image: none !important;
  }

  .table.dataTable,
  table.dataTable {
    width: 99.8% !important;
  }

  .row,
  h3 {
    font-family: Century Gothic !important;
  }

  .font-size {
    font-size: 16px;
  }

  h3 {
    min-inline-size: max-content;
  }

  .white-box .box-title {
    margin-top: 0;
    margin-bottom: 0;
    margin-left: 10px;
  }

  p {
    color: black;
    margin-bottom: 0;
  }

  .p-bg,
  .td-bg {
    background-color: #F0F0F0;
  }
</style>
 @stop
  @section('content') 
  <div class="container bg-white" id="printableSection">
  <!--Muhammad Ibrahim Code-->
  <!-- <a class="btn btn-warning avoid-this" id="print" href="#">Print</a> -->
  <!--Apartment Booking Agreement code starts here-->
  <br>
  <div class="row">
    <div class="col-sm-12 col-xs-12" style="text-align: right;">
      @if($already_exist == 0)
        <div id="successMessage" style="text-align: left;" class="alert alert-success" role="alert"> 
        Payslip Already Generated 
        </div> 
        @endif

      <p>
        <strong>PAYSTATEMENT</strong>
      </p>
      <p>
        <strong>{{date('F', mktime(0, 0, 0, $month))}} {{$year}}</strong>
      </p>
      <button class="btn btn-info btn-sm avoid-this" id="print" style="float: left; font-size: 18px;">Print</button>
    </div>
  </div>
  <br>
  <br>
  <br>
  <div class="row">
    <div class="col-xs-4">
      <strong><p>Employee:</p></strong>
      <p class="p-bg">{{$HrmEmployees->name}}</p>
      <br>
      <strong><p>Project Name:</p></strong>
      <p class="p-bg">FGI INVESTMENT </p>
      <br>
      <strong><p>Department:</p></strong>
      <p class="p-bg">{{$HrmEmployeeDepartmentAndCity->department ? $HrmEmployeeDepartmentAndCity->department->department_name : ''}}</p>
      {{-- companyDetail','accountDetail','docunmentDetail','earningDeduction --}}
      <br>
      <strong><p>Bank Name:</p></strong>
      <p class="p-bg">{{$HrmEmployees->account_detail ? $HrmEmployees->account_detail->bank_name: ''}}</p>
      <br>
    </div>
    <div class="col-xs-4">
      <strong><p>Employee ID:</p></strong>
      <p class="p-bg">{{$HrmEmployees->company_detail ? $HrmEmployees->company_detail->employee_code: '' }}</p>
      <br>
      <strong><p>Designation:</p></strong>
      <p class="p-bg">{{$HrmEmployees->company_detail->designation ? $HrmEmployees->company_detail->designation->name : ''}}</p>
      <br>
      <strong><p>City:</p></strong>
      <p class="p-bg">{{$HrmEmployeeDepartmentAndCity ? $HrmEmployeeDepartmentAndCity->city->name : ''}}</p>
      <br>
      <strong><p>Bank Account:</p></strong>
      <p class="p-bg">{{$HrmEmployees->account_detail ? $HrmEmployees->account_detail->account_no : ''}}</p>
      <br>
    </div>
    <div class="col-xs-4">
      <strong><p>Employment Type:</p></strong>
      <p class="p-bg">{{$HrmEmployees->company_detail ? $HrmEmployees->company_detail->contract_type : ''}}</p>
      <br>
      <strong><p>Date of Joining:</p></strong>
      <p class="p-bg">{{date('d-F-Y',strtotime($HrmEmployees->company_detail ? $HrmEmployees->company_detail->date_of_joining : ''))}}</p>
      <br>
      <strong><p>CNIC:</p></strong>
      <p class="p-bg">{{$HrmEmployees->cnic}}</p>
      <br>
      <strong><p>Service Period:</p></strong> 
      <?php
        $date1 =  date('Y-m-d',strtotime($HrmEmployees->company_detail ? $HrmEmployees->company_detail->date_of_joining : ''));
        $date2 = date('Y-m-d');

        $diff = abs(strtotime($date2) - strtotime($date1));

        $years = floor($diff / (365*60*60*24));
        $months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
        $days = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));       
      ?>
       <p class="p-bg"> <?php printf("%d years(s), %d month(s), %d day(s)\n", $years, $months, $days); ?> </p>
      <br>
    </div>
  </div>
  <br>
  <div class="row">
    <div class="col-xs-6">
      <p>
        <strong>Earnings</strong>
      </p>
      <div style="padding: 0 10px;" style="text-align: justify;">
        <div class="row" style="border: 1px solid black;"> 
            @php 

           $total_earning = 0;
             @endphp
        
              @foreach($hrm_employee_earning as $list)
                  <div class="col-xs-6" style="text-align:left;">
                  <p>{{$list->title}}</p>
                  </div>

                  <div class="col-xs-6" style="text-align:right;">
                  <p>{{number_format($list->amount , 2)}}</p>
                  </div>
           @php 
             $total_earning += $list->amount; 
          @endphp
              @endforeach
        </div>
        
        <p style="display:inline; ">
          <strong>Total Earnings</strong>
        </p>

        <p style="display: inline; float:right;">
          <strong>{{number_format($total_earning , 2)}}</strong>
        </p>
        <br>

         
      </div>
      <div class="col-xs-12" class="bf">
      <p>
        <strong>Benevolent Fund</strong>
      </p>
      <div style="font-size: 11px">
        <div class="row" style="border: 1px solid black;"> 
           
                  <div class="col-xs-6" style="float:left;">
                  <p>Employee B.f contribution till date: </p>
                  </div>

                  <div class="col-xs-6">
                  <p style="float: right;">{{number_format($total_benevolent_found - $employee_benevolent_found,2)}}</p>
                  </div>


                  <div class="col-xs-6" style="float:left;">
                  <p>Employeer B.f contribution: </p>
                  </div>
                  
                  <div class="col-xs-6" >
                  <p style="float: right;">{{number_format($employee_benevolent_found,2)}}</p>
                  </div>
                  <div class="col-xs-6" style="float:left;">
                  <p>Employeer B.f contribution till date: </p>
                  </div>
                  
                  <div class="col-xs-6" >
                  <p style="float: right;"> {{number_format($total_benevolent_found,2)}}</p>
                  </div>
          
        </div> 
      </div>
    </div> 
    </div>
    <div class="col-xs-6" style="text-align: justify;">
      <p>
        <strong>Deductions</strong>
      </p>
      <div style="padding: 0 10px;">
        <div class="row" style="border: 1px solid black;">
         @php $total_deduction = 0;
          @endphp
          <div class="col-xs-6" style="text-align:left;">
            <p>{{$type}}</p>
          </div>
          <div class="col-xs-6" style="text-align:right;">
            <p>{{number_format($HrmEmployeeLoan , 2)}}</p>
          </div>
          <div class="col-xs-6" style="text-align:left;">
            <p>Tax</p>
          </div>
          <div class="col-xs-6" style="text-align:right;">
            <p>{{number_format($total_tax_amount , 2)}}</p>
          </div>
          <div class="col-xs-6" style="text-align:left;">
            <p>Employee Bf contribution</p>
          </div>
          <div class="col-xs-6" style="text-align:right;">
            <p>{{number_format($employee_benevolent_found , 2)}}</p>
          </div>
          
           @foreach($hrm_employee_deduction as $list) 
          <div class="col-xs-6" style="text-align:left;">
            <p>{{$list->title}}</p>
          </div>
          <div class="col-xs-6" style="text-align:right;">
            <p>{{number_format($list->amount , 2)}}</p>
          </div>
           @php 
            $total_deduction += $list->amount; 
           @endphp 
           @endforeach
        </div>
        @php
        /*+ $late_fine + $total_absent_fine*/
         $total_deduction = $total_deduction;
        @endphp
        <p style="display:inline; ">
          <strong>Total Deductions</strong>
        </p>
        <p style="display: inline; float:right;">
          <strong>{{ number_format($total_deduction + $total_tax_amount + $employee_benevolent_found + $HrmEmployeeLoan, 2 )}}</strong>
        </p>
      </div>
    </div>
  </div>
  <br>
  <div class="row">
    <div class="col-xs-12">
      <p>
        {{-- <strong>Net Salary</strong> --}}
      </p>
      <div style="padding: 0 10px;">
        <div class="row" style="border: 1px solid black;">
          <div class="col-xs-6" style="text-align:left;">
            <strong>Total Net Salary</strong>
          </div>
          <div class="col-xs-6" style="text-align:right;">
            <strong>{{number_format( $total_earning - ($total_deduction + $total_tax_amount + $employee_benevolent_found + $HrmEmployeeLoan) , 2 )}}</strong> 
          </div>
        </div>
       
      </div>
    </div>
  </div>
  <br>
  <div class="row">
    <div class="col-xs-12">
      <p>
        <strong>Income Tax</strong>
      </p>
      <table style="width: 100%; margin-top: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table no-spacing" role="grid">
        <tbody>
          <tr>
            <td class="td-bg">
             <strong><center>Taxable Income</center></strong> 
            </td>
            <td class="td-bg">
              <strong><center>Tax Slab</center></strong>
            </td>
            <td class="td-bg">
              <strong><center>Tax Chargeable</center></strong>
            </td>
            <td class="td-bg">
              <strong><center>Tax Credit | Ad</center></strong>
            </td>
            <td class="td-bg">
              <strong><center>Tax Deducted</center></strong>
            </td>
            <td class="td-bg">
              <strong><center>Tax Payable</center></strong>
            </td>
          </tr>
          <tr>
            <td>
              <center>{{number_format($total_earning * 12 , 2)}}</center>
            </td>
            <td>
              <center>{{$tax_slab }}</center>
            </td>
            <td>
              <center >{{number_format($total_tax_amount * 12)}}</center>
            </td>
            <td>
              <center> <input type="number" value="0" onfocusout="changeTaxPayable(this)" style="border: none; background: none;" name=""></center>
            </td>
            <td>
              <center >{{number_format($totalfind * $total_tax_amount)}}</center>
            </td>
            <td>
              <center >
                <input type="hidden" value="{{  ($total_tax_amount * 12 ) - ($totalfind * $total_tax_amount) }}" id="tax_pay">
              <span id="total_payable">{{ number_format( ($total_tax_amount * 12 ) - ($totalfind * $total_tax_amount), 2 ) }}</span>
            </center>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
  <!--Muhammad Ibrahim Material Issue Requisition code ends here-->
  <!--Muhammad Ibrahim Code Ends Here-->
</div>
<!-- /.container-fluid --> 
@stop 
@section('js')
 <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>
<script>

  function changeTaxPayable(self)
  {
 var tax_pay = $('#tax_pay').val();
 $('#total_payable').html(parseInt(tax_pay) + parseInt($(self).val())  )
  }
</script> 
@stop