@extends('layouts.app')
@section('title')
    All Employees
@stop


@section('css')
    <style type="text/css">
        .first-div {
            background-color: whitesmoke;
            border: 5px;
            border-radius: 10px;
        }

        .row {
            margin-right: 0px !important;
            margin-left: 0px !important;
        }



        .fa {
            font-size: 20px !important;

        }

        .btn-primary {
            zoom: 1.1;
        }

    </style>
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right no-print">
        <li>
            <a href="{{ route('home') }}">
                <i class="fa fa-dashboard"></i> Home </a>
        </li>
        <li class="active">Employees Set Salary</li>
    </ol>
@stop
@section('css')
    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">
    <style>
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }

    </style>
@stop
@section('content')
    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title"> Set Salary </h3>
                    <br>
                    @if (Session::has('success'))
                        <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                        </div>
                    @endif
                    <div class="row">
                        <div class="col-lg-12 first-div">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <h3 style="color: black">{{ $HrmEmployees->name }}</h3>
                                        </div>
                                        <div class="col-sm-6">

                                        </div>
                                    </div>
                                    <hr>
                                </div>
                                <div class="card-body">
                                    <table class="table ">
                                        <tr>
                                            <th>Employee ID</th>
                                            <th>Designation</th>
                                            <th>Salary</th>

                                        </tr>
                                        <tr>
                                            <td>{{ $HrmEmployees->company_detail ? $HrmEmployees->company_detail->employee_code : '' }}
                                            </td>
                                            <td>{{ $HrmEmployees->company_detail ? $HrmEmployees->company_detail->designation->name : '' }}
                                            </td>
                                            <td>{{ number_format($HrmEmployees->company_detail ? $HrmEmployees->company_detail->monthly_salary : '', 2) }}
                                                <button type="button" class="btn btn-primary"
                                                    style="border: none;color: black;background: none;" data-toggle="modal"
                                                    data-target="#exampleModal" data-whatever="@mdo"><i
                                                        class="fa fa-pencil" aria-hidden="true"></i></button>
                                            </td>

                                            <td></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>


                        <br>
                        <br>
                        <br>

                        <div class="col-lg-12 first-div" style="margin-top: 5rem">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <h3 style="color: black"> Allowances </h3>
                                        </div>
                                        <div class="col-sm-6">
                                            <h1 style="float: right;">
                                                <button type="button" class="btn btn-primary" data-toggle="modal"
                                                    data-target="#Allowance" data-whatever="@mdo">+</button>
                                                <h1>
                                        </div>
                                    </div>
                                    <hr>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Title </th>
                                                    <th>Amount </th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($HrmEmployeesallownces as $HrmEmployeesallownce)
                                                    <tr>

                                                        <td>{{ $HrmEmployeesallownce->allownace_title }}</td>
                                                        <td>{{ number_format($HrmEmployeesallownce->allownace_amount, 2) }}
                                                        </td>
                                                        <td class="text-nowrap">
                                                            <a href="#"
                                                                onclick="return editEarning(this , '{{ $HrmEmployeesallownce->id }}')"
                                                                data-original-title="Edit">
                                                                <i class="fa fa-pencil"></i>
                                                            </a>

                                                            &nbsp;&nbsp;&nbsp;
                                                            <a href="{{ route('hrmemployeeallownce.delete', [$HrmEmployeesallownce->id]) }}"
                                                                data-toggle="tooltip" data-original-title="Delete"
                                                                onclick="return confirm('Ary You Sure To delete?')">
                                                                <i class="fa fa-close text-danger"></i>
                                                            </a>


                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="col-md-12 first-div" style="margin-top: 5rem;">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <h3 style="color: black"> Deduction</h3>
                                        </div>
                                        <div class="col-sm-6">
                                            <h1 style="float: right;">
                                                <button type="button" class="btn btn-primary" data-toggle="modal"
                                                    data-target="#deduction" data-whatever="@mdo">+</button>
                                                <h1>
                                        </div>
                                    </div>
                                    <hr>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>

                                                    <th>Title </th>
                                                    <th>Amount </th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                @foreach ($HrmEmployeesdeductions as $HrmEmployeesdeduction)
                                                    <tr>

                                                        <td>{{ $HrmEmployeesdeduction->deduction_title }}</td>
                                                        <td>{{ number_format($HrmEmployeesdeduction->deduction_amount, 2) }}
                                                        </td>
                                                        <td class="text-nowrap">

                                                            <a href="#"
                                                                onclick="return editDeduction(this , '{{ $HrmEmployeesdeduction->id }}')"
                                                                data-original-title="Edit">
                                                                <i class="fa fa-pencil"></i>
                                                            </a>

                                                            &nbsp;&nbsp;&nbsp;

                                                            <a href="{{ route('hrmemployeededuction.delete', [$HrmEmployeesdeduction->id]) }}"
                                                                data-toggle="tooltip" data-original-title="Delete"
                                                                onclick="return confirm('Ary You Sure To delete?')">
                                                                <i class="fa fa-close text-danger"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                    <br>
                    <br>
                    <br>

                </div>
            </div>
        </div>
    </div>





    <!----------modals------------------>




    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Employee Salary</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST"
                        action="{{ route('hrmemployeesalary.update', ['id' => $HrmEmployees->company_detail->id]) }}">
                        {{ csrf_field() }}
                        <div class="form-group">
                            <label for="message-text" class="col-form-label">Salary:</label>
                            <input type="number" class="form-control" name="salary"
                                value="{{ $HrmEmployees->company_detail->monthly_salary }}" id="exampleInputuname"
                                placeholder="Enter salary">
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" value="">Save change</button>
                </div>
                </form>
            </div>
        </div>
    </div>
    {{-- for Allowance --}}
    <div class="modal fade" id="Allowance" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Allowances</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('employeesalary.add') }}">
                        {{ csrf_field() }}
                        <input type="hidden" name="employee_id" value="{{ $HrmEmployees->id }}">
                        <div class="row" id="parent_div">


                            <div class="col-sm-5">
                                <div class="form-group">
                                    <label>Select Allowance <span style="color: red;">*</span> </label>

                                    <select class="form-control select" name="title[]" id="exampleInputuname">

                                        <option value="">Select Allowance </option>
                                        @foreach ($hrmAllowncesTitle as $Title)
                                            <option value="{{ $Title->name }}">{{ $Title->name }}</option>
                                        @endforeach

                                    </select>
                                    {{-- <label for="message-text" class="col-form-label"> Title:</label>
                                    <input type="text" class="form-control" name="title[]" value="{{old('title')}}" id="exampleInputuname" placeholder=" Title"> --}}
                                </div>

                            </div>


                            <div class="col-sm-5">

                                <div class="form-group">
                                    <label for="message-text" class="col-form-label"> Amount:</label>
                                    <input type="Number" class="form-control" name="amount[]"
                                        value="{{ old('amount') }}" id="exampleInputuname" placeholder=" Amount">
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group" style="margin-top: 2.5rem;">
                                    <button type="button" onclick="return addNewRow(this)"
                                        class="btn btn-primary">+</button>
                                </div>
                            </div>


                        </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save change</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    {{-- edit earning --}}
    <div class="modal fade" id="Allowanceedit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabeledit">Allowances</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('employee_earning.update') }}">
                        {{ csrf_field() }}
                        <input type="hidden" name="record_id" id="record_id" value="">


                        <div class="row">


                            <div class="col-sm-6">
                                <div class="form-group">

                                    <label>Select Allowance <span style="color: red;">*</span> </label>
                                    <select class="form-control select" name="title" id="earning_title">
                                        @foreach ($hrmAllowncesTitle as $Title)
                                            <option value="{{ $Title->name }}">{{ $Title->name }}</option>
                                        @endforeach

                                    </select>

                                    {{-- <label for="message-text" class="col-form-label"> Title:</label>
                                     <input type="text" class="form-control" name="title" value="" id="earning_title" placeholder=" Title"> --}}
                                </div>

                            </div>


                            <div class="col-sm-6">

                                <div class="form-group">
                                    <label for="message-text" class="col-form-label"> Amount:</label>
                                    <input type="Number" class="form-control" name="amount" value="" id="earning_amount"
                                        placeholder=" Amount">
                                </div>
                            </div>




                        </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save Update </button>
                </div>
                </form>
            </div>
        </div>
    </div>




    {{-- edit deduction --}}
    <div class="modal fade" id="deduction_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabeledit">Deduction</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('employee_deduction.update') }}">
                        {{ csrf_field() }}
                        <input type="hidden" name="record_deduction_id" id="record_deduction_id" value="">

                        <div class="row">


                            <div class="col-sm-6">
                                <div class="form-group">

                                    <label>Select Deduction <span style="color: red;">*</span> </label>
                                    <select class="form-control select" name="title" id="deduction_title">

                                        @foreach ($hrmDeductionTitle as $Title)
                                            <option value="{{ $Title->name }}">{{ $Title->name }}</option>
                                        @endforeach

                                    </select>

                                    {{-- <label for="message-text" class="col-form-label"> Title:</label>
                                    <input type="text" class="form-control" name="title" value="" id="deduction_title" placeholder=" Title"> --}}
                                </div>

                            </div>


                            <div class="col-sm-6">

                                <div class="form-group">
                                    <label for="message-text" class="col-form-label"> Amount:</label>
                                    <input type="Number" class="form-control" name="amount" value=""
                                        id="deduction_amount" placeholder=" Amount">
                                </div>
                            </div>




                        </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save Update </button>
                </div>
                </form>
            </div>
        </div>
    </div>


    {{-- Saturation Deduction --}}
    <div class="modal fade" id="deduction" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> Deduction</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('employeededuction.add') }}">
                        {{ csrf_field() }}
                        <input type="hidden" name="employee_id" value="{{ $HrmEmployees->id }}">


                        <div class="row" id="deduction_parent_div">


                            <div class="col-sm-5">
                                <div class="form-group">
                                    <label>Select Deduction <span style="color: red;">*</span> </label>
                                    <select class="form-control select" name="title[]" id="deduction_title">
                                        <option value="">Select Deduction </option>
                                        @foreach ($hrmDeductionTitle as $Title)
                                            <option value="{{ $Title->name }}">{{ $Title->name }}</option>
                                        @endforeach

                                    </select>
                                </div>

                            </div>


                            <div class="col-sm-5">

                                <div class="form-group">
                                    <label for="message-text" class="col-form-label"> Amount:</label>
                                    <input type="Number" class="form-control" name="amount[]"
                                        value="{{ old('amount') }}" id="exampleInputuname" placeholder=" Amount">
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group" style="margin-top: 2.5rem;">
                                    <button type="button" onclick="return addNewRowToDeduction(this)"
                                        class="btn btn-primary">+</button>
                                </div>
                            </div>



                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save change</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


@stop
@section('js')
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>
    <script>
        function editEarning(self, id) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('get_earning') }}",
                method: 'POST',
                dataType: 'json',
                data: {
                    id: id
                },
                success: function(data) {
                    if (data.response == 'yes') {
                        $('#earning_amount').val(data.amount)
                        $('#earning_title').val(data.title)
                        $('#record_id').val(data.id)
                        $('#Allowanceedit').modal('show')
                    }

                }
            })
        }

        function editDeduction(self, id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('get_deduction') }}",
                method: 'POST',
                dataType: 'json',
                data: {
                    id: id
                },
                success: function(data) {
                    if (data.response == 'yes') {
                        $('#deduction_amount').val(data.amount)
                        $('#deduction_title').val(data.title)
                        $('#record_deduction_id').val(data.id)
                        $('#deduction_edit').modal('show')
                    }

                }
            })
        }


        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'dom': 'Bfrtip',
                'buttons': ['copy', 'csv', 'excel', 'pdf', 'print']
            });
        });


        function addNewRow(self)

        {

            $('#parent_div').append(
                @foreach ($hrmAllowncesTitle as $Title)
                    <option value="{{ $Title->name }}">{{ $Title->name }}</option>
                @endforeach < /select></div > <
                /div><div class="col-sm-5"><div class="form-group"> <label for="message-text" class="col-form-label"> Amount:</label >
                <
                input type = "Number"
                class = "form-control"
                name = "amount[]"
                value = ""
                id = "exampleInputuname"
                placeholder = " Amount" > < /div></div > < div class = "col-sm-2" > < div class = "form-group"
                style = "margin-top: 2.5rem;" > < button onclick = "return delete_row(this)"
                type = "button"
                class = "btn btn-danger" > x < /button></div > < /div></div > '
            );


            return false;
        }


        function addNewRowToDeduction(self) {
            $('#deduction_parent_div').append(
                @foreach ($hrmDeductionTitle as $Title)
                    <option value="{{ $Title->name }}">{{ $Title->name }}</option>
                @endforeach < /select></div > <
                /div><div class="col-sm-5"><div class="form-group"> <label for="message-text" class="col-form-label"> Amount:</label >
                <
                input type = "Number"
                class = "form-control"
                name = "amount[]"
                value = ""
                id = "exampleInputuname"
                placeholder = " Amount" > < /div></div > < div class = "col-sm-2" > < div class = "form-group"
                style = "margin-top: 2.5rem;" > < button onclick = "return deduction_delete_row(this)"
                type = "button"
                class = "btn btn-danger" > x < /button></div > < /div></div > '
            );


            return false;
        }

        function delete_row(self) {
            $(self).closest('.row').remove();

            return false;
        }

        function deduction_delete_row(self) {
            $(self).closest('.row').remove();

            return false;
        }
    </script>
@stop {{-- for salary --}}
