@extends('layouts.app')


@section('title')
    Add New Inventory
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-inventory')
            <li><a href="{{ route('inventory.all') }}">All Inventories</a></li>
        @endpermission
        <li class="active">Add Inventory</li>
    </ol>
@stop

@section('content')

    @php
        $society = false;
        $highrise = false;
        $size = '';
        
        if ($projecttype->id == App\ProjectType::society) {
            $society = true;
            $size = \App\ProjectType::society_size;
        }
        
        if ($projecttype->id == App\ProjectType::high_rise) {
            $highrise = true;
            $size = \App\ProjectType::high_rise_size;
        }
        
    @endphp
    <div class="container-fluid">
        <!--.row-->
        <div class="row">

            <div class="col-md-12">
                @if ($errors->any())
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                        </ul>
                    </div>
                @endif
                <div class="white-box">

                    <h3 class="box-title m-b-0"><i class="fa fa-dashboard"></i> Add New Inventory</h3>
                    <p class="text-muted m-b-30 font-13"> Basic Information </p>
                    <form class="form-horizontal" action="{{ route('inventory.insert') }}" method="post">
                        {{ csrf_field() }}

                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Allocated</label>
                            <div class="col-sm-4">
                                <div class="input-group">

                                    <input type="radio" <?= old('type') == 0 ? 'checked' : '' ?> name="type"
                                        value="0" style="zoom: 1.6;" onchange="check_post(this)">
                                    @if ($errors->has('type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            @if (\App\ProjectType::getProjectType() == \App\ProjectType::society)

                                <label for="address" class="col-sm-2 control-label">Unallocated</label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <input type="radio" name="type" value="1"
                                            <?= old('type') == 1 ? 'checked' : '' ?> style="zoom: 1.6;"
                                            onchange="check_post(this)">
                                        @if ($errors->has('type'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('type') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        </div>

                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label" id="inventory_type">Plot / Serial
                                No</label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="text" class="form-control" name="unit_number"
                                        value="{{ rand('0000', '9999') }}" id="unit_number"
                                        placeholder="Enter Plot / Serial Number">
                                    @if ($errors->has('unit_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('unit_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        @can('isSuperAdmin')
                        @include('partial.multiproject_forinsertinventory')
                        @endcan

                        </div>

                        
                        <div class="form-group" id="pricelist">
                            <label for="floor" class="col-sm-2 control-label">Price List<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select id="price_list_id" class="form-control chosen-select" name="price_list_id">
                                        <option value=""><b>None</b></option>
                                        @foreach ($pricelist as $b)
                                            @if (old('price_list_id') == $b->id)
                                                <option selected="" value="{{ $b->id }}">{{ $b->l_no }}
                                                </option>
                                            @else
                                                <option value="{{ $b->id }}">{{ $b->l_no }} </option>
                                            @endif
                                        @endforeach

                                    </select>
                                    @if ($errors->has('price_list_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('price_list_id') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group" id="parent_div" style="display:<?= old('type') == 1 ? 'none' : '' ?>">
                            @if (\App\ProjectType::getProjectType() == \App\ProjectType::society)
                                <label for="floor" class="col-sm-2 control-label">Unit Street<span
                                        style="color: red">*</span></label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                        <select id="unit_floor_id" class="form-control chosen-select" name="unit_floor_id">
                                            <option value=""><b>None</b></option>
                                            @foreach ($floors as $b)
                                                @if (old('unit_floor_id') == $b->id)
                                                    <option selected="" value="{{ $b->id }}">{{ $b->name }}
                                                        - {{ $b->unitBlock ? $b->unitBlock->name : '' }}</option>
                                                @else
                                                    <option value="{{ $b->id }}">{{ $b->name }} -
                                                        {{ $b->unitBlock ? $b->unitBlock->name : '' }}</option>
                                                @endif
                                            @endforeach

                                        </select>
                                        @if ($errors->has('unit_floor_id'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('unit_floor_id') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            @endif
                            <!--  -->
                            @if (\App\ProjectType::getProjectType() == \App\ProjectType::high_rise)
                                <label for="floor" class="col-sm-2 control-label">Unit Floor<span
                                        style="color: red">*</span></label>

                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                        <select id="unit_floor_id" class="form-control  " name="unit_floor_id">
                                            <option value=""><b>None</b></option>


                                        </select>
                                        @if ($errors->has('unit_floor_id'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('unit_floor_id') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>


                            @endif
                        </div>
                            <!--  -->
                        </div>

                      
                        
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Unit Type <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select class="form-control chosen-select" id="unit_type_id" name="unit_type_id">
                                        <option value=""><b>None</b></option>
                                        @foreach ($types as $t)
                                            @if (old('unit_type_id') == $t->id)
                                                <option selected="" value="{{ $t->id }}">{{ $t->name }}
                                                </option>
                                            @else
                                                <option value="{{ $t->id }}">{{ $t->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>

                                    @if ($errors->has('unit_type_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('unit_type_id') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group" id='category_portion'>
                            <label for="address" class="col-sm-2 control-label">Unit Category </label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select class="form-control chosen-select" id="unit_category_id"
                                        name="unit_category_id[]" multiple="">
                                        <!--  <option value="" ><b>None</b></option> -->
                                        @foreach ($categories as $c)
                                            @if (old('unit_category_id') == $c->id)
                                                <option selected="" value="{{ $c->id }}">{{ $c->name }}
                                                </option>
                                            @else
                                                <option value="{{ $c->id }}">{{ $c->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>


                                    @if ($errors->has('unit_category_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('unit_category_id') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>

                        </div>


                        @if ($society)

                            <div class="form-group">
                                <label for="address" class="col-sm-2 control-label">Size<span
                                        style="color: red">*</span></label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                        <select class="form-control chosen-select" id="unit_size_id" name="unit_size_id">
                                            <option value="">None</option>
                                            @foreach ($sizes as $s)
                                                @if (old('unit_size_id') == $s->id)
                                                    <option selected="" value="{{ $s->id }}">
                                                        {{ $s->name }} {{ $size }}</option>
                                                @else
                                                    <option value="{{ $s->id }}">{{ $s->name }}
                                                        {{ $size }}</option>
                                                @endif
                                            @endforeach
                                        </select>

                                        @if ($errors->has('unit_size_id'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('unit_size_id') }}</strong>
                                            </span>
                                        @endif

                                    </div>
                                </div>
                                <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Dimension (w*h)</label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="text" class="form-control" value="{{ old('area') }}"
                                        placeholder="Total Dimension" name="area">
                                    @if ($errors->has('area'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('area') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                            </div>
                        @endif
                        @if ($highrise)
                            <input type='hidden' value=0 id='per_size_value' name='per_size_value'>
                            <div class="form-group">
                                <label for="address" class="col-sm-2 control-label">Unit Size<span
                                        style="color: red">*</span></label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                        {{-- <select class="form-control chosen-select" onchange="totalSizeFunction(this)" id='unit_size_id'   name="unit_size_id"> --}}
                                        <select class="form-control " id='unit_size_id' name="unit_size_id" >

                                            <option value="">None</option>
                                            @foreach ($sizes as $s)
                                                @if (old('unit_size_id') == $s->id)
                                                    <option selected="" value="{{ $s->id }}"
                                                        data-value='{{ $s->name }}'>
                                                        {{ $s->name }} {{ $size }}</option>
                                                @else
                                                    <option value="{{ $s->id }}"
                                                        data-value='{{ $s->name }}'>{{ $s->name }}
                                                        {{ $size }}</option>
                                                @endif
                                            @endforeach

                                        </select>
                                        @if ($errors->has('unit_size_id'))
                                            <span class="help-block" >
                                                <strong>{{ $errors->first('unit_size_id') }}</strong>
                                            </span>
                                        @endif


                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Total Amount <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="integer" class="form-control" value="{{ old('total_price') }}"
                                        id="total_price" placeholder="Total Price" name="total_price">
                                    @if ($errors->has('total_price'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('total_price') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Net Amount<span
                                    style="color: red">*</span> </label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="integer" class="form-control" value="{{ old('net_amount') }}"
                                        name="net_amount" id="net_amount" placeholder="Net Amount">
                                    @if ($errors->has('net_amount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('net_amount') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                        </div>

                        </div>



                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-2 control-label">Status <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select class="form-control chosen-select" name="status">
                                        @if (old('status'))
                                            @if (old('status') == \App\Inventory::open)
                                                <option value="{{ \App\Inventory::open }}" selected="">Open</option>

                                                <option value="{{ \App\Inventory::hold_company }}">Company Hold</option>
                                            @elseif(old('status') == \App\Inventory::hold_company)
                                                <option value="{{ \App\Inventory::open }}">Open</option>
                                                <option selected="" value="{{ \App\Inventory::hold_company }}">Company
                                                    Hold</option>
                                            @endif
                                        @else
                                            <option value="{{ \App\Inventory::open }}" selected="">Open</option>
                                            <option value="{{ \App\Inventory::hold_company }}">Company Hold</option>


                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Description </label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>

                                    <input type="text" class="form-control" name="description"
                                        value="{{ old('description') }}" id="description" placeholder="Description">
                                    @if ($errors->has('description'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('description') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-4">&nbsp;</div>
                            <div class=" col-sm-4">
                                <button type="submit" class="btn btn-info waves-effect waves-light "
                                    style="width: 100%">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

@stop


@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        function check_post(self) {

            if ($(self).val() == 1) { //unallocated portion
                $('#parent_div').hide()
                $('#category_portion').hide();
                $('#inventory_type').html('Inventory Id')

                var data = {
                    'type': $(self).val()
                };
                $('#unit_floor_id').html('<option selected value=""></option>');


                // $.get('/getNillFloor', data, function(data) {

                //     $('#unit_floor_id').html('<option selected value="' + data.output.id + '">' + data.output.name +
                //         '</option>');

                //     // $(".chosen-select").val(data.output.id).trigger("chosen:updated");
                // }, 'json');



            } else {

                $('#parent_div').show()
                $('#category_portion').show();
                $('#inventory_type').html('Plot / Serial No')

                var data = {
                    'type': $(self).val()
                };

                $.get('/getNillFloor', data, function(data) {

                    $option = '<option selected value="0">none</option>';

                    $.each(data.output, function(index, val) {
                        $option += '<option  value="' + val.id + '">' + val.name + '</option>';
                    });
                    $('#unit_floor_id').html($option);
                    $(".chosen-select").val(0).trigger("chosen:updated");
                }, 'json');
            }
        }

        @if ($highrise)
            $('#unit_type_id').change(function() {

                var floor = $('#unit_floor_id').val();
                var type = $('#unit_type_id').val();
                var pricelist_id = $('#price_list_id').find(":selected").val();;
                var project_type = {{ App\ProjectType::high_rise }}
                if (floor && type) {
                    var data = {
                        'floor': floor,
                        'type': type,
                        'pricelist_id': pricelist_id,
                        'project_type': project_type
                    };

                    $.get('/getRateByFloor', data, function(data) {

                        $('#per_size_value').val(data);

                        siz = $('#size').val();
                        if (siz > 0 && data > 0) {

                            // $('#total_price').val( siz*data);
                            //     $('#net_amount').val( siz*data);
                        } else {

                            $('#total_price').val(0);
                            $('#net_amount').val(0);
                        }

                        // $('#total_price').val(data);
                        // $('#net_amount').val(data);
                    });
                }
            });
            $("#unit_size_id").select2({

                    width: '100%',
                    tags: true,
                    createTag: function(params) {
                        var term = $.trim(params.term);

                        // Regular expression to check if input is a number (integer or float)
                        var numberRegex = /^[-+]?[0-9]*\.?[0-9]+$/;

                        // Return the tag if it's a valid number, otherwise return null
                        if (numberRegex.test(term)) {
                            return {
                                id: 'create' + term,
                                text: term + ' {{ $size }}',
                                value: 'tttt',
                                newTag: true, // add additional parameters



                                newOption: true
                            };
                        }

                        return null;
                    }
                }

            ).on('change', function() {
                var sizevalue = $(this).find(":selected").data("value");
                if (isNaN(sizevalue)) {
                    var word = "create";
                    sizevalue = $(this).val();
                    sizevalue = sizevalue.replace(word, "");
                }







                value = $('#per_size_value').val();

                $('#total_price').val(0);
                $('#net_amount').val(0);

                var s = sizevalue * value;
                $('#total_price').val(Math.round(s));
                $('#net_amount').val(Math.round(s));
            });
        @endif
        @if ($society)
            $('#unit_size_id').change(function() {
                var floor = $('#unit_floor_id').val();
                var type = $('#unit_type_id').val();
                var size = $('#unit_size_id').val();
                var pricelist_id = $('#price_list_id').find(":selected").val();
                var project_type = {{ App\ProjectType::society }}

                // if (floor && type && size) {
                if (type && size) {
                    var data = {
                        'floor': floor,

                        'type': type,
                        'size': size,
                        'pricelist_id': pricelist_id,
                        'project_type': project_type
                    };

                    $.get('/getRateByFloor', data, function(data) {

                        $('#total_price').val(data);
                        $('#net_amount').val(data);
                    });
                }
            });

            $('#unit_type_id').change(function() {
                $('#total_price').val(0);
                $('#net_amount').val(0);
            });
        @endif
        $('#unit_floor_id').change(function() {
            @if ($highrise)
                var floor = $('#unit_floor_id').val();

                var pricelist_id = $('#price_list_id').find(":selected").val();
                var project_type = {{ App\ProjectType::high_rise }}

                var data = {
                    'floor': floor,
                    'pricelist_id': pricelist_id,
                    'project_type': project_type
                };






                $.get('/getTypeByFloor', data, function(data) {
                    $('#unit_type_id option').remove();

                    $('#unit_type_id').append('<option value="">None</option>');
                    for (i = 0; i < data.name.length; i++) {
                        $('#unit_type_id').append('<option value="' + data.id[i] + '">' + data.name[i] +
                            '</option>');
                    }
                    //         $('#total_price').val(data);
                    //         $('#net_amount').val(data);
                    $('#unit_type_id').trigger('chosen:updated');

                });
            @endif

            @if ($society)


                var floor = $('#unit_floor_id').val();
                var type = $('#unit_type_id').val();
                var size = $('#unit_size_id').val();



                if (floor && type && size) {
                    var data = {
                        'floor': floor,
                        'type': type,
                        'size': size
                    };

                    $.get('/getRateByFloor', data, function(data) {

                        $('#total_price').val(data);
                        $('#net_amount').val(data);
                    });
                }
            @endif
        });


        $('#price_list_id').change(function() {
            $('#total_price').val(0);
            $('#net_amount').val(0);
            @if ($highrise)
                var pricelist_id = $('#price_list_id').find(":selected").val();
                var data = {
                    'price_list_id': pricelist_id
                };
                $.get('/getFloorByPrice', data, function(data) {

                    $('#unit_floor_id').empty();
                    $('#unit_floor_id').append('<option value="">None</option>');
                    for (i = 0; i < data.name.length; i++) {
                        $('#unit_floor_id').append('<option value="' + data.id[i] + '">' + data.name[i] +
                            '</option>');
                    }


                    $('#unit_floor_id').chosen();

                });
            @endif



        });

        $('#unit_category_id').change(function() {
            var category = $('#unit_category_id').val();

            var amount = parseInt($('#total_price').val());
            var sum = 0;
            if (category && amount > 0) {
                for (i = 0; i < category.length; i++) {
                    categories = <?php echo json_encode($categories); ?>;
                    obj = categories.find(obj => obj.id == category[i]);
                    percent = parseFloat(obj['percent']);
                    if (obj['is_percent'])
                        sum += (amount * percent) / 100;
                    else
                        sum += percent;


                }
                sum += amount;
                $('#net_amount').val(sum);

            } else {
                $('#net_amount').val(amount);
            }


        });
    </script>
@stop