@extends('layouts.app')
@section('title')
Sale Dashboard
@stop
@section('breadcrumb')
    <ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Sales Dashboard</li>
    </ol>
@stop
@section('css')
<style type="text/css">
    .table-bordered, .table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th, .table>thead>tr>td, .table>thead>tr>th {
    border: 1px solid #000000;
}
</style>
@stop
@section('content')

@php
    $size= '';

    if($projectType->id == \App\ProjectType::society){

    $size= \App\ProjectType::society_size;
    }

    else
    {
    $size= \App\ProjectType::high_rise_size;
    }

@endphp
            <!-- ===== Page-Container ===== -->
            <div class="container-fluid">
                @can('isSuperAdmin')
                @include('partial.multiproject_select')
                @endcan
                <div id='updatecontent'>
                <div class="row colorbox-group-widget" style="margin-top: 25px;">
                    <div class="col-md-4 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-primary">
                                <div class="media-body">
                                    <h3 class="info-count">{{number_format($total_units_count)}}<span class="pull-right"><i class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                    <p class="info-text font-12">Total Units</p>
                                    <p class="info-ot font-15"><span class="label " style="color:#58508d!important; background: #58508d!important">.</span></p>
                                    <p class="info-ot font-15">Booked Units<span class="label label-rounded">{{number_format($booked_units_count)}}</span></p>
                                    <p class="info-ot font-15">Un-Booked Units<span class="label label-rounded">{{number_format($un_booked_units_count)}}</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-success">
                                <div class="media-body">
                                    <h3 class="info-count">{{number_format($total_units_area)}} {{$size}}<span class="pull-right"><i class="mdi mdi-comment-text-outline"></i></span></h3>
                                    <p class="info-text font-12">Total Area</p>
                                    <p class="info-ot font-15"><span class="label " style="color:#bc5090!important; background: #bc5090!important">.</span></p>
                                    <p class="info-ot font-15">Booked Area<span class="label label-rounded">{{number_format($booked_units_area)}} {{$size}}</span></p>
                                    <p class="info-ot font-15">Un-Booked Area<span class="label label-rounded">{{number_format($un_booked_units_area)}} {{$size}}</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-danger">
                                <div class="media-body">
                                    <h3 class="info-count">Rs. {{number_format($total_units_amount)}} <span class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                                    <p class="info-text font-12">Total Price</p>
                                    <p class="info-ot font-15">Booked Price<span class="label label-rounded">Rs. {{number_format($booked_units_amount - ($booked_units_amount - $total_cost_booked_units ))}} </span></p>
                                    <p class="info-ot font-15">Un-Booked Price<span class="label label-rounded">Rs. {{number_format($un_booked_units_amount)}} </span></p>
                                    <p class="info-ot font-15">Discount<span class="label label-rounded">Rs. {{number_format($booked_units_amount - $total_cost_booked_units )}} </span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"> RECOVERIES & RECEIVABLES </h3>
                            <br>
                            <div class="table-responsive">
                                <table class="table" style="border-top:1px solid">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><strong>Description</strong></th>
                                            <th class="text-center"><strong>Rupees</strong></th>
                                            <th class="text-center"><strong>%age</strong></th>
                                            <th class="text-center"><strong>Receivable Ag.</strong></th>
                                            <th class="text-center"><strong>Rupees</strong></th>
                                            <th class="text-center"><strong>%age</strong></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $total = ($total_cost_booked_units - $total_collection); ?>
                                        <tr>
                                            <td>Total Cost of Booked Units</td>
                                            <td class="text-right">{{number_format($total_cost_booked_units)}}</td>
                                            <td class="text-right">100 %</td>
                                            <td>Overdues</td>
                                            <td class="text-right">{{number_format($overdues)}}</td>
                                            <td class="text-right">{{ $total > 0 ? round(($overdues  / ($total) ) * 100) : 0 }} %</td>
                                        </tr>
                                        <tr>
                                            <td>Total Collection/Recovery </td>
                                            <td class="text-right">{{number_format($total_collection)}}</td>
                                            <td class="text-right">{{$total_cost_booked_units > 0 ?  round(($total_collection  / $total_cost_booked_units ) * 100) : 0}} %</td>
                                            <td>Future Installments</td>
                                            <td class="text-right">{{number_format(($total) - $overdues)}}</td>
                                            <td class="text-right">{{$total > 0  ? round(( ($total - $overdues)  / ($total) ) * 100) : 0}} %</td>
                                            
                                            
                                        </tr>
                                        <tr>
                                            <td><strong>Balance Receivable</strong></td>
                                            <td class="text-right"><strong>{{number_format($total)}}</strong></td>
                                            <td class="text-right"><strong>{{$total > 0  ? round((($total)  / $total_cost_booked_units ) * 100) : 0 }} %</strong></td>
                                            <td><strong>Balance Receivable</strong></td>
                                            <td class="text-right"><strong>{{number_format($total)}}</strong></td>
                                            <td class="text-right"><strong> %</strong></td>
                                        </tr>
                                    </tbody>
                                    
                                </table>
                            </div>

                        </div>
                    </div>
                </div>


                <!-- .row -->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">BREAKUP OF RECEIVABLES AGAINST DEFAULTERS AGED</h3><br>
                            <div class="table-responsive" >
                                <table class="table" style="border-top: 1px solid">
                                    <thead>
                                         <tr>
                                            <th class="text-center" rowspan="2"><strong>Defaulters Age. in Month</strong></th>
                                            <th class="text-center" rowspan="2"><strong>No. of Units</strong></th>
                                            <th class="text-center" colspan="2"><strong>Total Amount Received Today</strong></th>
                                            <th class="text-center" colspan="2"><strong>Balance Receiveabe</strong></th>
                                            <th class="text-center" colspan="2"><strong>Receiveabe .ag Overdues</strong></th>
                                            <th class="text-center" colspan="2"><strong>Receiveabe .ag Future Inst.</strong></th>
                                         </tr>
                                         <tr>
                                            <th class="text-center"><strong>Amount</strong></th>
                                            <th class="text-center"><strong>%age</strong></th>
                                            <th class="text-center"><strong>Amount</strong></th>
                                            <th class="text-center"><strong>%age</strong></th>
                                            <th class="text-center"><strong>Amount</strong></th>
                                            <th class="text-center"><strong>%age</strong></th>
                                            <th class="text-center"><strong>Amount</strong></th>
                                            <th class="text-center"><strong>%age</strong></th>
                                         </tr>
                                    </thead>
                                    <tbody>
                                       
                                        <tr>
                                            <td><strong>Fully Paid</strong></td>
                                            <td class="text-center">{{$fully_paid_units_count}}</td>
                                            <td class="text-right">{{number_format($fully_paid_units_amount)}}</td>
                                            <td class="text-right">{{$total_collection > 0  ? round(($fully_paid_units_amount / $total_collection) * 100) : 0 }} %</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0 %</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0 %</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0 %</td>
                                        </tr>

                                        <tr>
                                            <td><strong>No Over Due</strong></td>
                                            <td class="text-center">{{$no_overdue_count}}</td>
                                            <td class="text-right">{{number_format($no_overdue_amount)}}</td>
                                            <td class="text-right">{{$total_collection > 0  ? round(($no_overdue_amount / $total_collection) * 100) : 0}} %</td>
                                            <td class="text-right">{{number_format($no_overdue_receivable)}}</td>
                                            <td class="text-right">{{$no_overdue_receivable_per}} %</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0 %</td>
                                            <td class="text-right">{{number_format($no_overdue_receivable)}}</td>
                                            <td class="text-right">{{$no_overdue_receivable_per}} %</td>
                                        </tr>

                                        <tr>
                                            <td><strong>1 Month</strong></td>
                                            <td class="text-center">{{$f_month_overdue_count}}</td>
                                            <td class="text-right">{{number_format($f_month_overdue_amount)}}</td>
                                            <td class="text-right">{{$total_collection > 0  ? round(($f_month_overdue_amount / $total_collection) * 100) : 0}} %</td>
                                            <td class="text-right">{{number_format($f_month_overdue_receivable)}}</td>
                                            <td class="text-right">{{$f_month_overdue_receivable_per}} %</td>
                                            <td class="text-right">{{number_format($f_month_overdue_balance)}}</td>
                                            <td class="text-right"> %</td>
                                            <td class="text-right">{{number_format($f_month_overdue_receivable - $f_month_overdue_balance)}}</td>
                                            <td class="text-right"> %</td>
                                        </tr>

                                        <tr>
                                            <td><strong>2 Month</strong></td>
                                            <td class="text-center">{{$s_month_overdue_count}}</td>
                                            <td class="text-right">{{number_format($s_month_overdue_amount)}}</td>
                                            <td class="text-right">{{$total_collection > 0  ? round(($s_month_overdue_amount / $total_collection) * 100) : 0}} %</td>
                                            <td class="text-right">{{number_format($s_month_overdue_receivable)}}</td>
                                            <td class="text-right">{{$s_month_overdue_receivable_per}} %</td>
                                            <td class="text-right">{{number_format($s_month_overdue_balance)}}</td>
                                            <td class="text-right"> %</td>
                                            <td class="text-right">{{number_format($s_month_overdue_receivable - $s_month_overdue_balance)}}</td>
                                            <td class="text-right"> %</td>
                                        </tr>

                                        <tr>
                                            <td><strong>3 Month</strong></td>
                                            <td class="text-center">{{$t_month_overdue_count}}</td>
                                            <td class="text-right">{{number_format($t_month_overdue_amount)}}</td>
                                            <td class="text-right">{{$total_collection > 0  ? round(($t_month_overdue_amount / $total_collection) * 100) : 0}} %</td>
                                            <td class="text-right">{{number_format($t_month_overdue_receivable)}}</td>
                                            <td class="text-right">{{$t_month_overdue_receivable_per}} %</td>
                                            <td class="text-right">{{number_format($t_month_overdue_balance)}}</td>
                                            <td class="text-right"> %</td>
                                            <td class="text-right">{{number_format($t_month_overdue_receivable - $t_month_overdue_balance)}}</td>
                                            <td class="text-right"> %</td>
                                        </tr>

                                        <tr>
                                            <td><strong>3+ Month</strong></td>
                                            <td class="text-center">{{$fo_month_overdue_count}}</td>
                                            <td class="text-right">{{number_format($fo_month_overdue_amount)}}</td>
                                            <td class="text-right">{{$total_collection > 0  ? round(($fo_month_overdue_amount / $total_collection) * 100) : 0}} %</td>
                                            <td class="text-right">{{number_format($fo_month_overdue_receivable)}}</td>
                                            <td class="text-right">{{$fo_month_overdue_receivable_per}} %</td>
                                            <td class="text-right">{{number_format($fo_month_overdue_balance)}}</td>
                                            <td class="text-right"> %</td>
                                            <td class="text-right">{{number_format($fo_month_overdue_receivable - $fo_month_overdue_balance)}}</td>
                                            <td class="text-right"> %</td>
                                        </tr>

                                        

                                        
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- <div class="col-lg-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">BREAKUP OF RECEIVABLES AGAINST RECOVERY %AGE WISE</h3><br>
                            <div class="table-responsive" >
                                <table class="table" style="border-top: 1px solid">
                                    <thead>
                                         <tr>
                                            <th class="text-center" rowspan="2"><strong>Recovery %age ag. Total Cost</strong></th>
                                            <th class="text-center" rowspan="2"><strong>No. of Units</strong></th>
                                            <th class="text-center" colspan="2"><strong>Total Amount Received Today</strong></th>
                                            <th class="text-center" colspan="2"><strong>Balance Receiveabe</strong></th>
                                            <th class="text-center" colspan="2"><strong>Receiveabe .ag Overdues</strong></th>
                                            <th class="text-center" colspan="2"><strong>Receiveabe .ag Future Inst.</strong></th>
                                         </tr>
                                         <tr>
                                            <th class="text-center"><strong>Amount</strong></th>
                                            <th class="text-center"><strong>%age</strong></th>
                                            <th class="text-center"><strong>Amount</strong></th>
                                            <th class="text-center"><strong>%age</strong></th>
                                            <th class="text-center"><strong>Amount</strong></th>
                                            <th class="text-center"><strong>%age</strong></th>
                                            <th class="text-center"><strong>Amount</strong></th>
                                            <th class="text-center"><strong>%age</strong></th>
                                         </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><strong>Canc.Reqst.</strong></td>
                                            <td>3</td>
                                            <td class="text-right">2925000</td>
                                            <td class="text-right">4%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                        </tr>
                                        <tr>
                                            <td><strong>No Recovery</strong></td>
                                            <td>3</td>
                                            <td class="text-right">2925000</td>
                                            <td class="text-right">4%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Upto 10%</strong></td>
                                            <td>3</td>
                                            <td class="text-right">2925000</td>
                                            <td class="text-right">4%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Upto 20%</strong></td>
                                            <td>3</td>
                                            <td class="text-right">2925000</td>
                                            <td class="text-right">4%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0%</td>
                                        </tr>
                                        <tr>
                                            <td class="text-right"><strong>Total</strong></td>
                                            <td><strong>153</strong></td>
                                            <td class="text-right"><strong>2925000</strong></td>
                                            <td class="text-right"><strong>4%</strong></td>
                                            <td class="text-right"><strong>0</strong></td>
                                            <td class="text-right"><strong>0%</strong></td>
                                            <td class="text-right"><strong>0</strong></td>
                                            <td class="text-right"><strong>0%</strong></td>
                                            <td class="text-right"><strong>0</strong></td>
                                            <td class="text-right"><strong>0%</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div> -->
                </div>
                </div>
                <!-- /.row -->

        </div>

@stop
@section('js')
<script>
    function updateStatus(value) {
            $('.preloader').fadeIn();

            if (value === 'search') {

                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
            $.get('{{ route('sales.dashboard') }}', data, function(data) {
                $('.preloader').fadeOut();
                $('#myTable tbody').empty();
                 
              
                
                document.getElementById('updatecontent').innerHTML = data;
                
                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });

        }
    </script>

@stop