@extends('layouts.app')

@section('title')
Inventory Detail 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-inventory')
        <li ><a href="{{route('inventory.all')}}">All Inventories</a></li>
        @endpermission
        <li class="active">Inventory Detail</li>
      </ol>
@stop
@section('content')


@php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
@endphp

@php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

    $map= \App\ProjectType::society_map;
    }
    else
    { $map= \App\ProjectType::high_rise_map;}

@endphp
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Inventory Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table ">
                                            <tbody>
                                                <tr>
                                                    <td width="360"><b>Unit Number</b></td>
                                                    <td> <span style="font-size:18px;"> {{$inventory->unit_number}} </span>

                                                        
                                                        
                                                        @foreach($inventory->oldNames as $o)
                                                        @if($loop->first)

                                                        <br>
                                                        <b style="font-size:12px;">Old Numbers : </b>
                                                        <ul>
                                                        @endif
                                                        <li>

                                                        {{$o->name}} </li>

                                                       

                                                        @endforeach
                                                    </ul>
                                                        
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><b>Project </b></td>
                                                    <td><span class="label label-success">{{$inventory->multiProject?$inventory->multiProject->name:''}}</span></td>
                                                </tr>
                                                <tr>
                                                    <td><b>Pricelist </b></td>  
                                                    <td><span class="label label-success">{{$inventory->priceList ? $inventory->priceList->l_no : '' }}</span></td>
                                                </tr>
                                                <tr>
                                                    <td><b>{{$map}}</b></td>
                                                    <td>
                                                        {{$inventory->floor ? $inventory->floor->name  : ''}}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td><b>Block</b></td>
                                                    <td>{{$inventory->floor?$inventory->floor->unitBlock->name:''}}</td>
                                                </tr>


                                                <tr>
                                                    <td><b>Type</b></td>
                                                    <td>{{$inventory->type ? $inventory->type->name  : ''}}</td>
                                                </tr>
                                                <tr>
                                                    <td><b>Size</b></td>

                                                    <td>{{$inventory->size?$inventory->size->name:''}}  {{$size}}
                                              
                                            </td>
                                                    </tr>

                                                <tr>
                                                    <td><b>Area</b></td>
                                                    <td>
                                                    {{$inventory->area}} </td>
                                                </tr>
                                                <tr>
                                                    <td><b>Total amount</b></td>
                                                    <td> {{number_format($inventory->total_price - $inventory->extra_amount)}}</td>
                                                </tr>
                                                <tr>
                                                    <td><b>Category</b></td>
                                                    <?php $sum =0;?>
                                                    <td>@foreach($inventory->categories as $c)
                                                        <?php $sum += $c->category->percent;?>
                                                        @if($loop->last)
                                                        {{$c->category->name}} 
                                                        @if($c->category->is_percent)
                                                        ({{$c->category->percent}} %)
                                                        @else
                                                        ({{$c->category->percent}} )
                                                        @endif
                                                        @else
                                                        {{$c->category->name}} @if($c->category->is_percent)
                                                        ({{$c->category->percent}} %)
                                                        @else
                                                        ({{$c->category->percent}} )
                                                        @endif,
                                                        @endif
                                                    @endforeach</td>
                                                </tr>
                                                <tr>
                                                    <td><b>Extra Charges</b></td>
                                                    <td>{{number_format($inventory->extra_amount)}} </td>
                                                </tr>
                                                <tr>
                                                    <td><b>Net Amount</b></td>
                                                    <td> {{number_format($inventory->total_price)}}</td>
                                                </tr>


                                                <tr>
                                                    <td><b>Description</b></td>
                                                    <td> {{$inventory->description}}</td>
                                                </tr>
                                                <tr>
                                                    @role('admin')
                                                    <td><b>Status</b></td>
                                                    @if($inventory->status == \App\Inventory::open)
                                                    <td> Open</td>
                                                    @elseif($inventory->status == \App\Inventory::sold)
                                                    <td>Sold</td>
                                                    @elseif($inventory->status == \App\Inventory::hold_company)
                                                    <td>Company Hold</td>
                                                    @elseif($inventory->status == \App\Inventory::hold_client)
                                                    <td>Client Hold</td>
                                                    @elseif($inventory->status == \App\Inventory::token_hold)
                                                    <td>Token Hold</td>
                                                    

                                                    @elseif($inventory->status == \App\Inventory::temp_hold)
                                                    <td>Temporary Hold</td>
                                                    @elseif($inventory->status == \App\Inventory::package_open_file)
                                                    <td>Open/Dealer Package File</td>
                                                    @endif

                                                    @else

                                                     <td><b>Status</b></td>
                                                    @if($inventory->status == \App\Inventory::open)
                                                    <td> Open</td>
                                                    @else
                                                    <td>Sold</td>
                                                    @endif


                                                    @endrole
                                                </tr>
                                                
                                                @if($inventory->dealer_id)
                                                <tr>
                                                    <td><b>Dealer</b></td>
                                                    <td>@if($inventory->dealer_id)
                                                        {{$inventory->dealer->name}}
                                                    @endif</td>
                                                </tr>
                                                @endif

                                                @if($inventory->token_amount)
                                                <tr>
                                                    <td><b>Token Amount</b></td>
                                                    <td>{{$inventory->token_amount}}</td>
                                                </tr>
                                                @endif

                                                @if($inventory->name)
                                                <tr>
                                                    <td><b>Name</b></td>
                                                    <td>{{$inventory->name}}</td>
                                                </tr>
                                                @endif
                                                @if($inventory->cnic)
                                                <tr>
                                                    <td><b>Cnic</b></td>
                                                    <td>{{$inventory->cnic}}</td>
                                                </tr>
                                                @endif
                                                @if($inventory->email)
                                                <tr>
                                                    <td><b>Email</b></td>
                                                    <td>{{$inventory->email}}</td>
                                                </tr>
                                                @endif
                                                @if($inventory->phone_number)
                                                <tr>
                                                    <td><b>Phone Number</b></td>
                                                    <td>{{$inventory->phone_number}}</td>

                                                </tr>
                                                @endif
                                                

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>

                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop