@extends('layouts.app')

@section('title')
    Update Inventory
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-inventory')
            <li><a href="{{ route('inventory.all') }}">All Inventories</a></li>
        @endpermission
        <li class="active">Update Inventory</li>
    </ol>
@stop

@section('content')

    <div class="container-fluid">
        <!--.row-->
        <div class="row">

            <div class="col-md-12">
                @if ($errors->any())
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                        </ul>
                    </div>
                @endif
                <div class="white-box">
                    <h3 class="box-title m-b-0"><i class="fa fa-dashboard"></i> Add New Inventory</h3>
                    <p class="text-muted m-b-30 font-13"> Basic Information </p>
                    <form class="form-horizontal" action="{{ route('inventory.update') }}" method="post">
                        {{ csrf_field() }}
                        <input type="hidden" name="id" value="{{ $inventory->id }}">
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Unit Number<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="text" class="form-control" name="unit_number"
                                        value="{{ $inventory->unit_number }}" id="unit_number"
                                        placeholder="Enter Unit Number">
                                    @if ($errors->has('unit_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('unit_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group" id="pricelist">
                            <label for="floor" class="col-sm-2 control-label">Price List<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select id="price_list_id" class="form-control chosen-select" name="price_list_id">
                                        <option value=""><b>None</b></option>
                                        
                                        @foreach ($pricelist as $b)
                                            @if($b->id == $inventory->pricelist_id)
                                            <option selected="" value="{{ $inventory->pricelist_id }}">{{ $inventory->priceList->l_no }}
                                            </option>
                                            @else
                                                <option value="{{ $b->id }}">{{ $b->l_no }} </option>
                                            @endif
                                        @endforeach

                                    </select>
                                    @if ($errors->has('price_list_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('price_list_id') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="floor" class="col-sm-2 control-label">Unit Floor<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select id="unit_floor_id" class="form-control chosen-select" name="unit_floor_id">
                                        <option value=""><b>None</b></option>
                                        @foreach ($floors as $b)
                                            @if ($inventory->unit_floor_id == $b->id)
                                                <option selected="" value="{{ $b->id }}">{{ $b->name }} -
                                                    {{ $b->unitBlock ? $b->unitBlock->name : '' }}</option>
                                            @else
                                                <option value="{{ $b->id }}">{{ $b->name }} -
                                                    {{ $b->unitBlock ? $b->unitBlock->name : '' }}</option>
                                            @endif
                                        @endforeach

                                    </select>
                                    @if ($errors->has('unit_floor'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('unit_floor') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Unit Type <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select class="form-control chosen-select" id="unit_type_id" name="unit_type_id">
                                        <option value=""><b>None</b></option>
                                        @foreach ($types as $t)
                                            @if ($inventory->unit_type_id == $t->id)
                                                <option selected="" value="{{ $t->id }}">{{ $t->name }}
                                                </option>
                                            @else
                                                <option value="{{ $t->id }}">{{ $t->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>



                                    @if ($errors->has('unit_type_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('unit_type_id') }}</strong>
                                        </span>
                                    @endif
                                </div>

                            </div>
                        </div>



                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Size<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select class="form-control chosen-select" id="unit_size_id" name="unit_size_id">
                                        <option value="">None</option>
                                        @foreach ($sizes as $s)
                                            @if ($inventory->unit_size_id == $s->id)
                                                <option selected="" value="{{ $s->id }}"> {{ $s->name }}
                                                    sq/ft</option>
                                            @else
                                                <option value="{{ $s->id }}">{{ $s->name }} sq/ft</option>
                                            @endif
                                        @endforeach
                                    </select>


                                    @if ($errors->has('unit_size_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('unit_size_id') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Area <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="text" class="form-control" value="{{ $inventory->area }}"
                                        placeholder="Total Area" name="area">
                                    @if ($errors->has('area'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('area') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Total Amount <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="number" class="form-control"
                                        value="{{ $inventory->total_price - $inventory->extra_amount }}" id="total_price"
                                        placeholder="Total Price" name="total_price">
                                    @if ($errors->has('total_price'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('total_price') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Unit Category </label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select class="form-control chosen-select" id="unit_category_id"
                                        name="unit_category_id[]" multiple="">
                                        <!--  <option value="" ><b>None</b></option> -->
                                        @foreach ($categories as $c)
                                            @if (in_array($c->id, $selected_categories))
                                                <option selected="" value="{{ $c->id }}">{{ $c->name }}
                                                </option>
                                            @else
                                                <option value="{{ $c->id }}">{{ $c->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>


                                    @if ($errors->has('unit_category_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('unit_category_id') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Net Amount </label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="number" class="form-control" value="{{ $inventory->total_price }}"
                                        name="net_amount" id="net_amount" placeholder="Net Amount">
                                    @if ($errors->has('net_amount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('net_amount') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Description </label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>

                                    <input type="text" class="form-control" name="description"
                                        value="{{ $inventory->description }}" id="description"
                                        placeholder="Description">
                                    @if ($errors->has('description'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('description') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-2 control-label">Status <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select class="form-control chosen-select" onchange="infoBox(this.value)"
                                        name="status">

                                        @if ($inventory->status == \App\Inventory::open)
                                            <option value="{{ \App\Inventory::open }}" selected="">Open</option>

                                            <option value="{{ \App\Inventory::hold_company }}">Company Hold</option>
                                            <option value="{{ \App\Inventory::token_hold }}">Token Hold</option>
                                            <option value="{{ \App\Inventory::temp_hold }}">Temporary Hold</option>

                                            <option value="{{ \App\Inventory::sold }}">Sold</option>
                                        @elseif($inventory->status == \App\Inventory::sold)
                                            <option value="{{ \App\Inventory::open }}">Open</option>
                                            <option value="{{ \App\Inventory::hold_company }}">Company Hold</option>
                                            <option value="{{ \App\Inventory::token_hold }}">Token Hold</option>
                                            <option value="{{ \App\Inventory::temp_hold }}">Temporary Hold</option>

                                            <option value="{{ \App\Inventory::sold }}" selected="">Sold</option>
                                        @elseif($inventory->status == \App\Inventory::hold_company)
                                            <option value="{{ \App\Inventory::open }}">Open</option>

                                            <option selected="" value="{{ \App\Inventory::hold_company }}">Company
                                                Hold</option>
                                            <option value="{{ \App\Inventory::token_hold }}">Token Hold</option>
                                            <option value="{{ \App\Inventory::temp_hold }}">Temporary Hold</option>
                                            <option value="{{ \App\Inventory::sold }}">Sold</option>
                                        @elseif($inventory->status == \App\Inventory::token_hold)
                                            <option value="{{ \App\Inventory::open }}">Open</option>

                                            <option value="{{ \App\Inventory::hold_company }}">Company Hold</option>
                                            <option selected="" value="{{ \App\Inventory::token_hold }}">Token Hold
                                            </option>
                                            <option value="{{ \App\Inventory::temp_hold }}">Temporary Hold</option>
                                            <option value="{{ \App\Inventory::sold }}">Sold</option>
                                        @elseif($inventory->status == \App\Inventory::temp_hold)
                                            <option value="{{ \App\Inventory::open }}">Open</option>

                                            <option value="{{ \App\Inventory::hold_company }}">Company Hold</option>
                                            <option value="{{ \App\Inventory::token_hold }}">Token Hold</option>
                                            <option selected="" value="{{ \App\Inventory::temp_hold }}">Temporary Hold
                                            </option>
                                            <option value="{{ \App\Inventory::sold }}">Sold</option>
                                        @endif

                                    </select>
                                </div>
                            </div>
                        </div>


                        <div id="info" style="display: none;">



                            <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Dealer</label>
                                <div class="col-sm-10">
                                    <div class="input-group">
                                        <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                        <select class="form-control chosen-select" name="dealer_id">
                                            <option value=""><b>None</b></option>
                                            @foreach ($dealers as $d)
                                                @if ($inventory->dealer_id == $d->id)
                                                    <option selected="" value="{{ $d->id }}">
                                                        {{ $d->name }}</option>
                                                @else
                                                    <option value="{{ $d->id }}">{{ $d->name }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        @if ($errors->has('dealer_id'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('dealer_id') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div id="infoC">

                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Token Amount </label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                            <input type="text" class="form-control"
                                                value="{{ $inventory->token_amount }}" name="token_amount"
                                                placeholder="Token Amount">
                                            @if ($errors->has('Token Amout'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('Token Amount') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Name</label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                            <input type="text" class="form-control" value="{{ $inventory->name }}"
                                                name="name" id="name" placeholder="Name">
                                            @if ($errors->has('name'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('name') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">CNIC </label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                            <input type="text" class="form-control" value="{{ $inventory->cnic }}"
                                                name="cnic" placeholder="CNIC">
                                            @if ($errors->has('cnic'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('cnic') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Phone Number </label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                            <input type="text" class="form-control"
                                                value="{{ $inventory->phone_number }}" name="phone_number"
                                                placeholder="Phone Number">
                                            @if ($errors->has('phone_number'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('phone_number') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Email </label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                            <input type="text" class="form-control" value="{{ $inventory->email }}"
                                                name="email" placeholder="Email">
                                            @if ($errors->has('email'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('email') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="form-group">
                            <div class=" col-sm-4">&nbsp;</div>
                            <div class=" col-sm-4">
                                <button type="submit" class="btn btn-info waves-effect waves-light"
                                    style="width: 100%">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

@stop


@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
        $('#unit_size_id').change(function() {
            var floor = $('#unit_floor_id').val();
            var type = $('#unit_type_id').val();
            var size = $('#unit_size_id').val();
            if (floor && type && size) {
                var data = {
                    'floor': floor,
                    'type': type,
                    'size': size
                };

                $.get('/getRateByFloor', data, function(data) {

                    $('#total_price').val(data);
                    $('#net_amount').val(data);
                });
            }
        });

        $('#unit_floor_id').change(function() {
            var floor = $('#unit_floor_id').val();
            var type = $('#unit_type_id').val();
            var size = $('#unit_size_id').val();
            if (floor && type && size) {
                var data = {
                    'floor': floor,
                    'type': type,
                    'size': size
                };

                $.get('/getRateByFloor', data, function(data) {

                    $('#total_price').val(data);
                    $('#net_amount').val(data);
                });
            }
        });


        $('#unit_type_id').change(function() {
            var floor = $('#unit_floor_id').val();
            var type = $('#unit_type_id').val();
            var size = $('#unit_size_id').val();
            if (floor && type && size) {
                var data = {
                    'floor': floor,
                    'type': type,
                    'size': size
                };

                $.get('/getRateByFloor', data, function(data) {

                    $('#total_price').val(data);
                    $('#net_amount').val(data);
                });
            }
        });

        $('#unit_category_id').change(function() {
            var category = $('#unit_category_id').val();

            var amount = parseInt($('#total_price').val());
            var sum = 0;
            if (category && amount > 0) {
                for (i = 0; i < category.length; i++) {
                    categories = <?php echo json_encode($categories); ?>;
                    obj = categories.find(obj => obj.id == category[i]);
                    percent = parseFloat(obj['percent']);
                    if (obj['is_percent'])
                        sum += (amount * percent) / 100;
                    else
                        sum += percent;
                }
                sum += amount;
                $('#net_amount').val(sum);

            } else {
                $('#net_amount').val(amount);
            }


        });
    </script>

    <script type="text/javascript">
        function infoBox(val) {

            if (val == '{{ \App\Inventory::token_hold }}') {
                document.getElementById('info').style.display = 'block';
                document.getElementById('infoC').style.display = 'block';
            } else if (val == '{{ \App\Inventory::temp_hold }}') {
                document.getElementById('info').style.display = 'block';
                document.getElementById('infoC').style.display = 'none';
            } else {
                document.getElementById('info').style.display = 'none';
            }

        }

        val = '{{ $inventory->status }}';
        if (val == '{{ \App\Inventory::token_hold }}') {
            document.getElementById('info').style.display = 'block';
        }
    </script>

@stop
