@extends('layouts.app')

@section('title')
    All Inventories
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i>Home</a></li>

        <li class="active">All Inventories</li>
    </ol>
@stop

@section('css')

    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

    <style>
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }
    </style>

@stop
@section('content')
    @php
        
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    @endphp


    @php
        $map = ' ';
        
        if ($projectType->id == \App\ProjectType::society) {
            $map = \App\ProjectType::society_map;
        } else {
            $map = \App\ProjectType::high_rise_map;
        }
        
    @endphp

    <div class="container-fluid">
        @can('isSuperAdmin')
            @include('partial.multiproject_select')
        @endcan

        <!--./row-->


        <div id='updatecontent'>


            <!--.row-->
            <div class="row" style="margin-top: 25px;">
                <div class="col-md-12">
                    <div class="panel panel-info">
                        <div class="panel-heading">Search Inventory</div>
                        <div class="panel-wrapper collapse in" aria-expanded="true">

                            <div class="panel-body">
                                <form>
                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By Unit Number</label>
                                                    <select id="unit" class="form-control chosen-select">
                                                        <option value="0">None</option>
                                                        @foreach ($unitNumbers as $p)
                                                            <option value="{{ $p->id }}">{{ $p->unit_number }}
                                                            </option>
                                                        @endforeach
                                                    </select>

                                                </div>
                                            </div>
                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By {{ $map }}</label>

                                                    <select id="floor" class="form-control chosen-select">
                                                        <option value="0">None</option>
                                                        @foreach ($floors as $b)
                                                            <option value="{{ $b->id }}">{{ $b->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <!--/span-->
                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By Size</label>

                                                    <select id="size" class="form-control chosen-select">
                                                        <option value="0">None</option>
                                                        @foreach ($sizes as $s)
                                                            <option value="{{ $s->id }}">
                                                                {{ $s->name }} {{ $size }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <!--/span-->

                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By status</label>
                                                    <select id="status" class="form-control chosen-select">
                                                        <option value="0">None</option>

                                                        <option value="{{ \App\Inventory::open }}">Open</option>
                                                        @role('admin')
                                                            <!-- <option  value="{{ \App\Inventory::hold_client }}">Client Hold</option> -->
                                                            <option value="{{ \App\Inventory::hold_company }}">Company Hold
                                                            </option>
                                                            <option value="{{ \App\Inventory::token_hold }}">Token Hold
                                                            </option>
                                                            <option value="{{ \App\Inventory::temp_hold }}">Temporary Hold
                                                            </option>
                                                        @endrole
                                                        <option value="{{ \App\Inventory::sold }}">Sold</option>

                                                    </select>
                                                </div>
                                            </div>
                                            <!--/span-->
                                        </div>

                                    </div>
                                    <div class="form-actions">
                                        <button type="button" class="btn btn-success search-customer"> <i
                                                class="fa fa-check"></i> Search</button>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row colorbox-group-widget">
                <div class="col-md-4 col-sm-6 info-color-box">
                    <div class="white-box">
                        <div class="media bg-primary">
                            <div class="media-body">
                                <h3 class="info-count">{{ number_format($total_units_count) }}<span class="pull-right"><i
                                            class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                <p class="info-text font-12">Total Units</p>
                                <p class="info-ot font-15"><span class="label "
                                        style="color:#58508d!important; background: #58508d!important">.</span></p>
                                <p class="info-ot font-15">Booked Units<span
                                        class="label label-rounded">{{ number_format($booked_units_count) }}</span></p>
                                <p class="info-ot font-15">Un-Booked Units<span
                                        class="label label-rounded">{{ number_format($un_booked_units_count) }}</span></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-6 info-color-box">
                    <div class="white-box">
                        <div class="media bg-success">
                            <div class="media-body">
                                <h3 class="info-count">{{ number_format($total_units_area) }} {{ env('SIZE') }}<span
                                        class="pull-right"><i class="mdi mdi-comment-text-outline"></i></span></h3>
                                <p class="info-text font-12">Total Area</p>
                                <p class="info-ot font-15"><span class="label "
                                        style="color:#bc5090!important; background: #bc5090!important">.</span></p>
                                <p class="info-ot font-15">Booked Area<span
                                        class="label label-rounded">{{ number_format($booked_units_area) }}
                                        {{ env('SIZE') }}</span></p>
                                <p class="info-ot font-15">Un-Booked Area<span
                                        class="label label-rounded">{{ number_format($un_booked_units_area) }}
                                        {{ env('SIZE') }}</span></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-6 info-color-box">
                    <div class="white-box">
                        <div class="media bg-danger">
                            <div class="media-body">
                                <h3 class="info-count">Rs. {{ number_format($total_units_amount) }} <span
                                        class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                                <p class="info-text font-12">Total Price</p>
                                <p class="info-ot font-15">Booked Price<span class="label label-rounded">Rs.
                                        {{ number_format($booked_units_amount) }} </span></p>
                                <p class="info-ot font-15">Un-Booked Price<span class="label label-rounded">Rs.
                                        {{ number_format($un_booked_units_amount) }} </span></p>
                                <p class="info-ot font-15">Discount<span class="label label-rounded">Rs.
                                        {{ number_format($booked_units_amount - $total_cost_booked_units) }} </span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <!-- /row -->
            <div class="row" id="update-table">
                <div class="col-sm-12">
                    <div class="white-box">
                        <!-- <div class="pull-right">
                                                    @permission('create-inventory')
        <a href="{{ route('inventory.add') }}" class="btn  btn-primary">
                                                                            <i class="fa fa-plus-square"></i>&nbsp; Add new Inventory
                                                                        </a>
    @endpermission
                                                </div> -->
                        <h3 class="box-title">All Inventories ({{ number_format($inventoryCount) }})</h3>

                        <div class="table-responsive">
                            <table id="myTable" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Sr #</th>
                                        <th>Project</th>
                                        <th>Unit #</th>
                                        <!-- <th>floor</th>
                                                                <th>Type</th> -->
                                        <th>Size</th>

                                        <th>Net Amount</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1; ?>
                                    @permission('view-inventory')
                                        <?php $view_inventory = true; ?>
                                    @else
                                        <?php $view_inventory = false; ?>
                                    @endpermission
                                    @permission('edit-inventory')
                                        <?php $edit_inventory = true; ?>
                                    @else
                                        <?php $edit_inventory = false; ?>
                                    @endpermission
                                    @permission('delete-inventory')
                                        <?php $delete_inventory = true; ?>
                                    @else
                                        <?php $delete_inventory = false; ?>
                                    @endpermission
                                    @role('admin')
                                        <?php $admin = true; ?>
                                    @else
                                        <?php $admin = false; ?>
                                    @endrole

                                    @foreach ($allInventories as $i)
                                        <tr>
                                            <td>{{ $count++ }}</td>
                                            <td>{{ $i->multiProject ? $i->multiProject->name : 'None' }}

                                            </td>
                                            <td>
                                                @permission('view-inventory')
                                                    <a
                                                        href="{{ route('inventory.detail', ['id' => $i->id]) }}">{{ $i->unit_number }}</a>
                                                @else
                                                    {{ $i->unit_number }}
                                                @endpermission

                                            </td>

                                            <td>{{ $i->size ? $i->size->name : '' }}
                                                {{ $size }}
                                            </td>
                                            <td>{{ number_format($i->total_price) }}</td>

                                            @if ($admin)
                                                @if ($i->status == \App\Inventory::open)
                                                    <td><span class="label label-success">Open</span></td>
                                                @elseif($i->status == \App\Inventory::package_open_file)
                                                    <td><span class="label label-success">Open/Dealer Package File</span></td>
                                                @elseif($i->status == \App\Inventory::package_open_file_refunded)
                                                    <td><span class="label label-success">Open/Dealer Package Refunded</span></td>
                                                @elseif($i->status == \App\Inventory::sold)
                                                    <td><span class="label label-danger">Sold</span></td>
                                                @elseif($i->status == \App\Inventory::hold_client)
                                                    <td><span class="label label-primary">Client Hold</span></td>
                                                @elseif($i->status == \App\Inventory::hold_company)
                                                    <td><span class="label label-primary">Company Hold</span></td>
                                                @elseif($i->status == \App\Inventory::token_hold)
                                                    <td><span class="label label-primary">Token Hold</span></td>
                                                @elseif($i->status == \App\Inventory::temp_hold)
                                                    <td><span class="label label-primary">Temporary Hold</span></td>
                                                @else
                                                    <td></td>
                                                @endif
                                            @else
                                                @if ($i->status == \App\Inventory::open)
                                                    <td><span class="label label-success">Open</span></td>
                                                @else
                                                    <td><span class="label label-danger">Sold</span></td>
                                                @endif
                                            @endif
                                            <td class="text-nowrap">
                                                @if ($view_inventory)
                                                    <a href="{{ route('inventory.detail', ['id' => $i->id]) }}"
                                                        data-toggle="tooltip" data-original-title="View"> <i
                                                            class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                @endif

                                                @if($i->status != \App\Inventory::package_open_file)
                                                @if ($edit_inventory)
                                                    <a href="{{ route('inventory.editView', ['id' => $i->id]) }}"
                                                        data-toggle="tooltip" data-original-title="Edit"> <i
                                                            class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endif
                                                @endif

                                                {{-- @if ($edit_inventory)
                                                <a href="#" data-toggle="tooltip" data-original-title="Update status "> <i class="fa fa-wrench text-inverse m-r-10"></i> </a>
                                                @endif --}}
                                                @if ($delete_inventory)
                                                    <a data-toggle="confirmation" data-title="Are you sure to delete?"
                                                        href="{{ route('inventory.delete', ['id' => $i->id]) }}"> <i
                                                            class="fa fa-close text-danger"></i> </a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                                
                            </table>
                            <div style="float: right;">{{ $allInventories->links() }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


    <script>
         $(function() {
                $('#myTable').DataTable({
                    'pageLength': 25,
                    'paging': false,
                    'searching': false,
                    'info': false,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });
            });
        function callItBack() {
           

            $('.search-customer').on('click', function() {
                $('.preloader').fadeIn();
                unit = $('#unit').val();
                floor = $('#floor').val();
                size = $('#size').val();
                status = $('#status').val();
                var selectValue = "";
                if ($("#multipro").length > 0) {
                     if($("#multipro").val() !== 'search'){
                    selectValue = $("#multipro").val();
                     }
                    // Do something with the value
                }


                if (unit == 0 && floor == 0 && size == 0 && status == 0) {
                    toastr.warning("please select any option.");
                    $('.preloader').fadeOut();
                    return false;
                }

                var data = {
                    'unit': unit,
                    'floor': floor,
                    'size': size,
                    'status': status,
                    'multipro_id': selectValue
                };

                $.get('/inventory/updateTable', data, function(data) {
                    document.getElementById('update-table').innerHTML = data;

                    $('#myTable').DataTable({
                        'pageLength': 50,
                        'paging': false,
                        'searching': false,
                        'info': true,
                        'dom': 'Bfrtip',
                        'buttons': [
                            'copy', 'csv', 'excel', 'pdf', 'print'
                        ]
                    });
                    toastr.success("Search updated.");


                    $('.preloader').fadeOut();
                });
            });
        }

        callItBack();
        function updateStatus(value) {
            $('.preloader').fadeIn();

            if (value === 'search') {

                $('.preloader').fadeOut();
                return false;
            }
            if (value == "") {
                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
            $.get('{{ route('inventory.all') }}', data, function(data) {
                $('.preloader').fadeOut();
                $('#myTable tbody').empty();

                $('.chosen-select').chosen('destroy');

                document.getElementById('updatecontent').innerHTML = data;
                $('.chosen-select').trigger('chosen:updated');
                callItBack();
                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': false,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });

                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });

        }
    </script>

@stop
