@extends('layouts.app')

@section('title')
    Inventory Status Sheet
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        @permission('list-inventory')
            <li><a href="{{ route('inventory.all') }}">All Inventories</a></li>
        @endpermission
        <li class="active">Inventory Sheet</li>
    </ol>
@stop

@section('css')

    <style type="text/css">
        td {
            text-align: center;
            border: 1px solid;
        }

        .popover {
            width: 184px !important;
        }

        th {
            border: 1px solid;
        }

        table {
            display: block;
            overflow-x: auto;
            white-space: nowrap;
        }
    </style>

@stop
@section('content')

    @php
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    @endphp

    @php
        $map = ' ';
        
        if ($projectType->id == \App\ProjectType::society) {
            $map = \App\ProjectType::society_map;
        } else {
            $map = \App\ProjectType::high_rise_map;
        }
        
    @endphp


    <div class="container-fluid">

        <!--.row-->
        <div class="row">
            <div class="col-md-12" style="margin-bottom: 10px;">
                <div class="panel panel-info">
                    <div class="panel-heading " style="text-align: center;">Inventory Status Sheet</div>
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        @can('isSuperAdmin')
                        @include('partial.multiproject_select')
                          @endcan
                        <div id='inventory_table'>
                        <div class="panel-body">

                            <div class="col-lg-12">
                              
                                <h3 class="box-title m-b-0">Inventory Info</h3>
                               
                                <p class="text-muted m-b-30"></p>
                                <div class="demo-popover">
                                    <button type="button" class="btn btn-primary popover-default sr-only"> Primary
                                    </button>
                                    <div class="popover top" style="margin-right:0px !important;">
                                        <div class="arrow"></div>
                                        <h3 class="popover-title" style="    font-size: 12px;">Open</h3>
                                        <div class="popover-content">
                                            <p class="info-ot " style="font-size:11px;"><b>Inventory count &nbsp;</b><span
                                                    class="label label-rounded">{{ $openInventoryCount }}</span></p>
                                            <p style="font-size:11px;"><b>Inventory Value:</b>
                                                {{ number_format($openInventoryAmount) }}</p>
                                            <p style="font-size:11px;"><b>Color: &nbsp;</b> <span class="clor"
                                                    style="background-color:white"></span></p>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-primary popover-primary sr-only"> Primary
                                    </button>
                                    <div class="popover top" style="margin-right:0px !important;">
                                        <div class="arrow"></div>
                                        <h3 class="popover-title" style="    font-size: 12px;">Token Hold</h3>
                                        <div class="popover-content">
                                            <p class="info-ot " style="font-size:11px;"><b>Inventory count &nbsp;</b><span
                                                    class="label label-rounded">{{ $tokenHoldInventoryCount }}</span></p>
                                            <p style="font-size:11px;"><b>Inventory Value:</b>
                                                {{ number_format($tokenHoldInventoryAmount) }}</p>
                                            <p style="font-size:11px;"><b>Color: &nbsp;</b> <span class="clor"
                                                    style="background-color: #0283cc;"></span></p>
                                        </div>
                                    </div>

                                    <button type="button" class="btn btn-primary popover-primary sr-only"
                                        style="background-color:#b1d3e7;"> Primary </button>
                                    <div class="popover top" style="margin-right:0px !important;">
                                        <div class="arrow"></div>
                                        <h3 class="popover-title" style="background-color: #b1d3e7;font-size: 12px;">
                                            Temporary Hold</h3>
                                        <div class="popover-content">
                                            <p class="info-ot " style="font-size:11px;"><b>Inventory count &nbsp;</b><span
                                                    class="label label-rounded">{{ $tempHoldInventoryCount }}</span></p>
                                            <p style="font-size:11px;"><b>Inventory Value:</b>
                                                {{ number_format($tempHoldInventoryAmount) }}</p>
                                            <p style="font-size:11px;"><b>Color: &nbsp;</b> <span class="clor"
                                                    style="background-color: #b1d3e7;"></span></p>
                                        </div>
                                    </div>

                                    <button type="button" class="btn btn-primary popover-info sr-only"> Primary </button>
                                    <div class="popover top" style="margin-right:0px !important;">
                                        <div class="arrow"></div>
                                        <h3 class="popover-title" style="    font-size: 12px;"> Company Hold </h3>
                                        <div class="popover-content">
                                            <p class="info-ot " style="font-size:11px;"><b>Inventory count &nbsp;</b><span
                                                    class="label label-rounded">{{ $companyHoldInventoryCount }}</span></p>
                                            <p style="font-size:11px;"><b>Inventory Value:</b>
                                                {{ number_format($companyHoldInventoryAmount) }}</p>
                                            <p style="font-size:11px;"><b>Color: &nbsp;</b> <span class="clor"
                                                    style="background-color: #1c3752;"></span></p>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-success popover-success sr-only"> Primary
                                    </button>
                                    <div class="popover top" style="margin-right:0px !important;">
                                        <div class="arrow"></div>
                                        <h3 class="popover-title"
                                            style="    background-color: green !important ;    font-size: 12px;"> Sold </h3>
                                        <div class="popover-content">
                                            <p class="info-ot" style="font-size:11px;"><b>Inventory count &nbsp;</b><span
                                                    class="label label-rounded">{{ $soldInventoryCount }}</span></p>
                                            <p style="font-size:11px;"><b>Inventory Value:</b>
                                                {{ number_format($soldInventoryAmount) }}</p>
                                            <p style="font-size:11px;"><b>Color: &nbsp;</b> <span class="clor"
                                                    style="background-color: green"></span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <br>
                            <br>



                            <label><b>Categories : </b>
                                @foreach ($categories as $c)
                                    <span class="label label-rounded"><i class="fa {{ $categoryIcon[$c->id] }}"></i>
                                        &nbsp;{{ $c->name }}</span>
                                @endforeach
                            </label>
                          
                            <table style="border: 1px solid black;" >


                                <?php $c = 0; ?>
                                <tr>

                                    @foreach ($inventories as $i)
                                        @if ($i->unit_floor_id == $c)
                                            @if ($i->status == \App\Inventory::open || $i->status == \App\Inventory::package_open_file)
                                                <td style="border: 1px solid black;    padding: 10px 10px;">

                                                    @foreach ($i->categories as $ca)
                                                        @if ($loop->last)
                                                            <i
                                                                class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i><br>
                                                        @else
                                                            <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i>
                                                        @endif
                                                    @endforeach


                                                    <a href="#"
                                                        onclick="updateModal({{ $i->id }})">{{ $i->unit_number }}</a>
                                                    <br>

                                                </td>
                                            @elseif($i->status == \App\Inventory::sold)
                                                <td
                                                    style="background-color: green; border: 1px solid black;  color: white;  padding: 10px 10px;">
                                                    @foreach ($i->categories as $ca)
                                                        @if ($loop->last)
                                                            <i
                                                                class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i><br>
                                                        @else
                                                            <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i>
                                                        @endif
                                                    @endforeach
                                                    <a href="#" onclick="updateModal({{ $i->id }})"
                                                        style="color: white;">{{ $i->unit_number }}</a>
                                                </td>
                                            @elseif($i->status == \App\Inventory::token_hold)
                                                <td
                                                    style=" background-color: #0283cc; border: 1px solid black;color: white;    padding: 10px 10px;">
                                                    @foreach ($i->categories as $ca)
                                                        @if ($loop->last)
                                                            <i
                                                                class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i><br>
                                                        @else
                                                            <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i>
                                                        @endif
                                                    @endforeach
                                                    <a href="#" onclick="updateModal({{ $i->id }})"
                                                        style="color: white;">{{ $i->unit_number }}</a>
                                                </td>
                                            @elseif($i->status == \App\Inventory::temp_hold)
                                                <td
                                                    style=" background-color: #b1d3e7; border: 1px solid black;color: white;    padding: 10px 10px;">
                                                    @foreach ($i->categories as $ca)
                                                        @if ($loop->last)
                                                            <i
                                                                class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i><br>
                                                        @else
                                                            <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i>
                                                        @endif
                                                    @endforeach
                                                    <a href="#" onclick="updateModal({{ $i->id }})"
                                                        style="color: white;">{{ $i->unit_number }}</a>
                                                </td>
                                            @elseif($i->status == \App\Inventory::hold_company)
                                                <td
                                                    style="background-color: #1c3752; border: 1px solid black;color: white;    padding: 10px 10px;">
                                                    @foreach ($i->categories as $ca)
                                                        @if ($loop->last)
                                                            <i
                                                                class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i><br>
                                                        @else
                                                            <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i>
                                                        @endif
                                                    @endforeach
                                                    <a href="#" onclick="updateModal({{ $i->id }})"
                                                        style="color: white;">{{ $i->unit_number }}</a>
                                                </td>
                                            @endif
                                        @else
                                </tr>
                                <tr>
                                    <td
                                        style="background-color: #080b12;;border: 1px solid #fff;    padding: 10px 10px;color: #fff;">
                                        <b>{{ $i->floor ? $i->floor->name : '' }} -
                                            {{ $i->floor->unitBlock ? $i->floor->unitBlock->name : '' }}</b><br>
                                        <small>
                                            @if (isset($floorSqft[$i->unit_floor_id]) && isset($floorValue[$i->unit_floor_id]))
                                                {{ $floorSqft[$i->unit_floor_id] }} {{ $size }} ,
                                                Rs.{{ number_format($floorValue[$i->unit_floor_id]) }}
                                        </small><br>
                                        @endif
                                        <small>
                                            @if (isset($floorSoldPer[$i->unit_floor_id]) && isset($floorSoldPer[$i->unit_floor_id]))
                                                Availability : {{ 100 - $floorSoldPer[$i->unit_floor_id] }} %
                                                &nbsp;&nbsp;&nbsp;&nbsp; Sold : {{ $floorSoldPer[$i->unit_floor_id] }} %
                                            @endif
                                        </small>

                                    </td>
                                    @if ($i->status == \App\Inventory::open || $i->status == \App\Inventory::package_open_file)
                                        <td style="border: 1px solid black;    padding: 10px 10px;">
                                            @foreach ($i->categories as $ca)
                                                @if ($loop->last)
                                                    @if (isset($categoryIcon[$ca->unit_category_id]))
                                                        <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i><br>
                                                    @endif
                                                @else
                                                    @if (isset($categoryIcon[$ca->unit_category_id]))
                                                        <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i>
                                                    @endif
                                                @endif
                                            @endforeach

                                            <a href="#"
                                                onclick="updateModal({{ $i->id }})">{{ $i->unit_number }}</a>


                                        </td>
                                    @elseif($i->status == \App\Inventory::sold)
                                        <td
                                            style="background-color: green; border: 1px solid black; color: white;    padding: 10px 10px;">
                                            @foreach ($i->categories as $ca)
                                                @if ($loop->last)
                                                    @if (isset($categoryIcon[$ca->unit_category_id]))
                                                        <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i><br>
                                                    @endif
                                                @else
                                                    @if (isset($categoryIcon[$ca->unit_category_id]))
                                                        <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i>
                                                    @endif
                                                @endif
                                            @endforeach
                                            <a href="#" onclick="updateModal({{ $i->id }})"
                                                style="color: white;">{{ $i->unit_number }}</a>
                                        </td>
                                    @elseif($i->status == \App\Inventory::token_hold)
                                        <td
                                            style=" background-color: #0283cc; border: 1px solid black;color: white;    padding: 10px 10px;">
                                            @foreach ($i->categories as $ca)
                                                @if ($loop->last)
                                                    <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i><br>
                                                @else
                                                    <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i>
                                                @endif
                                            @endforeach
                                            <a href="#" onclick="updateModal({{ $i->id }})"
                                                style="color: white;">{{ $i->unit_number }}</a>
                                        </td>
                                    @elseif($i->status == \App\Inventory::temp_hold)
                                        <td
                                            style=" background-color: #b1d3e7; border: 1px solid black;color: white;    padding: 10px 10px;">
                                            @foreach ($i->categories as $ca)
                                                @if ($loop->last)
                                                    <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i><br>
                                                @else
                                                    <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i>
                                                @endif
                                            @endforeach
                                            <a href="#" onclick="updateModal({{ $i->id }})"
                                                style="color: white;">{{ $i->unit_number }}</a>
                                        </td>
                                    @elseif($i->status == \App\Inventory::hold_company)
                                        <td
                                            style="background-color: #1c3752; border: 1px solid black; color: white;   padding: 10px 10px;">
                                            @foreach ($i->categories as $ca)
                                                @if ($loop->last)
                                                    <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i><br>
                                                @else
                                                    <i class="fa {{ $categoryIcon[$ca->unit_category_id] }}"></i>
                                                @endif
                                            @endforeach
                                            <a href="#" onclick="updateModal({{ $i->id }})"
                                                style="color: white;">{{ $i->unit_number }}</a>
                                        </td>
                                    @endif
                                    <?php $c = $i->unit_floor_id; ?>
                                    @endif


                                    @endforeach
                                </tr>
                            </table>
                           




                        </div>
                        </div>
                    </div>
                </div>
            </div>



        </div>
        <!--./row-->




    </div>
    <!-- /.container-fluid -->

    <div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">

    </div>

@stop

@section('js')
    <script>
        function updateModal(id) {

            data = {
                'id': id
            };

            $.get('/inventory-status-sheet/modal', data, function(data) {

                document.getElementById('exampleModal1').innerHTML = data;

                $('#exampleModal1').modal('toggle');

                // toastr.success(" up Updated.");

            });
        }

        function updateStatus(value){
            $('.preloader').fadeIn();
            
            if (value === 'search') {
             
                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
            $.get('{{route("inventory.sheet")}}', data, function(data) {
                $('.preloader').fadeOut();
                document.getElementById('inventory_table').innerHTML = data;

              
                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });
        }
        
    </script>

@stop
