@extends('layouts.app')


@section('title')
Add New Merging 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('merging-properties')
        <li ><a href="{{route('merging.properties.list')}}">All Merging</a></li>
        @endpermission
        <li class="active">Add Merging</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                         @if($errors->any())
                        <div class="white-box1"><h2>Errors</h2><ul>
    {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
</ul></div>@endif
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> MERGING PROPERTY ASSESSMENT FORM: MR - 002</h3>
                            <p class="text-muted m-b-30 font-13"> </p>
                            <form class="form-horizontal" action="{{route('merging.properties')}}" method="post" autocomplete="off">
                               {{csrf_field()}}
                               
                               <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">Select Merging Requisition <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-world"></i></div>
                                            <select class="form-control chosen-select"  name="mrf_no_id" onchange="return getForData(this)">
                                                <option value="" selected="">None</option>
                                                @foreach($merging_properties as $m)
                                                <option value="{{$m->id}}">{{$m->mrf_no}}</option>
                                                @endforeach
                                            </select>
                                        @if ($errors->has('mrf_no'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('mrf_no') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">MRF No <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="mrf_no" value="{{old('mrf_no')}}" readonly id="mrf_no" placeholder="Enter mrf no">
                                        @if ($errors->has('mrf_no'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('mrf_no') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">MAF No <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-lock"></i></div>
                                            <input  type="text" class="form-control" name="maf_no" readonly value="@if(old('maf_no')) {{old('maf_no')}}@else {{'MAF-'.rand(100,999)}}@endif"  id="maf_no" placeholder="Enter Code">
                                        @if ($errors->has('maf_no'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('maf_no') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                

                                <div class="form-group">
                                    <label for="cnic" class="col-sm-2 control-label">Property Code <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                            <input type="text"  class="form-control" readonly value="@if(old('property_code')) {{old('property_code')}}@else {{rand(1000,9999)}}@endif" name="property_code" id="property_code"   placeholder="Property Code"  >

                                    
                                            @if ($errors->has('property_code'))
                                            <span class="help-block">
                                            <strong>{{ $errors->first('property_code') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                 <div class="form-group">
                                    <label for="cnic" class="col-sm-2 control-label">Requested By <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                            <input type="text"  class="form-control" readonly value="{{old('requested_by')}}" name="requested_by" id="requested_by"   placeholder="Requested By"  >

                                    
                                            @if ($errors->has('requested_by'))
                                            <span class="help-block">
                                            <strong>{{ $errors->first('requested_by') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label">Contact No  <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="text" class="form-control" name="contact_no" readonly value="{{old('contact_no')}}" id="contact_no" placeholder="Enter contact no">
                                @if ($errors->has('contact_no'))
                                <span class="help-block">
                                <strong>{{ $errors->first('contact_no') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label">Sale Agent Name  <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="text" class="form-control" name="sale_agent_name" readonly id="sale_agent_name" value="{{old('sale_agent_name')}}" placeholder="Enter sale agent name">
                                @if ($errors->has('sale_agent_name'))
                                <span class="help-block">
                                <strong>{{ $errors->first('sale_agent_name') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                
                                
                                
                                 <div class="form-group">
                                <label for="address" class="col-sm-2 control-label">Country <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="text" class="form-control" name="country_id" id="country_id" value="{{old('country_id')}}" readonly>
                                @if ($errors->has('country_id'))
                                <span class="help-block">
                                <strong>{{ $errors->first('country_id') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                
                                
                                
                                 <div class="form-group">
                                <label for="address" class="col-sm-2 control-label">City <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="hidden"  name="city" id="city_hidden_id">
                                <input  type="text" class="form-control"  id="city_id" value="{{old('city_id')}}" readonly>
                                @if ($errors->has('city_id'))
                                <span class="help-block">
                                <strong>{{ $errors->first('city_id') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                
                    
                                <div class="form-group">
                                <label for="address" class="col-sm-2 control-label">Location/ Housing Society/ Town:  <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                <input type="text" class="form-control" name="address" readonly value="{{old('address')}}" id="address" placeholder="Enter Address">
                                @if ($errors->has('address'))
                                <span class="help-block">
                                <strong>{{ $errors->first('address') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                
                                
                                
                                 <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-2 control-label">Street   <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-email"></i></div>
                                            <input type="text"  class="form-control" name="street" readonly value="{{old('street')}}" id="street" placeholder="Enter street">
                                        @if ($errors->has('street'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('street') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-2 control-label">Phase/ Mohalla   <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-key"></i></div>
                                            <input type="text"  class="form-control" name="phase" readonly value="{{old('phase')}}" id="phase" placeholder="Enter phase">
                                        @if ($errors->has('phase'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phase') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Area  <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="area" readonly value="{{old('area')}}" id="area" placeholder="Enter area">
                                @if ($errors->has('area'))
                                <span class="help-block">
                                <strong>{{ $errors->first('area') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Demand for property:  <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' readonly name="demand_for_property" id="demand_for_property" value="{{old('demand_for_property')}}"  placeholder="Enter demand for property">
                                @if ($errors->has('demand_for_property'))
                                <span class="help-block">
                                <strong>{{ $errors->first('demand_for_property') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Merging Value (As per Client):  <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="merging_value" value="{{old('merging_value')}}"  placeholder="Enter merging value">
                                @if ($errors->has('merging_value'))
                                <span class="help-block">
                                <strong>{{ $errors->first('merging_value') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Merging Assessed Value:   <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="merging_assessed_value" value="{{old('merging_assessed_value')}}"  placeholder="Enter merging assessed value">
                                @if ($errors->has('merging_assessed_value'))
                                <span class="help-block">
                                <strong>{{ $errors->first('merging_assessed_value') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Assessment appraised by:   <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="appraised_by" value="{{old('appraised_by')}}"  placeholder="Enter appraised by">
                                @if ($errors->has('appraised_by'))
                                <span class="help-block">
                                <strong>{{ $errors->first('appraised_by') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Over assessment Amount:   <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="assessment_amount" value="{{old('assessment_amount')}}"  placeholder="Enter assessment amount">
                                @if ($errors->has('assessment_amount'))
                                <span class="help-block">
                                <strong>{{ $errors->first('assessment_amount') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                 <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Any other Details:   </label>
                                <div class="col-sm-10">
                              
                                <textarea class="form-control" name="details" readonly id="details" rows="4">{{old('details')}} </textarea>
                             
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Over assessment by Sales Agent:    <span style="color: red">*</span></label>
                                <div class="col-sm-5">
                                    
                               
                                 <span  style="position: relative;top: 3rem;left: 10rem;font-size: 16px;font-weight: 800;">   YES :</span>  <input type="radio" class="form-control" checked   name="appraised_by_sale_agent" value="yes"  >
                                    
                             
                                </div>
                                
                                <div class="col-sm-5">
                                    
                               
                                <span  style="position: relative;top: 3rem;left: 10rem;font-size: 16px;font-weight: 800;">   NO : </span> <input type="radio" class="form-control "   name="appraised_by_sale_agent" value="no"  >
                                    
                             
                                </div>
                                
                                @if ($errors->has('appraised_by_sale_agent'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('appraised_by_sale_agent') }}</strong>
                                    </span>
                                    @endif
                                    
                                </div>
                                
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">In case of Loss in merging, over Assessment to be adjusted against:   <span style="color: red">*</span> </label>
                                <div class="col-sm-5">
                                    
                               
                                  <span  style="position: relative;top: 3rem;left: 10rem;font-size: 16px;font-weight: 800;"> Rebate : </span><input type="radio" class="form-control" checked  name="assessment_adjusted_against" value="rebate"  >
                                    
                             
                                </div>
                                
                                <div class="col-sm-5">
                                    
                               
                                 <span  style="position: relative;top: 3rem;left: 10rem;font-size: 16px;font-weight: 800;">  Cash:  </span><input type="radio" class="form-control"   name="assessment_adjusted_against" value="cash"  >
                                    
                             
                                </div>
                                
                                @if ($errors->has('assessment_adjusted_against'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('assessment_adjusted_against') }}</strong>
                                    </span>
                                    @endif
                                    
                                </div>
                                

                                    
                               
                                <div class=" col-sm-4">&nbsp;</div>
                                <div class=" col-sm-4">
                                 <div class="form-group">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop


@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
function getForData(self)
{
    if($(self).val() > 0)
    {
        $.ajax({
            url:"{{ route('get.requisition') }}",
            method:'GET',
            dataType:'json',
            data: {id:$(self).val()},
            success:function(data)
            {
                
                $('#mrf_no').val(data.output.mrf_no)
            $('#requested_by').val(data.output.requested_by)
                $('#contact_no').val(data.output.contact_no)
                $('#sale_agent_name').val(data.output.sale_agent_name)
                $('#country_id').val('Pakistan') 
                
                $('#city_id').val(data.city.name)
                $('#city_hidden_id').val(data.city.id)
                $('#address').val(data.output.address) 
                $('#street').val(data.output.street)
                
                $('#phase').val(data.output.phase)
                $('#area').val(data.output.area)
                
                $('#demand_for_property').val(data.output.demand_for_property)
                
                $('#details').val(data.output.details)
                  
            }
            })
    }
    else
    {
        location.reload(true)
    }
        
    return false;
}
         function validateCnic(self) 
        {
           var cnic = $(self).val().replaceAll('-', '');

        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('validate.dnfbp.cnic') }}",
        method:'POST',
        dataType:'json',
        data: {cnic:cnic},
        success:function(data)
        {
          if (data.response == 'invalid') 
          {
                $(self).closest('.input-group').find('#cnic_error1').show();
          }

        }
        })



        return false;
        }


    $(":input").inputmask();
$('#country_id').change(function() {
    $('.preloader').fadeIn();
        var data = { 'country_id': $(this).val() };

        $.get('/getCitiesByCountry', data, function (data) {
           var model = $('#city_id');
                    model.empty();

                     model.append("<option value='' disabled selected>" + '' + "</option>");


                    $.each(data, function(index, element) {
                        model.append("<option value='"+ element.id +"'>" + element.name + "</option>");
                    });
        });
         $('.preloader').fadeOut();
    });

function percentCheckbox() {

        if($('#rebate_in_percent').prop("checked") == false) {
            document.getElementById('rebate_input').innerHTML = 'PKR';
        }
        else {
            document.getElementById('rebate_input').innerHTML = '%';
        }
    }
   </script>
@stop