@extends('layouts.app')

@section('title')
All Merging Properties
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Merging Properties</li>
      </ol>
@stop

@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('merging-properties')
                                <!-- <a href="{{route('merging.properties')}}" class="btn  btn-default">-->
                                <!--    <i class="fa fa-plus-square"></i>&nbsp; Add Merging Property-->
                                <!--</a> -->
                                @endpermission
                                
							</div>
                            <h3 class="box-title">All Merging Properties</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>MRF No</th>
                                            <th>MAF No</th>
                                            <th>Property Code</th>
                                            <th>Demand </th>
                                            <th>Value (As per Client)</th>
                                            <th> Assessed value </th>
                                            <th>Assessment Amount</th>
                                            

                                            <th>View Merging</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                      
                                        @foreach($merging_properties as $merging_property)
                                        <tr>
                                            
                                            
                                            <td>{{$count++}}</td>
                                            
                                            <td><b>{{$merging_property->mrf_no}} </b></td>
                                            
                                            <td>{{$merging_property->maf_no}} </td>
                                            
                                            <td>{{$merging_property->property_code}} </td>
                                            
                                            <td><b>{{$merging_property->demand_for_property}} PKR</b></td>
                                            
                                            <td>{{$merging_property->demand_for_property}} PKR</td>
                                            
                                            <td>{{$merging_property->merging_assessed_value}} PKR</td>
                                            
                                            <td>{{$merging_property->assessment_amount}} PKR</td>
                                            
                                            <td class="text-nowrap">
                                            
                                            <a href="{{route('merging.properties.form' , [$merging_property->id])}}" data-toggle="tooltip" data-original-title="View" class="btn btn-primary btn-sm">  Assesment </a>
                                            
                                             <a href="{{route('merging.properties.form.requisition' , [$merging_property->id])}}" data-toggle="tooltip" data-original-title="View" class="btn btn-success btn-sm">  Requisition </a>
                                            
                                            </td>
                                            
                                            
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>
@stop