@extends('layouts.app')


@section('title')
Add New Merging 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('merging-properties')
        <li ><a href="{{route('merging.properties.list')}}">All Merging</a></li>
        @endpermission
        <li class="active">Add Merging</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        @if($errors->any())
                        <div class="white-box1"><h2>Errors</h2><ul>
                        {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                        </ul></div>
                        @endif
                        <div class="white-box">
                            <h3 class="box-title m-b-0"> MERGING PROPERTY REQUISITION ASSESSMENT FORM: MR - 001</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" action="{{route('merging.properties.requisition')}}" method="post" autocomplete="off">
                               {{csrf_field()}}
                               
                               
                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label">MRF No <span style="color: red">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="text" class="form-control" name="mrf_no" value="MRF-000{{ \App\MergingProperty::count() + 1 }}" id="exampleInputuname" placeholder="Enter mrf  no">
                                @if ($errors->has('mrf_no'))
                                <span class="help-block">
                                <strong>{{ $errors->first('mrf_no') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                <div class="form-group">
                                    <label for="cnic" class="col-sm-2 control-label">Requested By <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                            <input type="text"  class="form-control" value="{{old('requested_by')}}" name="requested_by" id="requested_by"   placeholder="Requested By"  >

                                    
                                            @if ($errors->has('requested_by'))
                                            <span class="help-block">
                                            <strong>{{ $errors->first('requested_by') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label">Contact No  <span style="color: red">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="number" class="form-control" name="contact_no"  onKeyPress="if(this.value.length==11) return false;" value="{{old('contact_no')}}" placeholder="Enter contact no">
                                @if ($errors->has('contact_no'))
                                <span class="help-block">
                                <strong>{{ $errors->first('contact_no') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">Sale Agent Name <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-world"></i></div>
                                            <select class="form-control chosen-select" id="sale_agent_name" name="sale_agent_name">
                                            <option value="" selected="">None</option>
                                            @foreach($dealers as $d)
                                            <option value="{{$d->name}}">{{$d->name}}</option>
                                            @endforeach
                                            </select>
                                            @if ($errors->has('sale_agent_name'))
                                            <span class="help-block">
                                            <strong>{{ $errors->first('sale_agent_name') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                </div>
                                        
                                
                                

                                <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">Country <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-world"></i></div>
                                            <select class="form-control chosen-select" id="country_id" name="country_id">
                                            <option value="" selected="">None</option>
                                            @foreach($countries as $c)
                                            <option value="{{$c->id}}">{{$c->name}}</option>
                                            @endforeach
                                            </select>
                                            @if ($errors->has('country_id'))
                                            <span class="help-block">
                                            <strong>{{ $errors->first('country_id') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">City <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                            <select class="form-control chosen-select" id="city_id" name="city">
                                                <option value="" selected="">None</option>

                                            </select>
                                        @if ($errors->has('city_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('city_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                </div>


                                <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">Location/ Housing Society/ Town:  <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                            <input type="text" class="form-control" name="address" value="{{old('address')}}" id="address1" placeholder="Enter Address">
                                        @if ($errors->has('address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('address') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-2 control-label">Street  <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-email"></i></div>
                                            <input type="text"  class="form-control" name="street" value="{{old('street')}}" id="exampleInputEmail1" placeholder="Enter street">
                                        @if ($errors->has('street'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('street') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                
                                </div>
                                
                            
                                
                                
                                <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-2 control-label">Phase/ Mohalla  <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-key"></i></div>
                                            <input type="text"  class="form-control" name="phase" value="{{old('phase')}}" id="exampleInputEmail1" placeholder="Enter phase">
                                        @if ($errors->has('phase'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phase') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Area  <span style="color: red">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="area" value="{{old('area')}}"  placeholder="Enter area">
                                @if ($errors->has('area'))
                                <span class="help-block">
                                <strong>{{ $errors->first('area') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                </div>
                                
                                
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Demand for property:  <span style="color: red">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="demand_for_property" value="{{old('demand_for_property')}}"  placeholder="Enter demand for property">
                                @if ($errors->has('demand_for_property'))
                                <span class="help-block">
                                <strong>{{ $errors->first('demand_for_property') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Employee Id:  <span style="color: red">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="employee_id" value="{{old('employee_id')}}"  placeholder="Enter employee id">
                                @if ($errors->has('employee_id'))
                                <span class="help-block">
                                <strong>{{ $errors->first('employee_id') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                </div>
                                 
                                
                                 <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Any other Details:   </label>
                                <div class="col-sm-4">
                              
                                <textarea class="form-control" name="details" rows="4">{{old('details')}} </textarea>
                             
                                </div>
                                </div>
                                
                                
                                
                                <h3 class="box-title m-b-0"> Visit Details: </h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            
                                
                                
                               <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Visit Time  <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="datetime-local" class="form-control"  type='text' name="visit_time" value="{{old('visit_time')}}"  placeholder="Enter visit time">
                                @if ($errors->has('visit_time'))
                                <span class="help-block">
                                <strong>{{ $errors->first('visit_time') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Contact Person at Location:  <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' name="contact_person_at_location" value="{{old('contact_person_at_location')}}"  placeholder="Enter contact person at location">
                                @if ($errors->has('contact_person_at_location'))
                                <span class="help-block">
                                <strong>{{ $errors->first('contact_person_at_location') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Contact No:  <span style="color: red">*</span></label>
                                <div class="col-sm-10">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='number'  onKeyPress="if(this.value.length==11) return false;" name="contact_person_no" value="{{old('contact_person_no')}}"  placeholder="Enter contact no">
                                @if ($errors->has('contact_person_no'))
                                <span class="help-block">
                                <strong>{{ $errors->first('contact_person_no') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Requestor accompanied:    <span style="color: red">*</span></label>
                                <div class="col-sm-5">
                                    
                               
                                  <span  style="position: relative;top: 3rem;left: 10rem;font-size: 16px;font-weight: 800;"> Yes : </span><input type="radio" class="form-control" checked  name="requestor_accompanied" value="yes" style="width: 20px;margin-left: 50%;">
                                    
                             
                                </div>
                                
                                <div class="col-sm-5">
                                    
                               
                                 <span  style="position: relative;top: 3rem;left: 10rem;font-size: 16px;font-weight: 800;">  No:  </span><input type="radio" class="form-control"   name="requestor_accompanied" value="no" style="width: 20px;margin-left: 50%;">
                                    
                             
                                </div>
                                
                                @if ($errors->has('requestor_accompanied'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('requestor_accompanied') }}</strong>
                                    </span>
                                    @endif
                                    
                                </div>
                                

                                    
                               
                                <div class=" col-sm-4">&nbsp;</div>
                                <div class=" col-sm-4">
                                 <div class="form-group">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop


@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>

         function validateCnic(self) 
        {
           var cnic = $(self).val().replaceAll('-', '');

        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('validate.dnfbp.cnic') }}",
        method:'POST',
        dataType:'json',
        data: {cnic:cnic},
        success:function(data)
        {
          if (data.response == 'invalid') 
          {
                $(self).closest('.input-group').find('#cnic_error1').show();
          }

        }
        })



        return false;
        }


    $(":input").inputmask();
$('#country_id').change(function() {
    $('.preloader').fadeIn();
        var data = { 'country_id': $(this).val() };

        $.get('/getCitiesByCountry', data, function (data) {
           var model = $('#city_id');
                    model.empty();

                     model.append("<option value='' disabled selected>" + '' + "</option>");


                    $.each(data, function(index, element) {
                        model.append("<option value='"+ element.id +"'>" + element.name + "</option>");
                    });
                    
                     $('#city_id').trigger("chosen:updated");
        });
         $('.preloader').fadeOut();
    });

function percentCheckbox() {

        if($('#rebate_in_percent').prop("checked") == false) {
            document.getElementById('rebate_input').innerHTML = 'PKR';
        }
        else {
            document.getElementById('rebate_input').innerHTML = '%';
        }
    }
   </script>
@stop