@extends('layouts.app') 

@section('title') Payment Receipt @stop 

@section('css')
<style type="text/css">
/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

.container-fluid {
    padding: 3px 30px 0;
}

@media print {
    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    h3 {
        margin: 0;
        line-height: 1;
    }
    .white-box {
        border: none !important;
    }
}
</style> 
@stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer')
    <li><a href="#">Payment Receipt</a></li> 
    @endpermission
    <li class="active">Receipt Detail</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>

                
        <div class="col-lg-12">
            <div class="white-box">
                <br>
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                   <div class="col-md-1"></div>
                    <div class="col-md-10">
                        <div class="col-md-12">
                            
                            <h3><strong><u>MERGING PROPERTY REQUISITION ASSESSMENT FORM:  </u> MR - 001</strong></h3>
                            
                            <hr style="border-top: 3px solid #4a5256;">
                            
                            <p>MRF No. <span style="display: inline-block; width:20%; border-bottom: 1px solid #4a5256;">{{$merging_property->mrf_no}}</span> </p>
                            
                            <p>Requested By:  <span style="display: inline-block; width:40%; border-bottom: 1px solid #4a5256;">{{$merging_property->requested_by	}}</span></p>
                            
                            <p>Contact No:  <span style="display: inline-block; width:40%; border-bottom: 1px solid #4a5256;">{{$merging_property->contact_no	}}</span></p>
                            
                            
                            
                            <p><strong>Property Details:</strong> </p>
                            
                            <p>City: <span style="display: inline-block; width:25%; border-bottom: 1px solid #4a5256;">{{$merging_property->city_name->name	}}</span></p>
                            
                        </div>
                        
                        <div class="col-md-4">
                            <p>Location/ Housing Society/ Town: </p>
                        </div>
                        <div class="col-md-8">
                            <p style="border-bottom: 1px solid #4a5256;">{{$merging_property->address	}}</p>
                        </div>
                        
                        <div class="col-md-1">
                            <p>Street: </p>
                        </div>
                        <div class="col-md-11">
                            <p style="border-bottom: 1px solid #4a5256;">{{$merging_property->street	}}</p>
                        </div>
                        
                        <div class="col-md-2">
                            <p>Phase/ Mohalla:  </p>
                        </div>
                        <div class="col-md-10">
                            <p style="border-bottom: 1px solid #4a5256;">{{$merging_property->phase	}}</p>
                        </div>
                        
                        <div class="col-md-4">
                            <p>Covered Area in case of Houses:  </p>
                        </div>
                        <div class="col-md-8">
                            <p style="border-bottom: 1px solid #4a5256;">{{$merging_property->area	}}</p>
                        </div>
                        
                        <div class="col-md-3">
                            <p>Demand for property:  </p>
                        </div>
                        <div class="col-md-9">
                            <p style="border-bottom: 1px solid #4a5256;">{{$merging_property->demand_for_property	}}</p>
                        </div>
                        
                        
                        
                        <div class="col-md-12">
                            
                            <p>Any other Details: </p>
                            
                            <p style="border-bottom: 1px solid #4a5256;">{{$merging_property->details	}}</p>
                            
                            <p>Sales Agent Name:   <span style="display: inline-block; width:40%; border-bottom: 1px solid #4a5256;">{{$merging_property->sale_agent_name	}}</span></p>
                            
                            <p>Employee Id:   <span style="display: inline-block; width:40%; border-bottom: 1px solid #4a5256;">{{$merging_property->employee_id	}}</span></p>
                            
                            <p>Signature:   <span style="display: inline-block; width:40%; border-bottom: 1px solid #4a5256;">&nbsp;</span></p>
                            
                            <p><strong>Visit Details:</strong> </p>
                            
                            <p>Visit Time:  <span style="display: inline-block; width:25%; border-bottom: 1px solid #4a5256;">{{$merging_property->visit_time	}}</span></p>
                            
                            <p>Contact Person at Location:  <span style="display: inline-block; width:25%; border-bottom: 1px solid #4a5256;">{{$merging_property->contact_person_at_location	}}</span></p>
                            
                            <p>Contact No:  <span style="display: inline-block; width:25%; border-bottom: 1px solid #4a5256;">{{$merging_property->contact_person_no	}}</span></p>
                            
                            <p>Requestor accompanied: ( @if($merging_property->requestor_accompanied == 'yes') {{'Yes'}} @else {{'No'}}  @endif )</p>
                            
                            <p>Signature :  </p>
                            
                            <!--<p style="border-bottom: 1px solid #4a5256;">&nbsp;</p>-->
                            
                            <!--<p style="color:red;"><strong style="color:red;">Generate MR-002</strong> Form which will be signed by Sales agent and Merging owner and signed copy will be uploaded.</p>-->
                        </div>
                        
                    </div>    
                    <div class="col-md-1"></div>
                </div>
                
            </div>
        </div>
        

  


                
    </div>
    <div style="display: inline-block; ">
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
            <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>

</div>
<!-- /.container-fluid -->



@stop

@section('js')

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>


function upload_receipt_docs(self , receipt_id) 
{
$('#upload_btn').html('Uploading...')
$('#upload_btn').prop('disabled' , true)

 var form_data = new FormData();

       // Read selected files
   var totalfiles = document.getElementById('files').files.length;

    for (var index = 0; index < totalfiles; index++) 
    {
      form_data.append("files[]", document.getElementById('files').files[index]);
    }

    form_data.append("receipt_id", receipt_id);


   $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

   // AJAX request
   $.ajax({
     url:"{{ route('receipt.document') }}",
     type: 'post',
     data: form_data,
     dataType: 'json',
     contentType: false,
     processData: false,
     success: function (data) {

        if (data.response == 'yes') 
        {
            $('#success_message').html('Uploaded')
            $('#success_message').show()
            $('#error_message').hide()
            location.reload(true);
        }
        else if (data.response == 'invalid_document') 
        {
            $('#upload_btn').html('Upload')
            $('#upload_btn').prop('disabled' , false)
              $('#error_message').html(data.message)
              $('#error_message').show()
        }
        else
        {
            alert('Error! sonething went wrong.')
              location.reload(true);
        }

     }
   });



    return false;
}

$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>


@stop