@extends('layouts.app')

@section('title')
All Merging Properties
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Merging Properties</li>
      </ol>
@stop

@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('merging-properties-requisition')
                                 <a href="{{route('merging.properties.requisition')}}" class="btn  btn-default">
                                    <i class="fa fa-plus-square"></i>&nbsp; Add Merging Property
                                </a> 
                                @endpermission
                                
							</div>
                            <h3 class="box-title">All Merging Properties</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>MRF No</th>
                                            <th>Employee Id</th>
                                            
                                            <th>Visit Time:  </th>
                                            <th>Contact Person at Location: </th>
                                            <th> Contact No:  </th>
                                            <th>Requestor accompanied: </th>
                                            <th>Status</th>

                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;?>
                                      
                                        @foreach($merging_properties as $merging_property)
                                        <tr>
                                            
                                            
                                            <td>{{$count++}}</td>
                                            
                                            <td><b>{{$merging_property->mrf_no}} </b></td>
                                            
                                            <td>{{$merging_property->employee_id}} </td>
                                            
                                            <td><b>{{$merging_property->visit_time}} </b></td>
                                            
                                            <td>{{$merging_property->contact_person_at_location}} </td>
                                            
                                            <td>{{$merging_property->contact_person_no}} </td>
                                            
                                            <td>{{$merging_property->requestor_accompanied}} </td>
                                            
                                            
                                             <td>
                                                 @if($merging_property->is_approve == 1)
                                                 {{'Approve'}}
                                                 @elseif($merging_property->is_approve == 2)
                                                 {{'Cancel'}}
                                                 @else
                                                 {{'Pending'}}
                                                 @endif
                                             </td>
                                            
                                            <td class="text-nowrap">
                                            
                                            <a href="{{route('merging.properties.form.requisition' , [$merging_property->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                            
                                            </td>
                                            
                                            
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>
@stop