@extends('layouts.app')

@section('title')
Edit Project
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{route('multi.index')}}"><i class="fa fa-dashboard"></i> Projects List</a></li>
       
        <li class="active">Edit</li>
      </ol>
@stop
@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

 
      <style type="text/css">
   .whitebox3 {
background: #fff;
    padding: 18px 25px 10px 25px;
    margin-bottom: 30px;
    border-radius: 4px;
    }
    .circle {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        overflow: hidden;
        margin: 0 auto;
    }

    /* .circle img {
        display: block;
        max-width: 100%;
        max-height: 100%;
        margin: 0 auto;
    } */
    </style>
    

@stop

@section('content')


<div class="container-fluid">
    <form method="post" action="{{ route('multi.update') }}" class="form-horizontal" id="receipt_form" enctype="multipart/form-data">
        {{ csrf_field() }}
        <div class="row">
            <div class="col-lg-12 col-sm-12 col-xs-12">
                @if ($errors->any())
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            {!! implode(
                                '',
                                $errors->all('<li><span
                                class="help-block"><strong>:message</strong></span></li>'),
                            ) !!}
                        </ul>
                    </div>
                @endif
                <div class="whitebox3">
                    <h3 class="box-title">Edit Project</h3>
                    <hr>


                    <input type='hidden' name='id' value="{{$id}}">
                    <div class="col-md-6" style="margin-top: 40px;">
                        <div class="form-group">
                            <label for="exampleInputuname" class="control-label col-md-4">Name
                                <span style="color: red">*</span>
                            </label>
                            <div class="col-md-8">
                                <div class="input-group" style="width: 300px;">
                                    <input type="text" class="form-control" name="project_name"
                                          id="project_name" placeholder="Add..." value="{{$multiprojects->name}}">
                                    @if ($errors->has('project_name'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('project_name') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div> 
                        </div>

                       

                        <div class="form-group">
                            <label for="exampleInputuname" class="control-label col-md-4">Logo
                                <span style="color: red">*</span>
                            </label>
                            <div class="col-md-8">
                                 {{-- <div style='display:flex;' class="input-group">  --}}
                                    <div class="input-group" style="width: 300px;">
                                <input type="file" class="form-control" name="image"
                                id="image" onchange="readURL(this);">
                                <img id="blah" class='circle' src="{{ asset('images/add_logo.png') }}" alt="your image" style='display:none;'/>
                                
                                </div>
                                   
                                    @if ($errors->has('image'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('image') }}</strong>
                                        </span>
                                    @endif
                               
                            </div>

                        </div>
                        <div class="form-group">
                            <label for="exampleInputuname" class="control-label col-md-4">Address
                               
                            </label>
                            <div class="col-md-8">
                                <div class="input-group" style="width: 300px;">
                                    <input type='text ' class='form-control' id='address' name='address'  value="{{$multiprojects->address}}">
                                    @if ($errors->has('address'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('address') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div> 
                        </div>
                        <div class="form-group">
                            <label for="exampleInputuname" class="control-label col-md-4">Description
                                
                            </label>
                            <div class="col-md-8">
                                <div class="input-group" style="width: 300px;">
                                     <textarea name='description' style="width: 300px; height: 100px;" class='form-control' placeholder="Add...">{{$multiprojects->description}}</textarea>
                                    @if ($errors->has('description'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('description') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div> 
                        </div>


                       


                            <div class=" col-sm-4">
                                <button type="submit" class="btn btn-info waves-effect waves-light m-t-10"
                                    style="width: 80%; margin-left: 270px;">Save</button>
                            </div>


                    </div>
                    <div class="clearfix"></div>


                    <div class="clearfix"></div>
                    
                    
                </div>
            </div>
        </div>
    </form>
</div>

            
  
</div>


 

@stop

@section('js')
<script>
    function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#blah')
                        .attr('src', e.target.result)
                        .width(60)
                        .height(60);
                };

                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

   
@stop