@extends('layouts.app')

@section('title')
Projects List
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Projects List</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @role('admin')
								<a href="{{route('multi.create')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add New Projects
								</a>
                                @endrole
							</div>
                            <h3 class="box-title">Project List</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Image</th>
                                            <th>Type</th>
                                            <th>Address</th>
                                            <th>Description</th>

                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($multiprojects as $multiproject)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$multiproject->name}}</td>
                                    
                                            <td>
                                                <img id="blah" class='circle' src="{{ asset('images/'.$multiproject->image) }}" style='width:50px; border: 1px solid lightgray;' alt="your image" />
                                
                                              </td>
                                              <td>{{$multiproject->type->name}}</td>
                                            <td>{{$multiproject->address}}</td>
                                            <td>{{$multiproject->description}}</td>
                                            <td> 
                                            @php
                                                    
                                                $id= encrypt($multiproject->id);
                                                @endphp
                                                <a href="{{route('multi.edit',$id)}}"
                                                    data-toggle="tooltip" data-original-title="Edit"> <i
                                                        class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                            </td>

                                          
                                            
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop