@extends('layouts.app')

@section('title')
NOC
@stop

    @section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{ route('noc_req') }}">NOCs</a></li>
        <li class="active">Issue of NOC</li>
    </ol>
    @stop

        @section('css')

        <style type="text/css">

        </style>

        @stop

            @section('content')

            <div class="container-fluid">
                <form method="post" action="{{ route('noc.update') }}" class="form-horizontal"
                    id="receipt_form">
                    {!! method_field('put') !!}
                    {!! csrf_field() !!}
                    <input type='hidden' value='{{$noc->id}}' name='id'>
                    <div class="row">
                        <div class="col-lg-12 col-sm-12 col-xs-12">
                            @if($errors->any())
                                <div class="white-box">
                                    <h2>Errors</h2>
                                    <ul>
                                        {!! implode('', $errors->all('<li><span
                                                class="help-block"><strong>:message</strong></span></li>')) !!}
                                    </ul>
                                </div>
                            @endif
                            <div class="white-box1">
                                <h3 class="box-title">Issue of NOC</h3>
                                <hr>



                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputuname" class="control-label col-md-4">Status
                                            <span style="color: red">*</span>
                                        </label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <select name="status" id="status">
                                                    @if ($noc->status==1) {
                                                        <option value="1" selected="">Approved</option>
                                                        <option value="0" >Pending</option>
                                                    }
                                                    @else {
                                                        <option value="1" >Approved</option>
                                                        <option value="0" selected="">Pending</option>
                                                    }
                                                    @endif
                                                    
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="exampleInputuname" class="control-label col-md-4">NOC No
                                            <span style="color: red">*</span>
                                        </label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="noc_no"
                                                    value="{{$noc->noc_no}}" id="noc_no">
                                                @if($errors->has('noc_no'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('noc_no') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="exampleInputuname" class="control-label col-md-4">NOC Date
                                            <span style="color: red">*</span>
                                        </label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <input type="date" class="form-control" name="noc_date" id="noc_date"
                                                    value="{{$noc->noc_date }}">
                                                @if($errors->has('noc_date'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('noc_date') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">


                                        <label class="control-label col-md-4">Select Customer<span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <select name="customer_id" id='customer_id'
                                                class="form-control chosen-select"
                                                onchange="updateProperty(this.value)">
                                                <option value="{{$noc->customer_id}}" selected="">
                                                    {{ $noc->customer->name }}</option>
 
                                                @foreach($customers as $customer)

@if(old('customer_id') == $customer->id)
                                                        <option selected="" value="{{ $customer->id }}">None
                                                            {{ $customer->name }} - {{ $customer->cnic }} </option>

                                                    @else
                                                        <option value="{{ $customer->id }}">{{ $customer->name }} -
                                                            {{ $customer->cnic }}</option>
                                                    @endif

                                                @endforeach
                                            </select>

                                            @if($errors->has('customer_id'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('customer_id') }}</strong>
                                                </span>
                                            @endif

                                        </div>

                                        <br><br><br><br>
                                        <div class="form-group">
                                            <label for="exampleInputuname" class="control-label col-md-4">Contact No
                                                <span style="color: red">*</span>
                                            </label>
                                            <div class="col-md-8">
                                                <div class="input-group">
                                                    <input type="text" class="form-control" name="contact_no" readonly
                                                        value="{{ $noc->customer->mobile_number }}"
                                                        id="contact_no">
                                                    @if($errors->has('contact_no'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('contact_no') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="exampleInputuname"
                                                class="control-label col-md-4">S/O,D/O,W/O<span
                                                    style="color: red">*</span>
                                            </label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <input type="text" class="form-control" name="father_name_parent"
                                                        readonly value="{{ $noc->customer->father_name }}"
                                                        id="father_name_parent">
@if($errors->has('father_name_parent'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('father_name_parent') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="cnic" class="control-label col-md-4">CNIC
                                                <span style="color: red">*</span></label>
                                            <div class="col-md-8">
                                                <div class="input-group">
                                                    <input type="text" class="form-control" readonly
                                                        value="{{$noc->customer->cnic}}" name="cnic"
                                                        id="cnic">


                                                    @if($errors->has('cnic'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('cnic') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <br><br><br><br><br><br>
                                        <label class="control-label col-md-4">Select Unit No.<span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <select name="unit_number_id" id='unit_number_id' class="form-control"
                                                onchange="updateUnit(this.value)">
                                                <option value="{{ $noc->unit_number_id }}" selected="">
                                                    {{ $noc->unitNumber->unit_number }}</option>

                                            </select>

                                            @if($errors->has('unit_number_id'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('unit_number_id') }}</strong>
                                                </span>
                                            @endif

                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="address" class="control-label col-md-4">Sector
                                            <span style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="unit_floor_id" readonly
                                                    value="{{ $noc->unitNumber->floor ? $noc->unitNumber->floor->name : '' }}"
                                                    id="unit_floor_id">
                                                @if($errors->has('unit_floor_id'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('unit_floor_id') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>




                                    <div class="form-group">
                                        <label for="exampleInputEmail1" class="control-label col-md-4">Phase<span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="phase" readonly
                                                    value="{{ $noc->unitNumber->floor? $noc->unitNumber->floor->unit_block ? $noc->unitNumber->floor->unit_block->name : 'N/A':'' }}"
                                                    id="phase">
                                                @if($errors->has('phase'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('phase') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="exampleInputEmail1" class="control-label col-md-4">Membership No.
                                            <span style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="membership_no" readonly
                                                    value="{{ $noc->unitNumber->property->membership_no }}"
                                                    id="membership_no" style="width: 390px">
                                                @if($errors->has('membership_no'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('membership_no') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="clearfix"></div>

                                <div class="col-md-12" id='property'> </div>

                                <div class="clearfix"></div>
                                <div class=" col-sm-4">&nbsp;</div>
                                <div class=" col-sm-4">
                                    <button type="submit" class="btn btn-info waves-effect waves-light m-t-10"
                                        style="width: 100%">Save</button>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>

            </form>
            </div>

            @stop

                @section('js')

                <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
                </script>

                <script>
                    $(":input").inputmask();

                    function updateUnit(id) {


                        $('.preloader').fadeIn();

                        var unit_number_id = id;


                        var data = {
                            'unit_number_id': unit_number_id
                        };

                        $.get('/noc/getunitinfo', data, function (data) {

                            console.log(data);


                            $('#unit_floor_id').val(data.floor.name);
                            $('#phase').val(data.floor.unit_block.name);
                            $('#membership_no').val(data.property.membership_no);

                            $('.preloader').fadeOut();
                        });
                    }

                    function updateProperty(id) {


                        $('.preloader').fadeIn();

                        var customer_id = id;


                        var data = {
                            'customer_id': customer_id
                        };

                        $.get('/noc/getcustomerinfo', data, function (data) {


                            $('#contact_no').val(data.mobile_number);
                            $('#father_name_parent').val(data.father_name);
                            $('#cnic').val(data.cnic);


                            var model = $('#unit_number_id');
                            model.empty();

                            model.append("<option value='' disabled selected>" +
                                '' +
                                "</option>");


                            $.each(data.properties, function (index, element) {



                                model.append("<option value='" + element.inventory.id + "'>" +
                                    element.inventory.unit_number + "</option>");
                            });
                            // document.getElementById('property').innerHTML = data;

                            // $('#myTable').DataTable({
                            //     "paging": false,
                            //     "ordering": false,
                            //     "info": false
                            // });
                        });

                        // $('#wait').hide();
                        $('.preloader').fadeOut();

                    }
                </script>


                @stop
                    @if($errors->any())

                        <script>
                            window.onload = function () {

                                updateProperty('{{ old("customer_id") }}');

                                var payment_method = $('#payment_method').val();
                                changeFunc(payment_method)
                            }
                        </script>
                    @endif