@extends('layouts.app')

@section('title')
    All NOCs
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All NOCs</li>
    </ol>
@stop
@section('content')
    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">
                        @permission('create-noc')
                            <a href="{{ route('noc_add') }}" class="btn  btn-primary">
                                <i class="fa fa-plus-square"></i>&nbsp; Apply for NOC
                            </a>
                        @endpermission

                    </div>
                    <h3 class="box-title">All NOCs</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Project</th>
                                    <th>NOC No.</th>
                                    <th>Customer Name</th>
                                    <th>Unit No.</th>
                                    <th>Status</th>
                                    <th>NOC Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                                @permission('view-noc')
                                    <?php $view_noc = true; ?>
                                @else
                                    <?php $view_noc = false; ?>
                                @endpermission

                                @permission('edit-noc')
                                    <?php $edit_noc = true; ?>
                                @else
                                    <?php $edit_noc = false; ?>
                                @endpermission

                                @permission('delete-noc')
                                    <?php $delete_noc = true; ?>
                                @else
                                    <?php $delete_noc = false; ?>
                                @endpermission

                                @permission('download-noc')
                                    <?php $download_noc = true; ?>
                                @else
                                    <?php $download_noc = false; ?>
                                @endpermission


                                @foreach ($allnocs as $t)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>
                                            @if($t->unitNumber)
                             @if($t->unitNumber->multiProject)
                             {{$t->unitNumber->multiProject->name}}
                             @else
                             None
                            @endif
                           
                          @endif
                                        </td>
                                        <td>{{ $t->noc_no }}</td>
                                        <td>{{ $t->customer ? $t->customer->name : '' }}</td>

                                        <td>{{ $t->unitNumber ? $t->unitNumber->unit_number : '--' }}</td>
                                        @if ($t->status == 0)
                                            <td><span class="label label-primary"
                                                style="background-color:#4871c6;">Pending</span></td>
                                        @elseif($t->status == 1)
                                            <td><span class="label label-success">Approved</span></td>
                                        @elseif($t->status == 2)
                                            <td><span class="label label-success"
                                                    style="background-color: #DE0D0D">Expired</span></td>
                                                    @elseif($t->status == 3)
                                                    <td><span class="label label-success"
                                                        style="background-color:#cd703d;;">Transferred</span></td>
                                                @endif
                                                



                                        <td>{{ $t->noc_date }}</td>

                                        <td class="text-nowrap">
                                            <!-- @if ($view_noc)
    <a href="#"
                                                            data-toggle="tooltip" data-original-title="View"> <i
                                                                class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
    @endif -->


                                            @if ($edit_noc)
                                                <a href="{{ route('noc.edit', [$t->id]) }}" data-toggle="tooltip"
                                                    datza-original-title="Edit"> <i
                                                        class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            @endif


                                            @if ($delete_noc)
                                                <form action="{{ route('noc.delete', [$t->id]) }}" method="post"
                                                    style='display: inline;'>
                                                    {!! method_field('delete') !!}
                                                    {!! csrf_field() !!}


                                                    <button class="btn btn-link btn-s" style="color:red;" type="submit"
                                                        name="action" value="delete" data-toggle="confirmation"
                                                        data-title="Are you sure to delete?">
                                                        <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                    </button>
                                                </form>
                                            @endif


                                            @if ($download_noc)
                                                @if ($t->status != 2)
                                                    <a target="_blank" href="{{ route('noc.download', [$t->id]) }}"
                                                        data-toggle="tooltip" data-original-title="Issue NOC">
                                                        <i class="fa fa-download text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                @endif
                                            @endif
                                            @if ($download_noc)
                                                @if ($t->status == 1)
                                                    <a target="_blank" href="{{ route('noc.approvedownload', [$t->id]) }}"
                                                        data-toggle="tooltip" data-original-title="Approved NOC">
                                                        <i class="fa fa-arrow-circle-down"
                                                            aria-hidden="true"></i>&nbsp;&nbsp;</a>
                                                @endif
                                            @endif

                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>


@stop

@section('js')
    <script>
        $(function() {
            $('#myTable').DataTable();

            var table = $('#example').DataTable({
                "columnDefs": [{
                    "visible": false,
                    "targets": 2
                }],
                "order": [
                    [2, 'asc']
                ],
                "displayLength": 25,
                "drawCallback": function(settings) {
                    var api = this.api();
                    var rows = api.rows({
                        page: 'current'
                    }).nodes();
                    var last = null;
                    api.column(2, {
                        page: 'current'
                    }).data().each(function(group, i) {
                        if (last !== group) {
                            $(rows).eq(i).before(
                                '<tr class="group"><td colspan="5">' + group +
                                '</td></tr>');
                            last = group;
                        }
                    });
                }
            });
            // Order by the grouping
            $('#example tbody').on('click', 'tr.group', function() {
                var currentOrder = table.order()[0];
                if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                    table.order([2, 'desc']).draw();
                } else {
                    table.order([2, 'asc']).draw();
                }
            });
        });
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    </script>
@stop
