@extends('layouts.app')

@section('title')
    Edit Cancellation Request
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-cancellation')
            <li><a href="{{ route('property.refund') }}">All Refund Units</a></li>
        @endpermission
        <li class="active">Edit Refund Unit Request </li>
    </ol>
@stop
@section('content')
    <style>

    </style>
    <div class="container-fluid">


        <div class="container-fluid" style='background: white;
        border: 1px solid #e5ebec;'>
            <h2>Refund Request Information</h2>



            <form method='post' action="{{ route('property.adjust.update') }}" enctype="multipart/form-data">
                {{ csrf_field() }}



                {{-- Adjust or Refund Property  --}}
                <div class="form-group" id='adjust_refund'>

                    <input type='hidden' name='id' value={{ $openfileadjust->cancelOpenFile->id }}>

                    
                    {{-- Refund Div --}}
                    <div class="form-horizontal" id='refunded_portion'>
                        <div class="form-group">
                            <label class="control-label col-sm-2" for="email">UA No:<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                @if (!empty($allStatements->unitAdjustHistory))
                                    <input type="text" class="form-control" id="unit_adjust_no"
                                        value="{{ $allStatements->unitAdjustHistory->ua_no }}" style='width:59%'
                                        name='ua_no'>
                                @else
                                    <input type="text" class="form-control" id="unit_adjust_no"
                                        value="UA-000{{ \App\UnitAdjust::count() + 1 }}" style='width:59%' name='ua_no'>
                                @endif
                            </div>
                            @if ($errors->has('ua_no'))
                                <span class="help-block">
                                    {{ $errors->first('ua_no') }}
                                </span>
                            @endif
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-2" for="email">Total Package Received Amount:</label>
                            @php
                                
                                $paid_amount = $openfileadjust->dealerPackage->dealerPackagePayment
                                    ->where('dealer_package_id', $openfileadjust->dealerPackage->id)
                                    ->where('is_approved', 1)
                                    ->sum('amount');
                            @endphp



                            <div class="col-sm-10">
                                <input type="text" class="form-control" id="total_paid_amount" value={{ $paid_amount }}
                                    style='width:59%' readonly>
                            </div>
                        </div>

                       


                        <div class="form-group">
                            <label class="control-label col-sm-2" for="pwd" style='    margin-top: 10px;'>Status<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group" style='margin-top: 10px;'>

                                    <select class="custom-select mb-3 chosen-select" style="width:300px; " name="status">

                                        <option value="{{ App\UnitRefundHistory::REFUND_DECISION_PENDING }}" selected>
                                            Pending</option>
                                        <option value="{{ App\UnitRefundHistory::REFUND_DECISION_APPROVED }}">Approve
                                        </option>
                                        <option value="{{ App\UnitRefundHistory::REFUND_DECISION_DECLINE }}">Decline
                                        </option>



                                    </select>
                                    @if ($errors->has('status'))
                                        <span class="help-block">
                                            {{ $errors->first('status') }}
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                    </div>
                    {{-- End Refund Div --}}







                </div>
                {{-- End Adjust or Refund Property --}}
                <div class="form-group">
                    <div class="col-sm-offset-2 col-sm-10">
                        <button type="submit" class="btn btn-info  waves-effect waves-light "
                            style='    margin-top: 10px;'>Save</button>
                    </div>
                </div>













            </form>
        </div>





        <div class="container-fluid" style='background: white;
        border: 1px solid #e5ebec;     margin-top: 3%; '>
            <h2>Request Information</h2>

            <div class="col-lg-12" id="payment_div">
                <div class="white-box1 ">
                    <h4 class="box-title " style=" color: white; background-color:#1c3752; line-height: 30px">
                        &nbsp;&nbsp;Detail</h4>

                    <div class="col-md-12 col-xs-12">
                        <div class="table-responsive">
                            <table class="table bottom-table">
                                <tbody class="printFW">

                                    <tr>
                                        <td style="font-weight: 600;">Package Name: </td>
                                        <td>
                                            @if ($openfileadjust->dealerPackage)
                                                <a
                                                    href='{{ route('openfile.detail', $openfileadjust->dealerPackage->id) }}'>
                                                    {{ $openfileadjust->dealerPackage->package->name }}
                                                </a>
                                            @endif
                                        </td>
                                        <td style="font-weight: 600;">Package Total Amount: </td>
                                        <td>
                                            {{ $openfileadjust->dealerPackage->package->total_price }} pkr
                                        </td>

                                        <td style="font-weight: 600;">
                                            Package Paid Amount
                                        </td>
                                        <td>
                                            {{ $paid_amount }} pkr
                                        </td>





                                    </tr>


                                    <tr>

                                        <td style="font-weight: 600;">Unit Status:</td>


                                        @role('admin')
                                            <?php $admin = true; ?>
                                        @else
                                            <?php $admin = false; ?>
                                        @endrole
                                        @if ($admin)

                                            @if ($openfileadjust->inventory->status == \App\Inventory::open)
                                                <td><span class="label label-success">Open</span></td>
                                            @elseif($openfileadjust->inventory->status == \App\Inventory::package_open_file)
                                                <td><span class="label label-success">Open/Dealer Package File</span></td>
                                            @elseif($openfileadjust->inventory->status == \App\Inventory::sold)
                                                <td><span class="label label-danger">Sold</span></td>
                                            @elseif($openfileadjust->inventory->status == \App\Inventory::hold_client)
                                                <td><span class="label label-primary">Client Hold</span></td>
                                            @elseif($openfileadjust->inventory->status == \App\Inventory::hold_company)
                                                <td><span class="label label-primary"
                                                        style="background-color:#cd703d;">Company Hold</span></td>
                                            @elseif($openfileadjust->inventory->status == \App\Inventory::token_hold)
                                                <td><span class="label label-primary">Token Hold</span></td>
                                            @else
                                                <td></td>
                                            @endif
                                        @else
                                            @if ($openfileadjust->inventory->status == \App\Inventory::open)
                                                <td><span class="label label-success">Open</span></td>
                                            @else
                                                <td><span class="label label-danger">Sold</span></td>
                                            @endif


                                        @endif



                                        <td style="font-weight: 600;">Request Status : </td>
                                        @if ($openfileadjust->cancelOpenFile->after_cancellation_status == 'pending')
                                            <td><span class="label label-primary"
                                                    style="background-color:#4871c6;;">Pending</span></td>
                                        @elseif($openfileadjust->cancelOpenFile->after_cancellation_status == 'adjust-pending')
                                            <td><span class="label label-success">Adjust/Pending</span></td>
                                        @elseif($openfileadjust->cancelOpenFile->after_cancellation_status == 'refund-pending')
                                            <td><span class="label label-success">Refund/Pending</span></td>
                                        @elseif($openfileadjust->cancelOpenFile->after_cancellation_status == 'adjusted')
                                            <td><span class="label label-success">Adjusted</span></td>
                                        @elseif($openfileadjust->cancelOpenFile->after_cancellation_status == 'refunded')
                                            <td><span class="label label-success">Refunded</span></td>
                                        @elseif($openfileadjust->cancelOpenFile->after_cancellation_status == 'decline')
                                            <td><span class="label label-primary"
                                                    style="background-color:#f80808;;">Decline</span></td>
                                        @elseif($openfileadjust->cancelOpenFile->after_cancellation_status == 'swap-pending')
                                            <td><span class="label label-success">Swap/Pending</span></td>
                                        @endif





                                        <td style="font-weight: 600;">Unit DownPayment Price: </td>
                                        <td>
                                            <span class="label label-primary" style="background-color:#6a1aff;">
                                                {{ $result }} pkr</span>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: 600;">Unit Number: </td>
                                        <td>



                                            {{ $openfileadjust->inventory->unit_number }}
                                        </td>
                                        <td style="font-weight: 600;">Unit Size: </td>
                                        <td>



                                            {{ $openfileadjust->inventory->size->name }} Marla
                                        </td>
                                        <td style="font-weight: 600;">Unit Type: </td>
                                        <td>



                                            {{ $openfileadjust->inventory->type->name }}
                                        </td>




                                    </tr>

                                    <tr>
                                        <td style="font-weight: 600;">Dealer Name: </td>
                                        <td>



                                            {{ $openfileadjust->dealer->name }}
                                        </td>
                                        <td style="font-weight: 600;">Dealer Code: </td>
                                        <td>{{ $openfileadjust->dealer->code }}</td>




                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        <div class="clear"></div>
                    </div>

                </div>
            </div>








            {{-- Adjust or Refund Property  --}}

            {{-- End Adjust or Refund Property --}}





















        </div>

    </div>



@stop
@section('js')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-multiple').select2({
                disabled: true
            });
        });

        function findPercentage(value, totalpaidamount) {

            return (value / 100) * totalpaidamount;
        }

        function getval(sel) {

            if (sel.value == 1) {

                $("#adjust_refund").show();

            } else if (sel.value == 0) {
                $("#adjust_refund").hide();
            }
        }

        function adjusOrRefund(sel) {

            if (sel.value == 1) {
                $("#refunded_portion").hide();
                //    $("#adjust_refund").show();

            } else if (sel.value == 0) {
                //    $("#refunded_portion").hide();
                $("#refunded_portion").show();
            }
        }

        function refundValueType(sel) {

            if (sel.value == 0) {
                $("#per_for_refund_deduction").hide();
                //    $("#adjust_refund").show();
                $("#refund_amount_deducted_per").val(0);

            } else if (sel.value == 1) {
                //    $("#refunded_portion").hide();
                $("#per_for_refund_deduction").show();



                var totalpaidamount = $("#total_paid_amount").val(); //total paid value
                var value = $("#refund_amount_deducted").val();

                result = findPercentage(value, totalpaidamount);
                //    (sel.value /100) * totalpaidamount;
                $("#refund_amount_deducted_per").val(result);
            }
        }

        function getPerIf(sel) {
            //refund_deduction_type
            var deductiontype = $('#refund_deduction_type').find(":selected").val();

            if (deductiontype == 1) {
                // '#refund_amount_deducted_per';
                var totalpaidamount = $("#total_paid_amount").val(); //total paid value
                result = findPercentage(sel.value, totalpaidamount);
                //    (sel.value /100) * totalpaidamount;
                $("#refund_amount_deducted_per").val(result);

            }


        }
    </script>
@stop
