@extends('layouts.app')

@section('title')
Pending Open File Packages 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Pending Packages List</li>
      </ol>
@stop
@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->

                <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Pending Open File Packages
                                <div class="pull-right">
                               


                                </div>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>
                <!--./row-->
              
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        
                        <div class="white-box">
                        	
                            <h3 class="box-title">All Pending Open File Packages</h3>

                              <!-- Nav tabs -->
                <ul class="nav customtab nav-tabs" role="tablist" style='margin-bottom: 5%;'>

                    <li role="presentation" class="active"><a href="#approved" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Approved Package @if(count($approved_packages) > 0)<span class="label label-rounded pull-right" style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{count($approved_packages)}}</span>@endif </span></a></li>
                    <li role="presentation" class=""><a href="#pending" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Pending Package @if(count($pending_packages) > 0)<span class="label label-rounded pull-right" style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{count($pending_packages)}}</span>@endif  </span></a></li>
                     

                   
                </ul>
                <!-- Tab panes -->
                <div class="tab-content">

                    <div role="tabpanel" class="tab-pane fade active in" id="approved">
                        <div class="table-responsive">
                            <table id="myTable" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Sr. No.</th>    
                                        <th>Project</th>                                  
                                        <th>Dealer Name</th>
                                        <th>Dealer Code</th>
                                        <th>Package Name</th>  
                                      
                                        <th>Issue Date</th>
                                        <th>Request Status</th>
                                       
                                        <th style="width: 185px!important;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count =1;?>
                                   
                                    @foreach($approved_packages as $adopf)
                                    

                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>
                                             
                                            {{ $adopf->multiProject?$adopf->multiProject->name:'None' }}
                                        
                                        </td>
                                        <td>{{   $adopf->dealer->name }}</td>
                                        <td>{{   $adopf->dealer->code }}</td>
                                        <td>{{ ( $adopf->package)?$adopf->package->name:'' }}</td>
                                        
                                        <td>{{   $adopf->issue_date }}</td>
                                       
                                        <td> <span class="label label-success">Approved</span></td>
                                        <td class="text-nowrap">


                                            {{-- <a href="{{ route('openfile.pending.package.view',['id'=>$adopf->id]) }}"
                                                data-toggle="tooltip" data-original-title="detail"> <i
                                                    class="fa fa-info-circle text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
  --}}
                                            @if ( $adopf->inventory_status == \App\DealerPackage::inventory_not_created )
                                                <a href="{{ route('openfile.create.package.inventory',['id'=>$adopf->id]) }}"
                                                data-toggle="tooltip" data-original-title="Create Inventory"> <i class="fa fa-plus-circle" aria-hidden="true"></i>&nbsp;&nbsp;</a>

                                            @elseif ( $adopf->inventory_status == \App\DealerPackage::inventory_created )
                                                <a href="{{ route('openfile.create.package.inventory',['id'=>$adopf->id]) }}"
                                                data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye" aria-hidden="true"></i>&nbsp;&nbsp;</a>

                                            @else
                                                <p>&nbsp;</p>

                                            @endif



                                           
                                                    
                                          

                                           
                                        
                                             
                                        </td>
                                    </tr>
                                    @endforeach
                                   

                                </tbody>                                                                                                                    
                            </table>
                            <div style="float: right;"></div>
                        </div>
                    </div>


                    <div role="tabpanel" class="tab-pane fade " id="pending">
                            <div class="table-responsive">
                                <table id="myTable2" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr. No.</th> 
                                            <th>Project</th>                                     
                                            <th>Dealer Name</th>
                                            <th>Dealer Code</th>
                                            <th>Package Name</th>  
                                           
                                            <th>Issue Date</th>
                                            <th>Request Status</th>
                                           
                                            <th style="width: 185px!important;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                       
                                        @foreach($pending_packages as $dopf)
                                        

                                        <tr>
                                            <td>{{ $count++ }}</td>
                                            <td>
                                             
                                                {{ $dopf->multiProject?$dopf->multiProject->name:'None' }}
                                            
                                            </td>
                                            <td>{{   $dopf->dealer->name }}</td>
                                            <td>{{   $dopf->dealer->code }}</td>
                                            <td>{{ ($dopf->package)?$dopf->package->name:'' }}</td>
                                            
                                            <td>{{   $dopf->issue_date }}</td>
                                           
                                            <td> <span class="label label-danger">Pending</span></td>
                                            <td class="text-nowrap">
                                                {{-- <a href="{{ route('openfile.pending.package.view',['id'=>$dopf->id]) }}"
                                                    data-toggle="tooltip" data-original-title="approve"> <i
                                                        class="fa fa-check text-inverse m-r-10"></i>&nbsp;&nbsp;</a> --}}
                                                        <form action="{{route('openfile.approve.package.store')}}" method="post"
                                                            style='display: inline;'>
                                                          
                                                            {!! csrf_field() !!}
                                                            <input type='hidden' name='dealer_package_id' value='{{$dopf->id}}' > 
        
                                                            <button class="btn btn-link btn-s" style="color:red;" type="submit"
                                                            name="action" value="approve" data-toggle="confirmation"  
                                                            data-title="Are you sure to approve?">
                                                              
                                                                <i class="fa fa-check" aria-hidden="true"></i>
                                                            </button>
                                                        </form>

                                                {{-- <a href="{{ route('openfile.pending.package.view',['id'=>$dopf->id]) }}"
                                                    data-toggle="tooltip" data-original-title="detail"> <i
                                                        class="fa fa-info-circle text-inverse m-r-10"></i>&nbsp;&nbsp;</a> --}}

                                               
                                                        
                                              

                                               
                                                       
                                                      
                                            </td>
                                        </tr>
                                        @endforeach
                                       

                                    </tbody>                                                                                                                    
                                </table>
                                <div style="float: right;"></div>
                            </div>
                    </div>
                </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>


<div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
           
            // 'dom': 'Bfrtip',
         
        });
        $('#myTable2').DataTable({
            'pageLength':25,
           
            // 'dom': 'Bfrtip',
         
        });
    });

        



   







    </script>
@stop