@extends('layouts.app')

@section('title')
    Edit Cancellation Request
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-cancellation')
            <li><a href="{{ route('statement.cancel') }}">All Cancelled Units</a></li>
        @endpermission
        <li class="active">Edit Cancellation Request </li>
    </ol>
@stop
@section('content')
    <style>
.hide{
    display:none;
}
    </style>
    <div class="container-fluid">
        <div class="row">

            <div class="col-md-12">
                <div class="white-box">
                    <h3 class="box-title m-b-0">Edit Cancel Open File Request </h3>
                    <hr>
                </div>
            </div>
        </div>

        <div class="container-fluid" style='background: white;
                     border: 1px solid #e5ebec;'>
            <h2>Update Information</h2>
            <form method='post' action="{{ route('openfile.cancel.update') }}" enctype="multipart/form-data">
                {{ csrf_field() }}
                <input type='hidden' value={{ $allopenfile->id }} name='openfiledealerinfo_no'>
                <div class="form-group">
                    <label class="control-label col-sm-2" for="property_no">Property No <span
                            style="color: red">*</span>:</label>
                    <div class="col-sm-10">
                        <div class="input-group">
                            <select class="form-control js-example-basic-multiple" multiple="multiple">

                                
                                <option value="{{ $allopenfile->id }}" selected>{{ $allopenfile->dealer->code }} ---
                                    {{ $allopenfile->inventory->unit_number }} </option>
                            </select>
                            @if ($errors->has('openfiledealerinfo_no'))
                            <span class="help-block">
                                {{ $errors->first('openfiledealerinfo_no') }}
                            </span>
                        @endif
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-2" for="pwd" style='margin-top: 15px;'>Request<span
                            style="color: red">*</span></label>
                    <div class="col-sm-10">
                        <div class="input-group" style='margin-top: 10px; width: 231px;'>
                            <select class="custom-select mb-3 chosen-select" style="width:300px; " name="openfile_status">

                                <option value="{{ \App\CustomerProperty::cancel }}" selected>Cancel</option>

                            </select>

                            @if ($errors->has('openfile_status'))
                            <span class="help-block">
                               {{ $errors->first('openfile_status') }}
                            </span>
                        @endif
                        </div>
                    </div>
                </div>



                <div class="form-group">
                    <label class="control-label col-sm-2" for="pwd" style='margin-top: 10px;'>Fee/Charges<span
                            style="color: red">*</span></label>
                    <div class="col-sm-10">
                        <div class="input-group" style='margin-top: 10px; width: 231px;'>

                            <input type="number" class="form-control" placeholder="Add fee" name='openfile_cancelfee'
                                value='{{ $allopenfile->cancelOpenFile->fee  }}'>
                                @if ($errors->has('openfile_cancelfee'))
                                <span class="help-block">
                                    {{ $errors->first('openfile_cancelfee') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-sm-2" for="pwd" style='margin-top: 10px;'>Status<span
                            style="color: red">*</span></label>
                    <div class="col-sm-10">
                        <div class="input-group" style='margin-top: 10px; width: 231px;'>

                            <select class="custom-select mb-3 chosen-select" style="width:300px; " name="property_status"  onchange="getval(this)">
                                @if ($allopenfile->cancelOpenFile->status == 0)
                                    <option value="0" selected >Pending</option>
                                    <option value="1">Approve</option>
                                @elseif($allopenfile->cancelOpenFile->status == 1)
                                    <option value="0" >Pending</option>
                                    <option value="1" selected>Approve</option>
                                @endif

                            </select>
                            @if ($errors->has('status'))
                                <span class="help-block">
                                    {{ $errors->first('status') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>




                <div class="form-group " style='display:none' id='after_cancellation_status'>
                    <label class="control-label col-sm-2" for="pwd" style='margin-top: 10px;'>Refund or Adjust Paid Amount Request<span
                            style="color: red">*</span></label>
                    <div class="col-sm-10">
                        <div class="input-group" style='margin-top: 10px; width: 231px;'>
                            <select id='after_cancellation_status' name="after_cancellation_status"   class="custom-select mb-3 chosen-select">
                              
                              
                                @if ($allopenfile->cancelOpenFile->after_cancellation_status == 'pending')
                                <option value="pending" selected>Pending</option>
                                <option value="adjust-pending">Adjust</option>
                                <option value="refund-pending">Refund</option>
                                <option value="swap-pending" >Swap</option>
                                @elseif($allopenfile->cancelOpenFile->after_cancellation_status == 'adjust-pending')
                                <option value="pending">Pending</option>
                                <option value="adjust-pending" selected>Adjust</option>
                                <option value="refund-pending">Refund</option>
                                <option value="swap-pending" >Swap</option>
                                @elseif($allopenfile->cancelOpenFile->after_cancellation_status == 'refund-pending')
                                <option value="pending">Pending</option>
                                <option value="adjust-pending">Adjust</option>
                                <option value="refund-pending" selected>Refund</option>
                                <option value="swap-pending" >Swap</option>
                                @elseif($allopenfile->cancelOpenFile->after_cancellation_status == 'swap-pending')
                                <option value="pending">Pending</option>
                                <option value="adjust-pending">Adjust</option>
                                <option value="refund-pending" >Refund</option>
                                <option value="swap-pending" selected>Swap</option>
                                @endif
                                
                                
                                
                                
                              </select>
                             
                            @if ($errors->has('adjust_refund'))
                                <span class="help-block">
                                    {{ $errors->first('adjust_refund') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>


              

         


       















        <div class="form-group">
            <div class="col-sm-offset-2 col-sm-10">
                <button type="submit" class="btn btn-info  waves-effect waves-light "
                    style='margin-top: 10px; width: 90px; margin-left: 60px;'>Save</button>
            </div>
        </div>
        </form>
    </div>


    </div>



@stop
@section('js')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-multiple').select2({
                disabled: true
            });
        
        
        
        
        });
        @if($allopenfile->cancelOpenFile->status==1)
        $("#after_cancellation_status").show();
        @endif
       
       
        function getval(sel){

            

if(sel.value == 1){

$("#after_cancellation_status").show();

}
else if(sel.value == 0){
$("#after_cancellation_status").hide();
}
}




    </script>
@stop
