@extends('layouts.app')

@section('title')
    Issue Open File
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i>Home</a></li>
        <li><a href="{{ route('openfile.view') }}">All Open files</a></li>
        <li class="active">Issue Open File</li>
    </ol>
@stop

@section('css')

    <style type="text/css">
   .whitebox3 {
background: #fff;
    padding: 18px 25px 10px 25px;
    margin-bottom: 30px;
    border-radius: 4px;
    }
    </style>

@stop

@section('content')

    <div class="container-fluid">
        <form method="post" action="{{ route('openfile.store') }}" class="form-horizontal" id="receipt_form">
            {{ csrf_field() }}
            <div class="row">
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    @if ($errors->any())
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul>
                                {!! implode(
                                    '',
                                    $errors->all('<li><span
                                                                                class="help-block"><strong>:message</strong></span></li>'),
                                ) !!}
                            </ul>
                        </div>
                    @endif
                    <div class="whitebox3">
                        <h3 class="box-title">Issue Open File</h3>
                        <hr>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="exampleInputuname" class="control-label col-md-4">OF No
                                    <span style="color: red">*</span>
                                </label>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="of_no"
                                            value="OF-000{{ \App\OpenFileDealerInfo::count() + 1 }}" id="of_no">
                                        @if ($errors->has('of_no'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('of_no') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="exampleInputuname" class="control-label col-md-4">Unallocated Unit
                                    <span style="color: red">*</span>
                                </label>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <select class="form-control js-example-basic-multiple"   id="unit_number" name="unit_number">
                                            <option>Select a unit</option>
                                            @foreach ($unitNumbers as $unit)
                                                <option value="{{ $unit->id }}" data-amount='{{$unit->total_price}}'>{{ $unit->unit_number }} -- {{$unit->size->name}}{{env('SIZE')}}</option>
                                            @endforeach
                                        </select>
                                        @if ($errors->has('unit_number'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('unit_number') }}</strong>
                                            </span>
                                        @endif
                                        
                                         
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="exampleInputuname" class="control-label col-md-4">Dealer
                                    <span style="color: red">*</span>
                                </label>
                                <div class="col-md-8">
                                 
                                        <select class="form-control chosen-select" name="dealer_id" id="dealer_id" >
                                            <option value="">None</option>
                                            @foreach ($dealers as $dealer)
                                                @foreach ($dealer as $d)
                                                    @if ($loop->first)
                                                        <optgroup label="{{ $dealertypes[$d->dealer_type_id] }}">
                                                    @endif
                                                    @if (old('dealer_id'))
                                                        @if (old('dealer_id') == $d->id)
                                                            <option value="{{ $d->id }}" selected="">
                                                                {{ $d->name }} ( {{ $d->percentage }} %)</option>
                                                        @else
                                                            <option value="{{ $d->id }}">{{ $d->name }}
                                                                 </option>
                                                        @endif
                                                    @else
                                                        <option value="{{ $d->id }}">{{ $d->name }} </option>
                                                    @endif
                                                @endforeach
                                                <!-- </optgroup> -->
                                            @endforeach
                                        </select>
                                        @if ($errors->has('dealer_id'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('dealer_id') }}</strong>
                                            </span>
                                        @endif
                                   
                                </div>
                            </div>


                            <div class="form-group">
                                <label for="exampleInputuname" class="control-label col-md-4">Issue Date
                                    <span style="color: red">*</span>
                                </label>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <input type="date" class="form-control" name="issue_date" id="issue_date">
                                        @if ($errors->has('issue_date'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('issue_date') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="exampleInputuname" class="control-label col-md-4">Rebate Amount
                                    <span style="color: red">*</span>
                                </label>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="rebate_amount" id="rebate_amount" placeholder="Add rebate amount">
                                        @if ($errors->has('rebate_amount'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('rebate_amount') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>


                            <div class="form-group">
                                <label for="exampleInputuname" class="control-label col-md-4">Total Amount
                                    
                                </label>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <input type="number" class="form-control"   id="total_amount" readonly>
                                        
                                    </div>
                                </div>
                            </div>



                        </div>
                        <div class="clearfix"></div>

                        <div class="col-md-12" id='property'> </div>

                        <div class="clearfix"></div>
                        <div class=" col-sm-4">&nbsp;</div>
                        <div class=" col-sm-4">
                            <button type="submit" class="btn btn-info waves-effect waves-light m-t-10"
                                style="width: 100%">Save</button>
                        </div>
                    </div>
                </div>
            </div>
    </div>

    </form>
    </div>

@stop

@section('js')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
        

     

       
    </script>

<script>
   
    $(document).ready(function() {
        
        $('.js-example-basic-multiple').select2({
            placeholder: "Select a Unit"
        }).on('change', function (e) {
            var total_amount=0;
            $.each($(this).find(":selected"), function (i, item) { 
                total_amount += $(item).data("amount");
            });
            $('#total_amount').val(total_amount);     
                   });   
                          });
    </script>
@stop


@if ($errors->any())

    <script>
        window.onload = function() {

            updateProperty('{{ old('customer_id') }}');

            var payment_method = $('#payment_method').val();
            changeFunc(payment_method)
        }
    </script>
  
@endif
