@extends('layouts.app')


@section('title')
Packages List
@stop

    @section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-openfile')
            <li><a href="{{ route('openfile.view') }}">All Open File Packages List</a></li>
        @endpermission
        <li class="active">Open File Package Details</li>
    </ol>
    @stop

        @section('content')
        @php
        $society = false;
        $highrise = false;
        $size = '';
        
        if ($projectType->id == App\ProjectType::society) {
            $society = true;
            $size = \App\ProjectType::society_size;
        }
        
        if ($projectType->id == App\ProjectType::high_rise) {
            $highrise = true;
            $size = \App\ProjectType::high_rise_size;
        }
        
    @endphp
        <!-- .container-fluid -->
        <div class="container-fluid">
            <!-- /row -->
            <div class="row">
                <div class="col-sm-12">
                    <div class="white-box">
                        <h3 class="box-title">Detail Open File Package/Issue Form</h3>

                        <div class="table-responsive">
                            <table id="myTable" class="table table-striped">
                                <thead>
                                <tr>
                                    <th>Sr. No.</th>
                                    <th>Project Name</th>
                                    <th>Unit Number</th>
                                    <th>Size</th>
                                    <th>Type</th>
                                    <th>Status</th>
                                    <th>Expiry Date</th>
                                    <th style="width: 185px!important;">Action</th>
                                        
                                    
                                </tr>
                                </thead>
                               
                                <tbody>
    <?php $count =1;?>
                               @foreach($detail_dealer_openfile->openFileDealerInfo as $info)                                   

                               <tr>
                                <td>{{ $count++ }}</td>
                                <td>{{ $info->inventory ? $info->inventory->multiProject->name : 'None' }}</td>
                                <td>{{ $info->inventory ? $info->inventory->unit_number : '' }}</td>
                                <td>{{ $info->inventory ? $info->inventory->size->name : '' }}
                                    {{  $size  }}</td>
                                <td>{{ $info->inventory ? $info->inventory->type->name : '' }}</td>

                                @role('admin')
                                <?php $admin = true;?>
                            @else
                            <?php $admin = false;?>
                            @endrole
                          
                                @if($admin)

                                @if($info->inventory ? $info->inventory->status == \App\Inventory::open : '')
                                 <td><span class="label label-success">Open</span></td>
                                 @elseif($info->inventory ? $info->inventory->status == \App\Inventory::package_open_file : '')
                                 <td><span class="label label-success">Open/Dealer Package File</span></td>
                                 @elseif($info->inventory ? $info->inventory->status == \App\Inventory::sold : '')
                                 <td><span class="label label-danger">Sold</span></td>
                                 @elseif($info->inventory ? $info->inventory->status == \App\Inventory::hold_client : '')
                                 <td><span class="label label-primary">Client Hold</span></td>
                                 @elseif($info->inventory ? $info->inventory->status == \App\Inventory::hold_company : '')
                                 <td><span class="label label-primary" style="background-color:#cd703d;">Company Hold</span></td>
                                 @elseif($info->inventory ? $info->inventory->status == \App\Inventory::token_hold : '')
                                 <td><span class="label label-primary">Token Hold</span></td>
                                 @elseif($info->inventory ? $info->inventory->status == \App\Inventory::temp_hold : '')
                                 <td><span class="label label-primary">Temporary Hold</span></td>
                                 @elseif($info->inventory ? $info->inventory->status == \App\Inventory::package_open_file_refunded : '')
                                 <td><span class="label label-danger">Refunded</span></td>
                                 @else
                                 <td></td>
                                 @endif

                                 
                                 @else
                                 @if($info->inventory ? $info->inventory->status == \App\Inventory::open : '')
                                 <td><span class="label label-success">Open</span></td>
                                 @else
                                 <td><span class="label label-danger">Sold</span></td>
                                 @endif


                                 @endif
                              
                           
                                <td>{{$info->valid_until_date}}</td>
                                <td class="text-nowrap">
                                    
                                            @if($info->endUserForm)


                                            <a href="{{ route('openfile.get.enduser', [$info->endUserForm->id]) }}"
                                                data-toggle="tooltip" data-original-title="Registration Letter"> <i
                                                    class="fa fa-file-powerpoint-o" aria-hidden="true" >@if($info->endUserForm->registration_letter_count > 0)<span class="label label-rounded pull-right" style="line-height: 1.8;    min-width: 0px;font-size: 10px;padding: 0px 7px;background-color: rgb(204 2 2);">{{$info->endUserForm->registration_letter_count}}</span> @endif</i>&nbsp;&nbsp;</a>
                                                     
                                            <a href="{{ route('openfile.form',['id'=>$info->endUserForm->id]) }}"
                                                data-toggle="tooltip" data-original-title="Registration-Form"> <i
                                                    class="fa fa-folder-open text-inverse m-r-10" >@if($info->endUserForm->registration_form_count > 0)<span class="label label-rounded pull-right" style="line-height: 1.8;    min-width: 0px;font-size: 10px;padding: 0px 8px;background-color: rgb(204 2 2);">{{$info->endUserForm->registration_form_count}}</span> @endif</i></a>
        
                                            

                                                    
                                                     
                                            
                                                    
                                            @else
                                     
        
                                                            <a href="{{ route('openfile.create.enduser', [$info->id]) }}"
                                                                data-toggle="tooltip" data-original-title="Generate End User Form"> <i
                                                                    class="fa fa-pencil-square-o" aria-hidden="true"></i>&nbsp;&nbsp;</a>
                                             @endif


                                   
                                   </tr>
                                @endforeach
    
    
                                </tbody>
                                
    
                                <tfoot>
                                    
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.row -->
        </div>
        <!-- ./container-fluid -->
        @stop

            @section('js')

            <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
            </script>

            <script></script>
            @stop