@extends('layouts.app')


@section('title')
Registration Form
@stop

@section('breadcrumb')
<ol class="breadcrumb  pull-right no-print">
    <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
    @permission('view-openfile')
        <li><a href="{{ route('openfile.view') }}">All Open File Packages List</a></li>
    @endpermission
    <li class="active">End User Details</li>
</ol>
@stop

@section('content')
<div class="container-fluid">
    
    <form method="post" action="{{ route('openfile.enduser.store') }}" class="form-horizontal"
        id="receipt_form">
        {{ csrf_field() }}
        <div class="row">
            <div class="col-lg-12 col-sm-12 col-xs-12">
                @if($errors->any())
                <div class="white-box">
                    <h2>Errors</h2>
                    <ul>
                        {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span>
                        </li>')) !!}
                    </ul>
                </div>
                @endif
                <div class="white-box1">
                    <h3 class="box-title">Information Required To Generate End User Form</h3>
                    <hr>
                    <input type='hidden' name='openfiledealer_info_id' value='{{$openfiledealer_info->id}}'>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="inputcurrency" class="control-label col-md-4">Currency No.
                                <span style="color: red">*</span>
                            </label>
                            <div class="col-md-8">
                                <div class="input-group">
                                    <input type="text" class="form-control" name="currency_number" id="currency_number" value="{{old('currency_number')}}">
                                    @if($errors->has('currency_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('currency_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                        <label class="control-label col-md-4">App Form No<span style="color: red">*</span></label>
                        <div class="col-md-8">
                            <input type='text' class="form-control" name='app_form_no' id='app_form_no' >

                            @if($errors->has('app_form_no'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('app_form_no') }}</strong>
                                </span>
                            @endif

                        </div>
                        </div>
                        <br><br><br><br>


                        <div class="clearfix"></div>
                        <div class=" col-sm-4">&nbsp;</div>
                        <div class=" col-sm-4">
                            <button type="submit" class="btn btn-info waves-effect waves-light m-t-10"
                                style="width: 100%">Generate</button>
                        </div>
                    </div>
                </div>
            @stop
@section('js')

<script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
</script>

<script>
    $(":input").inputmask();

  

   
</script>


@stop
        
    




















